#ifndef __CP_Tran_h
#define __CP_Tran_h

#ifndef WORD
 #include <types.h>
#endif

class CpTranslator
	{
private:static CpTranslator *First;
	CpTranslator *Previous;
	CpTranslator *Next;

public: CpTranslator(char *name);
	~CpTranslator();

	char *Name;

	virtual WORD operator[](const WORD n) const {return(n);}
	virtual WORD number(void) const {return(0);}

	friend CpTranslator *GetTranslator(const char *Name);
	};
CpTranslator *GetTranslator(const char *Name);	


class WCpTranslator: public CpTranslator
	{
public: WCpTranslator(char *name, WORD number, const WORD *trn);

	WORD Number;
	const WORD *Trn;

	WORD operator[](const WORD n) const {if(n>=Number) return(n); return(Trn[n]);}
	WORD number(void) const {return(Number);}
	};

class BCpTranslator: public CpTranslator
	{
public: BCpTranslator(char *name, WORD number, const BYTE *trn);

	WORD Number;
	const BYTE *Trn;

	WORD operator[](const WORD n) const {if(n>=Number) return(n); return(Trn[n]);}
	WORD number(void) const {return(Number);}
	};        

class SparseCpTranslator: public CpTranslator
	{
public: SparseCpTranslator(char *name, BYTE banks, WORD **trn_bank);

	BYTE Banks;
	WORD **Trn_bank;

	WORD operator[](const WORD n) const;
	WORD number(void) const {return(256*Banks);}
	};


#endif