#ifndef __TYPES_INCLUDED
#define __TYPES_INCLUDED

/******** Definition of items with uniquely size **********
(c) 1997-2009 Jaroslav Fojtik
   if you don't use below mentionted compiler, please correct this items
   for your compiler and send me your correction to:
			fojtik@penguin.cz or fojtik@humusoft.cz

List of supported types:

   Type  Alternate  Size & Description
   -----+---------+------+---------------------
   __u8   BYTE     1 byte  =  8 bit
   __s8   SBYTE    1 byte  =  8 bit signed
   __u16  WORD     2 bytes = 16 bit
   __s16  SWORD    2 bytes = 16 bit signed
   __u32  DWORD    4 bytes = 32 bit
   __s32  SDWORD   4 bytes = 32 bit signed

***************************************************************/


#define NATIVE_ACCESS


#ifdef __BORLANDC__
 #ifndef LO_ENDIAN
  #define LO_ENDIAN
 #endif
 #define __u8    unsigned char
 #define __s8    signed char
 #if defined(__OS2__) || defined(__WIN32__)
   #define __u16   unsigned short int
   #define __s16   signed short int
 #else
   #define __u16   unsigned int
   #define __s16   signed int
 #endif
 #define __u32   unsigned long int
 #define __s32   signed long int
#else  /* __BORLANDC__ */


#if defined(__EGC__) || defined(__GNUC__)
 #ifdef __DJGPP__
   #ifndef LO_ENDIAN
    #define LO_ENDIAN
   #endif
 #endif
 typedef int __s8 __attribute__((mode(QI)));
 typedef unsigned int __u8 __attribute__((mode(QI)));
 typedef int __s16 __attribute__((mode(HI)));
 typedef unsigned int __u16 __attribute__((mode(HI)));
 typedef int __s32 __attribute__((mode(SI)));
 typedef unsigned int __u32 __attribute__((mode(SI)));
 typedef int __s64 __attribute__((mode(DI)));
 typedef unsigned int __u64 __attribute__((mode(DI)));
 #define __u8 __u8
 #define __u16 __u16
 #define __u32 __u32
 #define __u64 __u64
#else  /* __GNUC__ */


#ifdef __WATCOMC__
 #ifdef __386__
  #define __u8    unsigned char
  #define __s8    signed char
  #define __u16   unsigned short int
  #define __s16   signed short int
  #define __u32   unsigned int
  #define __s32   signed int
 #else
  #define __u8    unsigned char
  #define __s8    signed char
  #define __u16   unsigned int
  #define __s16   signed int
  #define __u32   unsigned long int
  #define __s32   signed long int
 #endif
#else /*__WATCOMC__*/

#ifdef __HPUXC__
 #define __u8	unsigned char
 #define __s8	signed char
 #define __u16	unsigned short int
 #define __s16	signed short int
 #define __u32	unsigned int
 #define __s32	signed int
#else

#ifdef __IAR_SYSTEMS_ICC__
 #define  __s8 signed char		
 #define  __u8 unsigned char 		
 #define  __s16 signed short		
 #define  __u16 unsigned short 		
 #define  __s32 signed int		
 #define  __u32 unsigned int 		
 #define  __s64 long long		
 #define  __u64 unsigned long long	///< 8-bit value
 #ifdef NATIVE_ACCESS
   #undef NATIVE_ACCESS
 #endif

/* Here you may include your definition for other C */
#endif
#endif
#endif
#endif
#endif


#ifndef __u8
 #define __u8    unsigned char
 #define __s8    signed char
#endif
#ifndef __u16
 #define __u16   unsigned short
 #define __s16   signed short
#endif
#ifndef __u32
 #define __u32   unsigned long int
 #define __s32   signed long int
#endif

#ifndef BYTE
 #define BYTE    __u8
 #define SBYTE   __s8
 #define WORD    __u16
 #define SWORD   __s16
 #define DWORD   __u32
 #define SDWORD  __s32
 #ifdef __u64
  #define QWORD	 __u64
  #define SQWORD __s64
 #endif
#endif


#ifndef INT8
// typedef __s8	INT8;
// typedef __u8	UINT8;
// typedef __s16	INT16;
// typedef __u16	UINT16;
// typedef __s32	INT32;
// typedef __u32	UINT32;

// #ifdef __u64
//  typedef __s64	INT64;
//  typedef __u64	UINT64;
// #endif
#endif



#define LD_UINT16_CPU(ptr)	(UINT16)(*(UINT16*)(UINT8*)(ptr))
#define LD_UINT32_CPU(ptr)	(UINT32)(*(UINT32*)(UINT8*)(ptr))
#define ST_UINT16_CPU(ptr,val)	*(UINT16*)(UINT8*)(ptr)=(UINT16)(val)
#define ST_UINT32_CPU(ptr,val)	*(UINT32*)(UINT8*)(ptr)=(UINT32)(val)

#define LD_UINT16_LO(ptr)	(UINT16)(((UINT16)*(UINT8*)((ptr)+1)<<8)|(UINT16)*(UINT8*)(ptr))
#define LD_UINT32_LO(ptr)	(UINT32)(((UINT32)*(UINT8*)((ptr)+3)<<24)|((UINT32)*(UINT8*)((ptr)+2)<<16)|((UINT16)*(UINT8*)((ptr)+1)<<8)|*(UINT8*)(ptr))
#define ST_UINT16_LO(ptr,val)	*(UINT8*)(ptr)=(UINT8)(val); *(UINT8*)((ptr)+1)=(UINT8)((UINT16)(val)>>8)
#define ST_UINT32_LO(ptr,val)	*(UINT8*)(ptr)=(UINT8)(val); *(UINT8*)((ptr)+1)=(UINT8)((UINT16)(val)>>8); *(UINT8*)((ptr)+2)=(UINT8)((UINT32)(val)>>16); *(UINT8*)((ptr)+3)=(UINT8)((UINT32)(val)>>24)

#ifdef NATIVE_ACCESS  /* Enable word access to the FAT structure */
 #define LD_UINT16	LD_UINT16_CPU
 #define LD_UINT32	LD_UINT32_CPU
 #define ST_UINT16	ST_UINT16_CPU
 #define ST_UINT32	ST_UINT32_CPU
#else		      /* Use byte-by-byte access to the FAT structure */
 #define LD_UINT16	LD_UINT16_LO
 #define LD_UINT32	LD_UINT32_LO
 #define ST_UINT16	ST_UINT16_LO
 #define ST_UINT32	ST_UINT32_LO
#endif



#endif  		/* End of Header Typedefs.h */
