TEXINPUTS := .:${SPLINT_ROOT}/cweb/:${SPLINT_ROOT}/tex/:${SPLINT_ROOT}/:${TEXINPUTS}

SPLINT_DRIVER_DIR = ${SPLINT_ROOT}/cweb

SPLINT_TEXSTYLES  = flex.sty yyfaststack.sty yyparse.sty yyunion.sty yyboth.sty yyinput.sty yystype.sty yy.sty
SPLINT_TEXSTYLES += yyinit.sty yybootstrap.sty dcols.sty limbo.sty yycommon.sty yymisc.sty yytexlex.sty
SPLINT_BOOTSTRAP_STYLES = grabstates.sty
SPLINT_PTABLES = byytab.tex dyytab.tex fyytab.tex gyytab.tex small_tab.tex
SPLINT_LTABLES = ltab.tex small_dfa.tex

SPLINT_XTEXSTYLES = $(patsubst %, ${SPLINT_ROOT}/tex/%, ${SPLINT_TEXSTYLES})
SPLINT_XBOOTSTRAP_STYLES = $(patsubst %, ${SPLINT_ROOT}/tex/%, ${SPLINT_BOOTSTRAP_STYLES})
SPLINT_XPTABLES = $(patsubst %, ${SPLINT_ROOT}/cweb/%, ${SPLINT_PTABLES})
SPLINT_XLTABLES = $(patsubst %, ${SPLINT_ROOT}/cweb/%, ${SPLINT_LTABLES})

SPLINT_DOC_PREREQS = %.tex ${SPLINT_PTABLES} ${SPLINT_LTABLES} ${SPLINT_XTEXSTYLES} ${SPLINT_ROOT}/tex/btokenset.sty bo.tok
SPLINT_DOC_PREREQS_XREF = ${SPLINT_DOC_PREREQS} %.scn %.idx 

PDFTEX = pdftex
TEX = tex
DVIPS = dvips
PDFVIEW = evince
CWEAVE = cweave -bhp
CTANGLE = ctangle -bhp
BISON = bison -v
FLEX = flex

BRACK = ${SPLINT_ROOT}/scripts/brack.pl
UNLINE = ${SPLINT_ROOT}/scripts/unline.pl
BINDX = ${SPLINT_ROOT}/scripts/bindx.pl

%.c:		%.w
%.c:		%.y
%.pdf:		%.tex
%.ps:		%.dvi
%.o:		%.c
%.c:		%.l

%.x:		%.w
		${BRACK} $< $@

%.c:		%.y
		${BISON} $^ -o $@

%.c:		%.l
		${FLEX} -o $@ $^

%.l:		%.ll
		${UNLINE} $^ $@

%.y:		%.yy
		cp -f $^ $@

%.ps:		%.dvi
		${DVIPS} $^ -o $@

%.gdy:		%.gdx
		${BINDX} $^ $@

${SPLINT_ROOT}/cweb/%:
		cd ${SPLINT_ROOT}/cweb && ${MAKE} $(notdir $@)

clean_temp:	
	-rm -f  *.o *.tab.* *.dvi *.pdf *.ps *~ *.log \
	*.rli *.rls *.lpg *.output *.lst *.exl *.ftn *.*pk *.gdx

clean_core:   clean_temp
	-rm -f *.c *.h *.tex *.idx *.scn *.toc *.tok *.sns *.gdy *.x *.yy *.ll *.y *.l

# to ensure that interrupted and erroneous builds are cleaned up

.DELETE_ON_ERROR:  
