% Copyright 2012-2014, Alexander Shibakov
% This file is part of SPLinT
%
% SPLinT is free software: you can redistribute it and/or modify
% it under the terms of the GNU General Public License as published by
% the Free Software Foundation, either version 3 of the License, or
% (at your option) any later version.
%
% SPLinT is distributed in the hope that it will be useful,
% but WITHOUT ANY WARRANTY; without even the implied warranty of
% MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
% GNU General Public License for more details.
%
% You should have received a copy of the GNU General Public License
% along with SPLinT.  If not, see <http://www.gnu.org/licenses/>.
\newwrite\gindex

\input limbo.sty
\def\optimization{5}
\input yy.sty
\input dcols.sty
\input symswitch.sty

\def\symnamespace{[symbols]}

\let\currentnamespace\parsernamespace
\let\parsernamespace\symnamespace
    \input symtoks.sty % 
\let\parsernamespace\currentnamespace
\let\hostparsernamespace\symnamespace % the namespace where tokens are looked up
                                       % for typesetting purposes

\immediate\openout\exampletable=\jobname.exl

\def\cite[#1]{%
    \def\next{#1}\setbox0=\hbox{l}
    [\ifx\next\empty$\,$\hbox{\vrule width\wd0 height\ht0 depth\dp0}$\,$\else #1\fi]%
}

\let\oldN\N
\let\N\textN
\let\M\textM

\defreserved{Y}{\.{Y}}

@** Introduction. \setupfootnotes
The same parser and lexer (with a slightly different input routine) 
are used to typeset examples of productions in text. 
Some of the features of this parser
are collected below for future reference. One might keep this section
handy when typesetting his own examples (for example, it is probably
unintuitive that `\.{`}' produces `\.{\yl}' but there is simply no
way to use `\.{\yl}' as a character inside the \TeX\ section of \CWEB).
The first, rather eclectic and lengthy example demonstrates various
typesetting features of the \bison\ parser. The parsing output as well
as the resulting table are saved in {\tt \jobname.exl}. All the \Cee\
typesetting is performed by \CWEB, using its \.{\yl}$\ldots$\.{\yl}
facility.
\saveparseoutputtrue
\expandafter\def\csname^^D^^D\endcsname{}
\medskip
\beginprod
\inline
example:
  term.1 term.2 \{\} term.3 \stashed{\relax} \{\stashed{\relax}\}
` term.more \{\} "nonterminal"[sym_name.1] term_other[sym_name.2] \{\}
` \
` \%empty \
` terms terms ',' terms \%? \{ \stashed{|a = b = c = d = e;|} \} \%dprec 7
` terms terms ',' terms \%? \{ \stashed{|a = b = c;|} \}
;
%
another:
  term.8 \%merge <some_tag> term.one \%dprec 3 term.two \{\stashed{\rm|int a, b, c;|}\}
` term.17 \%merge <other_tag> \{\stashed{|f(a,b)==c;|}\}
` term.78 \{\stashed{|h(b)=g(c);|}\} \%merge <tag.2> \%dprec 0x17
` term.77 \{\stashed{|h(b)=g(c);|}\} \%prec new_term
;
%
\resetf
and_another:
  term.8 \%merge <some_tag> term.one \%dprec 3 term.two \{\stashed{\rm|int a, b, c;|}\}
` term.17 \%merge <other_tag> \{\stashed{|f(a,b)==c;|}\}
` term.78 \{\stashed{|h(b)=g(c);|}\} \%merge <tag.2> \%dprec 0x17
` term.77 \{\stashed{|h(b)=g(c);|}\} \%prec new_term
;
%
\%token ANOTHER NONEXISTENT GENERIC  TOKEN 7 "token" ANOTHER 0x77 "more" TOKEN TOKEN ;
\%token bogey1 bogey2 ;
\%type <some> TOKEN ANOTHER ;
\%start inputer;
\stashed{\rm Example 1 of flushed code}\sflush{F}{flush this}
\%default-prec;
\%no-default-prec;
\stashed{\rm Example 2 of flushed code}
\%destructor \{ \stashed{\rm |func(int a, char b); a = b + c;|}\^^D\^^D % ignored because anything is accepted inside braces
                \stashed{\6\rm |func2(int a, char b);|} \} \^^D\^^D
    "token" TOKEN NONEXISTENT "none" BOGEY "more" A_TOKEN IDENTIFIER;
\%printer \{ \stashed{\rm |func(int a, char b); a = b + c;|} 
                \stashed{\6\rm |func2(int a, char b);|} \} \^^D\^^D
    "token" TOKEN NAME NONEXISTENT "none" ANOTHER BOGEY "more" A_TOKEN identifier.1 identifier.2;
\%code token.3 \{ \stashed{\rm |func(int a, char b); a = b + c;|} 
                \stashed{\6\rm |func2(int a, char b);|} \};
\%code \{ \stashed{\rm |new_function(int x, char y); |} \};
\%left <whoops> "one" 1 "two" 2 three.137 0x7;
\%precedence five six seven;
\%nonassoc two;\^^D\^^D
\%code \{ \stashed{\rm |other_function(int x, char y); |} \};
\endprod
\medskip
%\checktabletrue
\beginprod
\%expect 0x137;
\%expect-rr 17;
\%lex-param \{\stashed{|int number;|}\};
\%define var.1 \{ \stashed{ |func3(8, "string"){n = m++;};| } \}
\%union var.2 \{ \stashed{\rm |int a, b, c;|\6 |char a_char;|} \}
\%\{ \stashed{\rm |int a, b, c;|\6 |char a_char;|} \%\}
\endprod
%
\medskip
\noindent The next example is a demonstration of the hidden context
added to an incomplete language fragment and local typesetting
variations enabled by such context.
\def\cset#1{%
    \nx\colorset{darkwood}%
    {#1}%
    \nx\restorecolor
}%
\def\dset#1{%
    $\nx\underbrace{\hbox{#1}}_{{\nx\rm identifier:\ \the\toksc}}$%
}%
\def\esets#1{%
    \nx\beginub#1%
}%
\def\esete#1{%
    #1\nx\endub
}%
\def\beginub#1\endub{%
    $\underbrace{\hbox{#1}}_{\rm a\ group}$%
}
\smallskip
\beginprod
\skipheader
ghost:
  headerless_term.1 \formatlocal{\let\termmetastyle\cset} headerless_term.2 \{\stashed{\colorset{link}\rm|color(x,y,z);|\restorecolor}\}
` \formatlocal{\let\termmetastyle\dset}more.of.the.same.0\formatlocal{\restorecs{table-render}\termmetastyle} but.not.here 
      \{\stashed{\rm|color(a, b, c);|}\}
` \formatlocal{\let\termmetastyle\esets}three.more.terms\formatlocal{\restorecs{table-render}\termmetastyle}follow
  \formatlocal{\let\termmetastyle\esete}this\formatlocal{\restorecs{table-render}\termmetastyle}one\{\stashed{\rm|assign(x, y, z);|}\}
;
\endprod
\medskip
\noindent Finally, an incomplete listing of the characters that can be
typeset, as well as the way to typeset them. The use of `\.{`}' to
typeset `\.{\yl}' deserves a special note---\CWEB's rules make it
nearly impossible to use `\.{\yl}' in the \TeX\ portion of the program.
\medskip
\tomainparser
\prettywordpair{GENERIC}{\_Generic}
\prettywordpair{ss}{$^{\rm C99[}\,$\aftergroup\aftergroup\aftergroup\ignorespaces}
\prettywordpair{es}{\unskip$\,{}^{\rm ]C99}$}% there is still a problem when this appears in headers
\beginprod
line_breaking_and_symbols:
   GENERIC '(' expression',' \ ss another es')' \
 ` inline_c \{ \stashed{\X{$\infty$}:See this example to deduce $\ldots$\X\6}\stashed{|b == a - c|} \}
 ` more_inline_c \{ \stashed{|func(int a, char b);|} \}
%
\endprod
\medskip
\beginprod
\format{\inline\flatten}
symbol_tricks:
   '\&' \
 ` '*'  \
 ` '+'  \
 ` '-'  \
 ` '\~' \
 ` '!'  \
 ` '\{' \
 ` '`'  \
 ` '\`' \
 ` '\'' \
 ` '\\' \
 ` ' ' \
 ;
\endprod

\closeout\gindex
@** Index. Totally superfluous in this case.
\let\inx\inxmod
\let\fin\finmod
\def\topofcontents{\null\vskip-3\baselineskip\centerline{C{\sc ONTENTS} (\sc\uppercase\expandafter{\title})}\medskip}
