@q Copyright 2012-2014, Alexander Shibakov@>
@q This file is part of SPLinT@>

@q SPLinT is free software: you can redistribute it and/or modify@>
@q it under the terms of the GNU General Public License as published by@>
@q the Free Software Foundation, either version 3 of the License, or@>
@q (at your option) any later version.@>

@q SPLinT is distributed in the hope that it will be useful,@>
@q but WITHOUT ANY WARRANTY; without even the implied warranty of@>
@q MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the@>
@q GNU General Public License for more details.@>

@q You should have received a copy of the GNU General Public License@>
@q along with SPLinT.  If not, see <http://www.gnu.org/licenses/>.@>
\input limbo.sty
\def\optimization{5}
\input yy.sty

\let\oldN\N
\let\N\textN
\let\M\textM

@** A simple scanner for \flex\ options.
This is a `bare-bones' scanner for a subset of the `extended' \bison\
grammar that parses, well, some of the `extensions', namely, the
\flex\ state declarations. It does not use the state mechanism
itself, and is supposed to be used with the bootstrapping parser, even
though it is not strictly necessary. It parses state declarations as
long as they are separated into their own \CWEB\ sections and extracts
the {\it names\/} of the states. The \flex\ scanner output `driver'
does the rest after including the produced header file.
@s TeX_ TeX
@(ssffo.ll@>=
@<Lexer definitions@>@;
@G
%{@> @<Lexer \Cee\ preamble@> @=%}
@g
@<Lexer options@>@;
@G
%%
@g
@<Regular expressions@>@;
@G
%%
@g
@ A couple of handy abbreviations to get started.
@<Lexer definitions@>=
@G
letter    [_abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ]
id        {letter}({letter}|[-0-9])*
@g

@ @<Lexer \Cee\ preamble@>=

#include <stdint.h>
#include <stdbool.h>

  void define_all_states( void ){}

@ A standard combination of options to match the \TeX\ code that
drives the scanner.
@<Lexer options@>=
@G
%option bison-bridge
%option noyywrap nounput noinput reentrant 
%option noyy_top_state
%option debug
%option stack
%option outfile="ssffo.c"
@g

@ There are not that many regular expressions to list, since the range
of tokens recognized by this routine is not very wide.
@<Regular expressions@>=
  @<Scan white space@>@;
  @<Scan identifiers@>@;

@ White space skipping. 
@<Scan white space@>=
@G
[ \f\n\t\v]                        {@> @[TeX_( "/yylexnext" );@]@=}
@g

@ The rest of it are either identifiers or \.{\%}-options.
@<Scan identifiers@>=
@G
{id}                               {@> @<Return an identifier@> @=}
"%x"                               {@> @[TeX_( "/yylexreturnptr{FLEX_STATE_X}" );@] @=}
"%s"                               {@> @[TeX_( "/yylexreturnptr{FLEX_STATE_S}" );@] @=}
.                                  {@> @<React to a bad character@> @=}
@g

@ @<React to a bad character@>=
  @[TeX_( "/iftracebadchars" );@]@;
  @[TeX_( "    /yycomplain{invalid character(s): /the/yytext}" );@]@;
  @[TeX_( "/fi" );@]@;
  @[TeX_( "/yylexreturn{$undefined}" );@]@;

@ The lexer returns standard \.{\\yyunion} types.
@<Return an identifier@>=
  @[TeX_( "/edef/next{/yylval{/nx/idit{/the/yytextpure}{/the/yytext}" );@]@;
  @[TeX_( "    {/the/yyfmark}{/the/yysmark}}}/next" );@]@;
  @[TeX_( "/yylexreturn{ID}" );@]@;

@** Index.
\def\TeXx{\TeX\ material}