% Copyright 2012-2014, Alexander Shibakov
% This file is part of SPLinT
%
% SPLinT is free software: you can redistribute it and/or modify
% it under the terms of the GNU General Public License as published by
% the Free Software Foundation, either version 3 of the License, or
% (at your option) any later version.
%
% SPLinT is distributed in the hope that it will be useful,
% but WITHOUT ANY WARRANTY; without even the implied warranty of
% MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
% GNU General Public License for more details.
%
% You should have received a copy of the GNU General Public License
% along with SPLinT.  If not, see <http://www.gnu.org/licenses/>.
\newwrite\gindex

@i bo.x
@i lo.x
@i np.x
@i common.w
@i bs.w
@i fk.w
@i philosophy.w
@i references.w

\let\N\oldN
\let\hostparsernamespace\mainnamespace % to typeset examples in the text 
                                       % properly
@**Index. This section is, perhaps, the most valuable product of
\CWEB's labors. It lists references to definitions (set in {\it
italic}) as well as uses for each \Cee\ identifier used in the
source. Special facilities have been added to extend indexing to
\bison\ grammar terms and \TeX\ control sequences encountered in
\bison\ actions. Definitions of tokens (via \prodstyle{\%token},
\prodstyle{\%nterm} and \prodstyle{\%type} directives) are
$\underline{\hbox{underlined}}$. The \bison\ and \TeX\ entries are put
in distinct sections of the index in order to keep the separation
between the \Cee\ entries and the rest. It may be worth noting that
the {\it definition\/} of the symbol is listed under both its `macro
name' (such as \.{CHAR}, typeset as \prodstyle{CHAR} in the case of
the grammar below), as well as its `string' name if present (to
continue the previous example, \.{"char"} is synonymous with
\prodstyle{CHAR} after a declaration such as `\prodstyle{\%token}
\prodstyle{CHAR} \.{"char"}'), while the {\it use\/} of the term lists
whichever token form was referenced at the point of use (both forms
are accessible when the entry is typeset for the index and a macro can
be written to mention the other form as well).  The quotes indicate
that the `string' form of the token's name was used. A section set in
{\it italic\/} references the point where the corresponding term
appeared on the left hand side of a production.

A production:
\let\TeXx\TeXxi
\def\gatoks{%
    \omit\hfil&\omit\hfil&\omit\hfil\hbox to2em{\hfil}&\omit\hfil{\hfil}\cr
    \noalign{\vskip-\baselineskip}%
}%
\beginmprod
left_hand_side:
    term.1 term.2 term.3 \{\stashed{|TeX_("/do/something/yy(1)");|}\}
\endmprod
inside the \TeX\ part of a \CWEB\ section will generate several
index entries, as well, including the entries for any
material inside the action, mimicking \CWEB's behavior for the
{\it inline \Cee\/} (\.{\yl}$\ldots$\.{\yl}). Such entries (except for
the references to \Cee\ code inside actions) are labeled with $^\circ$, 
to provide a reminder of their origin.

This parser collection, as well as the indexing facilities therein have been
designed to showcase the broadest range of options available to the user
and thus it does not always exhibit the most sane choices one could make (for
example, using a full blown parser for term {\it names\/} is poor
design but it was picked to demonstrate multiple parsers in one
program). The same applies to the way the index is constructed (it
would be easy to agree to only use the `string' name of the token if
it is available, thus avoiding referencing the same token in two
different parts of the index).

\TeX\ control sequences are listed following the index of all \bison\
entries. The two indices are separated by a {\it dinkus}
(\dinkus). Since it is nearly impossible to determine at what point a
\TeX\ macro is defined (and most of them are defined outside of the
\CWEB\ sources), only their uses are listed (to be more precise, {\it
every\/} appearance of a macro is assumed to be its use). In a few cases, a
`graphic' representation for a control sequence is also listed (for
example, {\termindexfalse\def\texnspace{texline}\inlineTeXx{/getfirst}} represents
\.{\\getfirst}). The index entries are ordered alphabetically using
control sequence names.
\closeout\gindex
\let\inx\inxmod
\let\fin\finmod
\def\topofcontents{\null\vskip-3\baselineskip\centerline{C{\sc ONTENTS} (\sc\uppercase\expandafter{\title})}\medskip}
