@**Philosophy.
This section should, perhaps, be more appropriately called {\it rant\/} but
{\it philosophy\/} sounds more academic. The design of any software involves
numerous choices, and \splint\ is no exception. Some of these choices
are explained in the appropriate places in the package files. This
section collects a few `big picture' choices that did not fit elsewhere.

@*1 Why GPL.
The choice of license for this project goes beyond merely showing the
source. \TeX, by its very nature is an open source language, so it
is not a matter of hiding anything from the user or a potential
developer. The \Cee\ code is a different matter but the source is not
that complicated. Reducing the licensing issue to the ability of
someone else to see the source code is a great
oversimplification. Without getting into too many details of so-called
`open source licenses' (other than GPL) and arguing with their advocates, let me simply
express my lack of understanding at the arguments that purport that
BSD-style licenses introduce more freedom by allowing a software
vendor to incorporate the BSD-licensed software into their
products. What benefit does one derive from such `extension' of software
freedom? Perhaps the hope that the `open source' (for the lack of a
better term) will prompt the vendor to follow the accepted free (or
any other, for that matter!) software standards and make its software
more interoperable with the free alternatives? A well-known software
giant's {\it embrace, extend, extinguish\/} philosophy shows how na\"{\i}ve and
misplaced such hopes are.

I am not going to argue for the benefits of free software at length, either
(such benefits seem self-evident to me, although the readers should
feel free to disagree). Let me just point out that software companies
enjoy quite a few freedoms that we, as software consumers elect to
afford them. Among such freedoms are the ability to renege on any
promises made to potential users and withdraw any guarantees that such
users might enjoy. Free software, of course, does not provide any
guarantees, either but `you get what you paid for'. As a result of
such `release of any responsibility', the claims of increased
reliability or better support for the commercial software sound a
bit hollow. Another well spread tactic is user brainwashing and
changing the culture (usually for the worse) in order to promote new
`user-friendly' features of commercial software. Instead of taking
advantage of computers as cognitive machines we have come to view
them as advanced media players that we interact with through
artificial, unnatural interfaces. Meaningless terminology (`UX' for
`user experience'? What in the world is `user experience'?)
proliferates, and programmers are happy to deceive themselves with
their newly discovered business prowess.

One would hope that the somewhat higher standards of the `real'
manufacturers might percolate to the software world, however, the
reality is very different. Not only has life-cycle `engineering' 
got to the point where manufacturers can predict the life spans of
their products precisely, embedded software in those products has
become an enabling technology that makes this `life design' much
easier. 

In effect, by embedding software in their products, hardware
manufacturers not only piggy-back on software's perceived complexity,
and argue that such complex systems cannot be made reliable, they have
an added incentive to uphold this image. The software weighs nothing,
memory is cheap, consumers are easy to deceive, thus `software is
expensive' and `reliable software is prohibitively so'. Designing reliable
software is quite possible, though, just look at programmable
thermostats, simple cellphones and other `invisible' gadgets we
enjoy. The `software ideology' with its `IP' lingo is spreading like a
virus even through the world of real things. We now expect products to
break and are too quick to forgive sloppy engineering that goes into
everyday things. We are also getting used to the idea that it is the
manufacturers that get to dictate the terms of use for `their' products
and that we are merely borrowing `their' stuff.

The GPL was conceived as an antidote to this scourge. This document is a
remarkable piece of `legal engineering': a self-propagating license 
with a clearly outlined set of goals. While by itself it does not
guarantee reliability or quality, it does inhibit the spread of the `IP' 
(which is sometimes sarcastically, though quite perceptively,
`deabbreviated' as {\sl I}maginary {\sl P}roperty) disease through
software.

The industry has adapted, of course. So called (non GPL) `open source
licenses', that are supposed to be an improvement on GPL,
are a sort of `immune reaction' to the free software
movement. Convince and confuse enough apathetic users and the
protections granted by GPL are no longer visible.

@*1 Why not \Cee$++$ or OOP in general.
The choice of the language was mainly driven by \ae sthetic motives:
\Cee$++$ has a bloated and confusing standard, partially supported by
various compilers. It seems that there is no agreement on what
\Cee$++$ really is or how to use some of its constructs. This is all
in contrast to \Cee\ with its well defined and concise body of
specifications and rather well established stylistics. The existence
of `obfuscated \Cee' is not good evidence of deficiency and \Cee$++$
is definitely not immune to this malady.

Object oriented design has certainly taken on an aura of a religious
dictate, universally adhered to and forcefully promoted by its
followers. Unfortunately, the definition of what constitutes an
`object-oriented' approach is rather vague. A few abstract concepts are
commonly tossed about to give the illusion of a well developed
abstraction (such as `polymorphism', `encapsulation', and so on) but
definitions vary in both length and contents, depending on the source.

On a syntactic level, some features of object-oriented languages are
undoubtedly very practical (such as a |this| pointer in \Cee$++$),
however, many of those features can be effectively emulated with some
clever uses of an appropriate preprocessor (there are a few
exceptions, of course, |this| being one of them). The rest of the
`object-oriented philosophy' is just that: a design philosophy. Before
that we had structured programming, now there are patterns, extreme,
agile, reactive, etc. They might all find their uses, however, there
are always numerous exceptions (sometimes even global variables and
|goto|'s have their place, as well).

A pedantic reader might point out a few object-oriented features even
in the \TeX\ portion of the package and then accuse the author of
being `inconsistent'. I am always interested in possible improvements
in style but I am unlikely to consider any changes based solely on the
adherence to any particular design fad.

In short, OOP was not shunned simply because a `non-OOP' language was
chosen, instead, whatever approach or style was deemed most effective
was used. The author's judgment was not always perfect, of course,
and given a good reason, changes can be made, including the choice of
the language. `Make it object-oriented' is neither a good reason nor a
clearly defined one, however.

@*1 Why not $*$\TeX.
Simple. I never use it and have no idea of how packages, classes,
etc., are designed. I have heard it has impressive mechanisms for
dealing with various problems commonly encountered in \TeX. Sadly, my
knowledge of $*$\TeX\ machinery is almost nonexistent. This may change
but right now I have tried to make the macros as generic as possible,
hopefully making $*$\TeX\ adaptation easy.

The following quote from \cite[Ho] makes me feel particularly uneasy
about the current state of development of various \TeX\ variants:
``{\it Finally, to many current programmers\/ \.{WEB} source simply feels over-documented
and even more important is that the general impression is that of a finished book:
sometimes it seems like\/ \.{WEB} actively discourages development. This is
a subjective point, but nevertheless a quite important one.}''

{\it Discouraging development\/} seems like a good thing to
me. Otherwise we are one step away from encouraging writing poor
software with inadequate tools merely `to encourage development'.

The feeling of a \.{WEB} source being {\it over-documented\/} is most
certainly subjective, and, I am sure, not shared by all `current
programmers'. The advantage of using \.{WEB}-like tools, however, is
that it gives the programmer the ability to place the vital
information where it does not distract the reader (`developer',
`maintainer', call it whatever you like) from the logical flow of the
code. 

Some of the complaints in \cite[Ho] are definitely justified,
although it seems that a better approach would be to write an improved
tool similar to \.{WEB}, rather than give up all the flexibility such
a tool provides.

@*1 Why \CWEB.
\CWEB\ is not as polished as \TeX\ but it works and has a
number of impressive features. It is, regrettably, a `niche' tool and
a few existing extensions of \CWEB\ and software based on similar ideas
do not enjoy the popularity they deserve. Literate philosophy has been
largely neglected even though it seems to have a more logical
foundation than OOP. Under these circumstances, \CWEB\ seemed to be
the best available option.

@*1 Why not GitHub, Bitbucket, etc.
Git is an incredible tool and is used extensively in the development
of \splint. The distribution archive is a Git repository. The use of
centralized services such as GitHub, however, seems redundant. The
standard cycle, `clone-modify-create pull request' works the same even
when `clone' is replaced by `download'. Thus, no functionality is
lost. This might change if the popularity of the package unexpectedly
increases. 

On the other hand, GitHub and its cousins are commercial entities,
whose availability in the future is not guaranteed (nothing is
certain, of course, no matter what distribution method is
chosen). Keeping \splint\ as an archive of a Git repository seems like
an efficient way of being ready for an unexpected change.
