% Copyright 2012-2014, Alexander Shibakov
% This file is part of SPLinT
%
% SPLinT is free software: you can redistribute it and/or modify
% it under the terms of the GNU General Public License as published by
% the Free Software Foundation, either version 3 of the License, or
% (at your option) any later version.
%
% SPLinT is distributed in the hope that it will be useful,
% but WITHOUT ANY WARRANTY; without even the implied warranty of
% MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
% GNU General Public License for more details.
%
% You should have received a copy of the GNU General Public License
% along with SPLinT.  If not, see <http://www.gnu.org/licenses/>.

\input limbo.sty
\input yy.sty

\let\N\textN

@**Parser tables. This is the main table output code. Its core comes from the Bison
Sourcer(er?) (\.{bs.w}) which will be included as soon as this paragraph is
over. Since the main function of this code is to {\it dump\/} tables
produced by \bison, and a {\it bison\/} is a large buffalo like
animal, {\it and\/} the only reason it has to be done like this is due
to the less than optimal choices of a few developers, feel free to
interpret the acronym as something easier to remember.

@ @<Table names@>=
  @<Parser table names@>@;

@ @<Constant names@>=
  @<Parser constants@>@;

@ @<Local variable and type declarations@>=
  @<Variables and types local to the parser@>@;

@ @<Establish defaults@>=
  @<Parser defaults@>@;

@ @<Auxiliary function declarations@>=
  @<Helper functions declarations for for parser output@>@;

@ @<Auxiliary function definitions@>=
  @<Helper functions for parser output@>@;

@ @<Short option list@>=
  @<Shortcuts for command line options affecting parser output@>@;

@ @<Raw option list@>=
  @<Parser specific option list@>@;

@ @<Higher index options@>=
  @<Higher index parser specific options@>@;

@ @<Cases affecting the whole program@>=
  @<Handle parser output options@>@;

@ @<Output descriptor fields@>=
  @<Parser specific output descriptor fields@>@;

@ @<Default outputs@>=
  @<Parser specific default outputs@>@;

@ @<Various output modes@>=
  @<Handle parser related output modes@>@;

@ @<Output modes@>=
  @<Parser specific output modes@>@;

@ @<Output constants@>=
  @<Output parser constants@>@;

@ @<Cases involving specific modes@>=
  @<Configure parser output modes@>@;

@ @<Perform output@>=
  @<Output parser tokens@>@;

@ @<Output action switch, if any@>=
  @<Output parser semantic actions@>@;

@ @<\Cee\ preamble@>=
  @<Common code for \Cee\ preamble@>@;

@i common.w
@i bs.w

@*1 Parser dependent settings. 
This is it for the core table output functions. 
To make all this into a working code in this
case, lexing and error function declarations are supplied.
@<Auxiliary function declarations@>=
#ifndef HAS_SCANNER
  int yylex(void);
  int yyerror(void);
#endif

@ @<Auxiliary function definitions@>=
#ifndef HAS_SCANNER
  int yylex(void){}
  int yyerror(void){}
#endif

@ \let\B\oldB % \Cee\ mode mixes all up
@c

@<\Cee\ preamble@>@;

#include PARSER_FILE

@<\Cee\ postamble@>@;

@** Index (for {\tt \jobname}).
\def\readcontents{%
  {%
    \acrofalse
%    \def\jobname{bparser}\input bparser.toc 
%    \def\jobname{ftablesout}\input ftablesout.toc 
  }%
  \input \contentsfile
}