/*
Copyright (c) 2003-2005, Dirk Krause
All rights reserved.

Redistribution and use in source and binary forms,
with or without modification, are permitted provided
that the following conditions are met:

* Redistributions of source code must retain the above
  copyright notice, this list of conditions and the
  following disclaimer.
* Redistributions in binary form must reproduce the above 
  opyright notice, this list of conditions and the following
  disclaimer in the documentation and/or other materials
  provided with the distribution.
* Neither the name of the Dirk Krause nor the names of
  its contributors may be used to endorse or promote
  products derived from this software without specific
  prior written permission.

THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND
CONTRIBUTORS "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES,
INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF
MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
DISCLAIMED.
IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE
LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL,
EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE
OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH
DAMAGE.
*/

#ifndef PNG2PDF_INCLUDED
#define PNG2PDF_INCLUDED 1

#include <dk.h>
#include <dktypes.h>
#include <dklic.h>

#if HAVE_CONFIG_H
#include "config.h"
#else
#define	HAVE_ZLIB_H	1
#define HAVE_PNG_H	1
#endif

#include <stdio.h>
#if DK_HAVE_STDLIB_H
#include <stdlib.h>
#endif
#if HAVE_ZLIB_H
#include <zlib.h>
#else
#error "You must install zlib to compile this package!"
#endif
#if HAVE_PNG_H
#include <png.h>
#else
#error "You must install libpng to compile this package!"
#endif

#include <dkmem.h>
#include <dkerror.h>
#include <dkapp.h>
#include <dkstream.h>
#include <dkof.h>
#include <dkstr.h>
#include <dksf.h>
#include <dkma.h>
#include <dklogc.h>

#ifndef DK_PNG2PDF_C
#if !DK_HAVE_PROTOTYPES
#define EXTERN extern
#else
#define EXTERN /* nix */
#endif
#else
#define EXTERN /* nix */
#endif

typedef struct {
  int r;
  int g;
  int b;
  int gray;
} Png2PdfRGB;

typedef struct {
  /*	
  	Filled by main
  */
  /* application */
  dk_app_t	*a;
  /* File name of input file (NULL=stdin) */
  char	*inputfilename;
  /* real input filename to read PNG file */
  char	*realfilename;
  /* File name of output file (NULL=stdout) */
  char	*outputfilename;
  /* PDF format version */
  int	 pdf_version;
  /* background from PNG file */
  Png2PdfRGB	bg_file;
  /* background from command line */
  Png2PdfRGB	bg_cmdl;
  /* flags, see below */
  int		options;
  /* command, see below */
  int		cmd;
  /* localized messages */
  char		**msgptr;
  /* error code for last error */
  int		error_code;
  /*
  	Filled by run_normally
  */
  FILE		*inf;
  FILE		*of;
  /*
  	Filled by png2pdf_for_files
  */
  /* normal output stream */
  dk_stream_t	*os1;
  /* flate/ASCII85 encoding stream */
  dk_stream_t	*os2;
  /*
  	Filled by run_conversion
  */
  /* image width */
  unsigned long	wi;
  /* image height */
  unsigned long	he;
  /* bit depth */
  int		bd;
  /* color type */
  int		ct;
  int		cu;
  /* interlace type */
  int		it;
  /* compression type */
  int		zt;
  /* filter type */
  int		ft;
  /* number of channels */
  int		ch;
  /* background chunk data */
  png_color_16	bg;
  png_color_16p	bgp;
  /* PNG reader data */
  png_structp	pp;
  png_infop	pi;
  /* pointer to rows */
  int           rowbytes;
  png_bytep     *rows;
  Png2PdfRGB	bg_used;
} Png2PdfCmd;

#define PNG2PDF_PDF_VERSION_12		0
#define PNG2PDF_PDF_VERSION_13		1
#define PNG2PDF_PDF_VERSION_14		2

#define PNG2PDF_PDF_VERSION_MAX PNG2PDF_PDF_VERSION_14

/* mix against background */
#define PNG2PDF_OPT_MIX			1

/* command line background has higher priority */
#define PNG2PDF_OPT_BGCMD		2

/* create image mask */
#define PNG2PDF_OPT_IMAGEMASK		4

/* write transparency data */
#define PNG2PDF_OPT_TRANSPARENCY	8

/* inverted levels for image mask */
#define PNG2PDF_OPT_INVERTLEVELS	16

/* fill with background before writing image */
#define PNG2PDF_OPT_FILLBACKGROUND	32

/* alpha channel is transparency */
#define PNG2PDF_OPT_ALPHA_TRANS		64

/* make style */
#define PNG2PDF_OPT_MAKE		128

/* background was obtained from PNG file */
#define PNG2PDF_OPT_HAVE_FILE_BG	256

/* set image interpolation flag */
#define PNG2PDF_OPT_INTERPOLATE		512

#define PNG2PDF_CMD_RUN			0
#define PNG2PDF_CMD_HELP		1
#define PNG2PDF_CMD_VERSION		2
#define PNG2PDF_CMD_CONFIGURE		4
#define PNG2PDF_CMD_UNCONFIGURE		8
#define PNG2PDF_CMD_RESET		16
#define PNG2PDF_CMD_SHOWCONF		32

#define PNG2PDF_ERR_TOO_MANY_FILENAMES	-1
#define PNG2PDF_ERR_BACKGROUND_WRONG	-2

#ifdef __cplusplus
extern "C" {
#endif

EXTERN int
png2pdf_initialize_cmd DK_PR((Png2PdfCmd *c, dk_app_t *a));

EXTERN void
png2pdf_uninitialize_cmd DK_PR((Png2PdfCmd *c));

EXTERN void
png2pdf_process_args DK_PR((Png2PdfCmd *c, int xargc, char **xargv));

EXTERN void
png2pdf_save_configuration DK_PR((Png2PdfCmd *c));

EXTERN void
png2pdf_print_configuration DK_PR((Png2PdfCmd *c));

EXTERN void
png2pdf_reset_cmd DK_PR((Png2PdfCmd *c));

EXTERN int
png2pdf_for_files DK_PR((Png2PdfCmd *c));

#ifdef __cplusplus
}
#endif

#endif

