use Posix;

my $px = "128px";
my $width = 1000;
my $wh = $width / 2;
my $factor = 0.75;

my $c1 = "#7F7FFF";	# color of circles
my $c2 = "#7F7FFF";	# color of short pointer
my $c3 = "#7F7FFF";	# color of long pointer

my $w1 = 30;		# width of short pointer
my $w2 = 20;		# width of long pointer

my $f1 = 0.8;		# end of white filled, end of circles

my $r2 = 30;		# point radius;

# radius where the points are on
my $r1 = POSIX::floor($f1 * $wh - $r2);

my $r3 = 290; # length of long pointer
$r3 = $factor * ($r1 - $r2);

my $r4 = 179; # length of short pointer
$r4 = $factor * $factor * $r3;

my $pi = 3.1415926;



my $i; my $alpha; my $x; my $y;

print "<?xml version=\"1.0\" encoding=\"iso-8859-1\" standalone=\"no\"?>\n";
print "";
print "<svg width=\"$px\" height=\"$px\" viewBox=\"0 0 $width $width\"\n";
print "xmlns=\"http://www.w3.org/2000/svg\">\n";
print "<title>5 before 12</title>\n";
print "<desc>Analog clock image</desc>\n";
print "<defs>\n";
print "<style type=\"text/css\"><![CDATA[\n";
print ".A {\n";		# circle
print "fill: $c1;\n";
print "}\n";
print ".B {\n";		# short pointer
print "fill: $c2;\n";
print "stroke: $c2;\n";
print "stroke-linecap: round;\n";
print "stroke-width: $w1;\n";
print "}\n";
print ".C {\n";		# long pointer
print "fill: $c2;\n";
print "stroke: $c2;\n";
print "stroke-linecap: round;\n";
print "stroke-width: $w2;\n";
print "}\n";
print "]]></style>\n";
print "<radialGradient id=\"MyGradient\" gradientUnits=\"userSpaceOnUse\"\n";
print "cx=\"500\" cy=\"500\" r=\"500\">\n";
print "<stop offset=\"0\" stop-color=\"white\" stop-opacity=\"1\" />\n";
print "<stop offset=\"0.5\" stop-color=\"white\" stop-opacity=\"1\" />\n";
print "<stop offset=\"1\" stop-color=\"white\" stop-opacity=\"0\" />\n";
print "</radialGradient>\n";
print "<mask id=\"MyMask\" maskUnits=\"userSpaceOnUse\"\n";
print "x=\"0\" y=\"0\" width=\"1000\" height=\"1000\">\n";
print "<rect x=\"0\" y=\"0\" width=\"1000\" height=\"1000\" fill=\"url(#MyGradient)\"\n";
print "/>\n";
print "</mask>\n";
print "</defs>\n";
print "<rect x=\"0\" y=\"0\" width=\"1000\" height=\"1000\" fill=\"white\"";
print " mask=\"url(#MyMask)\" />\n";
# 5-minute-circles
for($i = 0; $i < 12; $i++) {
  $alpha = 2.0 * $pi * $i / 12.0;
  $x = $wh + $r1 * cos($alpha);
  $y = $wh + $r1 * sin($alpha);
  $x = 0.1 * POSIX::floor(10.0 * $x + 0.5);
  $y = 0.1 * POSIX::floor(10.0 * $y + 0.5);
  print "<circle cx=\"$x\" cy=\"$y\" r=\"$r2\" class=\"A\"/>\n";
}
# short pointer
$alpha = 0.0 - ((1.0 / 2.0 + 1.0 / 72.0) * $pi);
$x = $wh + $r4 * cos($alpha);
$y = $wh + $r4 * sin($alpha);
$x = 0.1 * POSIX::floor(10.0 * $x + 0.5);
$y = 0.1 * POSIX::floor(10.0 * $y + 0.5);
print "<line x1=\"$wh\" y1=\"$wh\" x2=\"$x\" y2=\"$y\" class=\"B\"/>\n";
# long pointer
$alpha = -2.0 * $pi / 3.0;
$x = $wh + $r3 * cos($alpha);
$y = $wh + $r3 * sin($alpha);
$x = 0.1 * POSIX::floor(10.0 * $x + 0.5);
$y = 0.1 * POSIX::floor(10.0 * $y + 0.5);
print "<line x1=\"$wh\" y1=\"$wh\" x2=\"$x\" y2=\"$y\" class=\"C\"/>\n";
print "</svg>\n";
