/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.uea.cmp.nlct.makeglossaries;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.URL;
import javax.swing.JFrame;
import javax.swing.JScrollPane;
import javax.swing.JTextPane;
import javax.swing.SwingUtilities;
import javax.swing.text.BadLocationException;
import javax.swing.text.Style;
import javax.swing.text.StyleContext;
import javax.swing.text.StyledDocument;
import uk.ac.uea.cmp.nlct.makeglossaries.MakeGlossariesGUI;

public class ViewFile
extends JFrame {
    private URL url;
    private JTextPane area;
    private JScrollPane scrollPane;
    private MakeGlossariesGUI app;

    public ViewFile(URL uRL, Font font, MakeGlossariesGUI makeGlossariesGUI) throws IOException, BadLocationException {
        super(uRL.getFile());
        this.app = makeGlossariesGUI;
        this.setIconImage(this.app.getIconImage());
        this.url = uRL;
        this.area = new JTextPane();
        StyledDocument styledDocument = this.area.getStyledDocument();
        Style style = StyleContext.getDefaultStyleContext().getStyle("default");
        styledDocument.addStyle("regular", style);
        this.area.setEditable(false);
        this.area.setFont(font);
        this.scrollPane = new JScrollPane(this.area);
        this.getContentPane().add((Component)this.scrollPane, "Center");
        this.scrollPane.setPreferredSize(new Dimension(500, 400));
        this.pack();
        this.setLocationRelativeTo(null);
        this.reload();
    }

    public void reload() throws IOException, BadLocationException {
        String string;
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(this.url.openStream()));
        String string2 = null;
        while ((string = bufferedReader.readLine()) != null) {
            if (string2 == null) {
                string2 = string;
                continue;
            }
            string2 = string2 + "\n" + string;
        }
        bufferedReader.close();
        StyledDocument styledDocument = this.area.getStyledDocument();
        styledDocument.insertString(0, string2, styledDocument.getStyle("regular"));
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                ViewFile.this.area.setCaretPosition(0);
            }
        });
    }
}

