/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.uea.cmp.nlct.makeglossaries;

import java.awt.Component;
import java.awt.Font;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.net.URL;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.JToolBar;
import javax.swing.KeyStroke;
import javax.swing.table.AbstractTableModel;
import uk.ac.uea.cmp.nlct.makeglossaries.Glossary;
import uk.ac.uea.cmp.nlct.makeglossaries.MakeGlossariesGUI;

public class ViewEntries
extends JFrame
implements ActionListener {
    private Glossary glossary;
    private JTable table;
    private JTextField searchField;
    private MakeGlossariesGUI app;
    private JToolBar toolbar;

    public ViewEntries(MakeGlossariesGUI makeGlossariesGUI, Glossary glossary, Font font) {
        super(MakeGlossariesGUI.getLabelWithValue("entry.title", glossary.label));
        this.app = makeGlossariesGUI;
        this.glossary = glossary;
        this.setIconImage(this.app.getIconImage());
        AbstractTableModel abstractTableModel = new AbstractTableModel(){

            @Override
            public int getRowCount() {
                return ViewEntries.this.glossary.getNumEntries();
            }

            @Override
            public int getColumnCount() {
                return 2;
            }

            @Override
            public boolean isCellEditable(int n, int n2) {
                return false;
            }

            @Override
            public Object getValueAt(int n, int n2) {
                if (n2 == 0) {
                    return ViewEntries.this.glossary.getEntryLabel(n);
                }
                return ViewEntries.this.glossary.getEntryCount(n);
            }

            @Override
            public String getColumnName(int n) {
                return n == 0 ? MakeGlossariesGUI.getLabel("entry.label") : MakeGlossariesGUI.getLabel("entry.count");
            }
        };
        this.table = new JTable(abstractTableModel);
        this.getContentPane().add((Component)new JScrollPane(this.table), "Center");
        this.toolbar = new JToolBar();
        this.getContentPane().add((Component)this.toolbar, "North");
        JLabel jLabel = new JLabel(MakeGlossariesGUI.getLabel("entry", "find_label"));
        jLabel.setDisplayedMnemonic(MakeGlossariesGUI.getMnemonic("entry", "find_label"));
        this.toolbar.add(jLabel);
        this.searchField = new JTextField();
        this.searchField.registerKeyboardAction(this, "find", KeyStroke.getKeyStroke(10, 0), 0);
        this.toolbar.add(this.searchField);
        jLabel.setLabelFor(this.searchField);
        this.addButton("find", "Find24", KeyStroke.getKeyStroke(70, 2));
        this.pack();
    }

    private JButton addButton(String string, String string2, KeyStroke keyStroke) {
        JButton jButton = new JButton();
        String string3 = MakeGlossariesGUI.getLabel("entry." + string, "tooltip");
        String string4 = MakeGlossariesGUI.getLabel("entry", string);
        String string5 = "/toolbarButtonGraphics/general/" + string2 + ".gif";
        URL uRL = this.app.getClass().getResource(string5);
        jButton.setActionCommand(string);
        jButton.addActionListener(this);
        if (keyStroke != null) {
            jButton.registerKeyboardAction(this, string, keyStroke, 2);
        }
        jButton.setToolTipText(string3);
        if (uRL != null) {
            jButton.setIcon(new ImageIcon(uRL, string4));
        } else {
            jButton.setText(string4);
            System.err.println("Unable to find resource: " + uRL);
        }
        this.toolbar.add(jButton);
        return jButton;
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        String string = actionEvent.getActionCommand();
        if (string == null) {
            return;
        }
        if (string.equals("find")) {
            String string2 = this.searchField.getText();
            int n = this.glossary.getEntryIdx(string2);
            if (n == -1) {
                MakeGlossariesGUI.error(this, MakeGlossariesGUI.getLabelWithValue("error.no_such_entry", string2));
            } else {
                this.table.clearSelection();
                this.table.addRowSelectionInterval(n, n);
                Rectangle rectangle = this.table.getCellRect(n, 1, true);
                this.table.scrollRectToVisible(rectangle);
            }
        }
    }
}

