/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.uea.cmp.nlct.makeglossaries;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.BufferedReader;
import java.io.File;
import java.io.InputStreamReader;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import uk.ac.uea.cmp.nlct.makeglossaries.FileField;
import uk.ac.uea.cmp.nlct.makeglossaries.MakeGlossariesGUI;
import uk.ac.uea.cmp.nlct.makeglossaries.MakeGlossariesProperties;

public class PropertiesDialog
extends JDialog
implements ActionListener {
    private MakeGlossariesGUI app;
    private JRadioButton homeButton;
    private JRadioButton lastButton;
    private JRadioButton customButton;
    private JCheckBox germanWordOrderButton;
    private JComboBox languageBox;
    private JComboBox encodingBox;
    private FileField customField;
    private FileField makeindexField;
    private FileField xindyField;
    private JFileChooser fileChooser;
    private MakeGlossariesProperties properties;
    private static final String[] knownXindyLanguages = new String[]{"albanian", "belarusian", "bulgarian", "croatian", "czech", "danish", "dutch", "english", "esperanto", "estonian", "finnish", "french", "general", "georgian", "german", "greek", "gypsy", "hausa", "hebrew", "hungarian", "icelandic", "italian", "klingon", "kurdish", "latin", "latvian", "lithuanian", "lower-sorbian", "macedonian", "mongolian", "norwegian", "polish", "portuguese", "romanian", "russian", "serbian", "slovak", "slovenian", "spanish", "swedish", "turkish", "ukrainian", "upper-sorbian", "vietnamese"};
    private static final String[] knownEncodings = new String[]{"cp1250", "cp1251", "cp1252", "ij-as-ij-latin1", "ij-as-ij-utf8", "ij-as-y-utf8", "iso88595", "iso88597", "isoir111", "koi8-r", "latin1", "latin2", "latin3", "latin4", "latin5", "latin9", "modern-latin1", "modern-utf8", "polytonic-utf8", "traditional-latin1", "traditional-utf8", "translit-latin4", "translit-utf8", "utf8"};

    public PropertiesDialog(MakeGlossariesGUI makeGlossariesGUI) {
        super(makeGlossariesGUI, MakeGlossariesGUI.getLabel("properties.title"), true);
        this.app = makeGlossariesGUI;
        this.properties = this.app.getProperties();
        File file = new File(this.properties.getDefaultDirectory());
        String string = this.properties.getDefaultDirectorySetting();
        if (string == null) {
            string = "home";
        }
        this.fileChooser = new JFileChooser(this.getDir());
        Box box = Box.createVerticalBox();
        this.getContentPane().add((Component)box, "Center");
        JLabel jLabel = new JLabel(MakeGlossariesGUI.getLabel("properties.start_dir"));
        jLabel.setAlignmentX(0.0f);
        box.add(jLabel);
        Dimension dimension = jLabel.getPreferredSize();
        int n = (int)dimension.getWidth();
        Box box2 = Box.createVerticalBox();
        box2.setAlignmentX(0.0f);
        box.add(box2);
        ButtonGroup buttonGroup = new ButtonGroup();
        this.homeButton = new JRadioButton(MakeGlossariesGUI.getLabel("properties.dir.home"));
        this.homeButton.setActionCommand("disablecustom");
        this.homeButton.addActionListener(this);
        this.homeButton.setMnemonic(MakeGlossariesGUI.getMnemonicInt("properties.dir.home"));
        this.homeButton.setAlignmentX(0.0f);
        buttonGroup.add(this.homeButton);
        box2.add(this.homeButton);
        dimension = this.homeButton.getPreferredSize();
        n = (int)Math.max((double)n, dimension.getWidth());
        this.lastButton = new JRadioButton(MakeGlossariesGUI.getLabel("properties.dir.last"));
        this.lastButton.setActionCommand("disablecustom");
        this.lastButton.setMnemonic(MakeGlossariesGUI.getMnemonicInt("properties.dir.last"));
        this.lastButton.addActionListener(this);
        this.lastButton.setAlignmentX(0.0f);
        buttonGroup.add(this.lastButton);
        box2.add(this.lastButton);
        dimension = this.lastButton.getPreferredSize();
        n = (int)Math.max((double)n, dimension.getWidth());
        Box box3 = Box.createHorizontalBox();
        box3.setAlignmentX(0.0f);
        box2.add(box3);
        this.customButton = new JRadioButton(MakeGlossariesGUI.getLabel("properties.dir.custom"));
        this.customButton.setMnemonic(MakeGlossariesGUI.getMnemonicInt("properties.dir.custom"));
        this.customButton.setActionCommand("enablecustom");
        this.customButton.addActionListener(this);
        buttonGroup.add(this.customButton);
        box3.add(this.customButton);
        dimension = this.customButton.getPreferredSize();
        n = (int)Math.max((double)n, dimension.getWidth());
        this.customField = new FileField((Container)this, this.fileChooser, 1);
        box3.add(this.customField);
        if (string.equals("home")) {
            this.homeButton.setSelected(true);
            this.customField.setEnabled(false);
        } else if (string.equals("last")) {
            this.homeButton.setSelected(true);
            this.customField.setEnabled(false);
        } else if (string.equals("custom")) {
            this.customButton.setSelected(true);
            this.customField.setFileName(file.getAbsolutePath());
        }
        Box box4 = Box.createVerticalBox();
        box4.setBorder(BorderFactory.createEtchedBorder());
        box.add(box4);
        box3 = Box.createHorizontalBox();
        box3.setAlignmentX(0.0f);
        box4.add(box3);
        JLabel jLabel2 = new JLabel(MakeGlossariesGUI.getLabel("properties.makeindex"));
        jLabel2.setDisplayedMnemonic(MakeGlossariesGUI.getMnemonic("properties.makeindex"));
        box3.add(jLabel2);
        dimension = jLabel2.getPreferredSize();
        n = (int)Math.max((double)n, dimension.getWidth());
        this.makeindexField = new FileField((Container)this, this.properties.getMakeIndexApp(), this.fileChooser);
        jLabel2.setLabelFor(this.makeindexField.getTextField());
        box3.add(this.makeindexField);
        this.germanWordOrderButton = new JCheckBox(MakeGlossariesGUI.getLabel("properties.german_word_order"), false);
        this.germanWordOrderButton.setMnemonic(MakeGlossariesGUI.getMnemonic("properties.german_word_order"));
        this.germanWordOrderButton.setSelected(this.properties.useGermanWordOrdering());
        Box box5 = Box.createVerticalBox();
        box5.setBorder(BorderFactory.createEtchedBorder());
        box.add(box5);
        box3 = Box.createHorizontalBox();
        box3.setAlignmentX(0.0f);
        box5.add(box3);
        JLabel jLabel3 = new JLabel(MakeGlossariesGUI.getLabel("properties.xindy"));
        jLabel3.setDisplayedMnemonic(MakeGlossariesGUI.getMnemonic("properties.xindy"));
        box3.add(jLabel3);
        JPanel jPanel = new JPanel();
        jPanel.setAlignmentX(0.0f);
        box5.add(jPanel);
        JLabel jLabel4 = new JLabel(MakeGlossariesGUI.getLabel("properties.language"));
        jLabel4.setDisplayedMnemonic(MakeGlossariesGUI.getMnemonic("properties.language"));
        jPanel.add(jLabel4);
        this.languageBox = new JComboBox<String>(knownXindyLanguages);
        this.languageBox.setEditable(true);
        jLabel4.setLabelFor(this.languageBox);
        this.languageBox.setSelectedItem(this.properties.getDefaultLanguage());
        jPanel.add(this.languageBox);
        JLabel jLabel5 = new JLabel(MakeGlossariesGUI.getLabel("properties.encoding"));
        jLabel5.setDisplayedMnemonic(MakeGlossariesGUI.getMnemonic("properties.encoding"));
        jPanel.add(jLabel5);
        this.encodingBox = new JComboBox<String>(knownEncodings);
        this.encodingBox.setEditable(true);
        jLabel5.setLabelFor(this.encodingBox);
        this.encodingBox.setSelectedItem(this.properties.getDefaultCodePage());
        jPanel.add(this.encodingBox);
        dimension = jLabel3.getPreferredSize();
        n = (int)Math.max((double)n, dimension.getWidth());
        this.xindyField = new FileField((Container)this, this.properties.getXindyApp(), this.fileChooser);
        jLabel3.setLabelFor(this.xindyField.getTextField());
        box3.add(this.xindyField);
        dimension = jLabel.getPreferredSize();
        dimension.width = n;
        jLabel.setPreferredSize(dimension);
        dimension = this.homeButton.getPreferredSize();
        dimension.width = n;
        this.homeButton.setPreferredSize(dimension);
        dimension = this.lastButton.getPreferredSize();
        dimension.width = n;
        this.lastButton.setPreferredSize(dimension);
        dimension = this.customButton.getPreferredSize();
        dimension.width = n;
        this.customButton.setPreferredSize(dimension);
        dimension = jLabel2.getPreferredSize();
        dimension.width = n;
        jLabel2.setPreferredSize(dimension);
        dimension = jLabel3.getPreferredSize();
        dimension.width = n;
        jLabel3.setPreferredSize(dimension);
        JPanel jPanel2 = new JPanel();
        this.getContentPane().add((Component)jPanel2, "South");
        jPanel2.add(MakeGlossariesGUI.createOkayButton(this));
        jPanel2.add(MakeGlossariesGUI.createCancelButton(this));
        JButton jButton = new JButton(MakeGlossariesGUI.getLabel("button.help"));
        jButton.setMnemonic(MakeGlossariesGUI.getMnemonic("button.help"));
        this.app.enableHelpOnButton(jButton, "sec:properties");
        jPanel2.add(jButton);
        this.pack();
        this.setLocationRelativeTo(this.app);
    }

    private File getDir() {
        String string = this.app.getMakeIndexApp();
        String string2 = this.app.getXindyApp();
        if ((string == null || string.equals("")) && (string2 == null || string2.equals(""))) {
            try {
                Process process = Runtime.getRuntime().exec("kpsewhich texmf.cnf");
                if (process.waitFor() == 0) {
                    File file;
                    BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(process.getInputStream()));
                    String string3 = bufferedReader.readLine();
                    bufferedReader.close();
                    if (string3 != null && (file = new File(string3).getParentFile()).isDirectory()) {
                        return file;
                    }
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return new File(this.properties.getDefaultDirectory());
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        String string = actionEvent.getActionCommand();
        if (string == null) {
            return;
        }
        if (string.equals("disablecustom")) {
            this.customField.setEnabled(false);
        } else if (string.equals("enablecustom")) {
            this.customField.setEnabled(true);
            this.customField.requestFocusInWindow();
        } else if (string.equals("cancel")) {
            this.setVisible(false);
        } else if (string.equals("okay")) {
            this.properties.setMakeIndexApp(this.makeindexField.getFileName());
            this.properties.setXindyApp(this.xindyField.getFileName());
            this.properties.setGermanWordOrdering(this.germanWordOrderButton.isSelected());
            this.properties.setDefaultLanguage((String)this.languageBox.getSelectedItem());
            this.properties.setDefaultCodePage((String)this.encodingBox.getSelectedItem());
            if (this.homeButton.isSelected()) {
                this.properties.setDefaultHomeDir();
            } else if (this.lastButton.isSelected()) {
                this.properties.setDefaultLastDir();
            } else {
                String string2 = this.customField.getFileName();
                if (string2.equals("")) {
                    MakeGlossariesGUI.error(this, MakeGlossariesGUI.getLabel("error.missing_dir_name"));
                    return;
                }
                File file = new File(string2);
                if (!file.isDirectory()) {
                    MakeGlossariesGUI.error(this, MakeGlossariesGUI.getLabelWithValue("error.no_such_directory", string2));
                }
                this.properties.setDefaultCustomDir(string2);
            }
            this.setVisible(false);
        }
    }

    public void display() {
        this.setVisible(true);
    }
}

