/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.uea.cmp.nlct.makeglossaries;

import java.awt.Cursor;
import java.io.File;
import java.io.IOException;
import uk.ac.uea.cmp.nlct.makeglossaries.Glossaries;
import uk.ac.uea.cmp.nlct.makeglossaries.GlossaryException;
import uk.ac.uea.cmp.nlct.makeglossaries.MakeGlossariesGUI;

public class ProcessThread
extends Thread {
    private MakeGlossariesGUI app;
    private File file;

    public ProcessThread(MakeGlossariesGUI makeGlossariesGUI, File file) {
        this.app = makeGlossariesGUI;
        this.file = file;
    }

    @Override
    public void run() {
        Cursor cursor = this.app.getCursor();
        this.app.setCursor(Cursor.getPredefinedCursor(3));
        try {
            this.processGlossaries();
            this.app.setCursor(cursor);
        }
        catch (InterruptedException interruptedException) {
            this.app.setCursor(cursor);
            if (this.app.glossaries != null) {
                this.app.glossaries.addDiagnosticMessage(MakeGlossariesGUI.getLabel("diagnostics.interrupt"));
            }
            MakeGlossariesGUI.error(this.app, MakeGlossariesGUI.getLabel("error.interrupt") + "\n" + interruptedException.getMessage());
        }
    }

    public void processGlossaries() throws InterruptedException {
        try {
            this.app.glossaries = Glossaries.loadGlossaries(this.app, this.file);
        }
        catch (IOException iOException) {
            MakeGlossariesGUI.error(this.app, "Unable to load file:\n" + iOException.getMessage());
            return;
        }
        try {
            this.app.glossaries.process();
        }
        catch (GlossaryException glossaryException) {
            String string = glossaryException.getDiagnosticMessage();
            if (string != null) {
                this.app.glossaries.addDiagnosticMessage(string);
            }
            MakeGlossariesGUI.error(this.app, glossaryException.getMessage());
            this.app.selectDiagnosticComponent();
        }
        catch (IOException iOException) {
            this.app.glossaries.addDiagnosticMessage(MakeGlossariesGUI.getLabel("diagnostics.io_error"));
            MakeGlossariesGUI.error(this.app, iOException.getMessage());
        }
        String string = this.app.glossaries.getErrorMessages();
        if (string != null) {
            MakeGlossariesGUI.error(this.app, string);
        }
        try {
            this.app.updateInfoPanel();
        }
        catch (Exception exception) {
            MakeGlossariesGUI.error(this.app, exception.getMessage());
        }
        this.app.updateDiagnostics();
    }
}

