/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.uea.cmp.nlct.makeglossaries;

import java.awt.event.ActionListener;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Locale;
import java.util.Properties;
import java.util.Vector;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import uk.ac.uea.cmp.nlct.makeglossaries.MakeGlossariesGUI;

public class MakeGlossariesProperties
extends Properties {
    private File propFile;
    private File recentFile;
    private static String propName = "makeglossaries.prop";
    private static String recentName = "recentfiles";
    private Vector<String> recentList;
    public static final int MAX_RECENT_FILES = 10;

    public MakeGlossariesProperties(File file, File file2) throws IOException {
        BufferedReader bufferedReader;
        this.propFile = file;
        this.recentFile = file2;
        this.recentList = new Vector();
        if (file != null && file.exists()) {
            bufferedReader = new BufferedReader(new FileReader(this.propFile));
            this.load(bufferedReader);
            bufferedReader.close();
        } else {
            this.setDefaults();
        }
        if (file2 != null && file2.exists()) {
            bufferedReader = new BufferedReader(new FileReader(file2));
            this.loadRecentFiles(bufferedReader);
            bufferedReader.close();
        }
    }

    public MakeGlossariesProperties() {
        this.propFile = null;
        this.recentFile = null;
        this.setDefaults();
    }

    protected void setDefaults() {
        this.setDefaultHomeDir();
        this.setProperty("language", Locale.getDefault().getDisplayLanguage().toLowerCase());
        this.setProperty("codepage", "utf8");
        this.setProperty("german-wordorder", "false");
        this.setProperty("fontsize", "12");
        this.setProperty("fontname", "Serif");
        this.setProperty("fontstyle", "0");
        this.setProperty("toolbar.position", "North");
        this.setProperty("toolbar.orientation", "0");
    }

    public String getToolBarPosition() {
        String string = this.getProperty("toolbar.position");
        return string == null ? "North" : string;
    }

    public void setToolBarPosition(String string) {
        this.setProperty("toolbar.position", string == null ? "North" : string);
    }

    public int getToolBarOrientation() {
        int n = 0;
        String string = this.getProperty("toolbar.orientation");
        if (string != null) {
            try {
                n = Integer.parseInt(string);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return n;
    }

    public void setToolBarOrientation(int n) {
        this.setProperty("toolbar.orientation", "" + n);
    }

    public int getFontSize() {
        String string = this.getProperty("fontsize");
        if (string == null) {
            return 12;
        }
        try {
            return Integer.parseInt(string);
        }
        catch (NumberFormatException numberFormatException) {
            return 12;
        }
    }

    public int getFontStyle() {
        String string = this.getProperty("fontstyle");
        if (string == null) {
            return 0;
        }
        try {
            return Integer.parseInt(string);
        }
        catch (NumberFormatException numberFormatException) {
            return 0;
        }
    }

    public String getFontName() {
        String string = this.getProperty("fontname");
        return string == null ? "Serif" : string;
    }

    public void setFontSize(int n) {
        this.setProperty("fontsize", "" + n);
    }

    public void setFontStyle(int n) {
        this.setProperty("fontstyle", "" + n);
    }

    public void setFontName(String string) {
        this.setProperty("fontname", string);
    }

    public String getDefaultLanguage() {
        String string = this.getProperty("language");
        return string == null ? "english" : string;
    }

    public void setDefaultLanguage(String string) {
        this.setProperty("language", string);
    }

    public String getDefaultCodePage() {
        String string = this.getProperty("codepage");
        return string == null ? "utf8" : string;
    }

    public void setDefaultCodePage(String string) {
        this.setProperty("codepage", string);
    }

    public static MakeGlossariesProperties fetchProperties() throws IOException {
        File file = MakeGlossariesProperties.getOrMakeConfigDir();
        File file2 = null;
        File file3 = null;
        if (file != null) {
            file2 = new File(file, propName);
            file3 = new File(file, recentName);
        }
        return new MakeGlossariesProperties(file2, file3);
    }

    public void save(MakeGlossariesGUI makeGlossariesGUI) throws IOException {
        File file = MakeGlossariesProperties.getConfigDir();
        if (file == null) {
            file = MakeGlossariesProperties.getOrMakeConfigDir();
        }
        if (file == null) {
            throw new IOException("Unable to create properties directory");
        }
        if (this.propFile == null) {
            this.propFile = new File(file, propName);
        }
        if (this.getProperty("directory.setting").equals("last")) {
            this.setProperty("directory", makeGlossariesGUI.getCurrentDirectoryName());
        }
        PrintWriter printWriter = new PrintWriter(new FileWriter(this.propFile));
        this.store(printWriter, "makeglossaries-gui properties");
        printWriter.close();
        if (this.recentFile == null) {
            this.recentFile = new File(file, recentName);
        }
        printWriter = new PrintWriter(new FileWriter(this.recentFile));
        int n = this.recentList.size();
        for (int i = 0; i < n; ++i) {
            printWriter.println(this.recentList.get(i));
        }
        printWriter.close();
    }

    public String getDefaultDirectory() {
        String string = this.getProperty("directory.setting");
        if (string == null) {
            string = "home";
        }
        if (string.equals("home")) {
            this.setProperty("directory", System.getProperty("user.home"));
        }
        return this.getProperty("directory");
    }

    public String getDefaultDirectorySetting() {
        return this.getProperty("directory.setting");
    }

    public String getMakeIndexApp() {
        String string = this.getProperty("makeindex");
        if (string == null || string.equals("")) {
            return null;
        }
        return string;
    }

    public String getXindyApp() {
        String string = this.getProperty("xindy");
        if (string == null || string.equals("")) {
            return null;
        }
        return string;
    }

    public boolean useGermanWordOrdering() {
        String string = this.getProperty("german-wordorder");
        if (string == null) {
            return false;
        }
        return string.equals("true");
    }

    public void setGermanWordOrdering(boolean bl) {
        this.setProperty("german-wordorder", bl ? "true" : "false");
    }

    public void setDefaultCustomDir(String string) {
        this.setProperty("directory", string);
        this.setProperty("directory.setting", "custom");
    }

    public void setDefaultHomeDir() {
        this.setProperty("directory", System.getProperty("user.home"));
        this.setProperty("directory.setting", "home");
    }

    public void setDefaultLastDir() {
        this.setProperty("directory.setting", "last");
    }

    public void setMakeIndexApp(String string) {
        this.setProperty("makeindex", string);
    }

    public void setXindyApp(String string) {
        this.setProperty("xindy", string);
    }

    private void loadRecentFiles(BufferedReader bufferedReader) throws IOException {
        String string;
        while ((string = bufferedReader.readLine()) != null) {
            this.recentList.add(string);
        }
    }

    public void addRecentFile(String string) {
        this.recentList.remove(string);
        this.recentList.add(string);
    }

    public void setRecentFiles(JMenu jMenu, ActionListener actionListener) {
        if (this.recentList == null) {
            return;
        }
        if (jMenu.getMenuComponentCount() > 0) {
            jMenu.removeAll();
        }
        int n = this.recentList.size() - 1;
        int n2 = Math.min(9, n);
        for (int i = 0; i <= n2; ++i) {
            File file = new File(this.recentList.get(n - i));
            String string = "" + i;
            JMenuItem jMenuItem = new JMenuItem(string + ": " + file.getName());
            jMenuItem.setMnemonic(string.charAt(0));
            jMenuItem.setToolTipText(file.getAbsolutePath());
            jMenuItem.setActionCommand(string);
            jMenuItem.addActionListener(actionListener);
            jMenu.add(jMenuItem);
        }
    }

    public String getRecentFileName(int n) {
        return this.recentList.get(this.recentList.size() - 1 - n);
    }

    public static File getConfigDir() {
        File file = null;
        String string = System.getenv("MAKEGLOSSARIES-SETTINGS");
        if (string != null && (file = new File(string)).isDirectory()) {
            return file;
        }
        String string2 = System.getProperty("user.home");
        if (string2 == null) {
            return null;
        }
        file = new File(string2, ".makeglossaries");
        if (file.isDirectory()) {
            return file;
        }
        file = new File(string2, "makeglossaries-settings");
        if (file.isDirectory()) {
            return file;
        }
        return null;
    }

    public static File getOrMakeConfigDir() {
        File file;
        String string;
        File file2 = null;
        String string2 = System.getenv("MAKEGLOSSARIES-SETTINGS");
        if (string2 != null) {
            file2 = new File(string2);
            if (!file2.exists() && file2.mkdir()) {
                return file2;
            }
            if (file2.isDirectory()) {
                return file2;
            }
        }
        if ((string = System.getProperty("user.home")) == null) {
            return null;
        }
        if (System.getProperty("os.name").toLowerCase().indexOf("windows") != -1) {
            file2 = new File(string, "makeglossaries-settings");
            file = new File(string, ".makeglossaries");
        } else {
            file2 = new File(string, ".makeglossaries");
            file = new File(string, "makeglossaries-settings");
        }
        if (file2.isDirectory()) {
            return file2;
        }
        if (file.isDirectory()) {
            return file;
        }
        if (file2.mkdir()) {
            return file2;
        }
        if (file.mkdir()) {
            return file;
        }
        return null;
    }
}

