/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.uea.cmp.nlct.makeglossaries;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.Hashtable;
import java.util.Locale;
import java.util.Properties;
import javax.help.BadIDException;
import javax.help.CSH;
import javax.help.HelpBroker;
import javax.help.HelpSet;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextArea;
import javax.swing.JToolBar;
import javax.swing.KeyStroke;
import javax.swing.event.MenuEvent;
import javax.swing.event.MenuListener;
import javax.swing.text.BadLocationException;
import uk.ac.uea.cmp.nlct.makeglossaries.AuxFileFilter;
import uk.ac.uea.cmp.nlct.makeglossaries.Glossaries;
import uk.ac.uea.cmp.nlct.makeglossaries.GlossariesPanel;
import uk.ac.uea.cmp.nlct.makeglossaries.MakeGlossariesProperties;
import uk.ac.uea.cmp.nlct.makeglossaries.ProcessThread;
import uk.ac.uea.cmp.nlct.makeglossaries.PropertiesDialog;
import uk.ac.uea.cmp.nlct.makeglossaries.ViewFile;

public class MakeGlossariesGUI
extends JFrame
implements ActionListener,
MenuListener {
    private JFileChooser fileChooser;
    private AuxFileFilter auxFileFilter;
    private String currentFileName = null;
    private MakeGlossariesProperties properties;
    private static Properties dictionary;
    private static final String appName = "MakeGlossariesGUI";
    private static final String appVersion = "1.0";
    private GlossariesPanel mainPanel;
    private JTabbedPane tabbedPane;
    private JScrollPane scrollPane;
    private JScrollPane diagnosticSP;
    private JTextArea diagnosticArea;
    protected Glossaries glossaries;
    private JMenu recentM;
    private PropertiesDialog propertiesDialog;
    private String mainInfoTemplate;
    private String glossaryInfoTemplate;
    private Hashtable<String, String> languageMap;
    private JToolBar toolBar;
    private HelpBroker mainHelpBroker;
    private CSH.DisplayHelpFromSource csh;

    public MakeGlossariesGUI() {
        super(appName);
        this.setDefaultCloseOperation(0);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent windowEvent) {
                MakeGlossariesGUI.this.quit();
            }
        });
        try {
            this.loadDictionary();
        }
        catch (IOException iOException) {
            MakeGlossariesGUI.error(this, "Unable to load dictionary file:\n" + iOException.getMessage());
        }
        this.setIconImage(new ImageIcon(this.getClass().getResource("/icons/logosmall.png")).getImage());
        try {
            this.initTemplates();
        }
        catch (IOException iOException) {
            MakeGlossariesGUI.error(this, iOException.getMessage());
        }
        this.initLanguageMappings();
        try {
            this.properties = MakeGlossariesProperties.fetchProperties();
        }
        catch (IOException iOException) {
            MakeGlossariesGUI.error(this, "Unable to load properties:\n" + iOException.getMessage());
            this.properties = new MakeGlossariesProperties();
        }
        this.toolBar = new JToolBar(this.properties.getToolBarOrientation());
        this.getContentPane().add((Component)this.toolBar, this.properties.getToolBarPosition());
        JMenuBar jMenuBar = new JMenuBar();
        this.setJMenuBar(jMenuBar);
        JMenu jMenu = this.createMenu("file");
        jMenuBar.add(jMenu);
        this.recentM = this.createMenu("file", "recent");
        this.recentM.addMenuListener(this);
        jMenu.add(this.recentM);
        jMenu.add(this.createMenuButtonItem("file", "open", KeyStroke.getKeyStroke(79, 2), "general/Open24"));
        jMenu.add(this.createMenuButtonItem("file", "reload", KeyStroke.getKeyStroke(82, 2), "general/Refresh24"));
        jMenu.add(this.createMenuItem("file", "quit", KeyStroke.getKeyStroke(81, 2)));
        JMenu jMenu2 = this.createMenu("settings");
        jMenuBar.add(jMenu2);
        jMenu2.add(this.createMenuButtonItem("settings", "incsize", KeyStroke.getKeyStroke(73, 2), "general/ZoomIn24"));
        jMenu2.add(this.createMenuButtonItem("settings", "decsize", KeyStroke.getKeyStroke(68, 2), "general/ZoomOut24"));
        jMenu2.add(this.createMenuItem("settings", "editproperties"));
        this.initHelp();
        JMenu jMenu3 = this.createMenu("help");
        jMenuBar.add(jMenu3);
        jMenu3.add(this.createMenuItem("help", "about"));
        jMenu3.add(this.createMenuItem("help", "license"));
        jMenu3.add(this.createMenuButtonItem("help", "manual", KeyStroke.getKeyStroke(112, 0), "general/Help24", this.csh));
        this.tabbedPane = new JTabbedPane();
        this.getContentPane().add((Component)this.tabbedPane, "Center");
        try {
            this.mainPanel = new GlossariesPanel(this);
        }
        catch (Exception exception) {
            MakeGlossariesGUI.fatalError(exception);
        }
        this.scrollPane = new JScrollPane(this.mainPanel);
        this.scrollPane.setPreferredSize(new Dimension(800, 600));
        this.setFont(new Font(this.properties.getFontName(), this.properties.getFontStyle(), this.properties.getFontSize()));
        this.scrollPane.setName(MakeGlossariesGUI.getLabel("main.title"));
        this.tabbedPane.add((Component)this.scrollPane, 0);
        this.tabbedPane.setMnemonicAt(0, MakeGlossariesGUI.getMnemonicInt("main.title"));
        this.diagnosticArea = new JTextArea();
        this.diagnosticArea.setEditable(false);
        this.diagnosticArea.setLineWrap(true);
        this.diagnosticArea.setWrapStyleWord(true);
        this.diagnosticArea.setFont(this.getFont());
        this.diagnosticSP = new JScrollPane(this.diagnosticArea);
        this.diagnosticSP.setName(MakeGlossariesGUI.getLabel("diagnostics.title"));
        this.tabbedPane.add((Component)this.diagnosticSP, 1);
        this.tabbedPane.setMnemonicAt(1, MakeGlossariesGUI.getMnemonicInt("diagnostics.title"));
        this.auxFileFilter = new AuxFileFilter(MakeGlossariesGUI.getLabel("filter.aux"));
        this.fileChooser = new JFileChooser(this.properties.getDefaultDirectory());
        this.fileChooser.setFileFilter(this.auxFileFilter);
        this.propertiesDialog = new PropertiesDialog(this);
        this.pack();
        this.setLocationRelativeTo(null);
        this.setVisible(true);
        String string = this.getXindyApp();
        String string2 = this.getMakeIndexApp();
        if ((string == null || string.equals("")) && (string2 == null || string2.equals(""))) {
            this.propertiesDialog.display();
        }
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        Object object;
        String string = actionEvent.getActionCommand();
        if (string == null) {
            return;
        }
        try {
            int n = Integer.parseInt(string);
            object = new File(this.properties.getRecentFileName(n));
            this.fileChooser.setCurrentDirectory(((File)object).getParentFile());
            this.load((File)object);
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        if (string.equals("open")) {
            if (this.fileChooser.showOpenDialog(this) == 0) {
                this.load(this.fileChooser.getSelectedFile());
            }
        } else if (string.equals("reload")) {
            this.reload();
        } else if (string.equals("quit")) {
            this.quit();
        } else if (string.equals("incsize")) {
            Font font = this.getFont();
            int n = font.getSize() + 1;
            int n2 = font.getStyle();
            String string2 = font.getFontName();
            this.setFont(new Font(string2, n2, n));
            this.properties.setFontSize(n);
            this.updateAll();
        } else if (string.equals("decsize")) {
            Font font = this.getFont();
            int n = font.getSize() - 1;
            int n3 = font.getStyle();
            String string3 = font.getFontName();
            if (n < 2) {
                return;
            }
            this.setFont(new Font(string3, n3, n));
            this.properties.setFontSize(n);
            this.updateAll();
        } else if (string.equals("editproperties")) {
            this.propertiesDialog.display();
        } else if (string.equals("about")) {
            object = dictionary.getProperty("about.translator_info");
            String[] stringArray = object == null || ((String)object).equals("") ? new String[]{appName, MakeGlossariesGUI.getLabelWithValue("about.version", appVersion), MakeGlossariesGUI.getLabelWithValues("about.copyright", "Nicola L. C. Talbot", "2011/09/16"), "http://theoval.cmp.uea.ac.uk/~nlct/"} : new String[]{appName, MakeGlossariesGUI.getLabelWithValue("about.version", appVersion), MakeGlossariesGUI.getLabelWithValues("about.copyright", "Nicola L. C. Talbot", "2011/09/16"), "http://theoval.cmp.uea.ac.uk/~nlct/", object};
            JOptionPane.showMessageDialog(this, stringArray, MakeGlossariesGUI.getLabelWithValue("about.title", appName), -1);
        } else if (string.equals("license")) {
            URL uRL = this.getClass().getResource("/resources/LICENSE");
            if (uRL != null) {
                try {
                    new ViewFile(uRL, this.getFont(), this).setVisible(true);
                }
                catch (Exception exception) {
                    MakeGlossariesGUI.error(this, exception.getMessage());
                }
            } else {
                MakeGlossariesGUI.error(this, "Can't locate resources/LICENSE");
            }
        }
    }

    @Override
    public void menuSelected(MenuEvent menuEvent) {
        Object object = menuEvent.getSource();
        if (object == this.recentM) {
            this.properties.setRecentFiles(this.recentM, this);
        }
    }

    @Override
    public void menuDeselected(MenuEvent menuEvent) {
    }

    @Override
    public void menuCanceled(MenuEvent menuEvent) {
    }

    public void quit() {
        try {
            this.properties.setToolBarPosition((String)((BorderLayout)this.getContentPane().getLayout()).getConstraints(this.toolBar));
            this.properties.setToolBarOrientation(this.toolBar.getOrientation());
            this.properties.save(this);
        }
        catch (IOException iOException) {
            MakeGlossariesGUI.error(this, "Unable to save properties:\n" + iOException.getMessage());
        }
        System.exit(0);
    }

    public void load(File file) {
        this.currentFileName = file.getAbsolutePath();
        this.setTitle("MakeGlossariesGUI - " + file.getName());
        this.properties.addRecentFile(this.currentFileName);
        this.reload(file);
    }

    public void reload() {
        this.reload(new File(this.currentFileName));
    }

    public void reload(File file) {
        ProcessThread processThread = new ProcessThread(this, file);
        processThread.start();
        processThread = null;
    }

    public void updateAll() {
        Component component = this.tabbedPane.getSelectedComponent();
        this.updateDiagnostics();
        this.tabbedPane.setSelectedComponent(component);
        try {
            this.mainPanel.updateInfo();
        }
        catch (Exception exception) {
            MakeGlossariesGUI.error(this, exception.getMessage());
        }
    }

    public void updateDiagnostics() {
        this.diagnosticArea.setFont(this.getFont());
        if (this.glossaries != null) {
            String string = this.glossaries.getDiagnostics();
            if (string == null) {
                this.diagnosticArea.setText(MakeGlossariesGUI.getLabel("diagnostics.no_errors"));
            } else {
                this.diagnosticArea.setText(string);
                this.tabbedPane.setSelectedComponent(this.diagnosticSP);
            }
        }
    }

    private JMenu createMenu(String string) {
        return this.createMenu(null, string);
    }

    private JMenu createMenu(String string, String string2) {
        JMenu jMenu = new JMenu(MakeGlossariesGUI.getLabel(string, string2));
        jMenu.setMnemonic(MakeGlossariesGUI.getMnemonic(string, string2));
        return jMenu;
    }

    private JMenuItem createMenuItem(String string, String string2) {
        return this.createMenuItem(string, string2, null, null, this);
    }

    private JMenuItem createMenuItem(String string, String string2, KeyStroke keyStroke) {
        return this.createMenuItem(string, string2, keyStroke, null, this);
    }

    private JMenuItem createMenuItem(String string, String string2, String string3) {
        return this.createMenuItem(string, string2, null, string3, this);
    }

    private JMenuItem createMenuItem(String string, String string2, KeyStroke keyStroke, String string3) {
        return this.createMenuItem(string, string2, keyStroke, string3, this);
    }

    private JMenuItem createMenuItem(String string, String string2, KeyStroke keyStroke, String string3, ActionListener actionListener) {
        JMenuItem jMenuItem = new JMenuItem(MakeGlossariesGUI.getLabel(string, string2));
        jMenuItem.setMnemonic(MakeGlossariesGUI.getMnemonic(string, string2));
        jMenuItem.setActionCommand(string2);
        if (actionListener != null) {
            jMenuItem.addActionListener(actionListener);
        }
        if (keyStroke != null) {
            jMenuItem.setAccelerator(keyStroke);
        }
        if (string3 != null) {
            jMenuItem.setToolTipText(string3);
        }
        return jMenuItem;
    }

    private JMenuItem createMenuButtonItem(String string, String string2, KeyStroke keyStroke, String string3) {
        return this.createMenuButtonItem(string, string2, keyStroke, string3, this);
    }

    private JMenuItem createMenuButtonItem(String string, String string2, KeyStroke keyStroke, String string3, ActionListener actionListener) {
        String string4 = dictionary.getProperty(string + "." + string2 + ".tooltip");
        String string5 = dictionary.getProperty(string + "." + string2 + ".altText");
        JMenuItem jMenuItem = this.createMenuItem(string, string2, keyStroke, string4, actionListener);
        String string6 = "/toolbarButtonGraphics/" + string3 + ".gif";
        URL uRL = this.getClass().getResource(string6);
        JButton jButton = new JButton();
        jButton.setActionCommand(string2);
        if (actionListener != null) {
            jButton.addActionListener(actionListener);
        }
        if (string4 != null) {
            jButton.setToolTipText(string4);
        }
        if (uRL != null) {
            jButton.setIcon(new ImageIcon(uRL, string5));
        } else {
            jButton.setText(string5);
            MakeGlossariesGUI.error(this, "Resource not found:\n" + string6);
        }
        this.toolBar.add(jButton);
        return jMenuItem;
    }

    public static String getLabel(String string) {
        return MakeGlossariesGUI.getLabel(null, string);
    }

    public static String getLabel(String string, String string2) {
        String string3;
        if (string != null) {
            string2 = string + "." + string2;
        }
        if ((string3 = dictionary.getProperty(string2)) == null) {
            System.err.println("No such dictionary property '" + string2 + "'");
            return "?" + string2 + "?";
        }
        return string3;
    }

    public static char getMnemonic(String string) {
        return MakeGlossariesGUI.getMnemonic(null, string);
    }

    public static char getMnemonic(String string, String string2) {
        String string3 = MakeGlossariesGUI.getLabel(string, string2 + ".mnemonic");
        if (string3.equals("")) {
            System.err.println("Empty dictionary property '" + string3 + "'");
            return string2.charAt(0);
        }
        return string3.charAt(0);
    }

    public static int getMnemonicInt(String string) {
        return MakeGlossariesGUI.getMnemonicInt(null, string);
    }

    public static int getMnemonicInt(String string, String string2) {
        String string3 = MakeGlossariesGUI.getLabel(string, string2 + ".mnemonic");
        if (string3.equals("")) {
            System.err.println("Empty dictionary property '" + string3 + "'");
            return string2.codePointAt(0);
        }
        return string3.codePointAt(0);
    }

    public static String getLabelWithValue(String string, String string2) {
        String string3 = MakeGlossariesGUI.getLabel(string);
        return string3.replaceAll("\\$1", string2);
    }

    public static String getLabelWithValues(String string, String string2, String string3) {
        String string4 = MakeGlossariesGUI.getLabel(string);
        return string4.replaceAll("\\$1", string2).replaceAll("\\$2", string3);
    }

    public int getFontSize() {
        return this.getFont().getSize();
    }

    public String getDefaultLanguage() {
        return this.properties.getDefaultLanguage();
    }

    public String getDefaultCodePage() {
        return this.properties.getDefaultCodePage();
    }

    public static JButton createActionButton(String string, ActionListener actionListener, KeyStroke keyStroke, String string2) {
        JButton jButton = new JButton(MakeGlossariesGUI.getLabel("button", string));
        jButton.setMnemonic(MakeGlossariesGUI.getMnemonic("button", string));
        jButton.setActionCommand(string);
        if (actionListener != null) {
            jButton.addActionListener(actionListener);
            if (keyStroke != null) {
                jButton.registerKeyboardAction(actionListener, string, keyStroke, 2);
            }
        }
        if (string2 != null) {
            jButton.setToolTipText(string2);
        }
        return jButton;
    }

    public static JButton createOkayButton(ActionListener actionListener) {
        return MakeGlossariesGUI.createActionButton("okay", actionListener, KeyStroke.getKeyStroke(10, 0), null);
    }

    public static JButton createCancelButton(ActionListener actionListener) {
        return MakeGlossariesGUI.createActionButton("cancel", actionListener, KeyStroke.getKeyStroke(27, 0), null);
    }

    public static void error(Component component, String string) {
        JOptionPane.showMessageDialog(component, string, MakeGlossariesGUI.getLabel("error.title"), 0);
    }

    public static void fatalError(Exception exception) {
        JOptionPane.showMessageDialog(null, MakeGlossariesGUI.getLabelWithValue("error.fatal.info", appName) + "\n" + exception.getMessage(), MakeGlossariesGUI.getLabel("error.fatal.title"), 0);
        exception.printStackTrace();
        System.exit(1);
    }

    private void loadDictionary() throws IOException {
        Locale locale = Locale.getDefault();
        String string = locale.getLanguage();
        InputStream inputStream = this.getClass().getResourceAsStream("/resources/dictionaries/makeglossaries-" + string + ".prop");
        if (inputStream == null && !string.equals("en")) {
            inputStream = this.getClass().getResourceAsStream("/resources/dictionaries/makeglossaries-en.prop");
        }
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(inputStream));
        dictionary = new Properties();
        dictionary.load(bufferedReader);
        bufferedReader.close();
        inputStream.close();
    }

    private String loadTemplate(String string) throws IOException {
        String string2;
        String string3 = "";
        InputStream inputStream = this.getClass().getResourceAsStream("/resources/" + string + "-template.html");
        if (inputStream == null) {
            throw new IOException("Can't find resources template '" + string + "'");
        }
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(inputStream));
        while ((string2 = bufferedReader.readLine()) != null) {
            string3 = string3 + string2;
        }
        bufferedReader.close();
        inputStream.close();
        return string3;
    }

    private void initTemplates() throws IOException {
        this.mainInfoTemplate = this.loadTemplate("information");
        this.glossaryInfoTemplate = this.loadTemplate("glossary-info");
    }

    public String getMainInfoTemplate() {
        return this.mainInfoTemplate;
    }

    public String getGlossaryInfoTemplate() {
        return this.glossaryInfoTemplate;
    }

    public String getGlossaryInfoTemplate(String string) {
        return this.glossaryInfoTemplate.replaceAll("-LABEL", "-" + string);
    }

    public Glossaries getGlossaries() {
        return this.glossaries;
    }

    public MakeGlossariesProperties getProperties() {
        return this.properties;
    }

    public String getFileName() {
        return this.currentFileName;
    }

    public File getFile() {
        return new File(this.currentFileName);
    }

    public File getCurrentDirectory() {
        File file = this.getFile().getParentFile();
        if (file == null) {
            file = new File(this.properties.getDefaultDirectory());
        }
        return file;
    }

    public String getCurrentDirectoryName() {
        return this.getCurrentDirectory().getAbsolutePath();
    }

    public String getXindyApp() {
        return this.properties.getXindyApp();
    }

    public String getMakeIndexApp() {
        return this.properties.getMakeIndexApp();
    }

    public boolean useGermanWordOrdering() {
        return this.properties.useGermanWordOrdering();
    }

    public void selectDiagnosticComponent() {
        this.tabbedPane.setSelectedComponent(this.diagnosticSP);
    }

    public void updateInfoPanel() throws BadLocationException, IOException {
        this.mainPanel.updateInfo();
    }

    private void initLanguageMappings() {
        this.languageMap = new Hashtable();
        this.languageMap.put("american", "english");
        this.languageMap.put("british", "english");
        this.languageMap.put("francais", "french");
        this.languageMap.put("frenchb", "french");
        this.languageMap.put("germanb", "german");
        this.languageMap.put("magyar", "hungarian");
        this.languageMap.put("ngermanb", "german");
        this.languageMap.put("norsk", "norwegian");
        this.languageMap.put("portuges", "portuguese");
        this.languageMap.put("russianb", "russian");
        this.languageMap.put("UKenglish", "english");
        this.languageMap.put("ukraineb", "ukrainian");
        this.languageMap.put("USenglish", "english");
        this.languageMap.put("usorbian", "upper-sorbian");
    }

    private void initHelp() {
        if (this.mainHelpBroker == null) {
            HelpSet helpSet = null;
            String string = "/resources/helpsets/makeglossariesgui";
            String string2 = Locale.getDefault().getLanguage();
            try {
                URL uRL = this.getClass().getResource(string + "-" + string2 + "/makeglossariesgui.hs");
                if (uRL == null && !string2.equals("en")) {
                    uRL = this.getClass().getResource(string + "-en/makeglossariesgui.hs");
                }
                helpSet = new HelpSet(null, uRL);
            }
            catch (Exception exception) {
                MakeGlossariesGUI.error(this, "/resources/helpsets/makeglossariesgui.hs\n" + MakeGlossariesGUI.getLabel("error.io.helpset") + ":\n" + exception.getMessage());
            }
            if (helpSet != null) {
                this.mainHelpBroker = helpSet.createHelpBroker();
            }
            if (this.mainHelpBroker != null) {
                this.csh = new CSH.DisplayHelpFromSource(this.mainHelpBroker);
            }
        }
    }

    public void enableHelpOnButton(JComponent jComponent, String string) {
        if (this.mainHelpBroker != null) {
            try {
                this.mainHelpBroker.enableHelpOnButton(jComponent, string, this.mainHelpBroker.getHelpSet());
            }
            catch (BadIDException badIDException) {
                MakeGlossariesGUI.error(this, badIDException.getMessage());
                badIDException.printStackTrace();
            }
        }
    }

    public String getLanguage(String string) {
        String string2 = this.languageMap.get(string);
        return string2 == null ? string : string2;
    }

    public static void main(String[] stringArray) {
        new MakeGlossariesGUI();
    }
}

