/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.uea.cmp.nlct.makeglossaries;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import uk.ac.uea.cmp.nlct.makeglossaries.GlossaryException;
import uk.ac.uea.cmp.nlct.makeglossaries.MakeGlossariesGUI;

public class Glossary {
    public String label;
    public String transExt;
    public String glsExt;
    public String gloExt;
    private String language;
    private String codepage;
    private String errorMessage;
    private String diagnosticMessage;
    private Hashtable<String, Integer> entryTable;
    private MakeGlossariesGUI app;
    private static final Pattern makeindexAcceptedPattern = Pattern.compile(".*(\\d+)\\s+entries\\s+accepted.*(\\d+)\\s+rejected.*");
    private static final Pattern makeindexIstAttributePattern = Pattern.compile(".*(\\d+)\\s+attributes\\s+redefined.*(\\d+).*ignored.*");
    private static final Pattern xindyIstPattern = Pattern.compile(".*variable (.*) has no value.*");
    private static final Pattern xindyModulePattern = Pattern.compile(".*Cannot\\s+locate\\s+xindy\\s+module\\s+for\\s+language\\s+([a-zA-Z0-9\\-]+)\\s+in\\s+codepage\\s+([a-zA-Z0-9\\-]+)..*");
    private static final Pattern entryPattern = Pattern.compile(".*\\\\glossaryentryfield\\{([^\\}]+)\\}.*");

    public Glossary(MakeGlossariesGUI makeGlossariesGUI, String string, String string2, String string3, String string4) {
        this.app = makeGlossariesGUI;
        this.label = string;
        this.transExt = string2;
        this.glsExt = string3;
        this.gloExt = string4;
        this.entryTable = new Hashtable();
    }

    public void xindy(File file, String string, boolean bl, String string2) throws IOException, InterruptedException, GlossaryException {
        Matcher matcher;
        Object object;
        String string3;
        File file2 = new File(this.app.getXindyApp());
        if (!file2.exists()) {
            throw new GlossaryException(MakeGlossariesGUI.getLabelWithValues("error.no_indexer_app", "xindy", file2.getAbsolutePath()), MakeGlossariesGUI.getLabelWithValue("diagnostics.no_indexer", "xindy"));
        }
        String string4 = string + "." + this.transExt;
        if (this.language == null || this.language.equals("")) {
            this.language = this.app.getDefaultLanguage();
        }
        if (this.codepage == null || this.codepage.equals("")) {
            this.codepage = this.app.getDefaultCodePage();
        }
        String string5 = string2;
        int n = string2.lastIndexOf(".");
        if (n != -1) {
            string5 = string5.substring(0, n);
        }
        File file3 = new File(file, string + "." + this.gloExt);
        String[] stringArray = bl ? new String[]{file2.getAbsolutePath(), "-L", this.language, "-C", this.codepage, "-I", "xindy", "-M", string5, "-t", string4, "-o", string + "." + this.glsExt, file3.getName()} : new String[]{file2.getAbsolutePath(), "-L", this.language, "-C", this.codepage, "-I", "xindy", "-M", string5, "-M", "ord/letorder", "-t", string4, "-o", string + "." + this.glsExt, file3.getName()};
        Process process = Runtime.getRuntime().exec(stringArray, null, file);
        int n2 = process.waitFor();
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(process.getErrorStream()));
        String string6 = null;
        String string7 = null;
        while ((string3 = bufferedReader.readLine()) != null) {
            string6 = string6 == null ? "\n" + string3 : string6 + "\n" + string3;
            object = xindyModulePattern.matcher(string3);
            if (!((Matcher)object).matches()) continue;
            string7 = MakeGlossariesGUI.getLabelWithValues("diagnostics.unknown_language_or_codepage", ((Matcher)object).group(1), ((Matcher)object).group(2));
        }
        bufferedReader.close();
        object = null;
        File file4 = new File(file, string4);
        if (file4.exists()) {
            bufferedReader = new BufferedReader(new FileReader(file4));
            while ((string3 = bufferedReader.readLine()) != null) {
                matcher = xindyIstPattern.matcher(string3);
                if (!matcher.matches()) continue;
                object = matcher.group();
            }
            bufferedReader.close();
        }
        if (file3.exists()) {
            bufferedReader = new BufferedReader(new FileReader(file3));
            while ((string3 = bufferedReader.readLine()) != null) {
                matcher = entryPattern.matcher(string3);
                if (!matcher.matches()) continue;
                String string8 = matcher.group(1);
                Integer n3 = this.entryTable.get(string8);
                n3 = n3 == null ? new Integer(1) : new Integer(n3 + 1);
                this.entryTable.put(string8, n3);
            }
            bufferedReader.close();
        }
        if (n2 > 0) {
            this.addErrorMessage(MakeGlossariesGUI.getLabelWithValues("error.app_failed", "Xindy", "" + n2));
            if (object != null) {
                this.addDiagnosticMessage(MakeGlossariesGUI.getLabelWithValues("diagnostics.bad_attributes", string2, "xindy"));
            } else if (string7 != null) {
                this.addDiagnosticMessage(string7);
            } else if (string6 != null) {
                this.addDiagnosticMessage(MakeGlossariesGUI.getLabelWithValues("diagnostics.app_err", "Xindy", string6));
            } else {
                this.addDiagnosticMessage(MakeGlossariesGUI.getLabel("diagnostics.app_err_null"));
            }
        } else if (this.entryTable.size() == 0) {
            this.addDiagnosticMessage(MakeGlossariesGUI.getLabelWithValue("diagnostics.no_entries", this.label));
        }
    }

    public void makeindex(File file, String string, boolean bl, String string2) throws IOException, InterruptedException, GlossaryException {
        Matcher matcher;
        String string3;
        File file2 = new File(this.app.getMakeIndexApp());
        if (!file2.exists()) {
            throw new GlossaryException(MakeGlossariesGUI.getLabelWithValues("error.no_indexer_app", "makeindex", file2.getAbsolutePath()), MakeGlossariesGUI.getLabelWithValue("diagnostics.no_indexer", "makeindex"));
        }
        String string4 = string + "." + this.transExt;
        File file3 = new File(file, string + "." + this.gloExt);
        String[] stringArray = this.app.useGermanWordOrdering() ? (bl ? new String[]{file2.getAbsolutePath(), "-g", "-s", string2, "-t", string4, "-o", string + "." + this.glsExt, file3.getName()} : new String[]{file2.getAbsolutePath(), "-l", "-g", "-s", string2, "-t", string4, "-o", string + "." + this.glsExt, file3.getName()}) : (bl ? new String[]{file2.getAbsolutePath(), "-s", string2, "-t", string4, "-o", string + "." + this.glsExt, file3.getName()} : new String[]{file2.getAbsolutePath(), "-l", "-s", string2, "-t", string4, "-o", string + "." + this.glsExt, file3.getName()});
        Process process = Runtime.getRuntime().exec(stringArray, null, file);
        int n = process.waitFor();
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(process.getErrorStream()));
        String string5 = null;
        while ((string3 = bufferedReader.readLine()) != null) {
            if (string5 == null) {
                string5 = "\n" + string3;
                continue;
            }
            string5 = string5 + "\n" + string3;
        }
        bufferedReader.close();
        bufferedReader = new BufferedReader(new FileReader(new File(file, string4)));
        int n2 = 0;
        int n3 = 0;
        String string6 = "";
        int n4 = 0;
        int n5 = 0;
        while ((string3 = bufferedReader.readLine()) != null) {
            matcher = makeindexAcceptedPattern.matcher(string3);
            if (matcher.matches()) {
                try {
                    n2 = Integer.parseInt(matcher.group(1));
                    string6 = matcher.group(2);
                    n3 = Integer.parseInt(string6);
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
            if (!(matcher = makeindexIstAttributePattern.matcher(string3)).matches()) continue;
            try {
                n4 = Integer.parseInt(matcher.group(1));
                n5 = Integer.parseInt(matcher.group(2));
            }
            catch (NumberFormatException numberFormatException) {}
        }
        bufferedReader.close();
        if (file3.exists()) {
            bufferedReader = new BufferedReader(new FileReader(file3));
            while ((string3 = bufferedReader.readLine()) != null) {
                matcher = entryPattern.matcher(string3);
                if (!matcher.matches()) continue;
                String string7 = matcher.group(1);
                Integer n6 = this.entryTable.get(string7);
                n6 = n6 == null ? new Integer(1) : new Integer(n6 + 1);
                this.entryTable.put(string7, n6);
            }
            bufferedReader.close();
        }
        if (n > 0) {
            this.addErrorMessage(MakeGlossariesGUI.getLabelWithValues("error.app_failed", "Makeindex", "" + n));
            if (string5 != null) {
                this.addDiagnosticMessage(MakeGlossariesGUI.getLabelWithValues("diagnostics.app_err", "Makeindex", string5));
            } else {
                this.addDiagnosticMessage(MakeGlossariesGUI.getLabel("diagnostics.app_err_null"));
            }
        } else if (n3 > 0) {
            if (n3 == 1) {
                this.addErrorMessage(MakeGlossariesGUI.getLabel("error.entry_rejected"));
            } else {
                this.addErrorMessage(MakeGlossariesGUI.getLabelWithValue("error.entries_rejected", string6));
            }
            if (n2 == 0) {
                this.addDiagnosticMessage(MakeGlossariesGUI.getLabelWithValue("diagnostics.makeindex_reject_all", this.label));
            }
            if (n5 > 0) {
                this.addDiagnosticMessage(MakeGlossariesGUI.getLabelWithValues("diagnostics.bad_attributes", string2, "makeindex"));
            }
        } else if (n2 == 0) {
            if (this.label.equals("main")) {
                this.addDiagnosticMessage(MakeGlossariesGUI.getLabel("diagnostics.no_entries_main"));
            } else {
                this.addDiagnosticMessage(MakeGlossariesGUI.getLabelWithValue("diagnostics.no_entries", this.label));
            }
            this.addErrorMessage(MakeGlossariesGUI.getLabelWithValue("error.no_entries", this.label));
        }
    }

    public int getNumEntries() {
        return this.entryTable.size();
    }

    public Integer getEntryCount(int n) {
        int n2 = 0;
        Enumeration<Integer> enumeration = this.entryTable.elements();
        while (enumeration.hasMoreElements()) {
            Integer n3 = enumeration.nextElement();
            if (n2 == n) {
                return n3;
            }
            ++n2;
        }
        return 0;
    }

    public String getEntryLabel(int n) {
        int n2 = 0;
        Enumeration<String> enumeration = this.entryTable.keys();
        while (enumeration.hasMoreElements()) {
            String string = enumeration.nextElement();
            if (n2 == n) {
                return string;
            }
            ++n2;
        }
        return null;
    }

    public int getEntryIdx(String string) {
        int n = 0;
        Enumeration<String> enumeration = this.entryTable.keys();
        while (enumeration.hasMoreElements()) {
            String string2 = enumeration.nextElement();
            if (string2.equals(string)) {
                return n;
            }
            ++n;
        }
        return -1;
    }

    public void setLanguage(String string) {
        this.language = this.app.getLanguage(string);
    }

    public void setCodePage(String string) {
        this.codepage = string;
    }

    public String displayCodePage() {
        return this.codepage == null ? "<font class=error>" + MakeGlossariesGUI.getLabel("error.unknown") + "</font>" : this.codepage;
    }

    public String displayLanguage() {
        return this.language == null ? "<font class=error>" + MakeGlossariesGUI.getLabel("error.unknown") + "</font>" : this.language;
    }

    public void addErrorMessage(String string) {
        this.errorMessage = this.errorMessage == null ? string : this.errorMessage + "\n" + string;
    }

    public String getErrorMessages() {
        return this.errorMessage;
    }

    public String getLanguage() {
        return this.language;
    }

    public String getCodePage() {
        return this.codepage;
    }

    public String getDiagnosticMessages() {
        return this.diagnosticMessage;
    }

    public void addDiagnosticMessage(String string) {
        this.diagnosticMessage = this.diagnosticMessage == null ? string : this.diagnosticMessage + "\n" + string;
    }
}

