/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.uea.cmp.nlct.makeglossaries;

import java.awt.Font;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.text.DateFormat;
import java.util.Date;
import javax.swing.JEditorPane;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import javax.swing.text.BadLocationException;
import javax.swing.text.Element;
import javax.swing.text.html.HTMLDocument;
import javax.swing.text.html.StyleSheet;
import uk.ac.uea.cmp.nlct.makeglossaries.Glossaries;
import uk.ac.uea.cmp.nlct.makeglossaries.Glossary;
import uk.ac.uea.cmp.nlct.makeglossaries.MakeGlossariesGUI;
import uk.ac.uea.cmp.nlct.makeglossaries.ViewEntries;
import uk.ac.uea.cmp.nlct.makeglossaries.ViewFile;

public class GlossariesPanel
extends JEditorPane
implements HyperlinkListener {
    private MakeGlossariesGUI app;

    public GlossariesPanel(MakeGlossariesGUI makeGlossariesGUI) throws IOException, BadLocationException {
        this.app = makeGlossariesGUI;
        this.setContentType("text/html");
        this.setEditable(false);
        this.addHyperlinkListener(this);
        HTMLDocument hTMLDocument = (HTMLDocument)this.getDocument();
    }

    public void updateInfo() throws BadLocationException, IOException {
        StyleSheet styleSheet = ((HTMLDocument)this.getDocument()).getStyleSheet();
        Font font = this.app.getFont();
        styleSheet.addRule("body { font-size: " + font.getSize() + "pt; }");
        styleSheet.addRule("body { font-family: " + font.getName() + "; }");
        styleSheet.addRule("body { font-weight: " + (font.isBold() ? "bold" : "normal") + "; }");
        styleSheet.addRule("body { font-style:  " + (font.isItalic() ? "italic" : "normal") + "; }");
        this.setText(this.app.getMainInfoTemplate());
        this.updateHeaders();
        this.updateFields();
        this.updateGlossaries();
    }

    private void updateHeaders() throws BadLocationException, IOException {
        HTMLDocument hTMLDocument = (HTMLDocument)this.getDocument();
        Glossaries glossaries = this.app.getGlossaries();
        int n = Glossaries.getNumFields();
        for (int i = 0; i < n; ++i) {
            Element element = Glossaries.getFieldLabelElement(hTMLDocument, i);
            String string = element.getName();
            hTMLDocument.setOuterHTML(element, "<" + string + ">" + Glossaries.getFieldLabel(i) + "</" + string + ">");
        }
    }

    private void updateFields() throws BadLocationException, IOException {
        HTMLDocument hTMLDocument = (HTMLDocument)this.getDocument();
        Glossaries glossaries = this.app.getGlossaries();
        if (glossaries == null) {
            return;
        }
        int n = glossaries.getNumFields();
        for (int i = 0; i < n; ++i) {
            Element element = Glossaries.getFieldElement(hTMLDocument, i);
            String string = glossaries.getField(i);
            String string2 = glossaries.getFieldError(i);
            String string3 = Glossaries.getFieldTag(i);
            String string4 = "";
            if (string2 == null) {
                if (string != null) {
                    string4 = string;
                }
            } else {
                string4 = string == null ? "<font class=errormess>" + string2 + "</font>" : "<font class=error>" + string + " <font class=errormess>" + string2 + "</font></font>";
            }
            hTMLDocument.setOuterHTML(element, "<td id=" + string3 + ">" + string4 + "</td>");
        }
    }

    private void updateGlossaries() throws BadLocationException, IOException {
        HTMLDocument hTMLDocument = (HTMLDocument)this.getDocument();
        Glossaries glossaries = this.app.getGlossaries();
        if (glossaries == null) {
            return;
        }
        if (glossaries.getIstName() == null) {
            return;
        }
        DateFormat dateFormat = DateFormat.getDateTimeInstance();
        File file = this.app.getFile();
        File file2 = file.getParentFile();
        String string = file.getName();
        int n = string.lastIndexOf(".");
        if (n != -1) {
            string = string.substring(0, n);
        }
        String string2 = MakeGlossariesGUI.getLabel("main.view");
        String string3 = MakeGlossariesGUI.getLabel("main.details");
        int n2 = glossaries.getNumGlossaries();
        for (int i = 0; i < n2; ++i) {
            Glossary glossary = glossaries.getGlossary(i);
            String string4 = this.app.getGlossaryInfoTemplate(glossary.label);
            hTMLDocument.insertBeforeEnd(hTMLDocument.getElement("glossaries"), string4);
            hTMLDocument.setInnerHTML(hTMLDocument.getElement("glossaryheader-" + glossary.label), MakeGlossariesGUI.getLabelWithValue("main.glossary", glossary.label));
            File file3 = new File(file2, string + "." + glossary.transExt);
            File file4 = new File(file2, string + "." + glossary.gloExt);
            File file5 = new File(file2, string + "." + glossary.glsExt);
            Element element = hTMLDocument.getElement("loglabel-" + glossary.label);
            String string5 = element.getName();
            hTMLDocument.setOuterHTML(element, "<" + string5 + ">" + MakeGlossariesGUI.getLabel("main.glossary.log") + "</" + string5 + ">");
            if (file3.exists()) {
                hTMLDocument.setOuterHTML(hTMLDocument.getElement("logname-" + glossary.label), file3.getName());
                hTMLDocument.setOuterHTML(hTMLDocument.getElement("logmod-" + glossary.label), file3.lastModified() < file4.lastModified() ? MakeGlossariesGUI.getLabel("main.out_of_date") : MakeGlossariesGUI.getLabel("main.up_to_date"));
                hTMLDocument.setOuterHTML(hTMLDocument.getElement("logview-" + glossary.label), "<a href=" + file3.toURI() + ">" + string2 + "</a>");
            } else {
                hTMLDocument.setInnerHTML(hTMLDocument.getElement("loginfo-" + glossary.label), "<font class=error>" + MakeGlossariesGUI.getLabel("error.no_such_file") + "</font>");
            }
            element = hTMLDocument.getElement("glslabel-" + glossary.label);
            string5 = element.getName();
            hTMLDocument.setOuterHTML(element, "<" + string5 + ">" + MakeGlossariesGUI.getLabel("main.glossary.gls") + "</" + string5 + ">");
            if (file5.exists()) {
                hTMLDocument.setOuterHTML(hTMLDocument.getElement("glsname-" + glossary.label), file5.getName());
                hTMLDocument.setOuterHTML(hTMLDocument.getElement("glsmod-" + glossary.label), file5.length() == 0L ? MakeGlossariesGUI.getLabel("main.empty") : (file5.lastModified() < file4.lastModified() ? MakeGlossariesGUI.getLabel("main.out_of_date") : MakeGlossariesGUI.getLabel("main.up_to_date")));
                hTMLDocument.setOuterHTML(hTMLDocument.getElement("glsview-" + glossary.label), "<a href=" + file5.toURI() + ">" + string2 + "</a>");
            } else {
                hTMLDocument.setInnerHTML(hTMLDocument.getElement("glsinfo-" + glossary.label), "<font class=error>" + MakeGlossariesGUI.getLabel("error.no_such_file") + "</font>");
            }
            element = hTMLDocument.getElement("glolabel-" + glossary.label);
            string5 = element.getName();
            hTMLDocument.setOuterHTML(element, "<" + string5 + ">" + MakeGlossariesGUI.getLabel("main.glossary.glo") + "</" + string5 + ">");
            if (file4.exists()) {
                hTMLDocument.setOuterHTML(hTMLDocument.getElement("gloname-" + glossary.label), file4.getName());
                hTMLDocument.setOuterHTML(hTMLDocument.getElement("glomod-" + glossary.label), dateFormat.format(new Date(file4.lastModified())));
                hTMLDocument.setOuterHTML(hTMLDocument.getElement("gloview-" + glossary.label), "<a href=" + file4.toURI() + ">" + string2 + "</a>");
            } else {
                hTMLDocument.setInnerHTML(hTMLDocument.getElement("gloinfo-" + glossary.label), "<font class=error>" + MakeGlossariesGUI.getLabel("error.no_such_file") + "</font>");
            }
            if (glossaries.useXindy()) {
                element = hTMLDocument.getElement("langlabel-" + glossary.label);
                string5 = element.getName();
                hTMLDocument.setOuterHTML(element, "<" + string5 + ">" + MakeGlossariesGUI.getLabel("main.glossary.language") + "</" + string5 + ">");
                hTMLDocument.setInnerHTML(hTMLDocument.getElement("langinfo-" + glossary.label), glossary.displayLanguage());
                element = hTMLDocument.getElement("codelabel-" + glossary.label);
                string5 = element.getName();
                hTMLDocument.setOuterHTML(element, "<" + string5 + ">" + MakeGlossariesGUI.getLabel("main.glossary.codepage") + "</" + string5 + ">");
                hTMLDocument.setInnerHTML(hTMLDocument.getElement("codeinfo-" + glossary.label), glossary.displayCodePage());
            } else {
                hTMLDocument.setOuterHTML(hTMLDocument.getElement("xindy"), "");
            }
            element = hTMLDocument.getElement("entrieslabel-" + glossary.label);
            string5 = element.getName();
            hTMLDocument.setOuterHTML(element, "<" + string5 + ">" + MakeGlossariesGUI.getLabel("main.num_entries") + "</" + string5 + ">");
            element = hTMLDocument.getElement("entriesinfo-" + glossary.label);
            string5 = element.getName();
            String string6 = "";
            if (glossary.getNumEntries() > 0) {
                string6 = " <a description=" + glossary.label + " href=" + glossary.label + ">" + string3 + "</a>";
            }
            hTMLDocument.setOuterHTML(element, "<" + string5 + ">" + glossary.getNumEntries() + string6 + "</" + string5 + ">");
            String string7 = glossary.getErrorMessages();
            if (string7 == null) continue;
            hTMLDocument.setOuterHTML(hTMLDocument.getElement("error-" + glossary.label), "<font class=error>" + string7 + "</font>");
        }
    }

    @Override
    public void hyperlinkUpdate(HyperlinkEvent hyperlinkEvent) {
        HyperlinkEvent.EventType eventType = hyperlinkEvent.getEventType();
        URL uRL = hyperlinkEvent.getURL();
        if (eventType == HyperlinkEvent.EventType.ACTIVATED) {
            if (uRL == null) {
                Glossary glossary = this.app.glossaries.getGlossary(hyperlinkEvent.getDescription());
                if (glossary != null) {
                    new ViewEntries(this.app, glossary, this.app.getFont()).setVisible(true);
                }
            } else {
                try {
                    new ViewFile(uRL, this.app.getFont(), this.app).setVisible(true);
                }
                catch (Exception exception) {
                    MakeGlossariesGUI.error(this.app, exception.getMessage());
                }
            }
        }
    }
}

