/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.uea.cmp.nlct.makeglossaries;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.Vector;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.text.Element;
import javax.swing.text.html.HTMLDocument;
import uk.ac.uea.cmp.nlct.makeglossaries.Glossary;
import uk.ac.uea.cmp.nlct.makeglossaries.GlossaryException;
import uk.ac.uea.cmp.nlct.makeglossaries.MakeGlossariesGUI;

public class Glossaries {
    private Vector<Glossary> glossaryList;
    private String istName;
    private String order;
    private String errorMessages = null;
    private String diagnosticMessages;
    private static final Pattern newGlossaryPattern = Pattern.compile("\\\\@newglossary\\{([^\\}]+)\\}\\{([^\\}]+)\\}\\{([^\\}]+)\\}\\{([^\\}]+)\\}");
    private static final Pattern istFilePattern = Pattern.compile("\\\\@istfilename\\{([^\\}]+)\\}");
    private static final Pattern orderPattern = Pattern.compile("\\\\@glsorder\\{([^\\}]+)\\}");
    private static final Pattern languagePattern = Pattern.compile("\\\\@xdylanguage\\{([^\\}]+)\\}\\{([^\\}]*)\\}");
    private static final Pattern codepagePattern = Pattern.compile("\\\\@gls@codepage\\{([^\\}]+)\\}\\{([^\\}]*)\\}");
    private static final String[] fields = new String[]{"aux", "order", "ist", "indexer", "list"};
    public static final int AUX = 0;
    public static final int ORDER = 1;
    public static final int IST = 2;
    public static final int INDEXER = 3;
    public static final int GLOSSARIES = 4;
    private MakeGlossariesGUI app;

    public Glossaries(MakeGlossariesGUI makeGlossariesGUI, String string, String string2) {
        this.app = makeGlossariesGUI;
        this.istName = string;
        this.order = string2;
        this.glossaryList = new Vector();
    }

    public Glossaries(MakeGlossariesGUI makeGlossariesGUI) {
        this.app = makeGlossariesGUI;
        this.glossaryList = new Vector();
    }

    public void clear() {
        this.glossaryList.clear();
    }

    public void add(Glossary glossary) {
        this.glossaryList.add(glossary);
    }

    public Glossary getGlossary(int n) {
        return this.glossaryList.get(n);
    }

    public Glossary getGlossary(String string) {
        int n = this.glossaryList.size();
        for (int i = 0; i < n; ++i) {
            Glossary glossary = this.glossaryList.get(i);
            if (!glossary.label.equals(string)) continue;
            return glossary;
        }
        return null;
    }

    public static Glossaries loadGlossaries(MakeGlossariesGUI makeGlossariesGUI, File file) throws IOException {
        String string;
        Glossaries glossaries = new Glossaries(makeGlossariesGUI);
        BufferedReader bufferedReader = new BufferedReader(new FileReader(file));
        while ((string = bufferedReader.readLine()) != null) {
            String string2;
            Glossary glossary;
            String string3;
            Matcher matcher = newGlossaryPattern.matcher(string);
            if (matcher.matches()) {
                glossaries.add(new Glossary(makeGlossariesGUI, matcher.group(1), matcher.group(2), matcher.group(3), matcher.group(4)));
            }
            if ((matcher = istFilePattern.matcher(string)).matches()) {
                glossaries.istName = matcher.group(1);
            }
            if ((matcher = orderPattern.matcher(string)).matches()) {
                glossaries.order = matcher.group(1);
            }
            if ((matcher = languagePattern.matcher(string)).matches()) {
                string3 = matcher.group(1);
                glossary = glossaries.getGlossary(string3);
                string2 = matcher.group(2);
                if (glossary == null) {
                    glossaries.addErrorMessage(MakeGlossariesGUI.getLabelWithValues("error.language_no_glossary", string2, string3));
                    glossaries.addDiagnosticMessage(MakeGlossariesGUI.getLabelWithValues("diagnostics.language_no_glossary", string2, string3));
                } else {
                    glossary.setLanguage(string2);
                }
            }
            if (!(matcher = codepagePattern.matcher(string)).matches()) continue;
            string3 = matcher.group(1);
            glossary = glossaries.getGlossary(string3);
            string2 = matcher.group(2);
            if (glossary == null) {
                glossaries.addErrorMessage(MakeGlossariesGUI.getLabelWithValues("error.codepage_no_glossary", string2, string3));
                glossaries.addDiagnosticMessage(MakeGlossariesGUI.getLabelWithValues("diagnostics.codepage_no_glossary", string2, string3));
                continue;
            }
            glossary.setCodePage(string2);
        }
        bufferedReader.close();
        return glossaries;
    }

    public void process() throws GlossaryException, IOException, InterruptedException {
        String string = this.getIndexerError();
        if (string != null) {
            throw new GlossaryException(string);
        }
        File file = this.app.getFile();
        String string2 = file.getName();
        int n = string2.lastIndexOf(".");
        if (n != -1) {
            string2 = string2.substring(0, n);
        }
        File file2 = file.getParentFile();
        int n2 = this.getNumGlossaries();
        for (int i = 0; i < n2; ++i) {
            Glossary glossary = this.getGlossary(i);
            try {
                if (this.useXindy()) {
                    glossary.xindy(file2, string2, this.isWordOrder(), this.istName);
                } else {
                    glossary.makeindex(file2, string2, this.isWordOrder(), this.istName);
                }
                String string3 = glossary.getErrorMessages();
                if (string3 == null) continue;
                this.addErrorMessage(string3);
                continue;
            }
            catch (IOException iOException) {
                File file3 = new File(file2, this.istName);
                if (!file3.exists()) {
                    throw new GlossaryException(MakeGlossariesGUI.getLabelWithValue("error.no_ist", this.istName), MakeGlossariesGUI.getLabel("diagnostics.no_ist"));
                }
                throw iOException;
            }
        }
    }

    public String displayGlossaryList() {
        String string = null;
        int n = this.glossaryList.size();
        for (int i = 0; i < n; ++i) {
            Glossary glossary = this.glossaryList.get(i);
            string = string == null ? glossary.label : string + ", " + glossary.label;
        }
        return string;
    }

    public String getDisplayGlossaryListError() {
        return this.getNumGlossaries() == 0 ? MakeGlossariesGUI.getLabel("error.no_glossaries") : null;
    }

    public String getOrder() {
        return this.order;
    }

    public boolean isWordOrder() {
        if (this.order == null) {
            return false;
        }
        return this.order.equals("word");
    }

    public boolean isLetterOrder() {
        if (this.order == null) {
            return false;
        }
        return this.order.equals("letter");
    }

    public boolean isValidOrder() {
        if (this.order == null) {
            return false;
        }
        return this.order.equals("word") || this.order.equals("letter");
    }

    public String getOrderError() {
        if (this.order == null) {
            return MakeGlossariesGUI.getLabel("error.missing_order");
        }
        return this.isValidOrder() ? null : MakeGlossariesGUI.getLabel("error.invalid_order");
    }

    public String displayFormat() {
        if (this.istName == null) {
            return MakeGlossariesGUI.getLabel("error.unknown");
        }
        return this.useXindy() ? "xindy" : "makeindex";
    }

    public String getIstName() {
        return this.istName;
    }

    public String getIstNameError() {
        return this.istName == null ? MakeGlossariesGUI.getLabel("error.missing_ist") : null;
    }

    public boolean useXindy() {
        if (this.istName == null) {
            return false;
        }
        return this.istName.endsWith(".xdy");
    }

    public String getIndexerError() {
        if (this.istName == null) {
            return MakeGlossariesGUI.getLabel("error.cant_determine_indexer");
        }
        if (this.useXindy()) {
            if (this.app.getXindyApp() == null) {
                return MakeGlossariesGUI.getLabel("error.no_xindy");
            }
        } else if (this.app.getMakeIndexApp() == null) {
            return MakeGlossariesGUI.getLabel("error.no_makeindex");
        }
        return null;
    }

    public int getNumGlossaries() {
        return this.glossaryList.size();
    }

    public String getDiagnostics() {
        if (this.istName == null && this.order == null) {
            if (this.glossaryList.size() == 0) {
                return this.app.getFileName().toLowerCase().endsWith(".aux") ? MakeGlossariesGUI.getLabel("diagnostics.no_glossaries") : MakeGlossariesGUI.getLabel("diagnostics.not_aux");
            }
            return MakeGlossariesGUI.getLabel("diagnostics.no_makeglossaries");
        }
        String string = this.getIndexerError();
        if (string != null) {
            return string + "\n" + MakeGlossariesGUI.getLabelWithValue("diagnostics.no_indexer", this.displayFormat());
        }
        string = this.diagnosticMessages;
        int n = this.getNumGlossaries();
        for (int i = 0; i < n; ++i) {
            String string2 = this.getGlossary(i).getDiagnosticMessages();
            if (string2 == null) continue;
            string = string == null ? string2 : string + "\n" + string2;
        }
        return string;
    }

    public void addDiagnosticMessage(String string) {
        this.diagnosticMessages = this.diagnosticMessages == null ? string : this.diagnosticMessages + "\n" + string;
    }

    public void addErrorMessage(String string) {
        this.errorMessages = this.errorMessages == null ? string : this.errorMessages + "\n" + string;
    }

    public String getErrorMessages() {
        return this.errorMessages;
    }

    public static int getNumFields() {
        return fields.length;
    }

    public static String getFieldTag(int n) {
        return fields[n];
    }

    public static Element getFieldElement(HTMLDocument hTMLDocument, int n) {
        return hTMLDocument.getElement(fields[n]);
    }

    public static Element getFieldLabelElement(HTMLDocument hTMLDocument, int n) {
        return hTMLDocument.getElement(fields[n] + "label");
    }

    public static String getFieldLabel(int n) {
        return MakeGlossariesGUI.getLabel("main", fields[n]);
    }

    public String getField(int n) {
        switch (n) {
            case 0: {
                return this.app.getFileName();
            }
            case 1: {
                return this.getOrder();
            }
            case 2: {
                return this.getIstName();
            }
            case 3: {
                return this.displayFormat();
            }
            case 4: {
                return this.displayGlossaryList();
            }
        }
        return null;
    }

    public String getFieldError(int n) {
        switch (n) {
            case 0: {
                return this.app.getFileName() == null ? MakeGlossariesGUI.getLabel("error.no_such_file") : null;
            }
            case 1: {
                return this.getOrderError();
            }
            case 2: {
                return this.getIstNameError();
            }
            case 3: {
                return this.getIndexerError();
            }
            case 4: {
                return this.getDisplayGlossaryListError();
            }
        }
        return null;
    }
}

