/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.uea.cmp.nlct.makeglossaries;

import java.awt.Container;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JPanel;
import javax.swing.JTextField;
import uk.ac.uea.cmp.nlct.makeglossaries.MakeGlossariesGUI;

public class FileField
extends JPanel
implements ActionListener {
    private JTextField textField;
    private JButton button;
    private JFileChooser fileChooser;
    private Container parent;
    private int mode;

    public FileField(Container container, JFileChooser jFileChooser) {
        this(container, null, jFileChooser, 0);
    }

    public FileField(Container container, JFileChooser jFileChooser, int n) {
        this(container, null, jFileChooser, n);
    }

    public FileField(Container container, String string, JFileChooser jFileChooser) {
        this(container, string, jFileChooser, 0);
    }

    public FileField(Container container, String string, JFileChooser jFileChooser, int n) {
        this.fileChooser = jFileChooser;
        this.parent = container;
        this.mode = n;
        this.textField = new JTextField(string == null ? "" : string, 20);
        this.add(this.textField);
        this.button = new JButton("...");
        this.button.setActionCommand("choose");
        this.button.addActionListener(this);
        this.add(this.button);
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        String string = actionEvent.getActionCommand();
        if (string == null) {
            return;
        }
        if (string.equals("choose")) {
            File file = this.getFile();
            if (file != null) {
                this.fileChooser.setCurrentDirectory(file.getParentFile());
            }
            this.fileChooser.setSelectedFile(file);
            this.fileChooser.setFileSelectionMode(this.mode);
            this.fileChooser.setApproveButtonMnemonic(MakeGlossariesGUI.getMnemonic("button.select"));
            if (this.fileChooser.showDialog(this.parent, MakeGlossariesGUI.getLabel("button.select")) == 0) {
                this.textField.setText(this.fileChooser.getSelectedFile().getAbsolutePath());
            }
        }
    }

    @Override
    public boolean requestFocusInWindow() {
        return this.textField.requestFocusInWindow();
    }

    public JTextField getTextField() {
        return this.textField;
    }

    public File getFile() {
        String string = this.getFileName();
        if (string == null || string.equals("")) {
            return null;
        }
        return new File(string);
    }

    public String getFileName() {
        return this.textField.getText();
    }

    public void setFileName(String string) {
        this.textField.setText(string);
    }

    @Override
    public void setEnabled(boolean bl) {
        super.setEnabled(bl);
        this.textField.setEnabled(bl);
        this.button.setEnabled(bl);
    }
}

