/*
 * Decompiled with CFR 0.152.
 */
package LogFilter;

import LogFilter.Controller;
import LogFilter.Entry;
import LogFilter.Model;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.util.EmptyStackException;
import java.util.Stack;

class Parser {
    int infc = 0;
    int prec = 0;
    int filc = 0;
    int pagc = 0;
    int msgc = 0;
    String logfilepath;
    Model model;
    Controller controller;
    Lexer lexer = new Lexer();
    String token;
    int pos;
    Stack filenames;
    byte[] buf;

    Parser(Controller controller) {
        this.controller = controller;
        this.model = controller.model;
    }

    void parse() {
        try {
            FileInputStream fileInputStream = new FileInputStream(this.controller.usersettings.logfilename);
            byte[] byArray = new byte[fileInputStream.available()];
            fileInputStream.read(byArray);
            fileInputStream.close();
            int n = 0;
            int n2 = 0;
            while (n2 < byArray.length - 2) {
                byArray[n] = byArray[n2] == 13 ? (byArray[n2 + 1] == 10 ? byArray[++n2] : 10) : byArray[n2];
                ++n2;
                ++n;
            }
            byArray[n] = byArray[n2] == 13 ? 10 : byArray[n2];
            this.buf = new byte[n];
            n2 = 0;
            while (n2 < n) {
                this.buf[n2] = byArray[n2];
                ++n2;
            }
            this.logfilepath = new File(this.controller.usersettings.logfilename).getParent();
            this.pos = 0;
            this.filenames = new Stack();
            this.lexer.seek("**");
            while (!this.token.equals("(")) {
                this.lexer.nextToken();
            }
            while (this.pre()) {
            }
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            this.model.add(new Entry(101, "Log file is 'corrupt'.. did TeX/LaTeX compile properly?", null, -1));
        }
        catch (NumberFormatException numberFormatException) {
            this.model.add(new Entry(101, "Log file is 'corrupt'.. did TeX/LaTeX compile properly?", null, -1));
        }
        catch (NullPointerException nullPointerException) {
            this.model.add(new Entry(101, "You need to choose a TeX/LaTeX log file...", null, -1));
        }
        catch (FileNotFoundException fileNotFoundException) {
            this.model.add(new Entry(101, "The chosen file \"" + this.controller.usersettings.logfilename + "\" could not be opened", null, -1));
        }
        catch (Error error) {
            this.model.add(new Entry(101, "Unexpected error " + error.getMessage() + " please contact the author...", null, -1));
        }
        catch (Exception exception) {
            this.model.add(new Entry(101, "Unexpected exception " + exception.getMessage() + " please contact the author...", null, -1));
        }
    }

    private boolean pre() {
        if (this.token.equals("(")) {
            String string = "";
            do {
                this.lexer.nextToken();
                string = string + this.token + " ";
            } while (!this.token.equals(")") && (string.length() <= 4 || string.charAt(string.length() - 5) != '.'));
            if (this.token.equals(")")) {
                this.lexer.pushbackToken();
                this.token = string.substring(0, string.length() - 3);
            } else {
                this.token = string.substring(0, string.length() - 1);
            }
            if (this.token.endsWith(".tex") || this.token.endsWith(".bbl")) {
                this.file();
            } else {
                this.info();
            }
            return true;
        }
        return false;
    }

    private boolean file() {
        if (this.token.charAt(1) == ':' || this.token.charAt(0) == '/') {
            this.filenames.push(new File(this.token).getAbsolutePath());
        } else {
            this.filenames.push(new File(this.logfilepath, this.token).getAbsolutePath());
        }
        this.model.add(new Entry(100, (String)this.filenames.peek(), (String)this.filenames.peek(), 1));
        this.lexer.nextToken();
        while (!this.token.equals(")")) {
            if (this.token.equals("(")) {
                this.pre();
                continue;
            }
            if (this.token.equals("[")) {
                this.pageno();
                continue;
            }
            this.msgs();
        }
        this.lexer.nextToken();
        this.filenames.pop();
        try {
            this.model.add(new Entry(100, (String)this.filenames.peek(), (String)this.filenames.peek(), 1));
        }
        catch (EmptyStackException emptyStackException) {
            // empty catch block
        }
        return true;
    }

    private void info() {
        this.lexer.nextToken();
        while (!this.token.equals(")")) {
            if (this.token.equals("(")) {
                this.lexer.nextToken();
                this.info();
                continue;
            }
            this.lexer.nextToken();
        }
        this.lexer.nextToken();
    }

    private void msgs() {
        while (!(this.token.equals("(") || this.token.equals(")") || this.token.endsWith("."))) {
            int n;
            StringBuffer stringBuffer;
            if (this.token.equals("!")) {
                stringBuffer = new StringBuffer();
                stringBuffer.append("! ");
                this.lexer.nextToken();
                stringBuffer.append(this.token);
                if (this.token.equals("Font")) {
                    stringBuffer.append(" " + this.lexer.crossLineSeek("not found."));
                    this.model.add(new Entry(0, stringBuffer.toString(), (String)this.filenames.peek()));
                } else {
                    stringBuffer.append(" " + this.lexer.seek('\n'));
                    this.model.add(new Entry(8, stringBuffer.toString(), (String)this.filenames.peek()));
                }
                return;
            }
            if (this.token.equals("Package")) {
                stringBuffer = new StringBuffer();
                stringBuffer.append(this.token + " ");
                this.lexer.nextToken();
                stringBuffer.append(this.token + " ");
                if (this.token.equals("FiXme")) {
                    this.fixmeParse(stringBuffer);
                    return;
                }
                this.lexer.nextToken();
                if (this.token.equals("Warning:")) {
                    stringBuffer.append(this.token + " ");
                    this.lexer.nextToken();
                    if (this.token.equals("Citation")) {
                        stringBuffer.append(this.token + " " + this.lexer.crossLineSeek("on input line"));
                        stringBuffer.append(this.token);
                        n = Integer.parseInt(this.token.substring(0, this.token.length() - 1));
                        this.model.add(new Entry(7, stringBuffer.toString(), (String)this.filenames.peek(), n));
                        return;
                    }
                    System.out.println("found: " + stringBuffer.toString());
                    this.lexer.seek('\n');
                    return;
                }
                this.lexer.seek('\n');
                return;
            }
            if (this.token.equals("Missing")) {
                stringBuffer = new StringBuffer();
                stringBuffer.append(this.token + " ");
                this.lexer.nextToken();
                if (this.token.equals("character:")) {
                    stringBuffer.append(this.token + " ");
                    String string = this.lexer.seek('\n');
                    string = string.substring(0, string.length() - 1);
                    stringBuffer.append(string);
                    this.model.addOnce(new Entry(0, stringBuffer.toString(), (String)this.filenames.peek(), 1));
                    return;
                }
                this.lexer.seek('\n');
                return;
            }
            if (this.token.equals("No")) {
                stringBuffer = new StringBuffer();
                stringBuffer.append(this.token + " ");
                this.lexer.nextToken();
                if (this.token.equals("file")) {
                    stringBuffer.append(this.token + " ");
                    String string = this.lexer.seek('\n');
                    string = string.substring(0, string.length() - 1);
                    if (!string.endsWith(".aux")) {
                        stringBuffer.append(string);
                        this.model.add(new Entry(6, stringBuffer.toString(), (String)this.filenames.peek()));
                    }
                    return;
                }
                this.lexer.seek('\n');
                return;
            }
            if (this.token.equals("Overfull")) {
                stringBuffer = new StringBuffer();
                stringBuffer.append(this.token + " ");
                this.lexer.nextToken();
                if (this.token.equals("\\hbox")) {
                    stringBuffer.append("\\hbox ");
                    this.lexer.nextToken();
                    stringBuffer.append("(");
                    this.lexer.nextToken();
                    int n2 = Integer.parseInt(this.token.substring(0, this.token.indexOf(46)));
                    if (n2 >= this.controller.usersettings.min_pt_overfull) {
                        stringBuffer.append(this.token + " ");
                        this.lexer.nextToken();
                        stringBuffer.append(this.lexer.crossLineSeek("line"));
                        if (this.token.equals("s")) {
                            stringBuffer.append(this.token + " ");
                            this.lexer.nextToken();
                            n = Integer.parseInt(this.token.substring(0, this.token.indexOf(45)));
                            this.model.add(new Entry(3, stringBuffer.toString() + this.token, (String)this.filenames.peek(), n));
                            this.lexer.seek("\n\n");
                            continue;
                        }
                        stringBuffer.append(this.token);
                        n = Integer.parseInt(this.token);
                        this.model.add(new Entry(6, stringBuffer.toString(), (String)this.filenames.peek(), n));
                        continue;
                    }
                    this.lexer.seek("\n\n");
                    return;
                }
                this.lexer.seek("\n\n");
                return;
            }
            if (this.token.equals("Underfull")) {
                stringBuffer = new StringBuffer();
                stringBuffer.append(this.token + " ");
                this.lexer.nextToken();
                if (this.token.equals("\\hbox")) {
                    stringBuffer.append(this.token + " " + this.lexer.crossLineSeek("line"));
                    if (this.token.equals("s")) {
                        stringBuffer.append(this.token + " ");
                        this.lexer.nextToken();
                        n = Integer.parseInt(this.token.substring(0, this.token.indexOf(45)));
                        this.model.add(new Entry(2, stringBuffer.toString() + this.token, (String)this.filenames.peek(), n));
                        this.lexer.seek("\n\n");
                    } else {
                        stringBuffer.append(this.token);
                        n = Integer.parseInt(this.token);
                        this.model.add(new Entry(6, stringBuffer.toString(), (String)this.filenames.peek(), n));
                    }
                    return;
                }
                if (this.token.equals("\\vbox")) {
                    stringBuffer.append("\\vbox ");
                    stringBuffer.append(this.lexer.seek('\n'));
                    this.model.add(new Entry(4, stringBuffer.toString(), (String)this.filenames.peek(), 1));
                    continue;
                }
                this.lexer.seek("\n\n");
                return;
            }
            if (this.token.equals("LaTeX")) {
                stringBuffer = new StringBuffer();
                stringBuffer.append(this.token + " ");
                this.lexer.nextToken();
                if (this.token.equals("Font")) {
                    String string;
                    this.lexer.nextToken();
                    if (this.token.equals("Info:")) {
                        String string2 = this.lexer.seek('\n');
                        if (!string2.endsWith("> not available")) continue;
                        string2 = this.strip(string2, "   ");
                        this.lexer.crossLineSeek("on input line");
                        this.model.add(new Entry(0, "LaTeX Font Info: " + string2 + ", line " + this.token, (String)this.filenames.peek(), Integer.parseInt(this.token.substring(0, this.token.length() - 1))));
                        return;
                    }
                    if (!this.token.equals("Warning:")) continue;
                    this.lexer.nextToken();
                    if (this.token.equals("Some") || !(string = this.token + this.lexer.seek('\n')).endsWith("undefined")) continue;
                    string = string + '\n' + this.token;
                    string = string + this.lexer.crossLineSeek("on input line");
                    string = string.replace('\n', ' ');
                    string = this.strip(string, "(Font)              ");
                    this.model.add(new Entry(1, "LaTeX Font Warning: " + string + this.token, (String)this.filenames.peek(), Integer.parseInt(this.token.substring(0, this.token.length() - 1))));
                    return;
                }
                if (!this.token.equals("Warning:")) continue;
                stringBuffer.append(this.token + " ");
                this.lexer.nextToken();
                if (this.token.equals("Citation")) {
                    stringBuffer.append(this.token + " " + this.lexer.crossLineSeek("on input line") + " ");
                    stringBuffer.append(this.token);
                    n = Integer.parseInt(this.token.substring(0, this.token.length() - 1));
                    this.model.add(new Entry(7, stringBuffer.toString(), (String)this.filenames.peek(), n));
                    return;
                }
                if (this.token.equals("Reference")) {
                    stringBuffer.append(this.token + " ");
                    String string = this.lexer.seek(".");
                    string = this.strip(string, '\n');
                    int n3 = string.lastIndexOf(32);
                    stringBuffer.append(string.substring(0, n3));
                    n = Integer.parseInt(string.substring(n3 + 1, string.length() - 1));
                    stringBuffer.append(" " + n);
                    this.model.add(new Entry(7, stringBuffer.toString(), (String)this.filenames.peek(), n));
                    return;
                }
                if (this.token.equals("File")) {
                    stringBuffer.append(this.token + " " + this.lexer.crossLineSeek("not found on input line"));
                    stringBuffer.append(this.token);
                    n = Integer.parseInt(this.token.substring(0, this.token.length() - 1));
                    this.model.add(new Entry(6, stringBuffer.toString(), (String)this.filenames.peek(), n));
                    return;
                }
                if (this.token.equals("There")) continue;
                stringBuffer.append(this.token + " " + this.lexer.seek('.'));
                String string = stringBuffer.toString();
                if (string.indexOf("float specifier changed to") > -1) {
                    this.model.add(new Entry(5, string, (String)this.filenames.peek(), 1));
                } else {
                    this.model.add(new Entry(8, string, (String)this.filenames.peek(), 1));
                }
                return;
            }
            this.lexer.nextToken();
        }
        if (this.token.endsWith(".")) {
            this.lexer.nextToken();
        }
    }

    private void fixmeParse(StringBuffer stringBuffer) {
        int n = -1;
        this.lexer.nextToken();
        if (this.token.equals("Note:")) {
            n = 30;
        } else if (this.token.equals("Warning:")) {
            n = 31;
        } else if (this.token.equals("Error:")) {
            n = 32;
        } else if (this.token.equals("Summary:")) {
            this.lexer.seek('.');
            return;
        }
        stringBuffer.append(" " + this.lexer.crossLineSeek("on input line") + " ");
        stringBuffer.append(this.token);
        int n2 = Integer.parseInt(this.token.substring(0, this.token.length() - 1));
        this.model.add(new Entry(n, stringBuffer.toString(), (String)this.filenames.peek(), n2));
    }

    private void pageno() {
        this.lexer.nextToken();
        if (!this.token.equals("]")) {
            this.lexer.nextToken();
        }
        if (this.token.equals("{")) {
            this.pdfinfo();
        }
        if (this.token.equals("]")) {
            this.lexer.nextToken();
        } else {
            System.out.println("parse error during pageno parse...expected ']' got '" + this.token + "'");
        }
    }

    private void pdfinfo() {
        while (!this.token.equals("]")) {
            if (this.token.equals("Warning:")) {
                this.lexer.nextToken();
                if (this.token.equals("pdflatex")) {
                    String string = "Warning: pdflatex " + this.strip(this.lexer.seek("ExtendFont"), '\n');
                    this.model.add(new Entry(1, string, (String)this.filenames.peek(), 1));
                    continue;
                }
                this.lexer.nextToken();
                continue;
            }
            this.lexer.nextToken();
        }
    }

    private String strip(String string, char c) {
        int n = string.indexOf(c);
        if (n == -1) {
            return string;
        }
        int n2 = 0;
        StringBuffer stringBuffer = new StringBuffer();
        do {
            stringBuffer.append(string.substring(n2, n));
        } while ((n = string.indexOf(c, n2 = n + 1)) != -1);
        stringBuffer.append(string.substring(n2));
        return stringBuffer.toString();
    }

    private String strip(String string, String string2) {
        int n = string.indexOf(string2);
        if (n == 0) {
            if (string.length() > string2.length()) {
                return this.strip(string.substring(string2.length()), string2);
            }
            return "";
        }
        if (n > 0) {
            return this.strip(string.substring(0, n) + string.substring(n + string2.length()), string2);
        }
        return string;
    }

    class Lexer {
        Lexer() {
        }

        void pushbackToken() {
            Parser.this.pos -= Parser.this.token.length();
        }

        void nextToken() {
            while (Parser.this.pos < Parser.this.buf.length && Parser.this.buf[Parser.this.pos] == 32 || Parser.this.buf[Parser.this.pos] == 9 || Parser.this.buf[Parser.this.pos] == 10) {
                ++Parser.this.pos;
            }
            int n = Parser.this.pos;
            while (Parser.this.pos < Parser.this.buf.length && Parser.this.buf[Parser.this.pos] != 32 && Parser.this.buf[Parser.this.pos] != 9 && Parser.this.buf[Parser.this.pos] != 10 && Parser.this.buf[Parser.this.pos] != 40 && Parser.this.buf[Parser.this.pos] != 41 && Parser.this.buf[Parser.this.pos] != 91 && Parser.this.buf[Parser.this.pos] != 93 && Parser.this.buf[Parser.this.pos] != 123 && Parser.this.buf[Parser.this.pos] != 125) {
                ++Parser.this.pos;
            }
            if (Parser.this.pos < Parser.this.buf.length) {
                Parser.this.token = Parser.this.pos - n == 0 ? new String(Parser.this.buf, Parser.this.pos++, 1) : (Parser.this.buf[Parser.this.pos] == 40 || Parser.this.buf[Parser.this.pos] == 91 || Parser.this.buf[Parser.this.pos] == 41 || Parser.this.buf[Parser.this.pos] == 93 ? new String(Parser.this.buf, n, Parser.this.pos - n) : new String(Parser.this.buf, n, Parser.this.pos++ - n));
            }
        }

        String seek(char c) {
            int n = Parser.this.pos;
            while (Parser.this.pos < Parser.this.buf.length) {
                if (Parser.this.buf[Parser.this.pos] == c) {
                    String string = new String(Parser.this.buf, n, Parser.this.pos - n);
                    ++Parser.this.pos;
                    this.nextToken();
                    return string;
                }
                ++Parser.this.pos;
            }
            throw new Error("Parser error! Did TeX/LaTeX complete its compilation?");
        }

        String seek(String string) {
            int n = Parser.this.buf.length - string.length();
            int n2 = Parser.this.pos;
            while (Parser.this.pos < n) {
                int n3 = 0;
                while (n3 < string.length()) {
                    if (Parser.this.buf[Parser.this.pos + n3] != string.charAt(n3)) break;
                    ++n3;
                }
                if (n3 == string.length()) {
                    String string2 = new String(Parser.this.buf, n2, Parser.this.pos + n3 - n2);
                    Parser.this.pos += n3;
                    this.nextToken();
                    return string2;
                }
                ++Parser.this.pos;
            }
            throw new Error("Parser error! Did TeX/LaTeX complete its compilation?");
        }

        String crossLineSeek(String string) {
            int n = Parser.this.buf.length - string.length();
            int n2 = 0;
            int n3 = Parser.this.pos;
            while (Parser.this.pos < n) {
                int n4 = 0;
                while (n4 < string.length()) {
                    if (Parser.this.buf[Parser.this.pos + n4 + n2] == 10 || Parser.this.buf[Parser.this.pos + n4 + n2] == 13) {
                        --n4;
                        ++n2;
                    } else if (Parser.this.buf[Parser.this.pos + n4 + n2] != string.charAt(n4)) break;
                    ++n4;
                }
                if (n4 == string.length()) {
                    String string2 = new String(Parser.this.buf, n3, Parser.this.pos + n4 + n2 - n3);
                    Parser.this.pos += n4 + n2;
                    this.nextToken();
                    string2 = Parser.this.strip(string2, '\n');
                    string2 = Parser.this.strip(string2, '\r');
                    return string2;
                }
                ++Parser.this.pos;
            }
            throw new Error("Parser error! Did TeX/LaTeX complete its compilation?");
        }
    }
}

