package com.dickimawbooks.jmakepdfx;

public class PdfxProcessListener implements ProcessListener
{
   public PdfxProcessListener(Jmakepdfx application)
   {
      this.app = application;
      this.message = null;
      this.errors = null;
   }

   public void setProcess(Process process)
   {
      this.process = process;
   }

   public void processLine(int lineNum, String line)
   {
      app.setInfo(line);

      if (lineNum > 4 && !line.startsWith("Page"))
      {
         if (message == null)
         {
            message = line;
         }
         else if (!message.contains(line))
         {
            message += "\n"+line;
         }
      }
   }

   public void processErrorLine(int lineNum, String line)
   {
      if (errors == null)
      {
         errors = line;
      }
      else
      {
         errors += "\n" + line;
      }
   }

   public void error(Exception e)
   {
      app.error(e);
   }

   public String getMessage()
   {
      return message;
   }

   public String getErrors()
   {
      return errors;
   }

   public void terminateProcess()
   {
      if (thread != null)
      {
         Jmakepdfx.debug("Interrupting "+thread);
         thread.interrupt();
      }

      if (process != null)
      {
         Jmakepdfx.debug("Destroying "+process);
         process.destroy();
      }
   }

   public void setThread(Thread thread)
   {
      this.thread = thread;
   }

   public void setInterruptor(InterruptTimerTask interruptor)
   {
      this.interruptor = interruptor;
   }

   public InterruptTimerTask getInterruptor()
   {
      return interruptor;
   }

   private Jmakepdfx app;
   private String message;
   private String errors;
   private Process process;
   private Thread thread;
   private InterruptTimerTask interruptor;
}
