"""
/*
 * Header.py 1.0
 * Implementa un mini lenguaje de bloques para crear
 * cabeceras con fancyhdr
 *
 * Copyright (C) Manuel Gutierrez Algaba, 2000
 *
 * This program is free software; you can redistribute it and/or modif
y
 * it under the terms of the GNU General Public License as published b
y
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
*/                 
"""

class Bloque:
    def __init__(self, y, x, inicio_y = 0, inicio_x = 0):
	"""
	y : altura
	x : anchura 
	"""
	self.y = y
	self.x = x
	self.inicio_y = inicio_y
	self.inicio_x = inicio_x
	self.lista_bloques=[]
	self.caracteres_anyadidos = []
    
    def genera_bloque(self):
	print "\\psline{-}" + self.escribe_coordenadas(
	    (self.inicio_x, self.inicio_y),
	    (self.inicio_x,  self.inicio_y + self.y),
	    (self.inicio_x+self.x,  self.inicio_y+ self.y),
	    (self.inicio_x+self.x,  self.inicio_y),
	    (self.inicio_x, self.inicio_y) )
	self.genera_escritura()
	for i in self.lista_bloques:
	    i.genera_bloque()

    def escribe_coordenadas(self, *args):
	dev = ""
	for i in args:
	    dev = dev + str(i) + " "
	return dev

    def anyade(self, un_bloque):
	self.lista_bloques.append(un_bloque)
	return un_bloque

    def tamanyo_x(self, factor):
	return Bloque(self.y, factor * self.x, self.inicio_y, self.inicio_x)

    def tamanyo_y(self, factor):
	return Bloque(self.y * factor, self.x, self.inicio_y, self.inicio_x)

    def lado(self, alt, long):
	if alt != "inf" and alt!= "sup" and alt!="cent":
	    raise "Mala 'altitud'"
	if long != "izq" and long!= "der" and long!="cent":
	    raise "Mala 'longitud'"
	t = Bloque(self.y, self.x, self.inicio_y, self.inicio_x)
	if alt == "sup":
	    t.inicio_y = self.y
	if alt == "cent":
	    t.inicio_y = self.y / 2
	if long == "der":
	    t.inicio_x = self.x 
	if long == "cent":
	    t.inicio_x = self.x / 2
	return t

    def traslada_x(self, x ):
	self.inicio_x = self.inicio_x + x 
	for i in self.lista_bloques:
	    i.traslada_x(x)

    def traslada_y(self, y):
	self.inicio_y = self.inicio_y + y
	for i in self.lista_bloques:
	    i.traslada_y(y)

    def escribe_hacia(self, pos_x, pos_y, escribir):
	"""
	pos = numero fraccionario
	"""
	if pos_x >= 1.0 or pos_x < 0:
	    raise "Pos_x debe ser fraccionario y positivo"

	if pos_y >= 1.0 or pos_y < 0:
	    raise "Pos_y debe ser fraccionario y positivo"
	
	self.caracteres_anyadidos.append((pos_x, pos_y, escribir))

    def genera_escritura(self):
	for i in self.caracteres_anyadidos: 
	    print "\\rput"+ self.escribe_coordenadas(( i[0] *( self.x - self.inicio_x) + self.inicio_x, self.inicio_y + i[1]* (self.y - self.inicio_y))) + "{" + i[2] + "}"
	

if __name__=='__main__':
    b = Bloque(3,4)
    c= b.anyade(b.lado("inf","der").tamanyo_y(0.5).tamanyo_x(3))
    b.escribe_hacia(0.12, 0.1, "Alphaville")
    d = b.anyade(c.lado("sup", "izq"))
    b.traslada_x(-3)
    b.genera_bloque()

