/* 
  Copyright (C) 1991-1995 Eberhard Mattes 

   ext.c - part of dvispell.
   definitions of functions for adding and removing extension from file names

   This program is free software; you can redistribute it and/or modify it
   under the terms of the GNU General Public License as published by the
   Free Software Foundation; either version 2, or (at your option) any
   later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.  
*/

#include <stdio.h>
#include <string.h>
#include <stdlib.h>
#include "ext.h"




void fndefext(char *fname, char *ext)
{
  char *fname2=strrchr(fname,'/');
  char *dot;

  if (!fname2)
  {
    fname2=fname;
  }
  else
  {
    fname2++;
  }

  if (strlen(fname2)==0)
  {
    fprintf(stderr,"You forget to write dvi file name!\n");
    exit(EXIT_FILE);
  }

  dot=strrchr(fname2,'.');
  if (dot)
  {
    dot++;
    if (strcmp(dot,ext)!=0)
    {
       fprintf(stderr,"%s is not a \"%s\" file name!\n",fname2,ext);
       exit(EXIT_FILE);
    }
  }
  else
  { //we must append an extension
    if (strlen(fname)+strlen(ext)+1>FNAME_SIZE)
    {
       fprintf(stderr,"dvi file name is too long!\n");
       exit(EXIT_FILE);
    }
    strcat(fname,".");
    strcat(fname,ext);
  }
}

void fnremext(char *fname)
{
  char * dot=strrchr(fname,'.');
  int ext_len=dot?strlen(dot):0;
  int base_len=strlen(fname)-ext_len;
  int i;
  for(i=base_len;i<base_len+ext_len+1;i++)
  {
    fname[i]='\0';
  }
}



