
#include "dk3conf.h"
#include "dk3types.h"
#include "dk3inst.h"


dkChar const * const dk3inst_directories[] = {
#if DK3_ON_WINDOWS || DK3_HAVE_BACKSLASH
  /*  0 */	dkT("C:\\Program Files\\Krause"),
  /*  1 */	dkT("C:\\Program Files\\Krause\\etc"),
  /*  2 */	dkT("C:\\Program Files\\Krause\\share"),
  /*  3 */	dkT("C:\\Program Files\\Krause\\var"),
  /*  4 */	dkT("C:\\Program Files\\Krause\\bin"),
  /*  5 */	dkT("C:\\Program Files\\Krause\\sbin"),
  /*  6 */	dkT("C:\\Program Files\\Krause\\lib"),
  /*  7 */	dkT("C:\\Program Files\\Krause\\include"),
  /*  8 */	dkT("C:\\Program Files\\Krause\\man"),
  /*  9 */	dkT("C:\\Program Files\\Krause"),
  /* 10 */	dkT("C:\\Program Files\\Krause\\libexec"),
#else
  /*  0 */	dkT("/usr/local"),
  /*  1 */	dkT("/usr/local/etc"),
  /*  2 */	dkT("/usr/local/share"),
  /*  3 */	dkT("/usr/local/var"),
  /*  4 */	dkT("/usr/local/bin"),
  /*  5 */	dkT("/usr/local/sbin"),
  /*  6 */	dkT("/usr/local/lib"),
  /*  7 */	dkT("/usr/local/include"),
  /*  8 */	dkT("/usr/local/share/man"),
  /*  9 */	dkT("/usr/local"),
  /* 10 */	dkT("/usr/local/libexec"),
#endif
};



dkChar const *
dk3inst_get_directory(size_t i)
/* {{{ */
{
  dkChar const *back = NULL;
  if(i <= 10) { back = dk3inst_directories[i]; }
  return back;
}
/* }}} */



/* vim: set ai sw=2 filetype=c foldmethod=marker foldopen=all : */

