:
# Standard directory variables from autoconf
prefix=/usr/local
datarootdir=${prefix}/share
exec_prefix=${prefix}
bindir=${exec_prefix}/bin
sbindir=${exec_prefix}/sbin
libexecdir=${exec_prefix}/libexec
datadir=${datarootdir}
sysconfdir=${prefix}/etc
scd=${sysconfdir}
libdir=${exec_prefix}/lib
sharedlibdir=${libdir}/shared
mandir=${datarootdir}/man
includedir=${prefix}/include
localstatedir=${prefix}/var

cat <<EOF

#include "dk3conf.h"
#include "dk3types.h"
#include "dk3inst.h"


dkChar const * const dk3inst_directories[] = {
#if DK3_ON_WINDOWS || DK3_HAVE_BACKSLASH
  /*  0 */	dkT("C:\\\\Program Files\\\\Krause"),
  /*  1 */	dkT("C:\\\\Program Files\\\\Krause\\\\etc"),
  /*  2 */	dkT("C:\\\\Program Files\\\\Krause\\\\share"),
  /*  3 */	dkT("C:\\\\Program Files\\\\Krause\\\\var"),
  /*  4 */	dkT("C:\\\\Program Files\\\\Krause\\\\bin"),
  /*  5 */	dkT("C:\\\\Program Files\\\\Krause\\\\sbin"),
  /*  6 */	dkT("C:\\\\Program Files\\\\Krause\\\\lib"),
  /*  7 */	dkT("C:\\\\Program Files\\\\Krause\\\\include"),
  /*  8 */	dkT("C:\\\\Program Files\\\\Krause\\\\man"),
  /*  9 */	dkT("C:\\\\Program Files\\\\Krause"),
  /* 10 */	dkT("C:\\\\Program Files\\\\Krause\\\\libexec"),
#else
  /*  0 */	dkT("$prefix"),
  /*  1 */	dkT("$sysconfdir"),
  /*  2 */	dkT("$datarootdir"),
  /*  3 */	dkT("$localstatedir"),
  /*  4 */	dkT("$bindir"),
  /*  5 */	dkT("$sbindir"),
  /*  6 */	dkT("$libdir"),
  /*  7 */	dkT("$includedir"),
  /*  8 */	dkT("$mandir"),
  /*  9 */	dkT("$exec_prefix"),
  /* 10 */	dkT("$libexecdir"),
#endif
};



dkChar const *
dk3inst_get_directory(size_t i)
/* {{{ */
{
  dkChar const *back = NULL;
  if(i <= 10) { back = dk3inst_directories[i]; }
  return back;
}
/* }}} */



/* vim: set ai sw=2 filetype=c foldmethod=marker foldopen=all : */

EOF
