#! /usr/bin/perl 
#===============================================================================
#
#         FILE:  transform-config.pl
#
#        USAGE:  ./transform-config.pl  
#
#  DESCRIPTION:  
#
#      OPTIONS:  ---
# REQUIREMENTS:  ---
#         BUGS:  ---
#        NOTES:  ---
#       AUTHOR:  YOUR NAME (), 
#      COMPANY:  
#      VERSION:  1.0
#      CREATED:  28.11.2010 19:17:13
#     REVISION:  ---
#===============================================================================

use strict;
use warnings;

my @have;
my @size;
my @timewith;
my %sections;

my %windows;

my $nhave = 0;
my $nsize = 0;
my $ntimewith = 0;
my $writeall = 0;
my $line;
my $name;
my $n;
my $value;
my $sectionnr = 0;
my $havearguments = 0;
my $havesystime = 0;
my $protectorname = undef;

if($#ARGV > -1) {
  $line = shift;
  if($line eq "-a") {
    $writeall = 1;
  }
}

$windows{"HAVE_WINSOCK2_H"} = 1;
$windows{"HAVE_WS2TCPIP_H"} = 1;
$windows{"HAVE_WINDOWS_H"} = 1;
$windows{"HAVE_WINBASE_H"} = 1;
$windows{"HAVE_WINREG_H"} = 1;
$windows{"HAVE_WINCON_H"} = 1;
$windows{"HAVE_STDIO_H"} = 1;
$windows{"HAVE_ERR_H"} = 0;
$windows{"HAVE_SYS_TYPES_H"} = 1;
$windows{"HAVE_SYS_STAT_H"} = 1;
$windows{"HAVE_STDLIB_H"} = 1;
$windows{"HAVE_STDDEF_H"} = 1;
$windows{"HAVE_UNISTD_H"} = 0;
$windows{"HAVE_PROCESS_H"} = 1;
$windows{"HAVE_LIMITS_H"} = 1;
$windows{"HAVE_SYS_PARAM_H"} = 0;
$windows{"HAVE_SYS_WAIT_H"} = 0;
$windows{"HAVE_SYS_STATVFS_H"} = 0;
$windows{"HAVE_SYS_STROPTS_H"} = 0;
$windows{"HAVE_SYS_FILE_H"} = 0;
$windows{"HAVE_SYS_UIO_H"} = 0;
$windows{"HAVE_SYS_UN_H"} = 0;
$windows{"HAVE_SYS_SUNDDI_H"} = 0;
$windows{"HAVE_SYS_RESOURCE_H"} = 0;
$windows{"HAVE_SYS_SYSTEMINFO_H"} = 0;
$windows{"HAVE_SYS_SOCKET_H"} = 0;
$windows{"TIME_WITH_SYS_TIME"} = 0;
$windows{"HAVE_SYS_TIME_H"} = 0;
$windows{"HAVE_TIME_H"} = 1;
$windows{"HAVE_ERRNO_H"} = 1;
$windows{"HAVE_ALLOC_H"} = 0;
$windows{"HAVE_MALLOC_H"} = 1;
$windows{"HAVE_CTYPE_H"} = 1;
$windows{"HAVE_STRING_H"} = 1;
$windows{"HAVE_STRINGS_H"} = 0;
$windows{"HAVE_STROPTS_H"} = 0;
$windows{"HAVE_IO_H"} = 1;
$windows{"HAVE_DOS_H"} = 1;
$windows{"HAVE_FCNTL_H"} = 1;
$windows{"HAVE_DIR_H"} = 0;
$windows{"HAVE_DIRENT_H"} = 0;
$windows{"HAVE_DIRECT_H"} = 1;
$windows{"HAVE_SYSRES_H"} = 0;
$windows{"HAVE_NETINET_IN_H"} = 0;
$windows{"HAVE_ARPA_INET_H"} = 0;
$windows{"HAVE_NETDB_H"} = 0;
$windows{"HAVE_GRP_H"} = 0;
$windows{"HAVE_PWD_H"} = 0;
$windows{"HAVE_MATH_H"} = 1;
$windows{"HAVE_FLOAT_H"} = 1;
$windows{"HAVE_FENV_H"} = 0;
$windows{"HAVE_SIGNAL_H"} = 1;
$windows{"HAVE_SYSLOG_H"} = 0;
$windows{"HAVE_CONIO_H"} = 1;
$windows{"HAVE_WCHAR_H"} = 1;
$windows{"HAVE_STDARG_H"} = 1;
$windows{"HAVE_VARARG_H"} = 0;
$windows{"HAVE_VARARGS_H"} = 0;
$windows{"HAVE_TERMIOS_H"} = 0;
$windows{"HAVE_SHADOW_H"} = 0;
$windows{"HAVE_SYS_TERMIOS_H"} = 0;
$windows{"HAVE_SYS_TTOLD_H"} = 0;
$windows{"HAVE_SETJMP_H"} = 1;
$windows{"HAVE_NDBM_H"} = 0;
$windows{"HAVE_STDINT_H"} = 1;
$windows{"HAVE_INTTYPES_H"} = 0;
$windows{"HAVE_SOCKET"} = 1;
$windows{"HAVE_GETPEERNAME"} = 1;
$windows{"HAVE_GETSOCKNAME"} = 1;
$windows{"HAVE_HTONL"} = 1;
$windows{"HAVE_SETSOCKOPT"} = 1;
$windows{"HAVE_GETHOSTBYNAME"} = 1;
$windows{"HAVE_GETADDRINFO"} = 1;
$windows{"HAVE_PNG_GET_PIXELS_PER_INCH"} = 1;
$windows{"HAVE_RFC_2249"} = 0;
$windows{"HAVE_FORK"} = 0;
$windows{"HAVE_GETRLIMIT"} = 0;
$windows{"HAVE_SETSID"} = 0;
$windows{"HAVE_SETPGRP"} = 0;
$windows{"HAVE_SYSLOG"} = 0;
$windows{"HAVE_SIG_ATOMIC_T"} = 0;
$windows{"HAVE_SOCKLEN_T"} = 0;
$windows{"HAVE_SSIZE_T"} = 0;
$windows{"HAVE_IN_ADDR"} = 1;
$windows{"HAVE_IN6_ADDR"} = 1;
$windows{"HAVE_ACOSH" } = 0;
$windows{"HAVE_ASINH" } = 0;
$windows{"HAVE_ATANH" } = 0;
$windows{"HAVE_BCMP" } = 0;
$windows{"HAVE_BCOPY" } = 0;
$windows{"HAVE_BZERO" } = 0;
$windows{"HAVE_FOPEN64" } = 0;
$windows{"HAVE_GDBM_H" } = 0;
$windows{"HAVE_GETENV" } = 1;
$windows{"HAVE_INET_ADDR" } = 0;
$windows{"HAVE_INET_ATON" } = 0;
$windows{"HAVE_INET_PTON" } = 0;
$windows{"HAVE_ISATTY" } = 1;
$windows{"HAVE_LOCALE_H" } = 1;
$windows{"HAVE_MEMCMP" } = 1;
$windows{"HAVE_MEMCPY" } = 1;
$windows{"HAVE_MEMSET" } = 1;
$windows{"HAVE_MPCTL" } = 0;
$windows{"HAVE_SELECT" } = 1;
$windows{"HAVE_SETGID" } = 0;
$windows{"HAVE_STRERROR" } = 1;
$windows{"HAVE_SYSCONF" } = 0;
$windows{"HAVE_SYSCTL" } = 0;
$windows{"HAVE_SYS_SYSCTL_H" } = 0;
$windows{"HAVE_TCFLUSH" } = 0;
$windows{"HAVE_TCGETATTR" } = 0;
# $windows{"HAVE_ZLIB_H"} = 0;
# $windows{"HAVE_BZLIB_H"} = 0;
# $windows{"HAVE_OPENSSL_RAND_H"} = 0;
# $windows{"HAVE_OPENSSL_MD5_H"} = 0;
# $windows{"HAVE_OPENSSL_SHA_H"} = 0;
# $windows{"HAVE_OPENSSL_RIPEMD_H"} = 0;
# $windows{"HAVE_PNG_H"} = 0;
# $windows{"HAVE_PNM_H"} = 0;
# $windows{"HAVE_JPEGLIB_H"} = 0;
# $windows{"HAVE_TIFF_H"} = 0;
# $windows{"HAVE_GDBM_H"} = 0;
# $windows{"HAVE_DB_H"} = 0;
# $windows{"HAVE_SHA224"} = 0;
# $windows{"HAVE_SHA256"} = 0;
# $windows{"HAVE_SHA384"} = 0;
# $windows{"HAVE_SHA512"} = 0;

$windows{"WORDS_BIGENDIAN"} = 0;
$windows{"SIZEOF_SHORT"} = 2;
$windows{"SIZEOF_INT"} = 4;
$windows{"SIZEOF_LONG"} = 4;
$windows{"SIZEOF_SIZE_T"} = 8;
$windows{"HAVE_LONG_LONG"} = 1;
$windows{"HAVE_INTMAX_T"} = 1;
$windows{"SIZEOF_INTMAX_T"} = 8;
$windows{"HAVE_LONG_DOUBLE"} = 1;
$windows{"SIZEOF_LONG_LONG"} = 8;
$windows{"SIZEOF_DOUBLE"} = 8;
$windows{"SIZEOF_LONG_DOUBLE"} = 8;
$windows{"HAVE_WCHAR_T"} = 1;
$windows{"SIZEOF_WCHAR_T"} = 2;
$windows{"HAVE_LARGEFILE64_SOURCE"} = 0;
$windows{"HAVE_CONST"} = 1;
$windows{"HAVE_VOLATILE"} = 1;
$windows{"HAVE_BACKSLASH"} = 1;
$windows{"HAVE_FNCASEINS"} = 1;
# $windows{"HAVE_COMPILER_CONVERSIONS"} = 1;
$windows{"HAVE_MALLOC"} = 1;
$windows{"HAVE_FREE"} = 1;
$windows{"HAVE_STRLEN"} = 1;
$windows{"HAVE_WCSLEN"} = 1;
$windows{"HAVE__WCSLEN"} = 0;
$windows{"HAVE_STRCMP"} = 1;
$windows{"HAVE_WCSCMP"} = 1;
$windows{"HAVE__WCSCMP"} = 0;
$windows{"HAVE_STRNCMP"} = 1;
$windows{"HAVE_WCSNCMP"} = 1;
$windows{"HAVE__WCSNCMP"} = 0;
$windows{"HAVE_STRICMP"} = 0;
$windows{"HAVE__STRICMP"} = 1;
$windows{"HAVE_STRCASECMP"} = 0;
$windows{"HAVE_WCSICMP"} = 0;
$windows{"HAVE__WCSICMP"} = 1;
$windows{"HAVE_STRCPY"} = 1;
$windows{"HAVE_WCSCPY"} = 1;
$windows{"HAVE__WCSCPY"} = 0;
$windows{"HAVE_STRNCPY"} = 1;
$windows{"HAVE_WCSNCPY"} = 1;
$windows{"HAVE__WCSNCPY"} = 0;
$windows{"HAVE_STRCAT"} = 1;
$windows{"HAVE_WCSCAT"} = 1;
$windows{"HAVE__WCSCAT"} = 0;
$windows{"HAVE_STRCHR"} = 1;
$windows{"HAVE_WCSCHR"} = 1;
$windows{"HAVE__WCSCHR"} = 0;
$windows{"HAVE_STRRCHR"} = 1;
$windows{"HAVE_WCSRCHR"} = 1;
$windows{"HAVE__WCSRCHR"} = 0;
$windows{"HAVE_STRDUP"} = 0;
$windows{"HAVE__STRDUP"} = 1;
$windows{"HAVE_SNPRINTF"} = 0;
$windows{"HAVE__SNPRINTF"} = 1;
$windows{"HAVE_WCSDUP"} = 0;
$windows{"HAVE__WCSDUP"} = 1;
$windows{"HAVE_RINT"} = 0;
$windows{"HAVE_FLOOR"} = 1;
$windows{"HAVE_CEIL"} = 1;
$windows{"HAVE_FABS"} = 1;
$windows{"HAVE_LABS"} = 1;
$windows{"HAVE_TIME"} = 1;
$windows{"HAVE_LOCALTIME"} = 1;
$windows{"HAVE_FOPEN"} = 1;
$windows{"HAVE__FOPEN"} = 0;
$windows{"HAVE_FCLOSE"} = 1;
$windows{"HAVE__FCLOSE"} = 0;
$windows{"HAVE_FEOF"} = 1;
$windows{"HAVE__FEOF"} = 0;
$windows{"HAVE_FERROR"} = 1;
$windows{"HAVE__FERROR"} = 0;
$windows{"HAVE_FFLUSH"} = 1;
$windows{"HAVE__FFLUSH"} = 0;
$windows{"HAVE_FREAD"} = 0;
$windows{"HAVE__FREAD"} = 1;
$windows{"HAVE_FWRITE"} = 0;
$windows{"HAVE__FWRITE"} = 1;
$windows{"HAVE__WGETENV"} = 1;
$windows{"HAVE_GETPWNAM"} = 0;
$windows{"HAVE_GETPWUID"} = 0;
$windows{"HAVE_GETPWENT"} = 0;
$windows{"HAVE_SETPWENT"} = 0;
$windows{"HAVE_ENDPWENT"} = 0;
$windows{"HAVE_GETUID"} = 1;
$windows{"HAVE_STAT64"} = 1;
$windows{"HAVE__STAT64"} = 0;
$windows{"HAVE_LSTAT64"} = 1;
$windows{"HAVE__LSTAT64"} = 0;
$windows{"HAVE_STAT32"} = 1;
$windows{"HAVE__STAT32"} = 0;
$windows{"HAVE_LSTAT32"} = 1;
$windows{"HAVE__LSTAT32"} = 0;
$windows{"HAVE_STAT"} = 1;
$windows{"HAVE__STAT"} = 0;
$windows{"HAVE_LSTAT"} = 1;
$windows{"HAVE__LSTAT"} = 0;
$windows{"HAVE_GETHOSTNAME"} = 0;
$windows{"HAVE_GETCWD"} = 1;
$windows{"HAVE__GETCWD"} = 0;
$windows{"HAVE_LOCALTIME"} = 1;
$windows{"HAVE_LOCALTIME_R"} = 0;
$windows{"HAVE_MKDIR"} = 0;
$windows{"HAVE__MKDIR"} = 1;
$windows{"HAVE_MKDIR2"} = 0;
$windows{"HAVE_UNLINK"} = 0;
$windows{"HAVE__UNLINK"} = 1;
$windows{"HAVE_RMDIR"} = 0;
$windows{"HAVE__RMDIR"} = 1;
$windows{"HAVE_GETPID"} = 1;
$windows{"HAVE__GETPID"} = 0;
$windows{"HAVE_OPENDIR"} = 0;
$windows{"HAVE_READDIR"} = 0;
$windows{"HAVE_CLOSEDIR"} = 0;
$windows{"HAVE_SIGNAL"} = 1;
$windows{"HAVE_INODES"} = 0;
$windows{"HAVE_READ"} = 1;
$windows{"HAVE_WRITE"} = 1;
$windows{"HAVE__READ"} = 0;
$windows{"HAVE__WRITE"} = 0;
$windows{"HAVE_DEV_URANDOM"} = 0;
$windows{"HAVE_DEV_RANDOM"} = 0;
$windows{"HAVE_RAND"} = 0;
$windows{"HAVE_SRAND"} = 0;
$windows{"HAVE_INITSTATE"} = 0;
$windows{"HAVE_SETSTATE"} = 0;
$windows{"HAVE_RANDOM"} = 0;
$windows{"HAVE_NRAND48"} = 0;
$windows{"HAVE_LRAND48"} = 0;
$windows{"HAVE_SEED48"} = 0;
$windows{"HAVE_CHDIR"} = 1;
# $windows{"HAVE_FALLBACK_STRING_FUNCTIONS"} = 1;
$windows{"HAVE_POPEN"} = 0;
$windows{"HAVE__POPEN"} = 1;
$windows{"HAVE_SIGACTION"} = 0;
$windows{"HAVE_SIGSET"} = 0;
$windows{"HAVE_USER_NAMES_CASE_INSENSITIVE"} = 1;
$windows{"HAVE_ATAN2"} = 1;
$windows{"HAVE_RINTL"} = 1;
$windows{"HAVE_FLOORL"} = 1;
$windows{"HAVE_CEILL"} = 1;
$windows{"HAVE_FABSL"} = 1;
$windows{"HAVE_ATAN2L"} = 1;
$windows{"HAVE_SINL"} = 1;
$windows{"HAVE_COSL"} = 1;
$windows{"HAVE_TANL"} = 1;
$windows{"HAVE_ASINL"} = 1;
$windows{"HAVE_ACOSL"} = 1;
$windows{"HAVE_ATANL"} = 1;
$windows{"HAVE_EXPL"} = 1;
$windows{"HAVE_LOGL"} = 1;
$windows{"HAVE_SQRTL"} = 1;
$windows{"HAVE_SINHL"} = 1;
$windows{"HAVE_COSHL"} = 1;
$windows{"HAVE_TANHL"} = 1;
$windows{"HAVE_ASINHL"} = 1;
$windows{"HAVE_ACOSHL"} = 1;
$windows{"HAVE_ATANHL"} = 1;
$windows{"HAVE_RFC_2279"} = 0;
$windows{"HAVE_GETGRNAM"} = 0;
$windows{"HAVE_GETGRENT"} = 0;
$windows{"HAVE_GETGRGID"} = 0;
$windows{"HAVE_SETGRENT"} = 0;
$windows{"HAVE_ENDGRENT"} = 0;
$windows{"HAVE_GETEUID"} = 0;
$windows{"HAVE_SETUID"} = 0;
$windows{"HAVE_GETUID"} = 0;
$windows{"HAVE_CHMOD"} = 0;
$windows{"HAVE_CHOWN"} = 0;
$windows{"HAVE_STRUCT_SOCKADDR_IN"} = 1;
$windows{"HAVE_STRUCT_SOCKADDR_UN"} = 0;
$windows{"HAVE_STRUCT_SOCKADDR_IN6"} = 1;
$windows{"HAVE_STRUCT_ADDRINFO"} = 0;
$windows{"HAVE_STRUCT_SOCKADDR_STORAGE"} = 0;
$windows{"HAVE_PTHREAD_H"} = 0;
$windows{"HAVE_UMASK"} = 0;
$windows{"HAVE_IEEE_754_DOUBLE"} = 1;
$windows{"HAVE_FPCLASSIFY"} = 0;
$windows{"HAVE_STRTOUMAX"} = 1;
$windows{"HAVE_STRTOIMAX"} = 1;
$windows{"HAVE_WCSTOUMAX"} = 1;
$windows{"HAVE_WCSTOIMAX"} = 1;
$windows{"HAVE_STRTOULL"}  = 1;
$windows{"HAVE_STRTOLL"}   = 1;
$windows{"HAVE_WCSTOULL"}  = 1;
$windows{"HAVE_WCSTOLL"}   = 1;
$windows{"HAVE_STRTOUL"}   = 1;
$windows{"HAVE_STRTOL"}    = 1;
$windows{"HAVE_WCSTOUL"}   = 1;
$windows{"HAVE_WCSTOL"}    = 1;
$windows{"HAVE_STRTOD"}	   = 1;
$windows{"HAVE_WCSTOD"}    = 1;
$windows{"HAVE_TWOS_COMPLEMENT"} = 1;
$windows{"HAVE__CLEARFP"}  = 1;
$windows{"HAVE_FETESTEXCEPT"} = 0;
$windows{"HAVE_ISFINITE"} = 0;
$windows{"HAVE_ISNORMAL"} = 0;

if(open(INPUT, "<config.h.in")) {
  while(<INPUT>) {
    $line = $_; chomp $line;
	if($line =~ /^#define\s+(HAVE_\S+)\s+([01-9])/o) {
	  if($sectionnr == 0) { $sectionnr = 1; }
	  $name = $1; $value = $2;
	  $have[$nhave++] = $name;
	  $sections{"$name"} = $sectionnr;
	} else {
	  if($line =~ /^#define\s+(SIZEOF_\S+)\s+0/o) {
	    $name = $1;
	    $size[$nsize++] = $name;
	    if($sectionnr == 0) { $sectionnr = 1; }
	  } else {
	    if($line =~ /^#define\s+(TIME_WITH_SYS_TIME)\s+0/o) {
	      if($sectionnr == 0) { $sectionnr = 1; }
	      $name = $1;
	      $timewith[$ntimewith++] = $name;
	    } else {
	      if($sectionnr == 1) { $sectionnr = 2; }
	    }
	  }
	}
  }
  close(INPUT);
}


my @rqwin7 = (
  "HAVE_STDINT_H",
  "HAVE_INTMAX_T",
  "SIZEOF_INTMAX_T",
  "HAVE_STRTOUMAX",
  "HAVE_STRTOIMAX",
  "HAVE_WCSTOUMAX",
  "HAVE_WCSTOIMAX",
  "HAVE_STRTOULL",
  "HAVE_STRTOLL",
  "HAVE_WCSTOULL",
  "HAVE_WCSTOLL",
  "HAVE_STRTOUL",
  "HAVE_STRTOL",
  "HAVE_WCSTOUL",
  "HAVE_WCSTOL",
  "HAVE__CLEARFP"
);

my @rqbits64 = (
  "SIZEOF_SIZE_T"
);

sub is_in_array($$)
{
  my	$name	= shift;
  my	$array	= shift;
  my	$back	= 0;
  my	$i	= 0;
  do {
    print "DEBUG Compare " . $name . " against " . $array->[$i] . "\n";
    if("$name" eq $array->[$i]) {
       $back = 1;
    }
    $i++;
  } while(($i <= $#$array) && (0 == $back));
  if($back) {
    print "DEBUG $name in array\n";
  }
  return($back);
}


if(open(OUTPUT, ">dkconfig.c")) {
  print OUTPUT "#include <stdio.h>\n\n";
  print OUTPUT "#ifdef HAVE_CONFIG_H\n";
  print OUTPUT "#include \"config.h\"\n";
  print OUTPUT "#else\n";
  print OUTPUT "#include \"dk3confd.h\"\n";
  print OUTPUT "#endif\n\n";
  foreach $name (@have) {
    $n = "$name";
    if($n =~ /_H/o) {
      if(exists($sections{"$n"})) {
        if($sections{"$n"} == 1) {
	        if(($n =~ /HAVE_TIME_H/o) || ($n =~ /HAVE_SYS_TIME_H/o)) {
	          if(!$havesystime) {
	            $havesystime = 1;
		    print OUTPUT "#if TIME_WITH_SYS_TIME\n";
		    print OUTPUT "#include <sys/time.h>\n";
		    print OUTPUT "#include <time.h>\n";
		    print OUTPUT "#else\n";
		    print OUTPUT "#if HAVE_TIME_H\n";
		    print OUTPUT "#include <time.h>\n";
		    print OUTPUT "#else\n";
		    print OUTPUT "#if HAVE_SYS_TIME_H\n";
		    print OUTPUT "#include <sys/time.h>\n";
		    print OUTPUT "#endif\n";
		    print OUTPUT "#endif\n";
		    print OUTPUT "#endif\n";
	          }
	        } else {
	          if(($n =~ /_VARARGS_H/o) || ($n =~ /_STDARG_H/o)) {
	            if(!$havearguments) {
	              print OUTPUT "#if HAVE_STDARG_H\n";
		      print OUTPUT "#include <stdarg.h>\n";
		      print OUTPUT "#else\n";
		      print OUTPUT "#if HAVE_VARARG_H\n";
		      print OUTPUT "#include <vararg.h>\n";
		      print OUTPUT "#else\n";
		      print OUTPUT "#if HAVE_VARARGS_H\n";
		      print OUTPUT "#include <varargs.h>\n";
		      print OUTPUT "#else\n";
		      print OUTPUT "#endif\n";
		      print OUTPUT "#endif\n";
		      print OUTPUT "#endif\n";
		      $havearguments = 1;
		    }
	          } else {
	            print OUTPUT "#if $n\n";
	            $n =~ s/_H/.h/g;
	            $n =~ s/HAVE_//g;
	            $n = lc $n;
	            $n =~ s/_/\//g;
	            print OUTPUT "#include <$n>\n";
	            print OUTPUT "#endif\n";
	          }
	        }
	}
      }
    }
  }
  print OUTPUT "\n#ifndef MPL\n";
  print OUTPUT "#ifdef MAXPATHLEN\n";
  print OUTPUT "/**\tMaximum path length.\n*/\n";
  print OUTPUT "#define MPL MAXPATHLEN\n";
  print OUTPUT "#else\n";
  print OUTPUT "#ifdef MAX_PATH\n";
  print OUTPUT "/**\tMaximum path length.\n*/\n";
  print OUTPUT "#define MPL MAX_PATH\n";
  print OUTPUT "#else\n";
  print OUTPUT "#ifdef PATH_MAX\n";
  print OUTPUT "/**\tMaximum path length.\n*/\n";
  print OUTPUT "#define MPL PATH_MAX\n";
  print OUTPUT "#else\n";
  print OUTPUT "/**\tMaximum path length.\n*/\n";
  print OUTPUT "#define MPL 1024\n";
  print OUTPUT "#endif\n";
  print OUTPUT "#endif\n";
  print OUTPUT "#endif\n";
  print OUTPUT "#endif\n";
  print OUTPUT "\nint main(int argc, char *argv[])\n";
  print OUTPUT "{\n";
  print OUTPUT "  printf(\"/**\\t\@file dk3conf.h";
  print OUTPUT "\\tConfiguration for DK3 libraries.\\n";
  print OUTPUT "\\tFeatures: Include files, functions, sizes,\\n";
  print OUTPUT "\\tand endianness.\\n*/\\n\\n\");\n";
  print OUTPUT "  printf(\"#ifndef DK3_CONF_H_INCLUDED\\n\");\n";
  print OUTPUT "  printf(\"/** Avoid multiple inclusions. */\\n\");\n";
  print OUTPUT "  printf(\"#define DK3_CONF_H_INCLUDED 1\\n\\n\");\n";

  print OUTPUT "  printf(\"#ifndef DK3_ON_WINDOWS\\n\");\n";
  print OUTPUT "  printf(\"#if defined(WIN32) || defined(_WIN32) || defined(WIN64) || defined(_WIN64)\\n\");\n";
  print OUTPUT "  printf(\"/** On a Windows system. */\\n\");\n";
  print OUTPUT "  printf(\"#define DK3_ON_WINDOWS\\t1\\n\");\n";
  print OUTPUT "  printf(\"#else\\n\");\n";
  print OUTPUT "  printf(\"/** Not on a Windows system. */\\n\");\n";
  print OUTPUT "  printf(\"#define DK3_ON_WINDOWS\\t0\\n\");\n";
  print OUTPUT "  printf(\"#endif\\n\");\n";
  print OUTPUT "  printf(\"#endif\\n/** ifndef DK3_ON_WINDOWS */\\n\");\n";

  print OUTPUT "  printf(\"\\n#if DK3_ON_WINDOWS\\n\");\n";
  foreach $name (sort(@have)) {
    if(exists($windows{"$name"})) {
      if(is_in_array($name, \@rqwin7)) {
        print OUTPUT "  printf(\"\\n#ifndef DK3_$name\\n\");\n";
	print OUTPUT "  printf(\"#if _MSC_VER >= 1700\\n\");\n";
        print OUTPUT "  printf(\"/**\\tDK3 version of $name.\\n*/\\n\");\n";
        print OUTPUT "  printf(\"#define DK3_$name ";
        print OUTPUT "" . $windows{"$name"} . "\\n\");\n";
	print OUTPUT "  printf(\"#else\\n\");\n";
        print OUTPUT "  printf(\"/**\\tDK3 version of $name.\\n*/\\n\");\n";
        print OUTPUT "  printf(\"#define DK3_$name 0\\n\");\n";
	print OUTPUT "  printf(\"#endif\\n\");\n";
        print OUTPUT "  printf(\"#endif\\n\");\n";
      } else {
        print OUTPUT "  printf(\"\\n#ifndef DK3_$name\\n\");\n";
        print OUTPUT "  printf(\"/**\\tDK3 version of $name.\\n*/\\n\");\n";
        print OUTPUT "  printf(\"#define DK3_$name ";
        print OUTPUT "" . $windows{"$name"} . "\\n\");\n";
        print OUTPUT "  printf(\"#endif\\n\");\n";
      }
    } else {
      # print OUTPUT "  printf(\"#define DK3_$name 0\\n\");\n";
      print OUTPUT "/* WARNING: $name not defined for Windows! */\n";
      print "WARNING: $name not defined for Windows!\n";
    }
  }
  foreach $name(sort(@timewith)) {
    if(exists($windows{"$name"})) {
      print OUTPUT "  printf(\"\\n#ifndef DK3_$name\\n\");\n";
      print OUTPUT "  printf(\"/**\\tDK3 version of $name.\\n*/\\n\");\n";
      print OUTPUT "  printf(\"#define DK3_$name ";
      print OUTPUT "" . $windows{"$name"} . "\\n\");\n";
      print OUTPUT "  printf(\"#endif\\n\");\n";
    } else {
      print OUTPUT "/* WARNING: $name not defined for Windows! */\n";
      print "WARNING: $name not defined for Windows!\n";
    }
  }
  foreach $name (sort(@size)) {
    print "DEBUG $name found in size array\n";
    if(exists($windows{"$name"})) {
      print "DEBUG $name exists for Windows\n";
      if(is_in_array($name, \@rqwin7)) {
        print "DEBUG $name is in array\n";
        print OUTPUT "  printf(\"\\n#ifndef DK3_$name\\n\");\n";
	print OUTPUT "  printf(\"#if _MSC_VER >= 1700\\n\");\n";
        print OUTPUT "  printf(\"/**\\tDK3 version of $name.\\n*/\\n\");\n";
        print OUTPUT "  printf(\"#define DK3_$name ";
        print OUTPUT "" . $windows{"$name"} . "\\n\");\n";
	print OUTPUT "  printf(\"#else\\n\");\n";
        print OUTPUT "  printf(\"/**\\tDK3 version of $name.\\n*/\\n\");\n";
        print OUTPUT "  printf(\"#define DK3_$name 0\\n\");\n";
	print OUTPUT "  printf(\"#endif\\n\");\n";
        print OUTPUT "  printf(\"#endif\\n\");\n";
      } else {
        if(is_in_array($name, \@rqbits64)) {
          print "DEBUG $name is not in array\n";
	  print OUTPUT "  printf(\"\\n#if defined(WIN64) || defined(_WIN64)\\n\");\n";
          print OUTPUT "  printf(\"#ifndef DK3_$name\\n\");\n";
          print OUTPUT "  printf(\"/**\\tDK3 version of $name.\\n*/\\n\");\n";
          print OUTPUT "  printf(\"#define DK3_$name ";
          print OUTPUT "" . $windows{"$name"} . "\\n\");\n";
          print OUTPUT "  printf(\"#endif\\n\");\n";
	  print OUTPUT "  printf(\"#else\\n\");\n";
          print OUTPUT "  printf(\"#ifndef DK3_$name\\n\");\n";
          print OUTPUT "  printf(\"/**\\tDK3 version of $name.\\n*/\\n\");\n";
          print OUTPUT "  printf(\"#define DK3_$name ";
          print OUTPUT "" . ($windows{"$name"} / 2) . "\\n\");\n";
          print OUTPUT "  printf(\"#endif\\n\");\n";
	  print OUTPUT "  printf(\"#endif\\n\");\n";
	} else {
          print "DEBUG $name is not in array\n";
          print OUTPUT "  printf(\"\\n#ifndef DK3_$name\\n\");\n";
          print OUTPUT "  printf(\"/**\\tDK3 version of $name.\\n*/\\n\");\n";
          print OUTPUT "  printf(\"#define DK3_$name ";
          print OUTPUT "" . $windows{"$name"} . "\\n\");\n";
          print OUTPUT "  printf(\"#endif\\n\");\n";
	}
      }
    } else {
      print OUTPUT "/* WARNING: $name not defined for Windows! */\n";
      print "WARNING: $name not defined for Windows!\n";
    }
  }
  foreach $name (sort (keys %windows)) {
    my $ind = -1;
    my $val = $windows{$name};
    for(my $i = 0; (($i <= $#have) && ($ind == -1)); $i++) {
      if($have[$i] eq $name) {
	$ind = $i;
      }
    }
    if($ind == -1) {
      for(my $i = 0; (($i <= $#timewith) && ($ind == -1)); $i++) {
        if($timewith[$i] eq $name) {
	  $ind = $i;
	}
      }
    }
    if($ind == -1) {
      for(my $i = 0; (($i <= $#size) && ($ind == -1)); $i++) {
        if($size[$i] eq $name) {
	  $ind = $i;
	}
      }
    }
    if($ind == -1) {
      print OUTPUT "  printf(\"\\n#ifndef DK3_$name\\n\");\n";
      print OUTPUT "  printf(\"/**\\tDK3 version of $name.\\n*/\\n\");\n";
      print OUTPUT "  printf(\"#define DK3_$name $val\\n\");\n";
      print OUTPUT "  printf(\"#endif\\n\");\n";
    }
  }
  print OUTPUT "  printf(\"\\n#else\\n";
  print OUTPUT "/* if DK3_ON_WINDOWS */\\n\\n\");\n";
  foreach $name (sort(@have)) {
    print OUTPUT "  printf(\"\\n#ifndef DK3_$name\\n\");\n";
    print OUTPUT "  printf(\"/**\\tDK3 version of $name.\\n*/\\n\");\n";
    print OUTPUT "#if $name\n";
    print OUTPUT "  printf(\"#define DK3_$name 1\\n\");\n";
    print OUTPUT "#else\n";
    print OUTPUT "  printf(\"#define DK3_$name 0\\n\");\n";
    print OUTPUT "#endif\n";
    print OUTPUT "  printf(\"#endif\\n\");\n";
  }
  foreach $name(sort(@timewith)) {
    print OUTPUT "  printf(\"\\n#ifndef DK3_$name\\n\");\n";
    print OUTPUT "  printf(\"/**\\tDK3 version of $name.\\n*/\\n\");\n";
    print OUTPUT "#if $name\n";
    print OUTPUT "  printf(\"#define DK3_$name 1\\n\");\n";
    print OUTPUT "#else\n";
    print OUTPUT "  printf(\"#define DK3_$name 0\\n\");\n";
    print OUTPUT "#endif\n";
    print OUTPUT "  printf(\"#endif\\n\");\n";
  }
  foreach $name (sort(@size)) {
    print OUTPUT "  printf(\"\\n#ifndef DK3_$name\\n\");\n";
    print OUTPUT "  printf(\"/**\\tDK3 version of $name.\\n*/\\n\");\n";
    print OUTPUT "  printf(\"#define DK3_$name %d\\n\", (int)$name);\n";
    print OUTPUT "  printf(\"#endif\\n\");\n";
  }
  print OUTPUT "  printf(\"\\n#endif\\n";
  print OUTPUT "/* if DK3_ON_WINDOWS */\\n\");\n";
  print OUTPUT "  printf(\"\\n#ifndef DK3_WORDS_BIGENDIAN\\n\");\n";
  print OUTPUT "#if WORDS_BIGENDIAN\n";
  print OUTPUT "  printf(\"/**\\tBig-endian.\\n*/\\n\");\n";
  print OUTPUT "  printf(\"#define DK3_WORDS_BIGENDIAN 1\\n\");\n";
  print OUTPUT "#else\n";
  print OUTPUT "  printf(\"/**\\tLittle-endian.\\n*/\\n\");\n";
  print OUTPUT "  printf(\"#define DK3_WORDS_BIGENDIAN 0\\n\");\n";
  print OUTPUT "#endif\n";
  print OUTPUT "  printf(\"#endif\\n\");\n";
  print OUTPUT "  printf(\"\\n#ifndef DK3_MAX_PATH\\n\");\n";
  print OUTPUT "  printf(\"/**\\tMaximum path length.\\n*/\\n\");\n";
  print OUTPUT "  printf(\"#define DK3_MAX_PATH %d\\n\", (MPL + 1));\n";
  print OUTPUT "  printf(\"#endif\\n\");\n";
  print OUTPUT "  printf(\"\\n#endif\\n/* ifndef DK3_CONF_H_INCLUDED */";
  print OUTPUT "\\n\\n\");\n";
  print OUTPUT "  exit(0); return 0;\n";
  print OUTPUT "}\n";
  close(OUTPUT);
}


if($writeall) {
if(open(INPUT, "<dk3all.h.in")) {
  $havesystime = 0;
  $havearguments = 0;

  if(open(OUTPUT, ">dk3all.h")) {
    while(<INPUT>) {
      $line = $_; chomp $line;
      if($line =~ /\/\*\s+all\s+include\s+files\s+\*\//o) {
	foreach $name (@have) {
	  if($name =~ /_H/o) {
	    if(exists($sections{"$name"})) {
	      if($sections{"$name"} == 1) {
	        if(($name =~ /HAVE_TIME_H/o) || ($name =~ /HAVE_SYS_TIME_H/o)) {
	          if(!$havesystime) {
	            $havesystime = 1;
		    print OUTPUT "#if DK3_TIME_WITH_SYS_TIME\n";
		    print OUTPUT "#include <sys/time.h>\n";
		    print OUTPUT "#include <time.h>\n";
		    print OUTPUT "#else\n";
		    print OUTPUT "#if DK3_HAVE_TIME_H\n";
		    print OUTPUT "#include <time.h>\n";
		    print OUTPUT "#else\n";
		    print OUTPUT "#if DK3_HAVE_SYS_TIME_H\n";
		    print OUTPUT "#include <sys/time.h>\n";
		    print OUTPUT "#endif\n";
		    print OUTPUT "#endif\n";
		    print OUTPUT "#endif\n";
	          }
	        } else {
	          if(($name =~ /_VARARGS_H/o) || ($name =~ /_STDARG_H/o)) {
	            if(!$havearguments) {
	              print OUTPUT "#if DK3_HAVE_STDARG_H\n";
		      print OUTPUT "#include <stdarg.h>\n";
		      print OUTPUT "#else\n";
		      print OUTPUT "#if DK3_HAVE_VARARG_H\n";
		      print OUTPUT "#include <vararg.h>\n";
		      print OUTPUT "#else\n";
		      print OUTPUT "#if DK3_HAVE_VARARGS_H\n";
		      print OUTPUT "#include <varargs.h>\n";
		      print OUTPUT "#else\n";
		      print OUTPUT "#endif\n";
		      print OUTPUT "#endif\n";
		      print OUTPUT "#endif\n";
		      $havearguments = 1;
		    }
	          } else {
		    $protectorname = undef;
		    if("$name" eq "HAVE_WINSOCK2_H") {
		      $protectorname = "DK3_WINSOCK2_H_INCLUDED";
		    }
		    if("$name" eq "HAVE_WINDOWS_H") {
		      $protectorname = "DK3_WINDOWS_H_INCLUDED";
		    }
		    if("$name" eq "HAVE_WINBASE_H") {
		      $protectorname = "DK3_WINBASE_H_INCLUDED";
		    }
		    if("$name" eq "HAVE_WINREG_H") {
		      $protectorname = "DK3_WINREG_H_INCLUDED";
		    }
		    if("$name" eq "HAVE_WINCON_H") {
		      $protectorname = "DK3_WINCON_H_INCLUDED";
		    }
	            print OUTPUT "#if DK3_$name\n";
	            $name =~ s/_H/.h/g;
	            $name =~ s/HAVE_//g;
	            $name = lc $name;
	            $name =~ s/_/\//g;
		    if(defined($protectorname)) {
		      print OUTPUT "#if !$protectorname\n";
		      print OUTPUT "#define $protectorname 1\n";
		    }
	            print OUTPUT "#include <$name>\n";
		    if(defined($protectorname)) {
		      print OUTPUT "#endif\n";
		    }
	            print OUTPUT "#endif\n";
	          }
	        }
	      }
	    }
	  }
	}
      } else {
	print OUTPUT "$line\n";
      }
    }
    close(OUTPUT);
  }
  close(INPUT);
}
}


if(open(OUTPUT, ">dk3info1.c")) {
  print OUTPUT "void show_defines(void)\n";
  print OUTPUT "{\n";
  print OUTPUT "  dkChar buf[64];\n";
  foreach $name (sort @have) {
    print "DEBUG have $name\n";
    print OUTPUT "#if DK3_$name\n";
    print OUTPUT "  dk3sf_fputs(dkT(\"DK3_$name = 1\\n\"), stdout);\n";
    print OUTPUT "#else\n";
    print OUTPUT "  dk3sf_fputs(dkT(\"DK3_$name = 0\\n\"), stdout);\n";
    print OUTPUT "#endif\n";
  }
  foreach $name (@size) {
    print OUTPUT "  dk3sf_sprintf3(buf, dkT(\"\%u\"), (unsigned)(DK3_$name));\n";
    print OUTPUT "  dk3sf_fputs(dkT(\"DK3_$name = \"), stdout);\n";
    print OUTPUT "  dk3sf_fputs(buf, stdout);\n";
    print OUTPUT "  dk3sf_fputc(dkT(\'\\n\'), stdout);\n";
  }
  print OUTPUT "}\n";
  close(OUTPUT);
}

