
my $version = "3-preview";
my $copyrightyears = "2012-2014";

sub create_rc_file($$$$$$$$$)
{
  my $filename = shift;
  my $vendor = shift;
  my $iconfile = shift;
  my $swname = shift;
  my $version = shift;
  my $prodname = shift;
  my $internalname = shift;
  my $fileversion = shift;
  my $prodversion = shift;
  my $outfile = undef;
  if($version =~ /(\d+)\.(\d+)\.(\d+)\.(\d+)/o) {
    $fileversion = $1 . "," . $2 . "," . $3 . "," . $4;
    $prodversion = $fileversion;
  } else {
    if($version =~ /(\d+)\.(\d+)\.(\d+)/o) {
      $fileversion = $1 . "," . $2 . "," . $3 . ",0";
      $prodversion = $fileversion;
    } else {
      if($version =~ /(\d+)\.(\d+)/o) {
        $fileversion = $1 . "," . $2 . ",0,0";
	$prodversion = $fileversion;
      } else {
        if($version =~ /(\d+)/o) {
	  $fileversion = $1 . ",0,0,0";
	  $prodversion = $fileversion;
	}
      }
    }
  }
  if(open($outfile, ">$filename")) {
    if(defined($iconfile)) {
      print $outfile "aaaaa ICON $iconfile\r\n\r\n";
      # print $outfile "#include \"wx/msw/wx.rc\"\r\n";
    }
    print $outfile "#include <windows.h>\r\n";
    print $outfile "\r\n";
    print $outfile "VS_VERSION_INFO VERSIONINFO\r\n";
    print $outfile " FILEVERSION $fileversion\r\n";
    print $outfile " PRODUCTVERSION $prodversion\r\n";
    print $outfile " FILEFLAGSMASK 0x3fL\r\n";
    print $outfile "#ifdef _DEBUG\r\n";
    print $outfile " FILEFLAGS 0x1L\r\n";
    print $outfile "#else\r\n";
    print $outfile " FILEFLAGS 0x0L\r\n";
    print $outfile "#endif\r\n";
    print $outfile " FILEOS 0x4L\r\n";
    print $outfile " FILETYPE 0x1L\r\n";
    print $outfile " FILESUBTYPE 0x0L\r\n";
    print $outfile "BEGIN\r\n";
    print $outfile "    BLOCK  \"StringFileInfo\"\r\n";
    print $outfile "    BEGIN\r\n";
    print $outfile "        BLOCK \"040904b0\"\r\n";
    print $outfile "        BEGIN\r\n";
    print $outfile "	    VALUE \"Comments\", \"$swname\\0\"\r\n";
    print $outfile "            VALUE \"CompanyName\",  \"$vendor\\0\"\r\n";
    print $outfile "            VALUE \"FileDescription\", \"$swname\\0\"\r\n";
    print $outfile "            VALUE \"FileVersion\",  \"$version\\0\"\r\n";
    print $outfile "            VALUE \"InternalName\",  \"$internalname\\0\"\r\n";
    print $outfile "            VALUE \"LegalCopyright\", \"Copyright \251 $copyrightyears $vendor\\0\"\r\n";
    print $outfile "            VALUE \"ProductName\",  \"$prodname\\0\"\r\n";
    print $outfile "            VALUE \"ProductVersion\", \"$version\\0\"\r\n";
    print $outfile "        END\r\n";
    print $outfile "    END\r\n";
    print $outfile "    BLOCK \"VarFileInfo\"\r\n";
    print $outfile "        BEGIN\r\n";
    print $outfile "            VALUE \"Translation\", 0x409, 1200\r\n";
    print $outfile "        END\r\n";
    print $outfile "END\r\n";
    print $outfile "\r\n";
    close($outfile);
  }
}


my $infile = undef;
my $firstline = 1;
if(open($infile, "<version.txt")) {
  while(<$infile>) {
    $line = $_; chomp($line);
    if($firstline) {
    if($line =~ /(\S+)/o) {
      $version = $1;
      $firstline = 0;
    }
    }
  }
  close($infile);
}

create_rc_file(
  "dkt.rc",
  "Dirk Krause",
  "dkicon.ico",
  "Dirk Krause's tool",
  $version,
  "Dirk Krause's tools",
  "dkt",
  "0,0,0,1",
  "0,0,0,1"
);

create_rc_file(
  "dkwt.rc",
  "Dirk Krause",
  "dkicon.ico",
  "Dirk Krause's Windows tool",
  $version,
  "Dirk Krause's tools",
  "dkwt",
  "0,0,0,1",
  "0,0,0,1"
);

create_rc_file(
  "dk3info.rc",
  "Dirk Krause",
  "dkicon.ico",
  "Dirk Krause's tools, setup information",
  $version,
  "Dirk Krause's tools",
  "dkwt",
  "0,0,0,1",
  "0,0,0,1"
);

create_rc_file(
  "dkct.rc",
  "Dirk Krause",
  "dkicon.ico",
  "Dirk Krause's C tool",
  $version,
  "Dirk Krause's tools",
  "dkct",
  "0,0,0,1",
  "0,0,0,1"
);

create_rc_file(
  "bmpp.rc",
  "Dirk Krause",
  "dkicon.ico",
  "Bitmap to PS/PDF converter",
  $version,
  "Dirk Krause's tools",
  "bmpp",
  "0,0,0,1",
  "0,0,0,1"
);

create_rc_file(
  "fig2lat.rc",
  "Dirk Krause",
  "dkicon.ico",
  "Fig to LaTeX converter",
  $version,
  "Dirk Krause's tools",
  "fig2lat",
  "0,0,0,1",
  "0,0,0,1"
);

create_rc_file(
  "dkwxwiz.rc",
  "Dirk Krause",
  "dkicon.ico",
  "Assistant for DK tools and wxWidgets based GUI programs",
  $version,
  "Dirk Krause's tools",
  "dkwxwiz",
  "0,0,0,1",
  "0,0,0,1"
);

create_rc_file(
  "wprclean.rc",
  "Dirk Krause",
  "dkicon.ico",
  "Clean up Windows print queues",
  $version,
  "Dirk Krause's tools",
  "wprclean",
  "0,0,0,1",
  "0,0,0,1"
);

create_rc_file(
  "winprint.rc",
  "Dirk Krause",
  "dkicon.ico",
  "Schedule file to Windows print queue",
  $version,
  "Dirk Krause's tools",
  "winprint",
  "0,0,0,1",
  "0,0,0,1"
);

create_rc_file(
  "lprngcl.rc",
  "Dirk Krause",
  "dkicon.ico",
  "Clean up LPRng print queues",
  $version,
  "Dirk Krause's tools",
  "lprngcl",
  "0,0,0,1",
  "0,0,0,1"
);

create_rc_file(
  "dkdbt.rc",
  "Dirk Krause",
  "dkicon.ico",
  "Dirk Krause's database tool",
  $version,
  "Dirk Krause's tools",
  "dkdbt",
  "0,0,0,1",
  "0,0,0,1"
);

create_rc_file(
  "dknet.rc",
  "Dirk Krause",
  "dkicon.ico",
  "Dirk Krause's network tool",
  $version,
  "Dirk Krause's tools",
  "dknet",
  "0,0,0,1",
  "0,0,0,1"
);

create_rc_file(
  "dknet4.rc",
  "Dirk Krause",
  "dkicon.ico",
  "Dirk Krause's IPv4 network tool",
  $version,
  "Dirk Krause's tools",
  "dknet4",
  "0,0,0,1",
  "0,0,0,1"
);

create_rc_file(
  "htmlbook.rc",
  "Dirk Krause",
  "dkicon.ico",
  "Dirk Krause's htmlbook program",
  $version,
  "Dirk Krause's tools",
  "htmlbook",
  "0,0,0,1",
  "0,0,0,1"
);


create_rc_file(
  "wxdkct.rc",
  "Dirk Krause",
  "dkicon.ico",
  "Dirk Krause's C tool, GUI version",
  $version,
  "Dirk Krause's tools",
  "wxdkct",
  "0,0,0,1",
  "0,0,0,1"
);

create_rc_file(
  "wxbmpp.rc",
  "Dirk Krause",
  "dkicon.ico",
  "Bitmap to PS/PDF converter, GUI version",
  $version,
  "Dirk Krause's tools",
  "wxbmpp",
  "0,0,0,1",
  "0,0,0,1"
);

create_rc_file(
  "wxpqdic.rc",
  "Dirk Krause",
  "dkicon.ico",
  "Information client for printqd",
  $version,
  "Dirk Krause's tools",
  "wxpqdic",
  "0,0,0,1",
  "0,0,0,1"
);

create_rc_file(
  "wximgsz.rc",
  "Dirk Krause",
  "dkicon.ico",
  "Image rescale suggestion",
  $version,
  "Dirk Krause's tools",
  "wximgsz",
  "0,0,0,1",
  "0,0,0,1"
);

create_rc_file(
  "wxdkclock.rc",
  "Dirk Krause",
  "dkclock.ico",
  "Alert clock",
  $version,
  "Dirk Krause's tools",
  "wxdkclock",
  "0,0,0,1",
  "0,0,0,1"
);

create_rc_file(
  "dkwxpath.rc",
  "Dirk Krause",
  "dkctinst.ico",
  "DK tools setup",
  $version,
  "Dirk Krause's tools",
  "dkwxpath",
  "0,0,0,1",
  "0,0,0,1"
);

create_rc_file(
  "wxdkhtb.rc",
  "Dirk Krause",
  "dkicon.ico",
  "HTB file viewer",
  $version,
  "Dirk Krause's tools",
  "wxdkhtb",
  "0,0,0,1",
  "0,0,0,1"
);

