#! /usr/bin/perl

my @underscore_types = (
  "size_t",
  "intmax_t",
  "wchar_t"
);

sub is_underscore_type($)
{
  my $name = shift;
  my $i;
  my $back = 0;
  for ($i = 0; $i <= $#underscore_types; $i++) {
    if ("$name" eq $underscore_types[$i]) {
      $back = 1;
    }
  }
  return $back;
}


my $fh = undef;
my $inf = undef;
my $line;
my $name;
my $lcname;

if (open($fh, ">wszchk.c")) {
  print $fh "#include <stdio.h>\n";
  print $fh "#include <stdlib.h>\n";
  print $fh "#include <process.h>\n";
  print $fh "#if _MSC_VER >= 1700\n";
  print $fh "#include <stdint.h>\n";
  print $fh "#endif\n";
  print $fh "\n";
  print $fh "#include <dk3conf.h>\n";
  print $fh "\n";

  print $fh "int main(int argc, char *argv[])\n";
  print $fh "{\n";
  print $fh "  int exval = 0;\n";
  if (open($inf, "<config.h.in")) {
    while(<$inf>) {
      $line = $_; chomp $line;
      if ($line =~ /^\s*#\s*define\s+SIZEOF_(\S+)\s+\d/o) {
        $name = $1;
	$lcname = lc($name);
	if (0 == is_underscore_type($lcname)) {
	  $lcname =~ s/_/ /g;
	}
	print $fh "#ifdef DK3_SIZEOF_$name\n";
	print $fh "  if(DK3_SIZEOF_$name == sizeof($lcname)) {\n";
	print $fh "    printf(\"DK3_SIZEOF_$name %u (ok)\\n\", (unsigned)sizeof($lcname));\n";
	print $fh "  } else {\n";
	print $fh "    printf(\"ERROR:DK3_SIZEOF_$name=%u sizeof($lcname)=%u\\n\", DK3_SIZEOF_$name, (unsigned)sizeof($lcname));\n";
	print $fh "    exval = 1;\n";
	print $fh "  }\n";
	print $fh "#else\n";
	print $fh "  printf(\"DK3_SIZEOF_$name not defined (ok)\\n\");\n";
	print $fh "#endif\n";
      }
    }
    close($inf);
  }
  print $fh "  exit(exval); return exval;\n";
  print $fh "}\n";
  close($fh);
}

