#! /bin/sh
umask 022
VERSION=`cat version.txt`
SOVERS=`cat version.txt | sed -e 's/\.[01-9][01-9]*$//'`
cat > dkt-version.h <<EOF
#ifndef DKT_VERSION_H_INCLUDED
/**	Protection from multiple inclusions.
*/
#define DKT_VERSION_H_INCLUDED	1

/**	@file	dkt-version.h	Version number for dktools.
*/


/**	Current version.
*/
#define	DKT_CHAR_VERSION	"$VERSION"

/**	Current version.
*/
#define	DKT_VERSION		dkT("$VERSION")

#if DK3_USE_WX
/**	Current version.
*/
#define	DKT_WXCHAR_VERSION	wxT("$VERSION")
#endif

#endif

EOF


[ -d ~/SW-DEV ] || (mkdir ~/SW-DEV ; chmod 755 ~/SW-DEV)
[ -d ~/SW-DEV/archives ] || (mkdir ~/SW-DEV/archives ; chmod 755 ~/SW-DEV/archives)
[ -d ~/rpmbuild ] || (mkdir ~/rpmbuild ; chmod 755 ~/rpmbuild)
[ -d ~/rpmbuild/SOURCES ] || (mkdir ~/rpmbuild/SOURCES ; chmod 755 ~/rpmbuild/SOURCES)
[ -d ~/rpmbuild/SPECS ] || (mkdir ~/rpmbuild/SPECS ; chmod 755 ~/rpmbuild/SPECS)

[ ! -d ../dktools-$VERSION ] || rm -fr ../dktools-$VERSION
[ -d ../dktools-$VERSION ] || mkdir ../dktools-$VERSION
chmod 755 ../dktools-$VERSION
tar cf - * --exclude '.git' --exclude doc --exclude devdoc | (cd ../dktools-$VERSION ; tar xf -)
cat GNUmakefile.in | sed -e "/^SOVERS=/cSOVERS=$SOVERS" > ../dktools-$VERSION/GNUmakefile.in
[ ! -d ../dktools-$VERSION/autom4te.cache ] || rm -fr ../dktools-$VERSION/autom4te.cache
[ ! -d ../dktools-doc-$VERSION ] || rm -fr ../dktools-doc-$VERSION
[ -d ../dktools-doc-$VERSION ] || mkdir ../dktools-doc-$VERSION
chmod 755 ../dktools-doc-$VERSION
(cd doc ; tar cf - * --exclude sf) | (cd ../dktools-doc-$VERSION ; tar xf -)
[ ! -d ../dktools-doc-$VERSION/autom4te.cache ] || rm -fr ../dktools-doc-$VERSION/autom4te.cache
[ ! -d ../dktools-sf-doc-$VERSION ] || rm -fr ../dktools-sf-doc-$VERSION
[ -d ../dktools-sf-doc-$VERSION ] || mkdir ../dktools-sf-doc-$VERSION
chmod 755 ../dktools-sf-doc-$VERSION
(cd doc/sf ; tar cf - *) | (cd ../dktools-sf-doc-$VERSION ; tar xf -)
[ ! -d ../dktools-sf-doc-$VERSION/autom4te.cache ] || rm -fr ../dktools-sf-doc-$VERSION/autom4te.cache
[ ! -d ../dktools-devdoc-$VERSION ] || rm -fr ../dktools-devdoc-$VERSION
[ -d ../dktools-devdoc-$VERSION ] || mkdir ../dktools-devdoc-$VERSION
chmod 755 ../dktools-devdoc-$VERSION
(cd devdoc ; tar cf - *) | (cd ../dktools-devdoc-$VERSION ; tar xf -)
[ ! -d ../dktools-devdoc-$VERSION/autom4te.cache ] || rm -fr ../dktools-devdoc-$VERSION/autom4te.cache

for i in ../dktools-$VERSION ../dktools-doc-$VERSION ../dktools-sf-doc-$VERSION ../dktools-devdoc-$VERSION
do
  find $i -type d -exec chmod 755 {} \;
  find $i -type f -exec chmod ugo+r {} \;
  find $i -name '*.sh' -exec chmod ugo+rx {} \;
  find $i -name '*.pl' -exec chmod ugo+rx {} \;
  find $i -name configure -exec chmod ugo+rx {} \;
  find $i -name '*.out' -exec rm -f {} \;
  find $i -name '*.log' -exec rm -f {} \;
done

for i in dktools-el6.spec dktools-fedora.spec dktools-doc.spec dktools-devdoc.spec
do
  if [ -f ~/rpmbuild/SPECS/$i ]
  then
    rm -f ~/rpmbuild/SPECS/$i
  fi
done
ln dktools-el6.spec ~/rpmbuild/SPECS/dktools-el6.spec
ln dktools-fedora.spec ~/rpmbuild/SPECS/dktools-fedora.spec
ln doc/dktools-doc.spec ~/rpmbuild/SPECS/dktools-doc.spec
ln devdoc/dktools-devdoc.spec ~/rpmbuild/SPECS/dktools-devdoc.spec

cd ..
tar cf dktools-$VERSION.tar ./dktools-$VERSION
gzip -9 dktools-$VERSION.tar
tar cf dktools-doc-$VERSION.tar ./dktools-doc-$VERSION
gzip -9 dktools-doc-$VERSION.tar
tar cf dktools-sf-doc-$VERSION.tar ./dktools-sf-doc-$VERSION
gzip -9 dktools-sf-doc-$VERSION.tar
tar cf dktools-devdoc-$VERSION.tar ./dktools-devdoc-$VERSION
gzip -9 dktools-devdoc-$VERSION.tar
mv dktools-$VERSION.tar.gz ~/SW-DEV/archives
mv dktools-doc-$VERSION.tar.gz ~/SW-DEV/archives
mv dktools-sf-doc-$VERSION.tar.gz ~/SW-DEV/archives
mv dktools-devdoc-$VERSION.tar.gz ~/SW-DEV/archives


[ ! -f ~/rpmbuild/SOURCES/dktools-$VERSION.tar.gz ] || rm ~/rpmbuild/SOURCES/dktools-$VERSION.tar.gz
cp ~/SW-DEV/archives/dktools-$VERSION.tar.gz ~/rpmbuild/SOURCES/dktools-$VERSION.tar.gz
[ ! -f ~/rpmbuild/SOURCES/dktools-doc-$VERSION.tar.gz ] || rm ~/rpmbuild/SOURCES/dktools-doc-$VERSION.tar.gz
cp ~/SW-DEV/archives/dktools-doc-$VERSION.tar.gz ~/rpmbuild/SOURCES/dktools-doc-$VERSION.tar.gz
[ ! -f ~/rpmbuild/SOURCES/dktools-sf-doc-$VERSION.tar.gz ] || rm ~/rpmbuild/SOURCES/dktools-sf-doc-$VERSION.tar.gz
cp ~/SW-DEV/archives/dktools-sf-doc-$VERSION.tar.gz ~/rpmbuild/SOURCES/dktools-sf-doc-$VERSION.tar.gz
[ ! -f ~/rpmbuild/SOURCES/dktools-devdoc-$VERSION.tar.gz ] || rm ~/rpmbuild/SOURCES/dktools-devdoc-$VERSION.tar.gz
cp ~/SW-DEV/archives/dktools-devdoc-$VERSION.tar.gz ~/rpmbuild/SOURCES/dktools-devdoc-$VERSION.tar.gz

