#! /bin/sh

cd help-src
for i in *
do
  cd $i
  for j in de en
  do
    cd $j
      make clean
    cd ..
  done
  cd ..
done
cd winprint
cd de
make
cd ..
cd ..
for i in *
do
  cd $i
  for j in de en
  do
    cd $j
    if [ "$i" != "$winprint" ]
    then
      ln ../../winprint/de/index.png index.png
      ln ../../winprint/de/index.svg index.svg
      ln ../../winprint/de/index.pdf index.pdf
      ln ../../winprint/de/toc.png toc.png
      ln ../../winprint/de/toc.svg toc.svg
      ln ../../winprint/de/toc.pdf toc.pdf
      ln ../../winprint/de/prev.png prev.png
      ln ../../winprint/de/prev.svg prev.svg
      ln ../../winprint/de/prev.pdf prev.pdf
      ln ../../winprint/de/previous.png previous.png
      ln ../../winprint/de/previous.svg previous.svg
      ln ../../winprint/de/previous.pdf previous.pdf
      ln ../../winprint/de/next.png next.png
      ln ../../winprint/de/next.svg next.svg
      ln ../../winprint/de/next.pdf next.pdf
      [ -f favicon.ico ] || ln ../../../dkicon.ico favicon.ico
    else
      if [ "$j" != "de" ]
      then
        ln ../../winprint/de/index.png index.png
        ln ../../winprint/de/index.svg index.svg
        ln ../../winprint/de/index.pdf index.pdf
        ln ../../winprint/de/toc.png toc.png
        ln ../../winprint/de/toc.svg toc.svg
        ln ../../winprint/de/toc.pdf toc.pdf
        ln ../../winprint/de/prev.png prev.png
        ln ../../winprint/de/prev.svg prev.svg
        ln ../../winprint/de/prev.pdf prev.pdf
        ln ../../winprint/de/previous.png previous.png
        ln ../../winprint/de/previous.svg previous.svg
        ln ../../winprint/de/previous.pdf previous.pdf
        ln ../../winprint/de/next.png next.png
        ln ../../winprint/de/next.svg next.svg
        ln ../../winprint/de/next.pdf next.pdf
	[ -f favicon.ico ] || ln ../../../dkicon.ico favicon.ico
      fi
    fi
    cd ..
  done
  cd ..
done

for i in *
do
  cd $i
  for j in de en
  do
    cd $j
      make chminstall
    cd ..
  done
  cd ..
done
cd ..

for i in index toc prev previous next
do
  for j in svg pdf
  do
    find help-src -name "$i.$j" -exec rm {} \;
    find help-html -name "$i.$j" -exec rm {} \;
  done
done

cd help-html
for i in *
do
  cd $i
  for j in de en
  do
    cd $j
      zip -r -9 ../$i.zip * -x $i.chm
      chmod 644 ../$i.zip
      mv ../$i.zip ../../../htb/$j/$i.htb
      chmcmd --verbosity 5 --html-scan project.hhp
      chmod 644 index.chm
      mv index.chm ../../../chm/$j/$i.chm
    cd ..
  done
  cd ..
done
cd ..

cd doc
cd src
ln ../../help-src/winprint/de/index.png index.png
ln ../../help-src/winprint/de/index.svg index.svg
ln ../../help-src/winprint/de/index.pdf index.pdf
ln ../../help-src/winprint/de/toc.png toc.png
ln ../../help-src/winprint/de/toc.svg toc.svg
ln ../../help-src/winprint/de/toc.pdf toc.pdf
ln ../../help-src/winprint/de/prev.png prev.png
ln ../../help-src/winprint/de/prev.svg prev.svg
ln ../../help-src/winprint/de/prev.pdf prev.pdf
ln ../../help-src/winprint/de/previous.png previous.png
ln ../../help-src/winprint/de/previous.svg previous.svg
ln ../../help-src/winprint/de/previous.pdf previous.pdf
ln ../../help-src/winprint/de/next.png next.png
ln ../../help-src/winprint/de/next.svg next.svg
ln ../../help-src/winprint/de/next.pdf next.pdf
[ -f favicon.ico ] || ln ../../dkicon.ico favicon.ico
cd ..
cd ..
