#! /bin/sh

for i in *.c
do
  j=`echo $i | sed -e 's/\.c$//g'`
  if [ ! -f $j.ctr ]
  then
    echo git add $i
    git add $i
  fi
done

for i in *.cpp
do
  j=`echo $i | sed -e 's/\.cpp$//g'`
  if [ ! -f $j.cpt ]
  then
    if [ ! -f $j.wxc ]
    then
      echo git add $i
      git add $i
    fi
  fi
done

for i in *.h
do
  j=`echo $i | sed -e 's/\.h$//g'`
  if [ -f $j.ctr ]
  then
    egrep '^%%.*header' $j.ctr > /dev/null
    EC=$?
    if [ "X$EC" != "X0" ]
    then
      echo git add $i
      git add $i
    fi
  else
    if [ -f $j.cpt ]
    then
      egrep '^%%.*header' $j.cpt > /dev/null
      EC=$?
      if [ "X$EC" != "X0" ]
      then
        echo git add $i
        git add $i
      fi
    else
      if [ -f $j.wxc ]
      then
        egrep '^%%.*header' $j.wxc > /dev/null
	EC=$?
	if [ "X$EC" != "X0" ]
	then
	  echo git add $i
	  git add $i
	fi
      else
        echo git add $i
        git add $i
      fi
    fi
  fi
done

find . -name 'configure.ac' -exec git add {} \;
find . -name '*.in' -exec git add {} \;

for dir in help-src doc/src
do
  find $dir -name '*.txt' -exec git add {} \;
  find $dir -name '*.fig' -exec git add {} \;
  find $dir -name 'math*.tex' -exec git add {} \;
  find $dir -name 'sc*.png' -exec git add {} \;
  find $dir -name 'index.prj' -exec git add {} \;
  find $dir -name 'GNUmakefile' -exec git add {} \;
  find $dir -name 'Makefile' -exec git add {} \;
done

git add scripts/*

