/*
	WARNING: This file was generated by dkct.
	Changes you make here will be lost if dkct is run again!
	You should modify the original source and run dkct on it.
	Original source: printqd.ctr
*/

/*
Copyright (C) 2012-2014, Dirk Krause

Redistribution and use in source and binary forms, with or without
modification, are permitted provided that the following conditions are met:

* Redistributions of source code must retain the above copyright notice,
  this list of conditions and the following disclaimer.
* Redistributions in binary form must reproduce the above opyright notice,
  this list of conditions and the following disclaimer in the documentation
  and/or other materials provided with the distribution.
* Neither the name of the author nor the names of contributors may be used
  to endorse or promote products derived from this software without specific
  prior written permission.

THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS ``AS IS''
AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
ARE DISCLAIMED.
IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE LIABLE FOR ANY
DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
(INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
(INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
*/

/**	@file printqd.h Header file for the printqd module.
*/

#ifndef PRINTQD_H_INCLUDED
/** Avoid multiple inclusions. */
#define PRINTQD_H_INCLUDED 1


#line 10 "printqd.ctr"

#include "dk3types.h"
#include "dk3sock.h"
#include "printqds.h"



/**	Limit for one user or group.
*/
typedef struct {
  char const	*name;	/**< User or group name. */
  unsigned long	 limit;	/**< Page limit. */
} pqd_limit_t;



/**	Printer class. Limits are valid for all printers in a class
	in summary.
*/
typedef struct {
  char const	*name;	/**< Class name. */
  dk3_sto_t	*s_u;	/**< User limits storage. */
  dk3_sto_it_t	*i_u;	/**< Iterator through user limits storage. */
  dk3_sto_t	*s_g;	/**< Group limits storage. */
  dk3_sto_it_t	*i_g;	/**< Iterator for group limits storage. */
  unsigned long	 dl;	/**< Default limit. */
  int		 da;	/**< Deny action: 1=hold, 0=remove. */
} pqd_class_t;



/**	Printer.
*/
typedef struct {
  char const	*name;	/**< Printer name. */
  pqd_class_t	*cl;	/**< Printer class. */
} pqd_printer_t;



/**	Printer alias.
*/
typedef struct {
  char const	*name;	/**< Alias name. */
  pqd_printer_t	*pr;	/**< The real printer. */
} pqd_alias_t;



/**	Printqd configuration data.
*/
typedef struct {
  char const		*usn;	/**< UNIX domain socket file name. */
  char const		*dbn;	/**< Database name. */
  dk3_sto_t		*s_c;	/**< Storage for classes. */
  dk3_sto_it_t		*i_c;	/**< Iterator for class storage. */
  dk3_sto_t		*s_p;	/**< Storage for printers. */
  dk3_sto_it_t		*i_p;	/**< Iterator for printers. */
  dk3_sto_t		*s_a;	/**< Storage for aliases. */
  dk3_sto_it_t		*i_a;	/**< Iterator for aliases storage. */
  dk3_sto_t		*s_i;	/**< Storage for allowed info clients. */
  dk3_sto_it_t		*i_i;	/**< Iterator for info clients storage. */
  uid_t			 uid;	/**< Run as user. */
  gid_t			 gid;	/**< Run as group. */
  int			 ubl;	/**< UNIX domain socket backlog. */
  int			 ibl;	/**< Info socket backlog. */
  unsigned short	 port;	/**< Port number for info requests. */
} pqd_conf_t;



/**	Printqd job data.
*/
typedef struct {
  pqd_conf_t		 cfg;	/**< Configuration data. */
  dk3_app_t		*app;	/**< Application structure. */
  char const * const	*lmsg;	/**< Localized messages. */
  char const * const	*cmsg;	/**< Localized messages for configuartion. */
  char const		*tmpn;	/**< File name for temporary file. */
  dk3_dbi_t		*db;	/**< Database. */
  char			*p_i;	/**< Buffer for input data. */
  char			*p_o;	/**< Buffer for output data. */
  size_t		 sz_i;	/**< Size of input data buffer. */
  size_t		 sz_o;	/**< Size of output data buffer. */
  dk3_socket_t		 lso;	/**< Listener socket. */
  int			 frun;	/**< Flag: First run. */
  int			 fres;	/**< Flag: Send response. */
  int			 rqt;	/**< Request type. */
} pqd_job_t;


#ifdef __cplusplus
extern "C" {
#endif

/*
	MODULE printqd
	==============
*/


/*
	MODULE pqdconf
	==============
*/

/**	Obtain localized error messages related to configuration.
	@param	app	Application structure.
	@return	Pointer to localized (success) or non-localized (error) array.
*/
dkChar const * const *
pqdconf_get_messages(dk3_app_t *app);

/**	Read a configuration.
	@param	cfg	Configuration buffer.
	@param	fn	File name.
	@param	type	Program type, PQD_PROGRAM_TYPE_xxx.
	@param	app	Application structure for diagnostics.
	@param	cmsg	Localized message texts for configuration reading.
	@return	1 on success, 0 on error.
*/
int
pqdconf_read(
  pqd_conf_t 		*cfg, 
  char const		*fn,
  int			 type,
  dk3_app_t		*app,
  dkChar const * const	*cmsg
);

/**	Clean up configuration, release dynamically allocated data.
	@param	cfg	Configuration to clean up.
*/
void
pqdconf_cleanup(pqd_conf_t *cfg);

/**	Check configuration for completeness.
	@param	cfg	Configuration to check.
	@param	type	Program type, PQD_PROGRAM_TYPE_xxx.
	@param	app	Application structure for diagnostics.
	@param	cmsg	Localized messages for configuration file reading.
	@return	1 on success, 0 on error.
*/
int
pqdconf_check(
  pqd_conf_t		*cfg,
  int			 type,
  dk3_app_t		*app,
  dkChar const * const	*cmsg
);

/*
	MODULE pqdproto
	===============
*/

/**	Process one request stored in job->p_i. If it is necessary
	to send a response, set the job->fres flag and place the response
	as 0x00-terminated string in job->p_o.
	@param	job	Job structure.
*/
void
pqdproto_process(pqd_job_t *job);

/*
	MODULE pqdstr
	=============
*/

/**	Get localized messages.
	@param	app	Application structure.
	@return	Pointer to localized (success) or non-localized (error) array.
*/
dkChar const * const *
pqdstr_get_messages(dk3_app_t *app);

/*
	MODULE pqdtool
	==============
*/

/**	Initially reset job data.
	@param	job	Job structure.
*/
void
pqdtool_job_init_first(pqd_job_t *job);

/**	Finally clean up and release all resources.
	@param	job	Job structure.
*/
void
pqdtool_job_cleanup_last(pqd_job_t *job);

/**	Create directory for file name.
	@param	fn	File name for which to create a directory for.
	@param	mo	Mode for directory and parents.
	@param	uid	User ID of owner.
	@param	gid	Group ID of owner.
	@param	job	Job structure.
	@return	1 on success, 0 on error.
*/
int
pqdtool_mkdir_for(
  char const		*fn,
  mode_t		 mo,
  uid_t			 uid,
  gid_t			 gid,
  pqd_job_t		*job
);

#ifdef __cplusplus
}
#endif

/**	Program type: The daemon itself		(printqd).
*/
#define	PQD_PROGRAM_TYPE_DAEMON		0

/**	Program type: Data multiplexor		(printqdc).
*/
#define PQD_PROGRAM_TYPE_MULTIPLEXOR	1

/**	Program type: Administrator client	(printqda).
*/
#define PQD_PROGRAM_TYPE_ADMIN		2

/**	Program type: Information daemon	(printqdi).
*/
#define	PQD_PROGRAM_TYPE_INFO		3

/**	Handle job: Accept job for printing.
*/
#define	PRINTQD_RESPONSE_ACCEPT		0

/**	Handle job: Remove job because printing is denied.
*/
#define	PRINTQD_RESPONSE_REMOVE		1

/**	Handle job: Hold job for later decision.
*/
#define	PRINTQD_RESPONSE_HOLD		2



#ifndef	PRINTQD_DEFAULT_PORT
/**	Default port number to use if not configured in configuration file.
*/
#define	PRINTQD_DEFAULT_PORT		9101
#endif

#ifndef PQD_CONFFILE
/**	Configuration file name.
*/
#define	PQD_CONFFILE	"/printqd/printqd.conf"
#endif


#endif
