/*
	WARNING: This file was generated by dkct.
	Changes you make here will be lost if dkct is run again!
	You should modify the original source and run dkct on it.
	Original source: pqdtool.ctr
*/

/*
Copyright (C) 2012-2014, Dirk Krause

Redistribution and use in source and binary forms, with or without
modification, are permitted provided that the following conditions are met:

* Redistributions of source code must retain the above copyright notice,
  this list of conditions and the following disclaimer.
* Redistributions in binary form must reproduce the above opyright notice,
  this list of conditions and the following disclaimer in the documentation
  and/or other materials provided with the distribution.
* Neither the name of the author nor the names of contributors may be used
  to endorse or promote products derived from this software without specific
  prior written permission.

THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS ``AS IS''
AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
ARE DISCLAIMED.
IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE LIABLE FOR ANY
DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
(INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
(INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
*/

/**	@file pqdtool.c The pqdtool module.
*/


#line 10 "pqdtool.ctr"

#include "printqd.h"




#line 15 "pqdtool.ctr"


#if DK3_CHAR_SIZE == 1
#if DK3_HAVE_STRUCT_SOCKADDR_UN
#if DK3_HAVE_SIGSET
#if DK3_HAVE_GETPWNAM && DK3_HAVE_GETGRNAM

void
pqdtool_job_init_first(pqd_job_t *job)
{
  job->app = NULL;
  job->lmsg = NULL;
  job->cmsg = NULL;
  job->tmpn = NULL;
  job->db = NULL;
  job->p_i = NULL;
  job->p_o = NULL;
  job->sz_i = 0;
  job->sz_o = 0;
  job->lso = INVALID_SOCKET;
  job->frun = 0;
  job->fres = 0;
  job->rqt = 0;
}



void
pqdtool_job_cleanup_last(pqd_job_t *job)
{
  if(job->app) {
    dk3app_close(job->app); job->app = NULL;
  }
}



int
pqdtool_mkdir_for(
  char const		*fn,
  mode_t		 mo,
  uid_t			 uid,
  gid_t			 gid,
  pqd_job_t		*job
)
{
  char		 bu[DK3_MAX_PATH];	/* Copy of file name. */
  struct stat	 stb;			/* Used to get file information. */
  char		*p1;			/* Rightmost separator. */
  char		*p2;			/* Current separator. */
  mode_t	 oldumask;		/* Umask at start. */
  int		 back = 0;
  

#line 68 "pqdtool.ctr"
  if(fn) {
    if(strlen(fn) < sizeof(bu)) {
      strcpy(bu, fn);
      oldumask = umask(0);
      p1 = dk3str_c8_rchr(bu, '/');
      if(p1) {
        *p1 = '\0';			

#line 75 "pqdtool.ctr"
	back = 1;
	p2 = bu;
	do {
	  p2 = dk3str_chr(p2, '/');
	  if(p2) { *p2     = '\0'; }
	  if(0 < strlen(bu)) {		

#line 81 "pqdtool.ctr"
	    if(0 != stat(bu, &stb)) {	

#line 82 "pqdtool.ctr"
	      if(0 == mkdir(bu, mo)) {
	        if((uid) || (gid)) {
		  if(0 != chown(bu, uid, gid)) {
		    back = 0;
		    if(!(p2)) {
		      /* Report error for the final directory */
		      dk3app_log_3(job->app,DK3_LL_ERROR,job->lmsg,14,15,bu);
		    }
		  }
		}
	      } else {			

#line 93 "pqdtool.ctr"
	        back = 0;
		if(!(p2)) {
		  /* Report error for the final directory */
		  dk3app_log_3(job->app,DK3_LL_ERROR,job->lmsg,16,17,bu);
		}
	      }
	    } else {			

#line 100 "pqdtool.ctr"
	    }
	  }
	  if(p2) { *(p2++) = '/'; }
	} while(p2);
      }
      umask(oldumask);
    }
  } 

#line 108 "pqdtool.ctr"
  return back;
}

#endif
#endif
#endif
#endif

