/*
	WARNING: This file was generated by dkct.
	Changes you make here will be lost if dkct is run again!
	You should modify the original source and run dkct on it.
	Original source: plptcol.ctr
*/

/*
Copyright (C) 2014, Dirk Krause

Redistribution and use in source and binary forms, with or without
modification, are permitted provided that the following conditions are met:

* Redistributions of source code must retain the above copyright notice,
  this list of conditions and the following disclaimer.
* Redistributions in binary form must reproduce the above opyright notice,
  this list of conditions and the following disclaimer in the documentation
  and/or other materials provided with the distribution.
* Neither the name of the author nor the names of contributors may be used
  to endorse or promote products derived from this software without specific
  prior written permission.

THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS ``AS IS''
AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
ARE DISCLAIMED.
IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE LIABLE FOR ANY
DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
(INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
(INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
*/

/**	@file plptcol.h Header file for the plptcol module.
*/

#ifndef PLPTCOL_H_INCLUDED
/** Avoid multiple inclusions. */
#define PLPTCOL_H_INCLUDED 1


#line 9 "plptcol.ctr"

#ifdef __cplusplus
extern "C" {
#endif

/**	Dynamically allocate new color structure.
	@param	name	Color name.
	@param	r	Red.
	@param	g	Green.
	@param	b	Blue.
	@return	Pointer to new structure on success, NULL on error.
*/
plpt_named_color_t *
plptcolor_new(char const *name, double r, double g, double b, dk3_app_t *app);

/**	Compare two named colors.
	@param	l	Left color.
	@param	r	Right color.
	@param	cr	Comparison criteria (0=name).
	@return	Comparison result.
*/
int
plptcolor_compare(void const *l, void const *r, int cr);

/**	Destroy color structure, release memory.
	@param	ptr	Color structure to destroy.
*/
void
plptcolor_delete(plpt_named_color_t *ptr);

/**	Find color information.
	@param	job	Job structure.
	@param	txt	LaTeX color specification, i.e. "brown!80!blue",
	modified during analysis.
	@param	r	Pointer to red result variable.
	@param	g	Pointer to green result variable.
	@param	b	Pointer to blue result variable.
*/
int
plptcol_get_color(
  plpdftex_job_t	*job,
  char 			*txt,
  double		*r,
  double		*g,
  double		*b
);

#ifdef __cplusplus
}
#endif



#endif
