/*
	WARNING: This file was generated by dkct.
	Changes you make here will be lost if dkct is run again!
	You should modify the original source and run dkct on it.
	Original source: plptcol.ctr
*/

/*
Copyright (C) 2014, Dirk Krause

Redistribution and use in source and binary forms, with or without
modification, are permitted provided that the following conditions are met:

* Redistributions of source code must retain the above copyright notice,
  this list of conditions and the following disclaimer.
* Redistributions in binary form must reproduce the above opyright notice,
  this list of conditions and the following disclaimer in the documentation
  and/or other materials provided with the distribution.
* Neither the name of the author nor the names of contributors may be used
  to endorse or promote products derived from this software without specific
  prior written permission.

THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS ``AS IS''
AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
ARE DISCLAIMED.
IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE LIABLE FOR ANY
DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
(INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
(INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
*/

/**	@file plptcol.c The plptcol module.
*/


#line 62 "plptcol.ctr"

#include "plpdftex.h"





#line 68 "plptcol.ctr"



void
plptcolor_delete(plpt_named_color_t *ptr)
{
  if (ptr) {
    dk3_release(ptr->name);
    dk3_delete(ptr);
  }
}



plpt_named_color_t *
plptcolor_new(char const *name, double r, double g, double b, dk3_app_t *app)
{
  plpt_named_color_t	*back	= NULL;
  if (name) {
    back = dk3_new_app(plpt_named_color_t,1,app);
    if (back) {
      back->r = r;
      back->g = g;
      back->b = b;
      back->name = dk3str_c8_dup_app(name, app);
      if (!(back->name)) {
        dk3_delete(back);
	back = NULL;
      }
    }
  }
  return back;
}



int
plptcolor_compare(void const *l, void const *r, int cr)
{
  int			 back	= 0;
  plpt_named_color_t	*pl;
  plpt_named_color_t	*pr;

  if (l) {
    if (r) {
      pl = (plpt_named_color_t *)l;
      pr = (plpt_named_color_t *)r;
      switch(cr) {
	case 1: {
	  if (pl->name) {
	    back = dk3str_c8_cmp(pl->name, (char *)pr);
	    if(-1 > back) back = -1;
	    if( 1 < back) back =  1;
	  } else back = -1;
	} break;
	default: {
          if (pl->name) {
            if (pr->name) {
	      back = dk3str_c8_cmp(pl->name, pr->name);
	      if(-1 > back) back = -1;
	      if( 1 < back) back =  1;
	    } else back = 1;
          } else {
            if (pr->name) back = -1;
          }
	} break;
      }
    } else back = 1;
  } else {
    if (r) back = -1;
  }
  return back;
}



/**	Predefined colors.
*/
static plpt_named_color_t const plptc_predefined_colors[] = {
  { "white",     1.0, 1.0, 1.0 },
  { "black",     0.0, 0.0, 0.0 },
  { "red",       1.0, 0.0, 0.0 },
  { "green",     0.0, 1.0, 0.0 },
  { "blue",      0.0, 0.0, 1.0 },
  { "cyan",      0.0, 1.0, 1.0 },
  { "magenta",   1.0, 0.0, 1.0 },
  { "yellow",    1.0, 1.0, 0.0 },
  { "gray",      0.5, 0.5, 0.5 },
  { "lightgray", 0.75, 0.75, 0.75 },
  { "darkgray",  0.25, 0.25, 0.25 },
  { "brown",     0.75, 0.5 , 0.25 },
  { "lime",      0.75, 1.0 , 0.0  },
  { "olive",     0.5 , 0.5 , 0.0  },
  { "orange",    1.0 , 0.5 , 0.0  },
  { "pink",      1.0 , 0.75, 0.75 },
  { "purple",    0.75, 0.0 , 0.25 },
  { "teal",      0.00, 0.5 , 0.5  },
  { "violet",    0.5 , 0.0 , 0.5  }
};

/**	Number of predefined colors.
*/
static size_t const sz_plptc_predefined_colors =
sizeof(plptc_predefined_colors)/sizeof(plpt_named_color_t);



/**	Find a named color.
	@param	job	Job structure.
	@param	txt	Color name.
	@return	Pointer to plpt_named_color_t on success, NULL on error.
*/
static
plpt_named_color_t const	*
plptcol_find_color(plpdftex_job_t *job, char const *txt)
{
  plpt_named_color_t const	*back	=	NULL;
  size_t		 	i;

  for (i = 0; i < sz_plptc_predefined_colors; i++) {
    if (0 == strcmp(txt, plptc_predefined_colors[i].name)) {
      back = &(plptc_predefined_colors[i]);
    }
  }
  if (NULL == back) {
    back = (plpt_named_color_t *)dk3sto_it_find_like(
      job->sico, txt, 1
    );
  }
  return back;
}



int
plptcol_get_color(
  plpdftex_job_t	*job,
  char 			*txt,
  double		*r,
  double		*g,
  double		*b
)
{
  plpt_named_color_t const	*cptr = NULL;
  char		*stt	=	NULL;	/* Start of text */
  char		*per	=	NULL;	/* Percentage value as text */
  char		*bgc	=	NULL;	/* Background color */
  char		*npt	=	NULL;	/* Next pointer */
  double	rres	=	0.0;	/* Result value for red */
  double	gres	=	0.0;	/* Result value for green */
  double	bres	=	0.0;	/* Result value for blue */
  double	bgr	=	0.0;	/* Background red */
  double	bgg	=	0.0;	/* Background green */
  double	bgb	=	0.0;	/* Background blue */
  double	f	=	1.0;	/* Factor */
  int		back	=	0;	/* Function result */
  

#line 225 "plptcol.ctr"
  /*	Check arguments.
  */
  if ((NULL == r) || (NULL == g) || (NULL == b)) {	

#line 228 "plptcol.ctr"
    goto finished;
  }
  if ((NULL == job) || (NULL == txt)) {			

#line 231 "plptcol.ctr"
    goto cleanup;
  }

  /*	Scan first color component.
  */
  stt = txt;
  dk3str_c8_chomp(stt, NULL);
  per = strchr(stt, '!');
  if (NULL != per) { *(per++) = '\0'; }
  cptr = plptcol_find_color(job, txt);
  if (NULL == cptr) {					

#line 242 "plptcol.ctr"
    /* ##### ERROR: Color not found! */
    goto cleanup;
  }
  rres = cptr->r;		

#line 246 "plptcol.ctr"
  gres = cptr->g;		

#line 247 "plptcol.ctr"
  bres = cptr->b;		

#line 248 "plptcol.ctr"

  /*	Mix against further components.
  */
  while (NULL != per) {
    npt = NULL;
    bgc = strchr(per, '!');
    if (NULL != bgc) {
      *(bgc++) = '\0';
      npt = strchr(bgc, '!');
      if (NULL != npt) {
        *(npt++) = '\0';
      }
    }
    if (0 == dk3ma_d_from_c8_string(&f, per, NULL)) {
      /* ##### ERROR: Not a number */			

#line 263 "plptcol.ctr"
      goto cleanup;
    }
    if ((0.0 > f) || (100.0 < f)) {			

#line 266 "plptcol.ctr"
      /* ##### ERROR: Out of range */
      goto cleanup;
    }
    f = f / 100.0;
    bgr = bgg = bgb = 1.0;
    if (bgc) {
      cptr = plptcol_find_color(job, txt);
      if (NULL == cptr) {
        /* ##### ERROR: Color not found */
	goto cleanup;
      }
      bgr = cptr->r; bgg = cptr->g; bgb = cptr->b;
    }
    rres = f * rres + (1.0 - f) * bgr;	

#line 280 "plptcol.ctr"
    gres = f * gres + (1.0 - f) * bgg;	

#line 281 "plptcol.ctr"
    bres = f * bres + (1.0 - f) * bgb;	

#line 282 "plptcol.ctr"
    per = npt;
  }
  back = 1;				

#line 285 "plptcol.ctr"

  /*	Transfer results and return.
  */
  cleanup:
  *r = rres; *g = gres; *b = bres;
  finished:
  

#line 292 "plptcol.ctr"
  return back;
}


