/*
	WARNING: This file was generated by dkct.
	Changes you make here will be lost if dkct is run again!
	You should modify the original source and run dkct on it.
	Original source: pjsnmp.ctr
*/

/*
Copyright (C) 2012-2014, Dirk Krause

Redistribution and use in source and binary forms, with or without
modification, are permitted provided that the following conditions are met:

* Redistributions of source code must retain the above copyright notice,
  this list of conditions and the following disclaimer.
* Redistributions in binary form must reproduce the above opyright notice,
  this list of conditions and the following disclaimer in the documentation
  and/or other materials provided with the distribution.
* Neither the name of the author nor the names of contributors may be used
  to endorse or promote products derived from this software without specific
  prior written permission.

THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS ``AS IS''
AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
ARE DISCLAIMED.
IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE LIABLE FOR ANY
DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
(INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
(INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
*/

/**	@file pjsnmp.h Header file for the pjsnmp module.
*/

#ifndef PJSNMP_H_INCLUDED
/** Avoid multiple inclusions. */
#define PJSNMP_H_INCLUDED 1


#line 10 "pjsnmp.ctr"

#include "dk3conf.h"
#include "dk3types.h"

#if DK3_CHAR_SIZE == 1
#if (DK3_HAVE_SIGACTION) || (DK3_HAVE_SIGSET)
#if DK3_HAVE_LIBNETSNMP

#include "dk3all.h"
#include <net-snmp/net-snmp-config.h>
#include <net-snmp/net-snmp-includes.h>
#include <net-snmp/utilities.h>


/**	@defgroup	pjsnmpexitcodes	Exit codes for pjsnmp.
*/
/**@{*/
/**	Exit code: Success.
*/
#define	PJSNMP_EXIT_SUCCESS	0

/**	Exit code: Transient error condition, retry later.
*/
#define	PJSNMP_EXIT_FAIL	1

/**	Exit code: Unrecoverable error, remove job from queue.
*/
#define	PJSNMP_EXIT_REMOVE	3

/**	Exit code: Hold job for later processing.
*/
#define	PJSNMP_EXIT_HOLD	6

/**	Exit code: Filter disturbed by signal.
*/
#define	PJSNMP_EXIT_SIGNAL	9
/**@}*/



/**	@defgroup	pjsnmpdevicestatus	Device status from SNMP.
*/
/**@{*/
/**	Device status:	Unknown.
*/
#define	PJSNMP_DEVICE_UNKNOWN	1

/**	Device status:	Device is running.
*/
#define	PJSNMP_DEVICE_RUNNING	2

/**	Device status:	Warning like paper or toner low.
*/
#define	PJSNMP_DEVICE_WARNING	3

/**	Device status:	In self-test.
*/
#define	PJSNMP_DEVICE_TESTING	4

/**	Device status:	Down due to error condition, i.e. paper jam.
*/
#define	PJSNMP_DEVICE_DOWN	5
/**@}*/



/**	@defgroup	pjsnmpprinterstatus	Printer status from SNMP.
*/
/**@{*/
/**	Printer status:	Any state not mentioned below.
*/
#define	PJSNMP_PRINTER_OTHER	1

/**	Printer status:	Unknown.
*/
#define	PJSNMP_PRINTER_UNKNOWN	2

/**	Printer status:	Ready, waiting for next job.
*/
#define	PJSNMP_PRINTER_IDLE	3

/**	Printer status:	Printing a job.
*/
#define	PJSNMP_PRINTER_PRINTING	4

/**	Printer status:	Warming up.
*/
#define	PJSNMP_PRINTER_WARMUP	5
/**@}*/



/**	@defgroup	pjsnmpprintersummary	Printer state summary.
*/
/**@{*/
/**	State summary: Printer unreachable, probably turned off.
*/
#define	PJSNMP_STATE_UNREACHABLE	1

/**	State summary: Failed to create SNMP request!
*/
#define	PJSNMP_STATE_REQUEST_FAILED	2

/**	State summary: Error in SNMP response!
*/
#define	PJSNMP_STATE_ERROR_IN_RESPONSE	3

/**	State summary: Printer ready, can use pagecounter.
*/
#define	PJSNMP_STATE_READY		4

/**	State summary: Waiting for printer to start printing.
*/
#define	PJSNMP_STATE_WAIT_START		5

/**	State summary: Printer warming up.
*/
#define	PJSNMP_STATE_WARMUP		6

/**	State summary: Printing.
*/
#define	PJSNMP_STATE_PRINTING		7

/**	State summary: Printing interrupted due to error.
*/
#define	PJSNMP_STATE_ERROR		8

/**	State summary: Printer unreachable, probably turned off.
*/
#define	PJSNMP_STATE_OTHER		9
/**@}*/


/**	Ensure value to be in range.
*/
#define	PJSNMP_IN_RANGE(a,b,c) (((c) >= (a)) ? (c) : (((c) <= (b)) ? (c) : (a)))



/**	Printer state.
*/
typedef struct {
  unsigned long	pc;	/**< Pagecounter value. */
  unsigned long	ec;	/**< Error conditions. */
  int		ds;	/**< Device state, see @ref pjsnmpdevicestatus. */
  int		ps;	/**< Printer state, see @ref pjsnmpprinterstatus. */
  int		st;	/**< State summary, see @ref pjsnmpprintersummary. */
} pjsnmp_printer_state_t;



/**	Job structure.
*/
typedef struct {
  struct snmp_session	 st;	/**< Session template. */
  pjsnmp_printer_state_t os;	/**< Old SNMP state. */
  pjsnmp_printer_state_t cs;	/**< Current SNMP state. */
  struct snmp_session	*ss;	/**< SNMP session. */
  char const		*un;	/**< User name. */
  char const		*qn;	/**< Printer name. */
  char const		*jn;	/**< Job name. */
  char const		*jt;	/**< Job title. */
  char const		*sf;	/**< Status file. */
  dk3_app_t		*app;	/**< Application structure. */
  dkChar const * const	*lm;	/**< Localized message texts. */
  char			*hn;	/**< Host name to transfer data to. */
  char			*af;	/**< Accounting file/socket name. */
  char			*sc;	/**< SNMP community. */
  char			*tf;	/**< Temporary file. */
  char			*sl;	/**< SNMP log file. */
  time_t		 ti;	/**< Start time of stage 2. */
  time_t		 tl;	/**< Time of last log. */
  unsigned long		 pc;	/**< Page count at start of job. */
  int			 ex;	/**< Exit status code. */
  int			 ac;	/**< Flag: achk accounting check. */
  int			 as;	/**< Accounting style: 0=printqd, 1=lprng. */
  int			 sv;	/**< SNMP version. */
  int			 od;	/**< Flag: Orderly release printer socket. */
  int			 fe;	/**< Flag: ERROR or signal, job cancelled. */
  int			 ct;	/**< Flag: SNMP check during data transfer. */
  int			 is;	/**< Flag: Ignore SNMP failure. */
  int			 wp;	/**< Flag: Printer was seen printing. */
  int			 hl;	/**< Flag: Already have log messages. */
  int			 pdes;	/**< Flag: Use hrPrinterDetectedErrorState. */
  int			 poid;	/**< Flag: running/warning+other = standby. */
  int			 repr;	/**< Flag: Report response. */
  unsigned short	 pn;	/**< Port name to transfer data to. */
} pjsnmp_job_t;


#endif
#endif
#endif




#endif
