/*
	WARNING: This file was generated by dkct.
	Changes you make here will be lost if dkct is run again!
	You should modify the original source and run dkct on it.
	Original source: itatool.ctr
*/

/*
Copyright (C) 2012-2014, Dirk Krause

Redistribution and use in source and binary forms, with or without
modification, are permitted provided that the following conditions are met:

* Redistributions of source code must retain the above copyright notice,
  this list of conditions and the following disclaimer.
* Redistributions in binary form must reproduce the above opyright notice,
  this list of conditions and the following disclaimer in the documentation
  and/or other materials provided with the distribution.
* Neither the name of the author nor the names of contributors may be used
  to endorse or promote products derived from this software without specific
  prior written permission.

THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS ``AS IS''
AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
ARE DISCLAIMED.
IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE LIABLE FOR ANY
DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
(INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
(INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
*/

/**	@file itatool.c The itatool module.
*/


#line 10 "itatool.ctr"

#include "dk3all.h"
#include "itadmin.h"





#line 17 "itatool.ctr"



/**	Keywords used by this module, not localized.
*/
static char const * const	itadmin_tool_c8_kw[] = {
/* 0 */
"\n",

/* 1 */
" ",

/* 2 */
"\\multicolumn{2}{c}{\\textbf{",

/* 3 */
"}",

/* 4 */
"\\\\*",

/* 5 */
"\\\\[1em]",

/* 6 */
"&",

/* 7 */
"\\textit{",

/* 8 */
"\\textbf{",

NULL


#line 61 "itatool.ctr"
};



int
itadmin_tool_convert_date(itadmin_job *job, itadmin_date *dp, char const *str)
{
  char		 bu[64];	/* Private copy of string. */
  char		*p1;		/* Start of month. */
  char		*p2;		/* Start of day. */
  int		 i;		/* Temporary conversion result. */
  int		 back	= 0;
  int		 se	= 0;
  if((dp) && (str)) {
    if(dk3str_c8_len(str) < sizeof(bu)) {
      dk3str_c8_cpy_not_overlapped(bu, str);
      dk3str_c8_normalize(bu, NULL, ' ');
      p1 = dk3str_c8_chr(bu, '-');
      if(p1) {
        *(p1++) = '\0';
	p2 = dk3str_c8_chr(p1, '-');
	if(p2) {
	  *(p2++) = '\0';
	  if(sscanf(bu, "%d", &i) == 1) {
	    dp->y = i;
	    if(sscanf(p1, "%d", &i) == 1) {
	      dp->m = i;
	      if(sscanf(p2, "%d", &i) == 1) {
	        dp->d = i;
		back = 1;
	      } else {
	        /* Syntax error */
		se = 1;
	      }
	    } else {
	      /* Syntax error */
	      se = 1;
	    }
	  } else {
	    /* Syntax error */
	    se = 1;
	  }
	} else {
	  /* Syntax error */
	  se = 1;
	}
      } else {
        p1 =dk3str_c8_chr(bu, '.');
	if(p1) {
	  *(p1++) = '\0';
	  p2 = dk3str_c8_chr(p1, '.');
	  if(p2) {
	    *(p2++) = '\0';
	    if(sscanf(bu, "%d", &i) == 1) {
	      dp->d = i;
	      if(sscanf(p1, "%d", &i) == 1) {
	        dp->m = i;
		if(sscanf(p2, "%d", &i) == 1) {
		  dp->y = i;
		  back = 1;
		  if(i < 100) {
		    dp->y = 1900 + i;
		  }
		} else {
		  se = 1;
		}
	      } else {
	        se = 1;
	      }
	    } else {
	      se = 1;
	    }
	  } else {
	    se = 1;
	  }
	} else {
	  se = 1;
	}
      }
    } else {
      /* ERROR: String too long! */
      se = 1;
    }
    if(!(back)) {
      dp->y = 0; dp->m = 0; dp->d = 0;
      if(se) {
        itadmin_tool_log_utf8_3(job, DK3_LL_ERROR, 300, 301, str);
      }
    }
  }
  return back;
}



void
itadmin_tool_write_ip(FILE *df, unsigned long ipv4)
{
  if(df) {
    fprintf(
      df,
      "%lu.%lu.%lu.%lu",
      ((ipv4 >> 24) & 255UL),
      ((ipv4 >> 16) & 255UL),
      ((ipv4 >>  8) & 255UL),
      ( ipv4        & 255UL)
    );
  }
}



void
itadmin_tool_stream_ip(dk3_stream_t *os, unsigned long ipv4)
{
  char	buffer[128];
  if(os) {
    sprintf(
      buffer,
      "%lu.%lu.%lu.%lu",
      ((ipv4 >> 24) & 255UL),
      ((ipv4 >> 16) & 255UL),
      ((ipv4 >>  8) & 255UL),
      ( ipv4        & 255UL)
    );
    dk3stream_c8_fputs(os, buffer);
  }
}



void
itadmin_tool_write_user_latex_short(
  itadmin_job	*job,
  dk3_stream_t	*os,
  itadmin_user	*user
)
{
  if(user->na) {
    dk3uc2lat_c8_utf8_stputs(job->uc2l, os, user->na);
  } else {
    dk3uc2lat_c8_utf8_stputs(job->uc2l, os, user->us);
  }
}


void
itadmin_tool_write_user_latex_long(
  itadmin_job	*job,
  dk3_stream_t	*os,
  itadmin_user	*user
)
{
  int	found	= 0;
  if(user->na) {
    if(user->tt) {
      dk3uc2lat_c8_utf8_stputs(job->uc2l, os, user->tt);
      found = 1;
    }
    if(user->sn) {
      if(found) {
        dk3stream_c8_fputs(os, itadmin_tool_c8_kw[1]);
      }
      dk3uc2lat_c8_utf8_stputs(job->uc2l, os, user->sn);
      found = 1;
    }
    if(found) {
      dk3stream_c8_fputs(os, itadmin_tool_c8_kw[1]);
    }
    dk3uc2lat_c8_utf8_stputs(job->uc2l, os, user->na);
  } else {
    dk3uc2lat_c8_utf8_stputs(job->uc2l, os, user->us);
  }
}



void
itadmin_tool_table_section_header(
  itadmin_job	*job,
  dk3_stream_t	*os,
  size_t	 kwi
)
{
  int		 ie;
  ie = dk3app_get_encoding(job->app);
  dk3stream_c8_fputs(os, itadmin_tool_c8_kw[2]);
  dk3uc2lat_stputs(job->uc2l, os, (job->msg)[kwi], ie);
  dk3stream_c8_fputs(os, itadmin_tool_c8_kw[3]);
  dk3stream_c8_fputs(os, itadmin_tool_c8_kw[3]);
  dk3stream_c8_fputs(os, itadmin_tool_c8_kw[4]);
  dk3stream_c8_fputs(os, itadmin_tool_c8_kw[0]);
}



void
itadmin_tool_table_line_start(
  itadmin_job	*job,
  dk3_stream_t	*os,
  size_t	 kwi
)
{
  int		 ie;
  ie = dk3app_get_encoding(job->app);
  dk3uc2lat_stputs(job->uc2l, os, (job->msg)[kwi], ie);
}



void
itadmin_tool_table_line_sep_rows(
  itadmin_job	*job,
  dk3_stream_t	*os
)
{
  dk3stream_c8_fputs(os, itadmin_tool_c8_kw[6]);
}



void
itadmin_tool_table_line_finish(
  itadmin_job	*job,
  dk3_stream_t	*os,
  int		 pb
)
{
  dk3stream_c8_fputs(os, itadmin_tool_c8_kw[(pb) ? 5 : 4]);
  dk3stream_c8_fputs(os, itadmin_tool_c8_kw[0]);
}



void
itadmin_tool_table_line_no_data(
  itadmin_job	*job,
  dk3_stream_t	*os,
  int		 nu
)
{
  int ie;
  ie = dk3app_get_encoding(job->app);
  if(nu) {
    dk3stream_c8_fputs(os, itadmin_tool_c8_kw[7]);
    dk3uc2lat_stputs(job->uc2l, os, (job->msg)[9], ie);
    dk3stream_c8_fputs(os, itadmin_tool_c8_kw[3]);
  }
}



void
itadmin_tool_table_line(
  itadmin_job	*job,
  dk3_stream_t	*os,
  size_t	 kwi,
  char const	*det,
  int		 nu,
  int		 pb
)
{
  itadmin_tool_table_line_start(job, os, kwi);
  itadmin_tool_table_line_sep_rows(job, os);
  if(det) {
    dk3uc2lat_c8_utf8_stputs(job->uc2l, os, det);
  } else {
    itadmin_tool_table_line_no_data(job, os, nu);
  }
  itadmin_tool_table_line_finish(job, os, pb);
}



void
itadmin_tool_table_values(
  itadmin_job	*job,
  dk3_stream_t	*os,
  char const	*key,
  char const	*val,
  int		 fb,
  int		 pb
)
{
  if(key) {
    if(fb) {
      dk3stream_c8_fputs(os, itadmin_tool_c8_kw[8]);
    }
    dk3uc2lat_c8_utf8_stputs(job->uc2l, os, key);
    if(fb) {
      dk3stream_c8_fputs(os, itadmin_tool_c8_kw[3]);
    }
  }
  dk3stream_c8_fputs(os, itadmin_tool_c8_kw[6]);
  if(val) {
    dk3uc2lat_c8_utf8_stputs(job->uc2l, os, val);
  }
  dk3stream_c8_fputs(os, itadmin_tool_c8_kw[(pb) ? 5 : 4]);
}



int
itadmin_tool_check_same_user(itadmin_user *us, itadmin_host *co)
{
  int		 back = 0;
  if((us) && (co)) {
    if(co->un) {
      if((us->us) && ((co->un)->us)) {
        if(dk3str_c8_cmp(us->us, (co->un)->us) == 0) {
	  back = 1;
	}
      }
    }
  }
  return back;
}



void
itadmin_tool_write_section(
  itadmin_job		*job,
  dk3_stream_t		*os,
  char const * const	*sect
)
{
  char const * const	*ptr;
  ptr = sect;
  while(*ptr) {
    dk3stream_c8_fputs(os, *(ptr++));
    dk3stream_c8_fputs(os, itadmin_tool_c8_kw[0]);
  }
}



void
itadmin_tool_log_1(
  itadmin_job		*job,
  int			 ll,
  size_t		 i
)
{
  if(job) {
    dk3app_log_1(job->app, ll, job->msg, i);
  }
}



void
itadmin_tool_log_utf8_3(
  itadmin_job		*job,
  int			 ll,
  size_t		 i1,
  size_t		 i2,
  char const		*msg
)
{
  dkChar	bu[256];
  int		res;
  if((job) && (msg)) {
    res = dk3str_c8u_to_str_app(
      bu, DK3_SIZEOF(bu,dkChar), dk3app_get_encoding(job->app), msg, job->app
    );
    if(res) {
      dk3app_log_3(job->app, ll, job->msg, i1, i2, bu);
    }
  }
}



void
itadmin_tool_log_utf8_5(
  itadmin_job		*job,
  int			 ll,
  size_t		 i1,
  size_t		 i2,
  size_t		 i3,
  char const		*msg1,
  char const		*msg2
)
{
  dkChar	bu1[256];
  dkChar	bu2[256];
  int		res;

  res = dk3str_c8u_to_str_app(
    bu1, DK3_SIZEOF(bu1,dkChar), dk3app_get_encoding(job->app), msg1, job->app
  );
  if(res) {
    res = dk3str_c8u_to_str_app(
      bu2,DK3_SIZEOF(bu2,dkChar),dk3app_get_encoding(job->app),msg2,job->app
    );
    if(res) {
      dk3app_log_5(job->app, ll, job->msg, i1, i2, i3, bu1, bu2);
    }
  }
}



void
itadmin_tool_log_pk_3(
  itadmin_job		*job,
  int			 ll,
  size_t		 i1,
  size_t		 i2,
  unsigned long		 pk
)
{
  char buffer[128];
  sprintf(buffer, "%lu", pk);
  itadmin_tool_log_utf8_3(job, ll, i1, i2, buffer);
}



void
itadmin_tool_log_pk_5(
  itadmin_job		*job,
  int			 ll,
  size_t		 i1,
  size_t		 i2,
  size_t		 i3,
  unsigned long		 pk,
  char const		*msg
)
{
  char buffer[128];
  sprintf(buffer, "%lu", pk);
  itadmin_tool_log_utf8_5(job, ll, i1, i2, i3, buffer, msg);
}



void
itadmin_tool_ip_to_buffer(char *bu, unsigned long ip)
{
  sprintf(
    bu,
    "%lu.%lu.%lu.%lu",
    ((ip >> 24) & 0x000000FFUL),
    ((ip >> 16) & 0x000000FFUL),
    ((ip >>  8) & 0x000000FFUL),
    ( ip        & 0x000000FFUL)
  );
}

