/*
	WARNING: This file was generated by dkct.
	Changes you make here will be lost if dkct is run again!
	You should modify the original source and run dkct on it.
	Original source: itareg.ctr
*/

/*
Copyright (C) 2012-2014, Dirk Krause

Redistribution and use in source and binary forms, with or without
modification, are permitted provided that the following conditions are met:

* Redistributions of source code must retain the above copyright notice,
  this list of conditions and the following disclaimer.
* Redistributions in binary form must reproduce the above opyright notice,
  this list of conditions and the following disclaimer in the documentation
  and/or other materials provided with the distribution.
* Neither the name of the author nor the names of contributors may be used
  to endorse or promote products derived from this software without specific
  prior written permission.

THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS ``AS IS''
AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
ARE DISCLAIMED.
IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE LIABLE FOR ANY
DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
(INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
(INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
*/

/**	@file itareg.c The itareg module.
*/


#line 11 "itareg.ctr"


#include "dk3all.h"
#include "itadmin.h"





#line 19 "itareg.ctr"



/**	Keywords used by the module.
*/
static char const * const	itadmin_register_c8_kw[] = {
/* 0 */
"",

/* 1 */
"-",

/* 2 */
"%02x:%02x:%02x:%02x:%02x:%02x",

NULL


#line 39 "itareg.ctr"
};



/**	Scope type names.
*/
char const * const	itadmin_register_scope_type_names[] = {
/* 0 */
"server",

/* 1 */
"vlan",

/* 2 */
"network",

/* 3 */
"group",

/* 4 */
"pool",

/* 5 */
"host",

NULL


#line 60 "itareg.ctr"
};



int
itadmin_register_check_user_name(char const *sn)
{
  int back = 0;
  

#line 69 "itareg.ctr"
  if(sn) {
    if(dk3str_c8_cmp(sn, itadmin_register_c8_kw[0])) {
      if(dk3str_c8_cmp(sn, itadmin_register_c8_kw[1])) {
        back = 1;
      }
    }
  } 

#line 76 "itareg.ctr"
  return back;
}



int
itadmin_register_check_ip(char const *ip)
{
  int back = 0;
  

#line 86 "itareg.ctr"
  if(ip) {
    if(dk3str_c8_len(ip) > 0) {
      back = 1;
    }
  } 

#line 91 "itareg.ctr"
  return back;
}



/**	Correct a MAC address (Windows notation to normal notation).
	@param	job	Job structure.
	@param	mac	Text buffer to modify.
	@return	1 for valid MAC address found, 0 for invalid source text.
*/
int
itadmin_register_correct_mac(itadmin_job *job, char *mac)
{
  char		*p1;
  char		*p2;
  int		 back = 0;
  int		 i1;
  int		 i2;
  int		 i3;
  int		 i4;
  int		 i5;
  int		 i6;
  

#line 114 "itareg.ctr"
  p1 = mac;
  while(*p1) {
    if(*p1 == '-') { *p1 = ':'; }
    p1++;
  }
  p1 = dk3str_c8_chr(mac, ':');
  if(p1) {
    *(p1++) = '\0';
    if(sscanf(mac, "%x", &i1) == 1) {
      p2 = dk3str_c8_chr(p1, ':');
      if(p2) {
        *(p2++) = '\0';
	if(sscanf(p1, "%x", &i2) == 1) {
	  p1 = dk3str_c8_chr(p2, ':');
	  if(p1) {
	    *(p1++) = '\0';
	    if(sscanf(p2, "%x", &i3) == 1) {
	      p2 = dk3str_c8_chr(p1, ':');
	      if(p2) {
	        *(p2++) = '\0';
		if(sscanf(p1, "%x", &i4) == 1) {
		  p1 = dk3str_c8_chr(p2, ':');
		  if(p1) {
		    *(p1++) = '\0';
		    if(sscanf(p2, "%x", &i5) == 1) {
		      if(sscanf(p1, "%x", &i6) == 1) {
		        if((i1 >= 0) && (i1 < 256)) {
			  if((i2 >= 0) && (i2 < 256)) {
			    if((i3 >= 0) && (i3 < 256)) {
			      if((i4 >= 0) && (i4 < 256)) {
			        if((i5 >= 0) && (i5 < 256)) {
				  if((i6 >= 0) && (i6 < 256)) {
				    sprintf(
				      mac,
				      itadmin_register_c8_kw[2],
				      i1, i2, i3, i4, i5, i6
				    );
				    back = 1;
				    p1 = mac;
				    while(*p1) {
				      switch(*p1) {
				        case 'a': {
					  *p1 = 'A';
					} break;
					case 'b': {
					  *p1 = 'B';
					} break;
					case 'c': {
					  *p1 = 'C';
					} break;
					case 'd': {
					  *p1 = 'D';
					} break;
					case 'e': {
					  *p1 = 'E';
					} break;
					case 'f': {
					  *p1 = 'F';
					} break;
				      }
				      p1++;
				    }
				  }
				}
			      }
			    }
			  }
			}
		      }
		    }
		  }
		}
	      }
	    }
	  }
	}
      }
    }
  } 

#line 193 "itareg.ctr"
  return back;
}



int
itadmin_register_user(
  itadmin_job	*job,
  char const	*us_s,
  char const	*us_t,
  char const	*us_sn,
  char const	*us_fn,
  char const	*us_em,
  char const	*us_ko,
  char const	*us_se
)
{
  itadmin_user	*nu;
  int		 back	= 0;
  

#line 213 "itareg.ctr"
  

#line 214 "itareg.ctr"
  

#line 215 "itareg.ctr"
  

#line 216 "itareg.ctr"
  

#line 217 "itareg.ctr"
  

#line 218 "itareg.ctr"
  

#line 219 "itareg.ctr"
  

#line 220 "itareg.ctr"
  nu = itadmin_mem_user_new(job, us_s, us_t, us_sn, us_fn, us_em, us_ko, us_se);
  if(itadmin_register_check_user_name(us_s)) {
    if(dk3sto_it_find_like(job->i_us, (void *)us_s, 1)) {
      /* ERROR: Duplicated entry! */
      itadmin_tool_log_utf8_3(job, DK3_LL_ERROR, 168, 169, us_s);
    } else {
      if(nu) {
        if(dk3sto_add(job->s_us, (void *)nu)) {
	  if(dk3sto_add(job->s_usn, (void *)nu)) {
            back = 1;
	  }
        } else {
          itadmin_mem_user_del((void *)nu);
        }
      }
    }
  } else {
    back = 1;
  }
  

#line 240 "itareg.ctr"
  return back;
}



int
itadmin_register_building(
  itadmin_job		*job,
  char const		*gb_s,
  char const		*gb_l,
  char const		*gb_a1,
  char const		*gb_a2,
  char const		*gb_a3,
  char const		*gb_a4,
  char const		*gb_plz,
  char const		*gb_ort
)
{
  itadmin_building	*nb;
  int			 back	= 0;
  

#line 261 "itareg.ctr"
  if(itadmin_register_check_user_name(gb_s)) {			

#line 262 "itareg.ctr"
    if(dk3sto_it_find_like(job->i_bu, (void *)gb_s, 1)) {	

#line 263 "itareg.ctr"
      /* ERROR: Duplicated entry! */
      itadmin_tool_log_utf8_3(job, DK3_LL_ERROR, 170, 171, gb_s);
    } else {							

#line 266 "itareg.ctr"
      nb = itadmin_mem_building_new(
        job,
        gb_s, gb_l, gb_a1, gb_a2, gb_a3, gb_a4, gb_plz, gb_ort
      );
      if(nb) {							

#line 271 "itareg.ctr"
        if(dk3sto_add(job->s_bu, (void *)nb)) {			

#line 272 "itareg.ctr"
          back = 1;
        } else {					

#line 274 "itareg.ctr"
          itadmin_mem_building_del((void *)nb);
        }
      } else {							

#line 277 "itareg.ctr"
      }
    }
  } else {							

#line 280 "itareg.ctr"
    back = 1;
  } 

#line 282 "itareg.ctr"
  return back;
}



int
itadmin_register_speed(itadmin_job *job, char const *sn, char const *ln)
{
  itadmin_speed	*sp;
  int back = 0;
  

#line 293 "itareg.ctr"
  if(itadmin_register_check_user_name(sn)) {
    if(dk3sto_it_find_like(job->i_sp, (void *)sn, 1)) {
      /* ERROR: Duplicated entry! */
      itadmin_tool_log_utf8_3(job, DK3_LL_ERROR, 172, 173, sn);
    } else {
      sp = itadmin_mem_speed_new(job, sn, ln);
      if(sp) {
        if(dk3sto_add(job->s_sp, (void *)sp)) {
          back = 1;
        } else {
          itadmin_mem_speed_del((void *)sp);
        }
      }
    }
  } else {
    back = 1;
  } 

#line 310 "itareg.ctr"
  return back;
}



int
itadmin_register_vlan(itadmin_job *job, char const *vl_s, char const *vl_l)
{
 itadmin_vlan		*vl;
 int			 back = 0;
 

#line 321 "itareg.ctr"
 if(itadmin_register_check_user_name(vl_s)) {
   if(dk3sto_it_find_like(job->i_vl, (void *)vl_s, 1)) {
     /* ERROR: Duplicated entry! */
     itadmin_tool_log_utf8_3(job, DK3_LL_ERROR, 174, 175, vl_s);
   } else {
     vl = itadmin_mem_vlan_new(job, vl_s, vl_l);
     if(vl) {
       if(dk3sto_add(job->s_vl, (void *)vl)) {
         back = 1;
       } else {
         itadmin_mem_vlan_del((void *)vl);
       }
     }
   }
 } else {
   back = 1;
 } 

#line 338 "itareg.ctr"
 return back;
}



int
itadmin_register_netgroup(itadmin_job *job, char const *ng_s, char const *ng_l)
{
  itadmin_netgroup	*ng;
  int			 back	= 0;
  if(itadmin_register_check_user_name(ng_s)) {
    if(dk3sto_it_find_like(job->i_ng, (void *)ng_s, 1)) {
      /* ERROR: Duplicate entry! */
      itadmin_tool_log_utf8_3(job, DK3_LL_ERROR, 180, 181, ng_s);
    } else {
      ng = itadmin_mem_netgroup_new(job, ng_s, ng_l);
      if(ng) {
        if(dk3sto_add(job->s_ng, (void *)ng)) {
	  back = 1;
	} else {
	  itadmin_mem_netgroup_del((void *)ng);
	}
      }
    }
  } else {
    back = 1;
  }
  return back;
}



int
itadmin_register_ngdep(itadmin_job *job, char const *pgn, char const *cgn)
{
  itadmin_ngdep		*nd;
  itadmin_netgroup	*pg;
  itadmin_netgroup	*cg;
  int			 back = 0;
  

#line 378 "itareg.ctr"
  if((pgn) && (cgn)) {
    if(itadmin_register_check_user_name(pgn)) {
      if(itadmin_register_check_user_name(cgn)) {
        pg = NULL; cg = NULL;
	pg = (itadmin_netgroup *)dk3sto_it_find_like(job->i_ng, (void *)pgn, 1);
	cg = (itadmin_netgroup *)dk3sto_it_find_like(job->i_ng, (void *)cgn, 1);
	if(!(pg)) {
	  /* WARNING: Netgroup does not yet exist! */
          itadmin_tool_log_utf8_3(job, DK3_LL_ERROR, 182, 183, pgn);
	  itadmin_register_netgroup(job, pgn, NULL);
	  pg = (itadmin_netgroup *)dk3sto_it_find_like(job->i_ng,(void *)pgn,1);
	}
	if(!(cg)) {
	  /* WARNING: Netgroup does not yet exist! */
	  itadmin_tool_log_utf8_3(job, DK3_LL_ERROR, 182, 183, cgn);
	  itadmin_register_netgroup(job, cgn, NULL);
	  cg = (itadmin_netgroup *)dk3sto_it_find_like(job->i_ng,(void *)cgn,1);
	}
	if((pg) && (cg)) {
	  nd = itadmin_mem_ngdep_new(job, pg, cg);
	  if(nd) {
	    if(dk3sto_add(job->s_nd, (void *)nd)) {
	      back = 1;
	    } else {
	      itadmin_mem_ngdep_del(nd);
	    }
	  }
	}
      }
    }
  } 

#line 409 "itareg.ctr"
  return back;
}



int
itadmin_register_patch(
  itadmin_job		*job,
  char const		*dd_n,
  char const		*sp_s,
  char const		*vl_s,
  char const		*dd_p,
  char const		*gb_s,
  char const		*dd_r
)
{
  itadmin_connect	*pa;
  itadmin_building	*bu;
  itadmin_vlan		*vl;
  itadmin_speed		*sp;
  int			 back	= 0;
  

#line 431 "itareg.ctr"
  if(itadmin_register_check_user_name(dd_n)) {
    if(dk3sto_it_find_like(job->i_pa, (void *)dd_n, 1)) {
      /* ERROR: Duplicate entry! */
      itadmin_tool_log_utf8_3(job, DK3_LL_ERROR, 184, 185, dd_n);
    } else {
      bu = NULL;
      vl = NULL;
      sp = NULL;
      if(itadmin_register_check_user_name(sp_s)) {
        sp = (itadmin_speed *)dk3sto_it_find_like(
	  job->i_sp, (void *)sp_s, 1
	);
	if(!(sp)) {
	  /* WARNING: Inconsistency, no such speed! */
          itadmin_tool_log_utf8_3(job, DK3_LL_ERROR, 186, 187, sp_s);
	}
      }
      if(itadmin_register_check_user_name(vl_s)) {
        vl = (itadmin_vlan *)dk3sto_it_find_like(
	  job->i_vl, (void *)vl_s, 1
	);
	if(!(vl)) {
	  /* WARNING: Inconsistency, no such VLAN! */
          itadmin_tool_log_utf8_3(job, DK3_LL_ERROR, 188, 189, vl_s);
	}
      }
      if(itadmin_register_check_user_name(gb_s)) {
        bu = (itadmin_building *)dk3sto_it_find_like(
	  job->i_bu, (void *)gb_s, 1
	);
	if(!(bu)) {
	  /* WARNING: Inconsistency, no such building! */
          itadmin_tool_log_utf8_3(job, DK3_LL_ERROR, 190, 191, gb_s);
	}
      }
      pa = itadmin_mem_connect_new(job, dd_n, dd_p, dd_r, sp, vl, bu);
      if(pa) {
        if(dk3sto_add(job->s_pa, (void *)pa)) {
	  back = 1;
	} else {
	  itadmin_mem_connect_del((void *)pa);
	}
      }
    }
  } else {
    back = 1;
  } 

#line 478 "itareg.ctr"
  return back;
}



int
itadmin_register_network(
  itadmin_job		*job,
  char const		*nw_ip,
  char const		*nw_ma,
  char const		*nw_gw,
  char const		*nw_bc,
  char const		*vl_s
)
{
  char			 buffer[128];
  itadmin_vlan		*vl;
  itadmin_network	*nw;
  unsigned long		 ip;
  unsigned long		 ma;
  unsigned long		 gw;
  unsigned long		 bc;
  int			 back = 0;
  

#line 502 "itareg.ctr"
  if(itadmin_register_check_ip(nw_ip)) {
    if(dk3enc_c8_ipaddr_to_ul_app(nw_ip, &ip, job->app)) {
      back = 1;
      if(itadmin_register_check_ip(nw_ma)) {
        if(!dk3enc_c8_ipaddr_to_ul_app(nw_ma, &ma, job->app)) {
	  back = 0;
	  /* ERROR: Failed to convert net mask! */
          itadmin_tool_log_utf8_3(job, DK3_LL_ERROR, 192, 193, nw_ma);
	}
      } else {
        /* WARNING: Using default mask 255.255.255.0! */
	dk3app_log_1(job->app, DK3_LL_WARNING, job->msg, 194);
	ma = 0xFFFFFF00UL;
      }
      if(back) {
        if(itadmin_register_check_ip(nw_gw)) {
	  if(!dk3enc_c8_ipaddr_to_ul_app(nw_gw, &gw, job->app)) {
	    back = 0;
	    /* ERROR: Failed to convert gateway! */
            itadmin_tool_log_utf8_3(job, DK3_LL_ERROR, 195, 196, nw_gw);
	  }
	} else {
	  /* WARNING: Using default gateway ip+1! */
	  gw = ip + 1UL;
	  itadmin_tool_ip_to_buffer(buffer, gw);
          itadmin_tool_log_utf8_3(job, DK3_LL_ERROR, 197, 198, buffer);
	}
	if(back) {
	  if(itadmin_register_check_ip(nw_bc)) {
	    if(!dk3enc_c8_ipaddr_to_ul_app(nw_bc, &bc, job->app)) {
	      back = 0;
	      /* ERROR: Failed to convert broadcast address! */
              itadmin_tool_log_utf8_3(job, DK3_LL_ERROR, 199, 200, nw_bc);
	    }
	  } else {
	    bc = (ip | (~(ip & ma)));
	  }
	  if(back) {
	    vl = NULL;
	    if(itadmin_register_check_user_name(vl_s)) {
	      vl = (itadmin_vlan *)dk3sto_it_find_like(
	        job->i_vl, (void *)vl_s, 1
	      );
	      if(!(vl)) {
	        back = 0;
		/* ERROR: No such VLAN! */
                itadmin_tool_log_utf8_3(job, DK3_LL_ERROR, 188, 189, vl_s);
	      }
	    }
	    if(back) {
	      if(dk3sto_it_find_like(job->i_nw, (void *)(&ip), 1)) {
	        back = 0;
		/* ERROR: Duplicate entry! */
		itadmin_tool_ip_to_buffer(buffer, ip);
                itadmin_tool_log_utf8_3(job, DK3_LL_ERROR, 201, 202, buffer);
	      } else {
	        nw = itadmin_mem_network_new(job, ip, ma, gw, bc, vl);
	        if(nw) {
	          if(dk3sto_add(job->s_nw, (void *)nw)) {
		    if(itadmin_job_do_dhcp(job)) {
		      if(vl) {
		        if(vl->s_nw) {
		          if(!dk3sto_add(vl->s_nw, (void *)nw)) {
		            back = 0;
			    /* ERROR: Failed to create backward reference! */
		          }
		        } else {
		          back = 0;
		          /* ERROR: Storage not available! */
		        }
		      }
		    }
		  } else {
		    back = 0;
		    itadmin_mem_network_del((void *)nw);
		  }
	        } else {
	          back = 0;
	        }
	      }
	    }
	  }
	}
      }
    } else {
      /* ERROR: Failed to convert IP address! */
    }
  } else {
    /* ERROR: Need IP address! */
    dk3app_log_1(job->app, DK3_LL_ERROR, job->msg, 203);
  }
  

#line 594 "itareg.ctr"
  return back;
}



int
itadmin_register_dhcp_class(itadmin_job *job, char const *dcs, char const *dcl)
{
  itadmin_dhcp_class	*dc;
  int			 back = 0;
  

#line 605 "itareg.ctr"
  if(itadmin_register_check_user_name(dcs)) {
    if(dk3sto_it_find_like(job->i_dc, (void *)dcs, 1)) {
      /* ERROR: Duplicate entry! */
      itadmin_tool_log_utf8_3(job, DK3_LL_ERROR, 204, 205, dcs);
    } else {
      dc = itadmin_mem_dhcp_class_new(job, dcs, dcl);
      if(dc) {
        if(dk3sto_add(job->s_dc, (void *)dc)) {
	  back = 1;
	} else {
	  itadmin_mem_dhcp_class_del(dc);
	}
      }
    }
  } else {
    back = 1;
  } 

#line 622 "itareg.ctr"
  return back;
}



int
itadmin_register_dhcp_group(itadmin_job *job, char const *sn, char const *ln)
{
  itadmin_dhcp_group	*dg;
  int			 back	= 0;
  

#line 633 "itareg.ctr"
  if(itadmin_register_check_user_name(sn)) {
    if(dk3sto_it_find_like(job->i_dg, (void *)sn, 1)) {
      /* ERROR: Duplicate entry! */
      itadmin_tool_log_utf8_3(job, DK3_LL_ERROR, 206, 207, sn);
    } else {
      dg = itadmin_mem_dhcp_group_new(job, sn, ln);
      if(dg) {
        if(dk3sto_add(job->s_dg, (void *)dg)) {
	  back = 1;
	} else {
	  itadmin_mem_dhcp_group_del(dg);
	}
      }
    }
  } else {
    back = 1;
  } 

#line 650 "itareg.ctr"
  return back;
}





#line 656 "itareg.ctr"


#line 657 "itareg.ctr"


#line 658 "itareg.ctr"


#line 659 "itareg.ctr"


#line 660 "itareg.ctr"


#line 661 "itareg.ctr"


#line 662 "itareg.ctr"


#line 663 "itareg.ctr"


#line 664 "itareg.ctr"


#line 665 "itareg.ctr"


#line 666 "itareg.ctr"


#line 667 "itareg.ctr"


#line 668 "itareg.ctr"


#line 669 "itareg.ctr"


#line 670 "itareg.ctr"


#line 671 "itareg.ctr"


#line 672 "itareg.ctr"


#line 673 "itareg.ctr"


#line 674 "itareg.ctr"



int
itadmin_register_dhcp_pool(
  itadmin_job		*job,
  char const		*ips,
  char const		*ipe,
  char const		*nw,
  int			 alu,
  int			 dnu,
  char const		*dcn
)
{
  char			 bu1[128];
  itadmin_dhcp_pool	*dp;	/* New pool. */
  itadmin_network	*ian;	/* Network. */
  itadmin_dhcp_class	*iac;	/* DHCP class. */
  unsigned long		 ip4s;	/* Start address of pool. */
  unsigned long		 ip4e;	/* End address of pool. */
  unsigned long		 ip4n;	/* Network address. */
  int			 back	= 0;
  int			 ok	= 1;
  

#line 698 "itareg.ctr"
  if(itadmin_register_check_ip(ips)) {
    if(dk3enc_c8_ipaddr_to_ul_app(ips, &ip4s, job->app)) {
      if(ip4s) {


#line 702 "itareg.ctr"
        if(itadmin_register_check_ip(ipe)) {
	  if(dk3enc_c8_ipaddr_to_ul_app(ipe, &ip4e, job->app)) {
	    if(ip4e) {


#line 706 "itareg.ctr"
	      if(itadmin_register_check_ip(nw)) {
	        if(dk3enc_c8_ipaddr_to_ul_app(nw, &ip4n, job->app)) {
		  if((ip4n)) {


#line 710 "itareg.ctr"
		  } else {
		    ok = 0;	

#line 712 "itareg.ctr"
		    /* ERROR: Invalid network address! */
                    itadmin_tool_log_utf8_3(job, DK3_LL_ERROR, 208, 209, nw);
		  }
		} else {
		  ok = 0;	

#line 717 "itareg.ctr"
		  /* ERROR: Failed to convert network address! */
		}
	      } else {
	        ip4n = ip4s;	

#line 721 "itareg.ctr"
	      }
	      if(ok) {		

#line 723 "itareg.ctr"
	        ian = NULL;
		iac = NULL;
		if(dcn) {
		  iac = (itadmin_dhcp_class *)dk3sto_it_find_like(
		    job->i_dc, (void *)dcn, 1
		  );
		  if(!(iac)) {
		    ok = 0;	

#line 731 "itareg.ctr"
		    /* ERROR: DHCP class not found! */
                    itadmin_tool_log_utf8_3(job, DK3_LL_ERROR, 210, 211, dcn);
		  }
		}
		if(ok) {
		  ian = (itadmin_network *)dk3sto_it_find_like(
		    job->i_nw, &ip4n, 1
		  );
		  if(ian) {


#line 741 "itareg.ctr"
		    dp = itadmin_mem_dhcp_pool_new(
		      job, ian, iac, ip4s, ip4e, dnu, alu
		    );
		    if(dp) {
		      if(dk3sto_add(job->s_dp, (void *)dp)) {
		        if(ian->s_p) {
			  if(dk3sto_add(ian->s_p, (void *)dp)) {
		            back = 1;
			  } else {	

#line 750 "itareg.ctr"
			    /* ERROR: Memory */
			  }
			} else {	

#line 753 "itareg.ctr"
			  /* BUG: We should arrive here only if s_p is set! */
			}
		      } else {	

#line 756 "itareg.ctr"
		        itadmin_mem_dhcp_pool_del(dp);
		      }
		    } else {	

#line 759 "itareg.ctr"
		    }
		  } else {	

#line 761 "itareg.ctr"
		    /* ERROR: Network not found! */
		    itadmin_tool_ip_to_buffer(bu1, ip4n);
                    itadmin_tool_log_utf8_3(job,DK3_LL_ERROR,212,213,bu1);
		  }
		} else {	

#line 766 "itareg.ctr"
		}
	      }
	    } else {		

#line 769 "itareg.ctr"
	      /* ERROR: Invalid end address! */
              itadmin_tool_log_utf8_3(job, DK3_LL_ERROR, 214, 215, ips);
	    }
	  } else {		

#line 773 "itareg.ctr"
	    /* ERROR: Failed to convert end IP address! */
	    itadmin_tool_log_utf8_3(job, DK3_LL_ERROR, 214, 215, ips);

	  }
	} else {		

#line 778 "itareg.ctr"
	  /* ERROR: Need end address! */
	  itadmin_tool_log_utf8_3(job, DK3_LL_ERROR, 216, 217, ips);
	}
      } else {			

#line 782 "itareg.ctr"
        /* ERROR: Invalid start address ! */
	itadmin_tool_log_utf8_3(job, DK3_LL_ERROR, 218, 219, ips);
      }
    } else {			

#line 786 "itareg.ctr"
      /* ERROR: Failed to convert start IP address! */
      itadmin_tool_log_utf8_3(job, DK3_LL_ERROR, 218, 219, ips);
    }
  } else {			

#line 790 "itareg.ctr"
    /* ERROR: Need start address! */
    dk3app_log_1(job->app, DK3_LL_ERROR, job->msg, 220);
  }
  

#line 794 "itareg.ctr"
  return back;
}



/**	Register a host into a DHCP pool.
	@param	job	Job structure.
	@param	pool	DHCP pool.
	@param	host	Host in DHCP pool.
	@return	1 on success, 0 on error.
*/
static
int
itadmin_register_host_in_pool(
  itadmin_job		*job,
  itadmin_dhcp_pool	*pool,
  itadmin_host		*host
)
{
  int			 back = 0;
  

#line 815 "itareg.ctr"
  if(!(pool->s_hoi)) {
    pool->s_hoi = dk3sto_open_app(job->app);
    if(pool->s_hoi) {
      dk3sto_set_comp(pool->s_hoi, itadmin_comp_host, 2);
    }
  }
  if(!(pool->i_hoi)) {
    if(pool->s_hoi) {
      pool->i_hoi = dk3sto_it_open(pool->s_hoi);
    }
  }
  if((pool->s_hoi) && (pool->i_hoi)) {
    if(dk3sto_add(pool->s_hoi, (void *)host)) {
      back = 1;
    }
  } 

#line 831 "itareg.ctr"
  return back;
}



/**	Register host in a network.
	@param	job	Job structure.
	@param	net	Network for host.
	@param	host	Host to register.
	@return	1 on success, 0 on error.
*/
static
int
itadmin_register_host_in_network(
  itadmin_job		*job,
  itadmin_network	*net,
  itadmin_host		*host
)
{
  int			 back = 0;
  

#line 852 "itareg.ctr"
  if(!(net->s_hoi)) {
    net->s_hoi = dk3sto_open_app(job->app);
    if(net->s_hoi) {
      dk3sto_set_comp(net->s_hoi, itadmin_comp_host, 2);
    }
  }
  if(!(net->i_hoi)) {
    if(net->s_hoi) {
      net->i_hoi = dk3sto_it_open(net->s_hoi);
    }
  }
  if((net->s_hoi) && (net->i_hoi)) {
    if(dk3sto_add(net->s_hoi, (void *)host)) {
      back = 1;
    }
  } 

#line 868 "itareg.ctr"
  return back;
}



/**	Register host in a DHCP group.
	@param	job	Job structure.
	@param	dgroup	DHCP group for host.
	@param	net	Network for host.
	@param	host	Host to register.
	@return	1 on success, 0 on error.
*/
static
int
itadmin_register_host_in_dhcp_group(
  itadmin_job		*job,
  itadmin_dhcp_group	*dgroup,
  itadmin_network	*net,
  itadmin_host		*host
)
{
  itadmin_dhcp_ginw	*ginw;
  int			 back = 0;
  

#line 892 "itareg.ctr"
  if(!(net->s_dg)) {
    net->s_dg = dk3sto_open_app(job->app);
    if(net->s_dg) {
      dk3sto_set_comp(net->s_dg, itadmin_comp_dhcp_ginw, 0);
    }
  }
  if(!(net->i_dg)) {
    if(net->s_dg) {
      net->i_dg = dk3sto_it_open(net->s_dg);
    }
  }
  if((net->s_dg) && (net->i_dg)) {	

#line 904 "itareg.ctr"
    ginw = (itadmin_dhcp_ginw *)dk3sto_it_find_like(
      net->i_dg, (void *)(dgroup->sn), 1
    );
    if(!(ginw)) {			

#line 908 "itareg.ctr"
      ginw = itadmin_mem_dhcp_ginw_new(job, dgroup);
      if(ginw) {
        if(!dk3sto_add(net->s_dg, (void *)ginw)) {
	  itadmin_mem_dhcp_ginw_del(ginw);
	  ginw = NULL;
	}
      }
    }
    if(ginw) {				

#line 917 "itareg.ctr"
      if(!(ginw->s_h)) {
        ginw->s_h = dk3sto_open_app(job->app);
	if(ginw->s_h) {
	  dk3sto_set_comp(ginw->s_h, itadmin_comp_host, 2);
	}
      }
      if(!(ginw->i_h)) {
        if(ginw->s_h) {
	  ginw->i_h = dk3sto_it_open(ginw->s_h);
	}
      }
      if((ginw->s_h) && (ginw->i_h)) {	

#line 929 "itareg.ctr"
        if(dk3sto_add(ginw->s_h, (void *)host)) {
	  back = 1;
	}
      } else {				

#line 933 "itareg.ctr"
      }
    } else {			

#line 935 "itareg.ctr"
    }
  } else {			

#line 937 "itareg.ctr"
  } 

#line 938 "itareg.ctr"
  return back;
}



/**	Register host in a DHCP class.
	@param	job	Job structure.
	@param	dhcpcl	DHCP class for host.
	@param	host	Host to register in class.
	@return	1 on success, 0 on error.
*/
static
int
itadmin_register_host_in_dhcp_class(
  itadmin_job		*job,
  itadmin_dhcp_class	*dhcpcl,
  itadmin_host		*host
)
{
  int			 back = 0;
  

#line 959 "itareg.ctr"
  if(!(dhcpcl->s_ho)) {
    dhcpcl->s_ho = dk3sto_open_app(job->app);
    if(dhcpcl->s_ho) {
      dk3sto_set_comp(dhcpcl->s_ho, itadmin_comp_host, 0);
    }
  }
  if(!(dhcpcl->i_ho)) {
    if(dhcpcl->s_ho) {
      dhcpcl->i_ho = dk3sto_it_open(dhcpcl->s_ho);
    }
  }
  if((dhcpcl->s_ho) && (dhcpcl->i_ho)) {
    if(dk3sto_add(dhcpcl->s_ho, (void *)host)) {
      back = 1;
    }
  } 

#line 975 "itareg.ctr"
  return back;
}



/**	Register host for a user.
	@param	job	Job structure.
	@param	user	User responsible for host.
	@param	host	Host to register.
	@return	1 on success, 0 on error.
*/
static
int
itadmin_register_host_for_user(
  itadmin_job	*job,
  itadmin_user	*user,
  itadmin_host	*host
)
{
  int			 back = 0;
  

#line 996 "itareg.ctr"
  if(!(user->s_ho)) {
    user->s_ho = dk3sto_open_app(job->app);
    if(user->s_ho) {
      dk3sto_set_comp(user->s_ho, itadmin_comp_host, 0);
    }
  }
  if(!(user->i_ho)) {
    if(user->s_ho) {
      user->i_ho = dk3sto_it_open(user->s_ho);
    }
  }
  if((user->s_ho) && (user->i_ho)) {
    if(dk3sto_add(user->s_ho, (void *)host)) {
      back = 1;
    }
  } 

#line 1012 "itareg.ctr"
  return back;
}


int
itadmin_register_host(
  itadmin_job		*job,
  char const		*co_s,
  char const		*us_s,
  char const		*co_ip,
  char const		*co_mc,
  char const		*ng_s,
  char const		*co_co,
  char const		*dc_s,
  char const		*dg_s,
  char const		*dd_n,
  char const		*gb_s,
  char const		*co_r,
  char const		*co_in,
  char const		*co_sn,
  char const		*co_dd,
  int			 co_ff,
  int			 co_gu,
  char const		*co_hi,
  itadmin_date		*co_ex,
  int			 co_nn,
  int			 co_na
)
{
  char			 maca[32];
  itadmin_user		*user;
  itadmin_netgroup	*ng;
  itadmin_dhcp_class	*dc;
  itadmin_dhcp_group	*dg;
  itadmin_connect	*nc;
  itadmin_building	*bu;
  itadmin_host		*ho;
  itadmin_network	*nw;
  unsigned long		 ipv4;
  int			 back	= 0;
  

#line 1053 "itareg.ctr"
  

#line 1054 "itareg.ctr"
  

#line 1055 "itareg.ctr"
  

#line 1056 "itareg.ctr"
  

#line 1057 "itareg.ctr"
  

#line 1058 "itareg.ctr"
  

#line 1059 "itareg.ctr"
  

#line 1060 "itareg.ctr"
  

#line 1061 "itareg.ctr"
  

#line 1062 "itareg.ctr"
  

#line 1063 "itareg.ctr"
  

#line 1064 "itareg.ctr"
  

#line 1065 "itareg.ctr"
  if(itadmin_register_check_user_name(co_s)) {	

#line 1066 "itareg.ctr"
    if(dk3sto_it_find_like(job->i_ho, (void *)co_s, 1)) { 

#line 1067 "itareg.ctr"
      /* ERROR: Duplicated entry! */
      itadmin_tool_log_utf8_3(job, DK3_LL_ERROR, 176, 177, co_s);
    } else {					

#line 1070 "itareg.ctr"
      user = NULL;
      ng = NULL;
      dc = NULL;
      dg = NULL;
      nc = NULL;
      bu = NULL;
      ipv4 = 0UL;
      back = 1;
      if(co_mc) {					

#line 1079 "itareg.ctr"
        if(dk3str_c8_len(co_mc) < sizeof(maca)) {	

#line 1080 "itareg.ctr"
	  dk3str_c8_cpy_not_overlapped(maca, co_mc);
	  if(!itadmin_register_correct_mac(job, maca)) {
	    back = 0;					

#line 1083 "itareg.ctr"
	    /* ERROR: Illegal MAC address! */
            itadmin_tool_log_utf8_3(job, DK3_LL_ERROR, 221, 222, co_mc);
	  } else {					

#line 1086 "itareg.ctr"
	  }
	} else {					

#line 1088 "itareg.ctr"
	  back = 0;
	  /* ERROR: MAC address too long! */
	  itadmin_tool_log_utf8_3(job, DK3_LL_ERROR, 223, 224, co_mc);
	}
      }
      if(itadmin_register_check_user_name(us_s)) {	

#line 1094 "itareg.ctr"
        user = (itadmin_user *)dk3sto_it_find_like(job->i_us, (void *)us_s, 1);
	if(!(user)) {				

#line 1096 "itareg.ctr"
	  /* ERROR: No such user! */
	  back = 0;
          itadmin_tool_log_utf8_5(job, DK3_LL_ERROR, 225, 226, 227, co_s, us_s);
	}
      }
      if(itadmin_register_check_user_name(ng_s)) {
        ng = (itadmin_netgroup *)dk3sto_it_find_like(job->i_ng,(void *)ng_s,1);
	if(!(ng)) {				

#line 1104 "itareg.ctr"
	  /* ERROR: No such netgroup! */
	  back = 0;
          itadmin_tool_log_utf8_5(job, DK3_LL_ERROR, 228, 229, 230, co_s, ng_s);
	}
      }
      if(itadmin_job_do_dhcp(job)) {			

#line 1110 "itareg.ctr"
        if(itadmin_register_check_user_name(dc_s)) {
          dc = (itadmin_dhcp_class *)dk3sto_it_find_like(
	    job->i_dc, (void *)dc_s, 1
	  );
	  if(!(dc)) {				

#line 1115 "itareg.ctr"
	    /* ERROR: No such DHCP class! */
	    back = 0;
            itadmin_tool_log_utf8_5(job,DK3_LL_ERROR,231,232,233,co_s,dc_s);
	  }
        }
        if(itadmin_register_check_user_name(dg_s)) {
          dg = (itadmin_dhcp_group *)dk3sto_it_find_like(
	    job->i_dg, (void *)dg_s, 1
	  );
	  if(!(dg)) {				

#line 1125 "itareg.ctr"
	    /* ERROR: No such DHCP group! */
	    back = 0;
            itadmin_tool_log_utf8_5(job,DK3_LL_ERROR,234,235,236,co_s,dg_s);
	  }
        }
      }
      if(itadmin_register_check_user_name(dd_n)) {
        nc = (itadmin_connect *)dk3sto_it_find_like(job->i_pa, (void *)dd_n, 1);
	if(!(nc)) {				

#line 1134 "itareg.ctr"
	  /* ERROR: No such patch! */
	  back = 0;
          itadmin_tool_log_utf8_5(job, DK3_LL_ERROR, 237, 238, 239, co_s, dd_n);
	}
      }
      if(itadmin_register_check_user_name(gb_s)) {
        bu = (itadmin_building *)dk3sto_it_find_like(job->i_bu,(void *)gb_s,1);
	if(!(bu)) {				

#line 1142 "itareg.ctr"
	  /* ERROR: No such building! */
	  back = 0;
          itadmin_tool_log_utf8_5(job, DK3_LL_ERROR, 240, 241, 242, co_s, gb_s);
	}
      }
      if(itadmin_register_check_ip(co_ip)) {
        if(!dk3enc_c8_ipaddr_to_ul_app(co_ip, &ipv4, job->app)) {
	  /* ERROR: Failed to convert IP address string to address! */
	  back = 0;				

#line 1151 "itareg.ctr"
	}
      }
      if(back) {				

#line 1154 "itareg.ctr"
        back = 0;
	if((ipv4) && (dc)) {
	  /* WARNING: Both IPv4 address and DHCP class! */
          itadmin_tool_log_utf8_3(job, DK3_LL_WARNING, 243, 244, co_s);
	}
	if((dc) && (!(co_mc))) {
	  /* WARNING: DHCP class but no MAC address! */
	  itadmin_tool_log_utf8_3(job, DK3_LL_WARNING, 245, 246, co_s);
	}
	if((!(ipv4)) && (ng)) {
	  /* WARNING: Netgroup but no IP address! */
	  itadmin_tool_log_utf8_3(job, DK3_LL_WARNING, 247, 248, co_s);
	}
	if((ng) && (!co_dd)) {
	  /* WARNING: Netgroup but no DNS domain! */
	  itadmin_tool_log_utf8_3(job, DK3_LL_WARNING, 249, 250, co_s);
	}
	if((co_ff) && (!(co_dd))) {
	  /* WARNING: FQDN first flag but no DNS domain! */
	  itadmin_tool_log_utf8_3(job, DK3_LL_WARNING, 251, 252, co_s);
	}	

#line 1175 "itareg.ctr"
	if(co_ex) {
	  if(((job->today).y) || ((job->today).m) || ((job->today).d)) {
	    if((co_ex->y) || (co_ex->m) || (co_ex->d)) {
	      if(itadmin_comp_date(&(job->today), co_ex) > 0) {
	        /* WARNING: Host expired. */
		itadmin_tool_log_utf8_3(job, DK3_LL_WARNING, 253, 254, co_s);
	      }
	    }
	  }
	}
	

#line 1186 "itareg.ctr"
	ho = itadmin_mem_host_new(
	  job, co_ex, co_s, co_co, 
	  ((co_mc) ? maca : NULL),
	  co_r, co_in, co_sn, co_hi, co_dd,
	  user, ng, dc, dg, nc, bu, ipv4, co_ff, co_gu, co_nn, co_na
	);
	if(ho) {				

#line 1193 "itareg.ctr"
	  if(dk3sto_add(job->s_ho, (void *)ho)) {	

#line 1194 "itareg.ctr"
	    if(dk3sto_add(job->s_hoi, (void *)ho)) {
	      back = 1;				

#line 1196 "itareg.ctr"
	      if(ipv4 == 0x7F000001UL) {
	        job->hlh = 1;
	      }
	      if(itadmin_job_do_dhcp(job)) {	

#line 1200 "itareg.ctr"
	        nw = NULL;
		if(ipv4) {
	          nw = (itadmin_network *)dk3sto_it_find_like(
		    job->i_nw, (void *)(&ipv4), 1
		  );
		}
		if(nw) {			

#line 1207 "itareg.ctr"
		  ho->dp = (itadmin_dhcp_pool *)dk3sto_it_find_like(
		    job->i_dp, (void *)(&ipv4), 1
		  );
		  if(!(ho->dp)) {		

#line 1211 "itareg.ctr"
		    if(dg) {			

#line 1212 "itareg.ctr"
		      if(!itadmin_register_host_in_dhcp_group(job,dg,nw,ho)) {
		        back = 0;
		      }
		    } else {			

#line 1216 "itareg.ctr"
		      if(!itadmin_register_host_in_network(job, nw, ho)) {
		        back = 0;
		      }
		    }
		  } else {			

#line 1221 "itareg.ctr"
		    if(!itadmin_register_host_in_pool(job, ho->dp, ho)) {
		      back = 0;
		    }
		  }
		} else {			

#line 1226 "itareg.ctr"
		  /* Host not in a network. */
		  if(dc) {			

#line 1228 "itareg.ctr"
		    if(!itadmin_register_host_in_dhcp_class(job,dc,ho)) {
		      back = 0;
		    }
		  } else {			

#line 1232 "itareg.ctr"
		  }
		}
	      } else {				

#line 1235 "itareg.ctr"
	      }
	      if(user) {
	        if(!itadmin_register_host_for_user(job, user, ho)) {
		  back = 0;
		}
	      }
	    } else {				

#line 1242 "itareg.ctr"
	    }
	  } else {				

#line 1244 "itareg.ctr"
	    itadmin_mem_host_del(ho);
	  }
	} else {				

#line 1247 "itareg.ctr"
	  /* ERROR: Memory! */
	}
      }
    }
  } else {					

#line 1252 "itareg.ctr"
    /* ERROR: Computer name! */
    dk3app_log_1(job->app, DK3_LL_ERROR, job->msg, 255);
  }
  

#line 1256 "itareg.ctr"
  return back;
}



int
itadmin_register_alias(itadmin_job *job, char const *al, char const *rn)
{
  itadmin_host		*host;
  char const		*nn;
  int			 back	= 0;
  

#line 1268 "itareg.ctr"
  if((job) && (al) && (rn)) {
    host = (itadmin_host *)dk3sto_it_find_like(job->i_ho, (void *)rn, 1);
    if(host) {
      if(!(host->s_al)) {
        host->s_al = dk3sto_open_app(job->app);
	if(host->s_al) {
	  dk3sto_set_comp(host->s_al, itadmin_comp_string, 0);
	}
      }
      if(!(host->i_al)) {
        if(host->s_al) {
	  host->i_al = dk3sto_it_open(host->s_al);
	}
      }
      if((host->s_al) && (host->i_al)) {
        nn = dk3str_c8_dup_app(al, job->app);
	if(nn) {
	  if(dk3sto_add(host->s_al, (void *)nn)) {
	    back = 1;
	  } else {
	    dk3_delete(nn);
	  }
	} else {
	  /* ERROR: Memory! */
	}
      } else {
        /* ERROR: Memory! */
      }
    } else {
      /* ERROR: No such host rn! */
      itadmin_tool_log_utf8_5(job, DK3_LL_ERROR, 256, 257, 258, al, rn);
    }
  } 

#line 1301 "itareg.ctr"
  return back;
}



int
itadmin_register_dhcp_option(
  itadmin_job	*job,
  char const	*sct,
  char const	*scn,
  char const	*k,
  char const	*v,
  long		 pk
)
{
  char			 buffer[128];
  itadmin_dhcp_option	*no;
  itadmin_vlan		*vl;
  itadmin_network	*nw;
  itadmin_dhcp_group	*dg;
  itadmin_dhcp_pool	*dp;
  itadmin_host		*ho;
  unsigned long		 ipv4;
  int			 scope;
  int			 back	= 0;
  

#line 1327 "itareg.ctr"
  

#line 1328 "itareg.ctr"
  

#line 1329 "itareg.ctr"
  

#line 1330 "itareg.ctr"
  

#line 1331 "itareg.ctr"
  if((job) && (sct) && (k)) {
    scope = dk3str_c8_array_index(itadmin_register_scope_type_names, sct, 0);
    switch(scope) {
      case 0: {		

#line 1335 "itareg.ctr"
        if((job->s_do) && (job->i_do)) {
	  no = itadmin_mem_dhcp_option_new(job, k, v, pk);
	  if(no) {
	    if(dk3sto_add(job->s_do, (void *)no)) {
	      back = 1;
	    } else {
	      itadmin_mem_dhcp_option_del((void *)no);
	    }
	  } else {
	  }
	} else {
	  /* BUG: Should be set during itamin_job_up()! */
	}
      } break;
      case 1: {		

#line 1350 "itareg.ctr"
        vl = NULL;
	if(scn) {
	  vl = (itadmin_vlan *)dk3sto_it_find_like(
	    job->i_vl, (void *)scn, 1
	  );
	}
	if(vl) {
	  if(!(vl->s_do)) {
	    vl->s_do = dk3sto_open_app(job->app);
	    if(vl->s_do) {
	      dk3sto_set_comp(vl->s_do, itadmin_comp_dhcp_option, 0);
	    }
	  }
	  if(!(vl->i_do)) {
	    if(vl->s_do) {
	      vl->i_do = dk3sto_it_open(vl->s_do);
	    }
	  }
	  if((vl->s_do) && (vl->i_do)) {
	    no = itadmin_mem_dhcp_option_new(job, k, v, pk);
	    if(no) {
	      if(dk3sto_add(vl->s_do, (void *)no)) {
	        back = 1;
	      } else {
	        itadmin_mem_dhcp_option_del((void *)no);
	      }
	    } else {
	    }
	  }
	} else {
	  /* ERROR: No such VLAN! */
          itadmin_tool_log_pk_5(job, DK3_LL_ERROR, 259, 260, 261, pk, scn);
	}
      } break;
      case 2: {		

#line 1385 "itareg.ctr"
        nw = NULL;
        if(scn) {
	  if(dk3enc_c8_ipaddr_to_ul_app(scn, &ipv4, job->app)) {
	    nw = (itadmin_network *)dk3sto_it_find_like(
	      job->i_nw, (void *)(&ipv4), 1
	    );
	  }
	}
	if(nw) {
	  if(!(nw->s_do)) {
	    nw->s_do = dk3sto_open_app(job->app);
	    if(nw->s_do) {
	      dk3sto_set_comp(nw->s_do, itadmin_comp_dhcp_option, 0);
	    }
	  }
	  if(!(nw->i_do)) {
	    if(nw->s_do) {
	      nw->i_do = dk3sto_it_open(nw->s_do);
	    }
	  }
	  if((nw->s_do) && (nw->i_do)) {
	    no = itadmin_mem_dhcp_option_new(job, k, v, pk);
	    if(no) {
	      if(dk3sto_add(nw->s_do, (void *)no)) {
	        back = 1;
	      } else {
	        itadmin_mem_dhcp_option_del((void *)no);
	      }
	    } else {
	    }
	  }
	} else {
	  /* ERROR: No such network! */
	  itadmin_tool_ip_to_buffer(buffer, ipv4);
          itadmin_tool_log_pk_5(job,DK3_LL_ERROR,262,263,264,pk,buffer);
	}
      } break;
      case 3: {		

#line 1423 "itareg.ctr"
        dg = NULL;
	if(scn) {
	  dg = (itadmin_dhcp_group *)dk3sto_it_find_like(
	    job->i_dg, (void *)scn, 1
	  );
	}
	if(dg) {
	  if(!(dg->s_do)) {
	    dg->s_do = dk3sto_open_app(job->app);
	    if(dg->s_do) {
	      dk3sto_set_comp(dg->s_do, itadmin_comp_dhcp_option, 0);
	    }
	  }
	  if(!(dg->i_do)) {
	    if(dg->s_do) {
	      dg->i_do = dk3sto_it_open(dg->s_do);
	    }
	  }
	  if((dg->s_do) && (dg->i_do)) {
	    no = itadmin_mem_dhcp_option_new(job, k, v, pk);
	    if(no) {
	      if(dk3sto_add(dg->s_do, (void *)no)) {
	        back = 1;
	      } else {
	        itadmin_mem_dhcp_option_del((void *)no);
	      }
	    } else {
	    }
	  }
	} else {
	  /* ERROR: No such DHCP group! */
          itadmin_tool_log_pk_5(job, DK3_LL_ERROR, 265, 266, 267, pk, scn);
	}
      } break;
      case 4: {		

#line 1458 "itareg.ctr"
        dp = NULL;
	if(scn) {
	  if(dk3enc_c8_ipaddr_to_ul_app(scn, &ipv4, job->app)) {
	    dp = (itadmin_dhcp_pool *)dk3sto_it_find_like(
	      job->i_dp, (void *)(&ipv4), 1
	    );
	  }
	}
	if(dp) {
	  if(!(dp->s_do)) {
	    dp->s_do = dk3sto_open_app(job->app);
	    if(dp->s_do) {
	      dk3sto_set_comp(dp->s_do, itadmin_comp_dhcp_option, 0);
	    }
	  }
	  if(!(dp->i_do)) {
	    if(dp->s_do) {
	      dp->i_do = dk3sto_it_open(dp->s_do);
	    }
	  }
	  if((dp->s_do) && (dp->i_do)) {
	    no = itadmin_mem_dhcp_option_new(job, k, v, pk);
	    if(no) {
	      if(dk3sto_add(dp->s_do, (void *)no)) {
	        back = 1;
	      } else {
	        itadmin_mem_dhcp_option_del((void *)no);
	      }
	    } else {
	    }
	  }
	} else {
	  /* ERROR: No such DHCP pool! */
	  itadmin_tool_ip_to_buffer(buffer, ipv4);
          itadmin_tool_log_pk_5(job,DK3_LL_ERROR,268,269,270,pk,buffer);
	}
      } break;
      case 5: {		

#line 1496 "itareg.ctr"
        ho = NULL;
	if(scn) {
	  ho = (itadmin_host *)dk3sto_it_find_like(
	    job->i_ho, (void *)scn, 1
	  );
	}
	if(ho) {
	  if(!(ho->s_do)) {
	    ho->s_do = dk3sto_open_app(job->app);
	    if(ho->s_do) {
	      dk3sto_set_comp(ho->s_do, itadmin_comp_dhcp_option, 0);
	    }
	  }
	  if(!(ho->i_do)) {
	    if(ho->s_do) {
	      ho->i_do = dk3sto_it_open(ho->s_do);
	    }
	  }
	  if((ho->s_do) && (ho->i_do)) {
	    no = itadmin_mem_dhcp_option_new(job, k, v, pk);
	    if(no) {
	      if(dk3sto_add(ho->s_do, (void *)no)) {
	        back = 1;
	      } else {
	        itadmin_mem_dhcp_option_del((void *)no);
	      }
	    } else {
	    }
	  }
	} else {
	  /* ERROR: No such host! */
          itadmin_tool_log_pk_5(job, DK3_LL_ERROR, 271, 272, 273, pk, scn);
	}
      } break;
      default: {
        /* ERROR: Unknown scope type name! */
	itadmin_tool_log_pk_5(job, DK3_LL_ERROR, 274, 275, 276, pk, sct);
      } break;
    }
  } else {
    /* ERROR: Incomplete arguments! */
  } 

#line 1538 "itareg.ctr"
  return back;
}



int
itadmin_register_swman( itadmin_job *job, char const *sm_s, char const *sm_l)
{
  itadmin_swman	*sm;
  int		 back = 0;
  

#line 1549 "itareg.ctr"
  if(itadmin_register_check_user_name(sm_s)) {	

#line 1550 "itareg.ctr"
    if(dk3sto_it_find_like(job->i_sm, (void *)sm_s, 1)) { 

#line 1551 "itareg.ctr"
      /* ERROR: Duplicated entry! */
      itadmin_tool_log_utf8_3(job, DK3_LL_ERROR, 178, 179, sm_s);
    } else {
      sm = itadmin_mem_sw_man_new(job, sm_s, sm_l);
      if(sm) {
        if(dk3sto_add(job->s_sm, (void *)sm)) {
	  back = 1;
	} else {
	  itadmin_mem_sw_man_del((void *)sm);
	}
      }
    }
  } else {
    /* ERROR: Manufacturer name! */
    itadmin_tool_log_utf8_3(job, DK3_LL_ERROR, 303, 304, sm_s);
  } 

#line 1567 "itareg.ctr"
  return back;
}



int
itadmin_register_swprod(
  itadmin_job	*job,
  char const	*sw_s,
  char const	*sw_l,
  char const	*sm_s
)
{
  itadmin_swprod	*sp;
  itadmin_swman		*sm;
  int			 back = 0;
  if(itadmin_register_check_user_name(sw_s)) {
    if(dk3sto_it_find_like(job->i_sw, (void *)sw_s, 1)) {
      /* ERROR: Duplicate entry! */
      itadmin_tool_log_utf8_3(job, DK3_LL_ERROR, 277, 278, sw_s);
    } else {
      sm = NULL;
      if(sm_s) {
        sm = (itadmin_swman *)dk3sto_it_find_like(job->i_sm, (void *)sm_s, 1);
	if(!(sm)) {
	  /* WARNING: Failed to find software manufacturer! */
          itadmin_tool_log_utf8_5(job, DK3_LL_ERROR, 279, 280, 281, sw_s, sm_s);
	}
      }
      sp = itadmin_mem_swprod_new(job, sw_s, sw_l, sm);
      if(sp) {
        if(dk3sto_add(job->s_sw, (void *)sp)) {
	  back = 1;
	} else {
	  itadmin_mem_software_del((void *)sp);
	}
      }
    }
  } else {
    /* ERROR: Illegal software product name! */
    itadmin_tool_log_utf8_3(job, DK3_LL_ERROR, 305, 306, sw_s);
  }
  return back;
}



int
itadmin_register_lictype(
  itadmin_job	*job,
  char const	*lt_s,
  char const	*lt_l,
  int		 nl
)
{
  itadmin_lictype	*lt;
  int			 back = 0;
  if(itadmin_register_check_user_name(lt_s)) {
    if(dk3sto_it_find_like(job->i_lt, (void *)lt_s, 1)) {
      /* ERROR: Duplicate entry! */
      itadmin_tool_log_utf8_3(job, DK3_LL_ERROR, 282, 283, lt_s);
    } else {
      lt = itadmin_mem_lictype_new(job, lt_s, lt_l, nl);
      if(lt) {
        if(dk3sto_add(job->s_lt, (void *)lt)) {
	  back = 1;
	} else {
	  itadmin_mem_lic_type_del((void *)lt);
	}
      }
    }
  } else {
    /* ERROR: Illegal license type name */
    itadmin_tool_log_utf8_3(job, DK3_LL_ERROR, 307, 308, lt_s);
  }
  return  back;
}



/**	Register a license assigned to a user.
	@param	job	Job structure.
	@param	us	User.
	@param	li	New license to register.
	@return	1 on success, 0 on error.
*/
static
int
itadmin_register_license_to_user(
  itadmin_job		*job,
  itadmin_user		*us,
  itadmin_license	*li
)
{
  int		back = 0;
  if(!(us->s_li)) {
    us->s_li = dk3sto_open_app(job->app);
    if(us->s_li) {
      dk3sto_set_comp(us->s_li, itadmin_comp_license, 2);
    }
  }
  if(!(us->i_li)) {
    if(us->s_li) {
      us->i_li = dk3sto_it_open(us->s_li);
    }
  }
  if((us->s_li) && (us->i_li)) {
    if(dk3sto_add(us->s_li, (void *)li)) {
      back = 1;
    }
  }
  return back;
}



/**	Register a license used on a computer.
	@param	job	Job structure.
	@param	co	Computer on which the license is used.
	@param	li	License to register.
	@return	1 on success, 0 on error.
*/
static
int
itadmin_register_license_to_host(
  itadmin_job		*job,
  itadmin_host		*co,
  itadmin_license	*li
)
{
  int		back = 0;
  if(!(co->s_li)) {
    co->s_li = dk3sto_open_app(job->app);
    if(co->s_li) {
      dk3sto_set_comp(co->s_li, itadmin_comp_license, 2);
    }
  }
  if(!(co->i_li)) {
    if(co->s_li) {
      co->i_li = dk3sto_it_open(co->s_li);
    }
  }
  if((co->s_li) && (co->i_li)) {
    if(dk3sto_add(co->s_li, (void *)li)) {
      back = 1;
    }
  }
  return back;
}



/**	Register an unused license (a license not assigned to
	any user or computer).
	@param	job	Job structure.
	@param	li	License to register.
	@return	1 on success, 0 on error.
*/
static
int
itadmin_register_unused_license(
  itadmin_job		*job,
  itadmin_license	*li
)
{
  int		back = 0;
  if(dk3sto_add(job->s_lf, (void *)li)) {
    back = 1;
  }
  return back;
}



int
itadmin_register_license(
  itadmin_job	*job,
  unsigned long	 pk,
  char const	*li_on,
  char const	*sw_s,
  char const	*us_s,
  char const	*co_s,
  char const	*lt_s,
  char const	*li_no,
  char const	*sr_s,
  itadmin_date	*li_dd,
  char const	*li_nd,
  itadmin_date	*li_di,
  char const	*li_ni
)
{
  itadmin_swprod	*sp;
  itadmin_lictype	*lt;
  itadmin_user		*us;
  itadmin_host		*co;
  itadmin_license	*li;
  int			 back = 0;
  if(itadmin_register_check_user_name(sw_s)) {
    if(dk3sto_it_find_like(job->i_lc, (void *)(&pk), 1)) {
      /* ERROR: Duplicate entry */
      itadmin_tool_log_pk_3(job, DK3_LL_ERROR, 284, 285, pk);
    } else {
      sp = NULL; lt = NULL; us = NULL; co = NULL;
      sp = (itadmin_swprod *)dk3sto_it_find_like(job->i_sw, (void *)sw_s, 1);
      if(sp) {
        back = 1;
	if(us_s) {
	  if(itadmin_register_check_user_name(us_s)) {
	    us =
	    (itadmin_user *)dk3sto_it_find_like(job->i_us, (void *)us_s, 1);
	    if(!(us)) {
	      back = 0;
	      /* ERROR: User not found! */
              itadmin_tool_log_pk_5(job,DK3_LL_ERROR,286,287,288,pk,us_s);
	    }
	  }
	}
	if(co_s) {
	  if(itadmin_register_check_user_name(co_s)) {
	    co =
	    (itadmin_host *)dk3sto_it_find_like(job->i_ho, (void *)co_s, 1);
	    if(!(co)) {
	      back = 0;
	      /* ERROR: Computer not found! */
              itadmin_tool_log_pk_5(job,DK3_LL_ERROR,289,290,291,pk,co_s);
	    }
	  }
	}
	if(lt_s) {
	  if(itadmin_register_check_user_name(lt_s)) {
	    lt =
	    (itadmin_lictype *)dk3sto_it_find_like(job->i_lt,(void *)lt_s,1);
	    if(!(lt)) {
	      back = 0;
	      /* ERROR: License type not found! */
              itadmin_tool_log_pk_5(job,DK3_LL_ERROR,292,293,294,pk,lt_s);
	    }
	  }
	}
	if(back) {
	  back = 0;
	  li = itadmin_mem_license_new(
	    job, pk, li_on, li_no, li_dd, li_nd, li_di, li_ni, sp, lt, us, co
	  );
	  if(li) {
	    if(dk3sto_add(job->s_lc, (void *)li)) {
	      back = 1;
	      if(us) {
	        if(co) {
		  if(itadmin_tool_check_same_user(us, co)) {
		    if(!itadmin_register_license_to_host(job, co, li)) {
		      back = 0; 
		    }
		  } else {
		    if(!itadmin_register_license_to_host(job, co, li)) {
		      back = 0;
		    }
		    if(!itadmin_register_license_to_user(job, us, li)) {
		      back = 0;
		    }
		  }
		} else {
		  if(!itadmin_register_license_to_user(job, us, li)) {
		    back = 0;
		  }
		}
	      } else {
	        if(co) {
		  if(!itadmin_register_license_to_host(job, co, li)) {
		    back = 0;
		  }
		  /* Warning: License assigned to computer, not user */
                  itadmin_tool_log_pk_5(
		    job, DK3_LL_WARNING, 295, 296, 297, pk, co_s
		  );
		} else {
		  if(!itadmin_register_unused_license(job, li)) {
		    back = 0;
		  }
		}
	      }
	    } else {
	      itadmin_mem_license_del((void *)li);
	    }
	  }
	}
      }
    }
  } else {
    /* ERROR: No software specified! */
    itadmin_tool_log_pk_3(job, DK3_LL_ERROR, 298, 299, pk);
  }
  return back;
}


