/*
	WARNING: This file was generated by dkct.
	Changes you make here will be lost if dkct is run again!
	You should modify the original source and run dkct on it.
	Original source: itange.ctr
*/

/*
Copyright (C) 2012-2014, Dirk Krause

Redistribution and use in source and binary forms, with or without
modification, are permitted provided that the following conditions are met:

* Redistributions of source code must retain the above copyright notice,
  this list of conditions and the following disclaimer.
* Redistributions in binary form must reproduce the above opyright notice,
  this list of conditions and the following disclaimer in the documentation
  and/or other materials provided with the distribution.
* Neither the name of the author nor the names of contributors may be used
  to endorse or promote products derived from this software without specific
  prior written permission.

THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS ``AS IS''
AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
ARE DISCLAIMED.
IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE LIABLE FOR ANY
DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
(INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
(INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
*/

/**	@file itange.c The itange module.
*/


#line 10 "itange.ctr"

#include "dk3all.h"
#include "itadmin.h"





#line 17 "itange.ctr"



/**	Keywords used by the module.
*/
static char const * const itadmin_netgroup_c8_kw[] = {
/* 0 */
"netgroup.ldif",

/* 1 */
"w",

/* 2 */
"dn: cn=",

/* 3 */
",ou=netgroup,",

/* 4 */
"objectClass: top",

/* 5 */
"objectClass: nisNetgroup",

/* 6 */
"cn: ",

/* 7 */
"nisNetgroupTriple: (",

/* 8 */
",,",

/* 9 */
")",

NULL


#line 65 "itange.ctr"
};

int
itadmin_netgroup_expand(itadmin_job *job)
{
  itadmin_netgroup	*ng;	/* Current netgroup. */
  itadmin_ngdep		*nd;	/* Netgroup dependency. */
  size_t		 nng;	/* Next netgroup number. */
  int			 back	= 0;
  

#line 75 "itange.ctr"
  /*
  	Assign number to each netgroup.
  */
  nng = 0;
  dk3sto_it_reset(job->i_ng);
  while(NULL != (ng = (itadmin_netgroup *)dk3sto_it_next(job->i_ng))) {
    ng->no = nng++;
  }
  job->nng = nng;
  /*
  	Create dependency matrix.
  */
  if(nng > 0) {
    job->ngdep = dk3bm_open(nng, nng, job->app);
    if(job->ngdep) {		

#line 90 "itange.ctr"
      /*
      	Enter dependencies into matrix.
      */
      dk3sto_it_reset(job->i_nd);
      while(NULL != (nd = (itadmin_ngdep *)dk3sto_it_next(job->i_nd))) {
        if((nd->ch) && (nd->pa)) {
	  dk3bm_set(job->ngdep, (nd->ch)->no, (nd->pa)->no, 1);
	}
      }
      /*
      	Expand matrix to find indirect parent/child relations.
      */
      dk3bm_expand(job->ngdep);
      back = 1;
    } else {			

#line 105 "itange.ctr"
    }
  } else {			

#line 107 "itange.ctr"
    back = 1;
  }
  

#line 110 "itange.ctr"
  return back;
}



int
itadmin_netgroup_host_member(
  itadmin_job		*job,
  itadmin_netgroup	*netgroup,
  itadmin_host		*host
)
{
  int			back	= 0;
  

#line 124 "itange.ctr"
  if((netgroup) && (host)) {			

#line 125 "itange.ctr"
    if(host->ng) {				

#line 126 "itange.ctr"
      if((host->ng)->no == netgroup->no) {	

#line 127 "itange.ctr"
        back = 2;
      } else {					

#line 129 "itange.ctr"
        if(job->ngdep) {				

#line 130 "itange.ctr"
          if(dk3bm_get(job->ngdep, (host->ng)->no, netgroup->no)) {
	    back = 1;
	  }
        } else {					

#line 134 "itange.ctr"
        }
      }
    } else {					

#line 137 "itange.ctr"
    }
  } else {					

#line 139 "itange.ctr"
  } 

#line 140 "itange.ctr"
  return back;
}



int
itadmin_netgroup_ldif_output(itadmin_job *job)
{
  char			 bu[ITADMIN_CONFIG_LINE_SIZE];
  itadmin_netgroup	*ng;		/* Current netgroup to process. */
  itadmin_host		*host;		/* Current host to process. */
  FILE			*fipo;		/* Output file. */
  char const		*al;		/* Current alias name. */
  int			 ie;		/* Input encoding. */
  int			 nghf	= 0;	/* Flag: Already host found here. */
  int			 back	= 0;
  

#line 157 "itange.ctr"
  ie = dk3app_get_encoding(job->app);
  if(dk3str_to_c8u_app(bu,sizeof(bu),job->ldapb,ie,job->app)) {	

#line 159 "itange.ctr"
    fipo = dk3sf_c8_fopen_app(
      itadmin_netgroup_c8_kw[0],
      itadmin_netgroup_c8_kw[1],
      job->app
    );
    if(fipo) {							

#line 165 "itange.ctr"
      dk3sto_it_reset(job->i_ng);
      while(NULL != (ng = (itadmin_netgroup *)dk3sto_it_next(job->i_ng))) {
        nghf = 0;						

#line 168 "itange.ctr"
        dk3sto_it_reset(job->i_hoi);
        while(NULL != (host = (itadmin_host *)dk3sto_it_next(job->i_hoi))) {
	  if((host->sn) && (host->ipv4) && (host->dnsd)) {	

#line 171 "itange.ctr"
            if(itadmin_netgroup_host_member(job, ng, host)) {	

#line 172 "itange.ctr"
	      if(!(nghf)) {
	        fputs(itadmin_netgroup_c8_kw[2], fipo);
	        fputs(ng->sn, fipo);
	        fputs(itadmin_netgroup_c8_kw[3], fipo);
	        fputs(bu, fipo);
	        fputc('\n', fipo);
	        fputs(itadmin_netgroup_c8_kw[4], fipo);
	        fputc('\n', fipo);
	        fputs(itadmin_netgroup_c8_kw[5], fipo);
	        fputc('\n', fipo);
	        fputs(itadmin_netgroup_c8_kw[6], fipo);
	        fputs(ng->sn, fipo);
	        fputc('\n', fipo);
	      }
	      nghf = 1;						

#line 187 "itange.ctr"
	      /* Short host name */
	      fputs(itadmin_netgroup_c8_kw[7], fipo);
	      fputs(host->sn, fipo);
	      fputs(itadmin_netgroup_c8_kw[8], fipo);
	      fputs(host->dnsd, fipo);
	      fputs(itadmin_netgroup_c8_kw[9], fipo);
	      fputc('\n', fipo);
	      /* Full host name */
	      fputs(itadmin_netgroup_c8_kw[7], fipo);
	      fputs(host->sn, fipo);
	      fputc('.', fipo);
	      fputs(host->dnsd, fipo);
	      fputs(itadmin_netgroup_c8_kw[8], fipo);
	      fputs(host->dnsd, fipo);
	      fputs(itadmin_netgroup_c8_kw[9], fipo);
	      fputc('\n', fipo);
	      /* Aliases */
	      if(host->i_al) {
	        dk3sto_it_reset(host->i_al);
		while(NULL != (al = (char const *)dk3sto_it_next(host->i_al))) {
	          fputs(itadmin_netgroup_c8_kw[7], fipo);
	          fputs(al, fipo);
	          fputs(itadmin_netgroup_c8_kw[8], fipo);
	          fputs(host->dnsd, fipo);
	          fputs(itadmin_netgroup_c8_kw[9], fipo);
	          fputc('\n', fipo);
		}
	      }
	      /* IP */
	      fputs(itadmin_netgroup_c8_kw[7], fipo);
	      itadmin_tool_write_ip(fipo, host->ipv4);
	      fputs(itadmin_netgroup_c8_kw[8], fipo);
	      fputs(host->dnsd, fipo);
	      fputs(itadmin_netgroup_c8_kw[9], fipo);
	      fputc('\n', fipo);
	    } else {						

#line 223 "itange.ctr"
	    }
	  }
	}
        if(nghf) {
          fputc('\n', fipo);
        }
      }
      back = 1;
#if DK3_CHAR_SIZE == 1
      if(!dk3sf_fclose_fn_app(fipo, itadmin_netgroup_c8_kw[0], job->app)) {
        back = 0;
      }
#else
      if(!dk3sf_fclose_fn_app(fipo, NULL, job->app)) {
        back = 0;
      }
#endif
    } else {						

#line 241 "itange.ctr"
    }
  } else {						

#line 243 "itange.ctr"
  }
  

#line 245 "itange.ctr"
  return back;
}


