/*
	WARNING: This file was generated by dkct.
	Changes you make here will be lost if dkct is run again!
	You should modify the original source and run dkct on it.
	Original source: itanetd.ctr
*/

/*
Copyright (C) 2012-2014, Dirk Krause

Redistribution and use in source and binary forms, with or without
modification, are permitted provided that the following conditions are met:

* Redistributions of source code must retain the above copyright notice,
  this list of conditions and the following disclaimer.
* Redistributions in binary form must reproduce the above opyright notice,
  this list of conditions and the following disclaimer in the documentation
  and/or other materials provided with the distribution.
* Neither the name of the author nor the names of contributors may be used
  to endorse or promote products derived from this software without specific
  prior written permission.

THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS ``AS IS''
AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
ARE DISCLAIMED.
IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE LIABLE FOR ANY
DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
(INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
(INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
*/

/**	@file itanetd.c The itanetd module.
*/


#line 10 "itanetd.ctr"

#include "dk3all.h"
#include "itadmin.h"





#line 17 "itanetd.ctr"



/**	Keywords used by the module.
*/
static char const * const itadmin_netdocu_c8_kw[] = {
/* 0 */
"\n",

/* 1 */
" ",

/* 2 */
"w",

/* 3 */
"netdocu.tex",

/* 4 */
"pdftitle={",

/* 5 */
"},",

/* 6 */
"pdfsubject={",

/* 7 */
"pdfauthor={",

/* 8 */
"pdfcreator={itadmin - http://dktools.sourceforge.net/}",

/* 9 */
"\\author{",

/* 10 */
"\\title{",

/* 11 */
"}",

/* 12 */
"\\section{",

/* 13 */
"\\subsection[",

/* 14 */
"]{",

/* 15 */
"\\subsection{",

/* 16 */
"\\subsubsection{",

/* 17 */
"\\clearpage",

/* 18 */
"\\begin{tabular}{rl}",

/* 19 */
"\\end{tabular}",

/* 20 */
"\\\\*[1em]",

/* 21 */
"\\begin{itemize}",

/* 22 */
"\\end{itemize}",

/* 23 */
"\\item{",

/* 24 */
"&",

/* 25 */
"\\\\",

/* 26 */
"\\textbf{",

/* 27 */
"\\begin{longtable}{ll}",

/* 28 */
"\\endfirsthead",

/* 29 */
"\\endhead",

/* 30 */
"\\endfoot",

/* 31 */
"\\endlastfoot",

/* 32 */
"\\end{longtable}",

/* 33 */
"~\\\\[0.5em]",

/* 34 */
"\\begin{longtable}{|c|c|c|c|c|}",

/* 35 */
"\\hline",

/* 36 */
"\\multicolumn{1}{|c}{\\textbf{",

/* 37 */
"\\multicolumn{1}{|c|}{\\textbf{",

/* 38 */
"}}",

NULL


#line 181 "itanetd.ctr"
};



/**	Start of LaTeX source.
*/
static char const * const	itadmin_netdocu_file_start1a[] = {
"\\documentclass[titlepage,origlongtable]{scrartcl}",
"\\KOMAoptions{paper=a4}",
"\\KOMAoptions{fontsize=12pt}",
NULL


#line 193 "itanetd.ctr"
};



/**	Start of LaTeX source.
*/
static char const * const	itadmin_netdocu_file_start1b[] = {
"\\documentclass[12pt]{article}",
NULL


#line 203 "itanetd.ctr"
};


/**	LaTeX packages after ngerman.
*/
static char const * const       itadmin_netdocu_file_start4[] = {
"\\usepackage{ifpdf}",
"\\usepackage[utf8]{inputenc}",
"\\usepackage{mathptmx}",
"\\usepackage[scaled=.92]{helvet}",
"\\usepackage{courier}",
"\\usepackage[T1]{fontenc}",
"\\usepackage{textcomp}",
"\\usepackage{latexsym}",
"\\usepackage{varioref}",
"\\usepackage{color}",
"\\usepackage{makeidx}",
"\\usepackage{longtable}",
"\\makeindex",
"\\ifpdf",
"\\usepackage[activate=normal]{pdfcprot}",
"\\pdfcompresslevel=9",
"\\usepackage[",
"pdftex,",
"colorlinks=true,",
"pdfpagemode=UseNone,",
"pdfstartview={XYZ 0 835 1.25},",
"bookmarksnumbered,",
NULL


#line 233 "itanetd.ctr"
};



/**	LaTeX package after hyperref options for title, subject, author.
*/
static char const * const	itadmin_netdocu_file_start2[] = {
"]{hyperref}",
"\\else",
"\\usepackage[dvips,colorlinks=true,linkcolor=black]{hyperref}",
"\\fi",
"\\parindent0cm",
NULL


#line 247 "itanetd.ctr"
};



/**	Renewcommand, only used for koma-script.
*/
static char const * const	itadmin_netdocu_file_start3a[] = {
"\\renewcommand*{\\sectfont}{\\bfseries}",
NULL


#line 257 "itanetd.ctr"
};



/**	Final commands after title and author.
*/
static char const * const	itadmin_netdocu_file_start3[] = {
"\\setcounter{secnumdepth}{1}",
"\\begin{document}",
NULL


#line 268 "itanetd.ctr"
};



/**	LaTeX file end.
*/
static char const * const	itadmin_netdocu_file_end[] = {
"\\end{document}",
NULL


#line 278 "itanetd.ctr"
};



/**	Write section header for hosts section
*/
static
void
itadmin_netdocu_write_sh_hosts(itadmin_job *job, dk3_stream_t *os)
{
  int ie;
  ie = dk3app_get_encoding(job->app);
  dk3stream_c8_fputs(os, itadmin_netdocu_c8_kw[12]);
  dk3stream_strputs(os, (job->msg)[3], ie);
  dk3stream_c8_fputs(os, itadmin_netdocu_c8_kw[11]);
  dk3stream_c8_fputs(os, itadmin_netdocu_c8_kw[0]);
}



/**	Write section header for one user.
*/
static
void
itadmin_netdocu_write_sh_user(
  itadmin_job	*job,
  dk3_stream_t	*os,
  itadmin_user	*user
)
{
  int ie;
  ie = dk3app_get_encoding(job->app);
  dk3stream_c8_fputs(os, itadmin_netdocu_c8_kw[13]);
  itadmin_tool_write_user_latex_short(job, os, user);
  dk3stream_c8_fputs(os, itadmin_netdocu_c8_kw[14]);
  itadmin_tool_write_user_latex_long(job, os, user);
  dk3stream_c8_fputs(os, itadmin_netdocu_c8_kw[11]);
  dk3stream_c8_fputs(os, itadmin_netdocu_c8_kw[0]);
}



/**	Write section header "Other hosts"
	@param	job	Job structure.
	@param	os	Output stream.
*/
static
void
itadmin_netdocu_write_sh_others(itadmin_job *job, dk3_stream_t *os)
{
  int ie;
  ie = dk3app_get_encoding(job->app);
  dk3stream_c8_fputs(os, itadmin_netdocu_c8_kw[15]);
  dk3uc2lat_stputs(job->uc2l, os, (job->msg)[4], ie);
  dk3stream_c8_fputs(os, itadmin_netdocu_c8_kw[11]);
  dk3stream_c8_fputs(os, itadmin_netdocu_c8_kw[0]);
}



/**	Write section header "BYOD"
	@param	job	Job structure.
	@param	os	Output stream.
*/
static
void
itadmin_netdocu_write_sh_byod(itadmin_job *job, dk3_stream_t *os)
{
  int ie;
  ie = dk3app_get_encoding(job->app);
  dk3stream_c8_fputs(os, itadmin_netdocu_c8_kw[13]);
  dk3uc2lat_stputs(job->uc2l, os, (job->msg)[21], ie);
  dk3stream_c8_fputs(os, itadmin_netdocu_c8_kw[14]);
  dk3uc2lat_stputs(job->uc2l, os, (job->msg)[22], ie);
  dk3stream_c8_fputs(os, itadmin_netdocu_c8_kw[11]);
  dk3stream_c8_fputs(os, itadmin_netdocu_c8_kw[0]);
}



/**	Write data for one host.
	@param	job	Job structure.
	@param	os	Output stream.
	@param	host	Host to write.
*/
static
void
itadmin_netdocu_write_one_host(
  itadmin_job	*job,
  dk3_stream_t	*os,
  itadmin_host	*host
)
{
  itadmin_netgroup	*ng;
  char const		*p1;
  int			 ie;
  

#line 375 "itanetd.ctr"
  ie = dk3app_get_encoding(job->app);
  dk3stream_c8_fputs(os, itadmin_netdocu_c8_kw[16]);
  dk3uc2lat_c8_utf8_stputs(job->uc2l, os, host->sn);
  dk3stream_c8_fputs(os, itadmin_netdocu_c8_kw[11]);
  dk3stream_c8_fputs(os, itadmin_netdocu_c8_kw[0]);
  if(host->dp) {
    dk3uc2lat_stputs(job->uc2l, os, (job->msg)[20], ie);
    dk3stream_c8_fputs(os, itadmin_netdocu_c8_kw[20]);
    dk3stream_c8_fputs(os, itadmin_netdocu_c8_kw[0]);
  } else {
    if(host->fgu) {
      switch(host->fgu) {
	case 2: {	

#line 388 "itanetd.ctr"
	  dk3uc2lat_stputs(job->uc2l, os, (job->msg)[25], ie);
	  dk3stream_c8_fputs(os, itadmin_netdocu_c8_kw[0]);
	  dk3uc2lat_stputs(job->uc2l, os, (job->msg)[26], ie);
	  dk3stream_c8_fputs(os, itadmin_netdocu_c8_kw[0]);
	  dk3uc2lat_stputs(job->uc2l, os, (job->msg)[27], ie);
	  dk3stream_c8_fputs(os, itadmin_netdocu_c8_kw[20]);
	  dk3stream_c8_fputs(os, itadmin_netdocu_c8_kw[0]);
	} break;
	case 3: {	

#line 397 "itanetd.ctr"
	  dk3uc2lat_stputs(job->uc2l, os, (job->msg)[28], ie);
	  dk3stream_c8_fputs(os, itadmin_netdocu_c8_kw[20]);
	  dk3stream_c8_fputs(os, itadmin_netdocu_c8_kw[0]);
	} break;
	case 4: {	

#line 402 "itanetd.ctr"
	  dk3uc2lat_stputs(job->uc2l, os, (job->msg)[31], ie);
	  dk3stream_c8_fputs(os, itadmin_netdocu_c8_kw[20]);
	  dk3stream_c8_fputs(os, itadmin_netdocu_c8_kw[0]);
	} break;
        default: {	

#line 407 "itanetd.ctr"
	  dk3uc2lat_stputs(job->uc2l, os, (job->msg)[23], ie);
	  dk3stream_c8_fputs(os, itadmin_netdocu_c8_kw[0]);
	  dk3uc2lat_stputs(job->uc2l, os, (job->msg)[24], ie);
	  dk3stream_c8_fputs(os, itadmin_netdocu_c8_kw[20]);
	  dk3stream_c8_fputs(os, itadmin_netdocu_c8_kw[0]);
	} break;
      }
    }
  }
  /* begin{tabular}.... */
  dk3stream_c8_fputs(os, itadmin_netdocu_c8_kw[18]);
  dk3stream_c8_fputs(os, itadmin_netdocu_c8_kw[0]);

  itadmin_tool_table_section_header(job, os, 5);
  

#line 422 "itanetd.ctr"
  if(host->un) {
    itadmin_tool_table_line_start(job, os, 10);
    itadmin_tool_table_line_sep_rows(job, os);
    itadmin_tool_write_user_latex_long(job, os, host->un);
    itadmin_tool_table_line_finish(job, os, 0);
  } else {
    if(!(host->fgu)) {
      itadmin_tool_table_line(job, os, 10, NULL, 1, 0);
    }
  }
  

#line 433 "itanetd.ctr"
  itadmin_tool_table_line(job, os, 6, host->co, 1, 0);
  /* Ort (Gebaeude und Raum) */		

#line 435 "itanetd.ctr"
  itadmin_tool_table_line_start(job, os, 11);
  itadmin_tool_table_line_sep_rows(job, os);
  if(host->bu) {
    dk3uc2lat_c8_utf8_stputs(job->uc2l, os, (host->bu)->s);
    if(host->room) {
      dk3stream_c8_fputs(os, itadmin_netdocu_c8_kw[1]);
      dk3uc2lat_c8_utf8_stputs(job->uc2l, os, host->room);
    }
  } else {
    if(host->room) {
      dk3uc2lat_c8_utf8_stputs(job->uc2l, os, host->room);
    } else {
      itadmin_tool_table_line_no_data(job, os, 1);
    }
  }					

#line 450 "itanetd.ctr"
  itadmin_tool_table_line_finish(job, os, 0);
  itadmin_tool_table_line(job, os, 7, host->inv, 1, 0);
  itadmin_tool_table_line(job, os, 8, host->serno, 1, 1);

  itadmin_tool_table_section_header(job, os, 12);
  if(host->ipv4) {
    itadmin_tool_table_line_start(job, os, 13);
    itadmin_tool_table_line_sep_rows(job, os);
    itadmin_tool_stream_ip(os, host->ipv4);
    itadmin_tool_table_line_finish(job, os, 0);
    if(host->dnsd) {
      itadmin_tool_table_line(job, os, 14, host->dnsd, 0, 0);
    }
  } else {
    if(!(host->dc)) {
      itadmin_tool_table_line(job, os, 13, NULL, 1, 0);
    }
  }
  /* MAC-Adresse */
  itadmin_tool_table_line(job, os, 15, host->maca, 1, 0);
  /* Datendose */
  p1 = NULL;
  if(host->nc) { p1 = (host->nc)->s; }
  itadmin_tool_table_line(job, os, 16, p1, 1, 0);
  /* DHCP-Klasse */
  if(!((host->ipv4) || (host->dp))) {
    p1 = NULL;
    if(host->dc) { p1 = (host->dc)->sn; }
    itadmin_tool_table_line(job, os, 17, p1, 1, 0);
  }
  /* DHCP-Gruppe */
  p1 = NULL;
  if(host->dg) { p1 = (host->dg)->sn; }
  itadmin_tool_table_line(job, os, 18, p1, 0, 1);
  /* Netgroups */
  if(host->ng) {
    itadmin_tool_table_section_header(job, os, 19);
    itadmin_tool_table_values(job, os, (host->ng)->sn, (host->ng)->ln, 1, 0);
    dk3sto_it_reset(job->i_ng);
    while(NULL != (ng = (itadmin_netgroup *)dk3sto_it_next(job->i_ng))) {
      if(1 == itadmin_netgroup_host_member(job, ng, host)) {
        itadmin_tool_table_values(job,os, ng->sn, ng->ln, 0, 0);
      }
    }
  }
  /* end{tabular} */
  dk3stream_c8_fputs(os, itadmin_netdocu_c8_kw[19]);
  dk3stream_c8_fputs(os, itadmin_netdocu_c8_kw[0]);
  dk3stream_c8_fputs(os, itadmin_netdocu_c8_kw[17]);
  dk3stream_c8_fputs(os, itadmin_netdocu_c8_kw[0]);
  

#line 501 "itanetd.ctr"
}




/**	Write data for one host.
	@param	job	Job structure.
	@param	os	Output stream.
	@param	host	Host to write.
*/
static
void
itadmin_netdocu_write_byod_host(
  itadmin_job	*job,
  dk3_stream_t	*os,
  itadmin_host	*host
)
{
  char const		*p1;
  int			 ie;
  

#line 522 "itanetd.ctr"
  ie = dk3app_get_encoding(job->app);
  dk3stream_c8_fputs(os, itadmin_netdocu_c8_kw[16]);
  dk3uc2lat_c8_utf8_stputs(job->uc2l, os, host->sn);
  dk3stream_c8_fputs(os, itadmin_netdocu_c8_kw[11]);
  dk3stream_c8_fputs(os, itadmin_netdocu_c8_kw[0]);
  /* begin{tabular}.... */
  dk3stream_c8_fputs(os, itadmin_netdocu_c8_kw[18]);
  dk3stream_c8_fputs(os, itadmin_netdocu_c8_kw[0]);
  if(host->un) {
    itadmin_tool_table_line_start(job, os, 10);
    itadmin_tool_table_line_sep_rows(job, os);
    itadmin_tool_write_user_latex_long(job, os, host->un);
    itadmin_tool_table_line_finish(job, os, 0);
  } else {
  }
  itadmin_tool_table_line(job, os, 6, host->co, 1, 0);
  if(host->ipv4) {
    itadmin_tool_table_line_start(job, os, 13);
    itadmin_tool_table_line_sep_rows(job, os);
    itadmin_tool_stream_ip(os, host->ipv4);
    itadmin_tool_table_line_finish(job, os, 0);
  } else {
    if(!(host->dc)) {
      itadmin_tool_table_line(job, os, 13, NULL, 1, 0);
    }
  }
  /* MAC-Adresse */
  itadmin_tool_table_line(job, os, 15, host->maca, 1, 0);
  /* DHCP-Klasse */
  if(!((host->ipv4) || (host->dp))) {
    p1 = NULL;
    if(host->dc) { p1 = (host->dc)->sn; }
    itadmin_tool_table_line(job, os, 17, p1, 1, 0);
  }
  /* DHCP-Gruppe */
  if(host->dg) {
    p1 = NULL;
    if(host->dg) { p1 = (host->dg)->sn; }
    itadmin_tool_table_line(job, os, 18, p1, 0, 1);
  }
  /* end{tabular} */
  dk3stream_c8_fputs(os, itadmin_netdocu_c8_kw[19]);
  dk3stream_c8_fputs(os, itadmin_netdocu_c8_kw[0]);
  

#line 566 "itanetd.ctr"
}



/**	Check whether the host is a BRING YOUR OWN DEVICE computer.
	@param	host	The host to check.
	@return	1 for yes, 0 for no.
*/
static
int
itadmin_netdocu_is_byod(itadmin_host *host)
{
  int		back = 0;
  if(!(host->ipv4)) {
    if(host->dc) {
      if(host->fgu == 1) {
        back = 1;
      }
    }
  }
  return back;
}



/**	Write hosts section of network documentation.
	@param	job	Job structure.
	@param	os	Output stream.
*/
static
void
itadmin_netdocu_write_hosts(itadmin_job *job, dk3_stream_t *os)
{
  itadmin_user		*user;
  itadmin_host		*host;
  int			 hshw	= 0;	/* Flag: Host section header written. */
  int			 ushw;
  dk3sto_it_reset(job->i_us);
  while(NULL != (user = (itadmin_user *)dk3sto_it_next(job->i_usn))) {
    ushw = 0;
    if(user->i_ho) {
      dk3sto_it_reset(user->i_ho);
      while(NULL != (host = (itadmin_host *)dk3sto_it_next(user->i_ho))) {
        if(!(host->snd)) {
	  if(!(hshw)) {
	    itadmin_netdocu_write_sh_hosts(job, os);
	    hshw = 1;
	  }
	  if(!(ushw)) {
	    itadmin_netdocu_write_sh_user(job, os, user);
	    ushw = 1;
	  }
	  itadmin_netdocu_write_one_host(job, os, host);
	}
      }
    }
  }
  ushw = 0;
  dk3sto_it_reset(job->i_ho);
  while(NULL != (host = (itadmin_host *)dk3sto_it_next(job->i_ho))) {
    if(!(host->un)) {
      if(!(host->snd)) {
        if(!itadmin_netdocu_is_byod(host)) {
          if(!(hshw)) {
	    itadmin_netdocu_write_sh_hosts(job, os);
	    hshw = 1;
	  }
	  if(!(ushw)) {
	    itadmin_netdocu_write_sh_others(job, os);
	    ushw = 1;
	  }
	  itadmin_netdocu_write_one_host(job, os, host);
	}
      }
    }
  }
  ushw = 0;
  dk3sto_it_reset(job->i_ho);
  while(NULL != (host = (itadmin_host *)dk3sto_it_next(job->i_ho))) {
    if(!(host->un)) {
      if(!(host->snd)) {
        if(itadmin_netdocu_is_byod(host)) {
          if(!(hshw)) {
	    itadmin_netdocu_write_sh_hosts(job, os);
	    hshw = 1;
	  }
	  if(!(ushw)) {
	    itadmin_netdocu_write_sh_byod(job, os);
	    ushw = 1;
	  }
	  itadmin_netdocu_write_byod_host(job, os, host);
	}
      }
    }
  }
  if(ushw) {
    dk3stream_c8_fputs(os, itadmin_netdocu_c8_kw[17]);
    dk3stream_c8_fputs(os, itadmin_netdocu_c8_kw[0]);
  }
}



/**	Write start of longtable for Netgroup member hosts.
	@param	job	job structure.
	@param	os	Output stream.
*/
static
void
itadmin_netdocu_write_netgroup_member_longtable(
  itadmin_job	*job,
  dk3_stream_t	*os
)
{
  int	ie;
  ie = dk3app_get_encoding(job->app);
  dk3stream_c8_fputs(os, itadmin_netdocu_c8_kw[16]);
  dk3uc2lat_stputs(job->uc2l, os, (job->msg)[32], ie);
  dk3stream_c8_fputs(os, itadmin_netdocu_c8_kw[11]);
  dk3stream_c8_fputs(os, itadmin_netdocu_c8_kw[0]);
  dk3stream_c8_fputs(os, itadmin_netdocu_c8_kw[27]);
  dk3stream_c8_fputs(os, itadmin_netdocu_c8_kw[0]);
  dk3stream_c8_fputs(os, itadmin_netdocu_c8_kw[28]);
  dk3stream_c8_fputs(os, itadmin_netdocu_c8_kw[0]);
  dk3stream_c8_fputs(os, itadmin_netdocu_c8_kw[29]);
  dk3stream_c8_fputs(os, itadmin_netdocu_c8_kw[0]);
  dk3stream_c8_fputs(os, itadmin_netdocu_c8_kw[30]);
  dk3stream_c8_fputs(os, itadmin_netdocu_c8_kw[0]);
  dk3stream_c8_fputs(os, itadmin_netdocu_c8_kw[31]);
  dk3stream_c8_fputs(os, itadmin_netdocu_c8_kw[0]);
}



/**	Write one member host to longtable.
	@param	job	Job structure.
	@param	os	Output stream.
	@param	ng	Netgroup.
	@param	ho	Host.
	@param	f_d	Flag: Direct member (write bold).
*/
static
void
itadmin_netdocu_write_netgroup_member_host(
  itadmin_job		*job,
  dk3_stream_t		*os,
  itadmin_netgroup	*ng,
  itadmin_host		*ho,
  int			 f_d
)
{
  if(f_d) {
    dk3stream_c8_fputs(os, itadmin_netdocu_c8_kw[26]);
  }
  dk3uc2lat_c8_utf8_stputs(job->uc2l, os, ho->sn);
  if(f_d) {
    dk3stream_c8_fputs(os, itadmin_netdocu_c8_kw[11]);
  }
  dk3stream_c8_fputs(os, itadmin_netdocu_c8_kw[24]);
  if(ho->co) {
    dk3uc2lat_c8_utf8_stputs(job->uc2l, os, ho->co);
  }
  dk3stream_c8_fputs(os, itadmin_netdocu_c8_kw[25]);
  dk3stream_c8_fputs(os, itadmin_netdocu_c8_kw[0]);
}

/**	Write netgroups section.
	@param	job	Job structure.
	@param	os	Output stream.
*/
static
int
itadmin_netdocu_write_netgroups(itadmin_job *job, dk3_stream_t *os)
{
  itadmin_netgroup	*ng;
  itadmin_netgroup	*ng2;
  itadmin_host		*ho;
  dk3_sto_it_t		*i_ng2;
  int			 ng_found	= 0;
  int			 sh_found	= 0;
  int			 ie;
  int			 back		= 1;
  
  ie = dk3app_get_encoding(job->app);
  dk3sto_it_reset(job->i_ng);
  while(NULL != (ng = (itadmin_netgroup *)dk3sto_it_next(job->i_ng))) {
    sh_found = 0;
    if(!(ng_found)) {
      dk3stream_c8_fputs(os, itadmin_netdocu_c8_kw[12]);
      dk3uc2lat_stputs(job->uc2l, os, (job->msg)[19], ie);
      dk3stream_c8_fputs(os, itadmin_netdocu_c8_kw[11]);
      dk3stream_c8_fputs(os, itadmin_netdocu_c8_kw[0]);
      ng_found = 1;
    }
    dk3stream_c8_fputs(os, itadmin_netdocu_c8_kw[15]);
    dk3uc2lat_c8_utf8_stputs(job->uc2l, os, ng->sn);
    dk3stream_c8_fputs(os, itadmin_netdocu_c8_kw[11]);
    dk3stream_c8_fputs(os, itadmin_netdocu_c8_kw[0]);
    if(ng->ln) {
      dk3uc2lat_c8_utf8_stputs(job->uc2l, os, ng->ln);
      dk3stream_c8_fputs(os, itadmin_netdocu_c8_kw[0]);
    }
    i_ng2 = dk3sto_it_open(job->s_ng);
    if(i_ng2) {
      dk3sto_it_reset(i_ng2);
      sh_found = 0;
      while(NULL != (ng2 = (itadmin_netgroup *)dk3sto_it_next(i_ng2))) {
        if(ng->no != ng2->no) {
	  if(dk3bm_get(job->ngdep, ng->no, ng2->no)) {
	    if(!(sh_found)) {
              dk3stream_c8_fputs(os, itadmin_netdocu_c8_kw[16]);
              dk3uc2lat_stputs(job->uc2l, os, (job->msg)[29], ie);
              dk3stream_c8_fputs(os, itadmin_netdocu_c8_kw[11]);
              dk3stream_c8_fputs(os, itadmin_netdocu_c8_kw[0]);
	      dk3stream_c8_fputs(os, itadmin_netdocu_c8_kw[18]);
	      dk3stream_c8_fputs(os, itadmin_netdocu_c8_kw[0]);
	    } sh_found = 1;
	    dk3uc2lat_c8_utf8_stputs(job->uc2l, os, ng2->sn);
	    dk3stream_c8_fputs(os, itadmin_netdocu_c8_kw[24]);
	    if(ng2->ln) {
	      dk3uc2lat_c8_utf8_stputs(job->uc2l, os, ng2->ln);
	    }
	    dk3stream_c8_fputs(os, itadmin_netdocu_c8_kw[25]);
	    dk3stream_c8_fputs(os, itadmin_netdocu_c8_kw[0]);
	  }
	}
      }
      if(sh_found) {
        dk3stream_c8_fputs(os, itadmin_netdocu_c8_kw[19]);
	dk3stream_c8_fputs(os, itadmin_netdocu_c8_kw[0]);
      }
      dk3sto_it_reset(i_ng2);
      sh_found = 0;
      while(NULL != (ng2 = (itadmin_netgroup *)dk3sto_it_next(i_ng2))) {
        if(ng->no != ng2->no) {
	  if(dk3bm_get(job->ngdep, ng2->no, ng->no)) {
	    if(!(sh_found)) {
              dk3stream_c8_fputs(os, itadmin_netdocu_c8_kw[16]);
              dk3uc2lat_stputs(job->uc2l, os, (job->msg)[30], ie);
              dk3stream_c8_fputs(os, itadmin_netdocu_c8_kw[11]);
              dk3stream_c8_fputs(os, itadmin_netdocu_c8_kw[0]);
	      dk3stream_c8_fputs(os, itadmin_netdocu_c8_kw[18]);
	      dk3stream_c8_fputs(os, itadmin_netdocu_c8_kw[0]);
	    } sh_found = 1;
	    dk3uc2lat_c8_utf8_stputs(job->uc2l, os, ng2->sn);
	    dk3stream_c8_fputs(os, itadmin_netdocu_c8_kw[24]);
	    if(ng2->ln) {
	      dk3uc2lat_c8_utf8_stputs(job->uc2l, os, ng2->ln);
	    }
	    dk3stream_c8_fputs(os, itadmin_netdocu_c8_kw[25]);
	    dk3stream_c8_fputs(os, itadmin_netdocu_c8_kw[0]);
	  }
	}
      }
      if(sh_found) {
        dk3stream_c8_fputs(os, itadmin_netdocu_c8_kw[19]);
	dk3stream_c8_fputs(os, itadmin_netdocu_c8_kw[0]);
      }
      dk3sto_it_close(i_ng2);
    }
    /* Member hosts */
    dk3sto_it_reset(job->i_ho);
    sh_found = 0;
    while(NULL != (ho = (itadmin_host *)dk3sto_it_next(job->i_ho))) {
      if(2 == itadmin_netgroup_host_member(job, ng, ho)) {
        if(!(sh_found)) {
	  itadmin_netdocu_write_netgroup_member_longtable(job, os);
	} sh_found = 1;
	itadmin_netdocu_write_netgroup_member_host(job, os, ng, ho, 1);
      }
    }
    dk3sto_it_reset(job->i_ho);
    while(NULL != (ho = (itadmin_host *)dk3sto_it_next(job->i_ho))) {
      if(1 == itadmin_netgroup_host_member(job, ng, ho)) {
        if(!(sh_found)) {
	  itadmin_netdocu_write_netgroup_member_longtable(job, os);
	} sh_found = 1;
	itadmin_netdocu_write_netgroup_member_host(job, os, ng, ho, 0);
      }
    }
    if(sh_found) {
      dk3stream_c8_fputs(os, itadmin_netdocu_c8_kw[32]);
      dk3stream_c8_fputs(os, itadmin_netdocu_c8_kw[0]);
    }
    dk3stream_c8_fputs(os, itadmin_netdocu_c8_kw[17]);
    dk3stream_c8_fputs(os, itadmin_netdocu_c8_kw[0]);
  }
  return back;
}




/**	Write DHCP pools list.
	@param	job	Job structure.
	@param	os	Output stream.
*/
static
void
itadmin_netdocu_write_dhcp_pools(itadmin_job *job, dk3_stream_t *os)
{
  itadmin_dhcp_pool	*po;
  int			 is_first = 1;
  int			 ie;
  ie = dk3app_get_encoding(job->app);
  dk3sto_it_reset(job->i_dp);
  while(NULL != (po = (itadmin_dhcp_pool *)dk3sto_it_next(job->i_dp))) {
    if(is_first) {
      dk3stream_c8_fputs(os, itadmin_netdocu_c8_kw[12]);
      dk3uc2lat_stputs(job->uc2l, os, (job->msg)[33], ie);
      dk3stream_c8_fputs(os, itadmin_netdocu_c8_kw[11]);
      dk3stream_c8_fputs(os, itadmin_netdocu_c8_kw[0]);
    } else {
      dk3stream_c8_fputs(os, itadmin_netdocu_c8_kw[33]);
      dk3stream_c8_fputs(os, itadmin_netdocu_c8_kw[0]);
    } is_first = 0;
    dk3stream_c8_fputs(os, itadmin_netdocu_c8_kw[15]);
    itadmin_tool_stream_ip(os, po->ip4s);
    dk3stream_c8_fputs(os, itadmin_netdocu_c8_kw[11]);
    dk3stream_c8_fputs(os, itadmin_netdocu_c8_kw[0]);
    dk3stream_c8_fputs(os, itadmin_netdocu_c8_kw[18]);
    dk3stream_c8_fputs(os, itadmin_netdocu_c8_kw[0]);
    dk3uc2lat_stputs(job->uc2l, os, (job->msg)[34], ie);
    dk3stream_c8_fputs(os, itadmin_netdocu_c8_kw[24]);
    itadmin_tool_stream_ip(os, po->ip4s);
    dk3stream_c8_fputs(os, itadmin_netdocu_c8_kw[25]);
    dk3stream_c8_fputs(os, itadmin_netdocu_c8_kw[0]);
    dk3uc2lat_stputs(job->uc2l, os, (job->msg)[35], ie);
    dk3stream_c8_fputs(os, itadmin_netdocu_c8_kw[24]);
    itadmin_tool_stream_ip(os, po->ip4e);
    dk3stream_c8_fputs(os, itadmin_netdocu_c8_kw[25]);
    dk3stream_c8_fputs(os, itadmin_netdocu_c8_kw[0]);
    dk3uc2lat_stputs(job->uc2l, os, (job->msg)[36], ie);
    dk3stream_c8_fputs(os, itadmin_netdocu_c8_kw[24]);
    dk3uc2lat_stputs(job->uc2l, os, (job->msg)[(po->auc) ? 39 : 40], ie);
    dk3stream_c8_fputs(os, itadmin_netdocu_c8_kw[25]);
    dk3stream_c8_fputs(os, itadmin_netdocu_c8_kw[0]);
    dk3uc2lat_stputs(job->uc2l, os, (job->msg)[37], ie);
    dk3stream_c8_fputs(os, itadmin_netdocu_c8_kw[24]);
    dk3uc2lat_stputs(job->uc2l, os, (job->msg)[(po->duc) ? 39 : 40], ie);
    dk3stream_c8_fputs(os, itadmin_netdocu_c8_kw[25]);
    dk3stream_c8_fputs(os, itadmin_netdocu_c8_kw[0]);
    if(po->acl) {
      if((po->acl)->sn) {
        dk3uc2lat_stputs(job->uc2l, os, (job->msg)[38], ie);
        dk3stream_c8_fputs(os, itadmin_netdocu_c8_kw[24]);
        dk3uc2lat_c8_utf8_stputs(job->uc2l, os, (po->acl)->sn);
        dk3stream_c8_fputs(os, itadmin_netdocu_c8_kw[25]);
        dk3stream_c8_fputs(os, itadmin_netdocu_c8_kw[0]);
      }
    }
    dk3stream_c8_fputs(os, itadmin_netdocu_c8_kw[19]);
    dk3stream_c8_fputs(os, itadmin_netdocu_c8_kw[0]);
  }
  if(0 == is_first) {
    dk3stream_c8_fputs(os, itadmin_netdocu_c8_kw[17]);
    dk3stream_c8_fputs(os, itadmin_netdocu_c8_kw[0]);
  }
}



/**	Write DHCP classes list.
	@param	job	Job structure.
	@param	os	Output stream.
*/
static
void
itadmin_netdocu_write_dhcp_classes(itadmin_job *job, dk3_stream_t *os)
{
  itadmin_dhcp_class	*dc;
  itadmin_host		*ho;
  int			 is_first = 1;
  int			 first_host;
  int			 ie;
  ie = dk3app_get_encoding(job->app);
  dk3sto_it_reset(job->i_dc);
  while(NULL != (dc = (itadmin_dhcp_class *)dk3sto_it_next(job->i_dc))) {
    if(is_first) {
      dk3stream_c8_fputs(os, itadmin_netdocu_c8_kw[12]);
      dk3uc2lat_stputs(job->uc2l, os, (job->msg)[41], ie);
      dk3stream_c8_fputs(os, itadmin_netdocu_c8_kw[11]);
      dk3stream_c8_fputs(os, itadmin_netdocu_c8_kw[0]);
    } else {
    }
    is_first = 0;
    dk3stream_c8_fputs(os, itadmin_netdocu_c8_kw[15]);
    dk3uc2lat_c8_utf8_stputs(job->uc2l, os, dc->sn);
    dk3stream_c8_fputs(os, itadmin_netdocu_c8_kw[11]);
    dk3stream_c8_fputs(os, itadmin_netdocu_c8_kw[0]);
    if(dc->ln) {
      dk3uc2lat_c8_utf8_stputs(job->uc2l, os, dc->ln);
      dk3stream_c8_fputs(os, itadmin_netdocu_c8_kw[0]);
    }
    if(dc->i_ho) {
      dk3sto_it_reset(dc->i_ho);
      first_host = 1;
      while(NULL != (ho = (itadmin_host *)dk3sto_it_next(dc->i_ho))) {
        if(first_host) {
          dk3stream_c8_fputs(os, itadmin_netdocu_c8_kw[27]);
          dk3stream_c8_fputs(os, itadmin_netdocu_c8_kw[0]);
          dk3stream_c8_fputs(os, itadmin_netdocu_c8_kw[28]);
          dk3stream_c8_fputs(os, itadmin_netdocu_c8_kw[0]);
          dk3stream_c8_fputs(os, itadmin_netdocu_c8_kw[29]);
          dk3stream_c8_fputs(os, itadmin_netdocu_c8_kw[0]);
          dk3stream_c8_fputs(os, itadmin_netdocu_c8_kw[30]);
          dk3stream_c8_fputs(os, itadmin_netdocu_c8_kw[0]);
          dk3stream_c8_fputs(os, itadmin_netdocu_c8_kw[31]);
          dk3stream_c8_fputs(os, itadmin_netdocu_c8_kw[0]);
	} first_host = 0;
        dk3uc2lat_c8_utf8_stputs(job->uc2l, os, ho->sn);
	dk3stream_c8_fputs(os, itadmin_netdocu_c8_kw[24]);
	if(ho->co) {
	  dk3uc2lat_c8_utf8_stputs(job->uc2l, os, ho->co);
	}
	dk3stream_c8_fputs(os, itadmin_netdocu_c8_kw[25]);
	dk3stream_c8_fputs(os, itadmin_netdocu_c8_kw[0]);
      }
      if(!(first_host)) {
        dk3stream_c8_fputs(os, itadmin_netdocu_c8_kw[32]);
	dk3stream_c8_fputs(os, itadmin_netdocu_c8_kw[0]);
      }
    }
    dk3stream_c8_fputs(os, itadmin_netdocu_c8_kw[17]);
    dk3stream_c8_fputs(os, itadmin_netdocu_c8_kw[0]);
  }
}



/**	Write patches list.
	@param	job	Job structure.
	@param	os	Output stream.
*/
static
void
itadmin_netdocu_write_patches(itadmin_job *job, dk3_stream_t *os)
{
  itadmin_connect	*co;
  int			 is_first = 1;
  int			 ie;
  

#line 1008 "itanetd.ctr"
  ie = dk3app_get_encoding(job->app);
  dk3sto_it_reset(job->i_pa);
  while(NULL != (co = (itadmin_connect *)dk3sto_it_next(job->i_pa))) {
    if(is_first) {		

#line 1012 "itanetd.ctr"
      /* Section patches */
      dk3stream_c8_fputs(os, itadmin_netdocu_c8_kw[12]);
      dk3uc2lat_stputs(job->uc2l, os, (job->msg)[42], ie);
      dk3stream_c8_fputs(os, itadmin_netdocu_c8_kw[11]);
      dk3stream_c8_fputs(os, itadmin_netdocu_c8_kw[0]);
      /* begin longtable */
      dk3stream_c8_fputs(os, itadmin_netdocu_c8_kw[34]);
      dk3stream_c8_fputs(os, itadmin_netdocu_c8_kw[0]);
      dk3stream_c8_fputs(os, itadmin_netdocu_c8_kw[35]);
      dk3stream_c8_fputs(os, itadmin_netdocu_c8_kw[0]);
      dk3stream_c8_fputs(os, itadmin_netdocu_c8_kw[36]);
      dk3uc2lat_stputs(job->uc2l, os, (job->msg)[43], ie);
      dk3stream_c8_fputs(os, itadmin_netdocu_c8_kw[38]);
      dk3stream_c8_fputs(os, itadmin_netdocu_c8_kw[24]);
      dk3stream_c8_fputs(os, itadmin_netdocu_c8_kw[36]);
      dk3uc2lat_stputs(job->uc2l, os, (job->msg)[44], ie);
      dk3stream_c8_fputs(os, itadmin_netdocu_c8_kw[38]);
      dk3stream_c8_fputs(os, itadmin_netdocu_c8_kw[24]);
      dk3stream_c8_fputs(os, itadmin_netdocu_c8_kw[36]);
      dk3uc2lat_stputs(job->uc2l, os, (job->msg)[45], ie);
      dk3stream_c8_fputs(os, itadmin_netdocu_c8_kw[38]);
      dk3stream_c8_fputs(os, itadmin_netdocu_c8_kw[24]);
      dk3stream_c8_fputs(os, itadmin_netdocu_c8_kw[36]);
      dk3uc2lat_stputs(job->uc2l, os, (job->msg)[46], ie);
      dk3stream_c8_fputs(os, itadmin_netdocu_c8_kw[38]);
      dk3stream_c8_fputs(os, itadmin_netdocu_c8_kw[24]);
      dk3stream_c8_fputs(os, itadmin_netdocu_c8_kw[37]);
      dk3uc2lat_stputs(job->uc2l, os, (job->msg)[47], ie);
      dk3stream_c8_fputs(os, itadmin_netdocu_c8_kw[38]);
      dk3stream_c8_fputs(os, itadmin_netdocu_c8_kw[25]);
      dk3stream_c8_fputs(os, itadmin_netdocu_c8_kw[0]);
      dk3stream_c8_fputs(os, itadmin_netdocu_c8_kw[35]);
      dk3stream_c8_fputs(os, itadmin_netdocu_c8_kw[0]);
      /* end first header */
      dk3stream_c8_fputs(os, itadmin_netdocu_c8_kw[28]);
      dk3stream_c8_fputs(os, itadmin_netdocu_c8_kw[0]);
      dk3stream_c8_fputs(os, itadmin_netdocu_c8_kw[35]);
      dk3stream_c8_fputs(os, itadmin_netdocu_c8_kw[0]);
      dk3stream_c8_fputs(os, itadmin_netdocu_c8_kw[36]);
      dk3uc2lat_stputs(job->uc2l, os, (job->msg)[43], ie);
      dk3stream_c8_fputs(os, itadmin_netdocu_c8_kw[38]);
      dk3stream_c8_fputs(os, itadmin_netdocu_c8_kw[24]);
      dk3stream_c8_fputs(os, itadmin_netdocu_c8_kw[36]);
      dk3uc2lat_stputs(job->uc2l, os, (job->msg)[44], ie);
      dk3stream_c8_fputs(os, itadmin_netdocu_c8_kw[38]);
      dk3stream_c8_fputs(os, itadmin_netdocu_c8_kw[24]);
      dk3stream_c8_fputs(os, itadmin_netdocu_c8_kw[36]);
      dk3uc2lat_stputs(job->uc2l, os, (job->msg)[45], ie);
      dk3stream_c8_fputs(os, itadmin_netdocu_c8_kw[38]);
      dk3stream_c8_fputs(os, itadmin_netdocu_c8_kw[24]);
      dk3stream_c8_fputs(os, itadmin_netdocu_c8_kw[36]);
      dk3uc2lat_stputs(job->uc2l, os, (job->msg)[46], ie);
      dk3stream_c8_fputs(os, itadmin_netdocu_c8_kw[38]);
      dk3stream_c8_fputs(os, itadmin_netdocu_c8_kw[24]);
      dk3stream_c8_fputs(os, itadmin_netdocu_c8_kw[37]);
      dk3uc2lat_stputs(job->uc2l, os, (job->msg)[47], ie);
      dk3stream_c8_fputs(os, itadmin_netdocu_c8_kw[38]);
      dk3stream_c8_fputs(os, itadmin_netdocu_c8_kw[25]);
      dk3stream_c8_fputs(os, itadmin_netdocu_c8_kw[0]);
      dk3stream_c8_fputs(os, itadmin_netdocu_c8_kw[35]);
      dk3stream_c8_fputs(os, itadmin_netdocu_c8_kw[0]);
      /* end header */
      dk3stream_c8_fputs(os, itadmin_netdocu_c8_kw[29]);
      dk3stream_c8_fputs(os, itadmin_netdocu_c8_kw[0]);
      /* end footer */
      dk3stream_c8_fputs(os, itadmin_netdocu_c8_kw[30]);
      dk3stream_c8_fputs(os, itadmin_netdocu_c8_kw[0]);
      /* end last footer */
      dk3stream_c8_fputs(os, itadmin_netdocu_c8_kw[35]);
      dk3stream_c8_fputs(os, itadmin_netdocu_c8_kw[0]);
      dk3stream_c8_fputs(os, itadmin_netdocu_c8_kw[31]);
      dk3stream_c8_fputs(os, itadmin_netdocu_c8_kw[0]);
    } is_first = 0;		

#line 1085 "itanetd.ctr"

    /* Horitontal line */
    dk3stream_c8_fputs(os, itadmin_netdocu_c8_kw[35]);
    dk3stream_c8_fputs(os, itadmin_netdocu_c8_kw[0]);
    /* Dose */			

#line 1090 "itanetd.ctr"
    dk3uc2lat_c8_utf8_stputs(job->uc2l, os, co->s);
    dk3stream_c8_fputs(os, itadmin_netdocu_c8_kw[24]);
    /* Gebaeude + Raum */		

#line 1093 "itanetd.ctr"
    if(co->bu) {
      if((co->bu)->s) {
        dk3uc2lat_c8_utf8_stputs(job->uc2l, os, (co->bu)->s);
        if(co->room) {
          dk3stream_c8_fputs(os, itadmin_netdocu_c8_kw[1]);
          dk3uc2lat_c8_utf8_stputs(job->uc2l, os, co->room);
        }
      } else {
        if(co->room) {
          dk3uc2lat_c8_utf8_stputs(job->uc2l, os, co->room);
        }
      }
    } else {
      if(co->room) {
        dk3uc2lat_c8_utf8_stputs(job->uc2l, os, co->room);
      }
    }
    dk3stream_c8_fputs(os, itadmin_netdocu_c8_kw[24]);
    /* VLAN */			

#line 1112 "itanetd.ctr"
    if(co->vl) {
      if((co->vl)->s) {
        dk3uc2lat_c8_utf8_stputs(job->uc2l, os, (co->vl)->s);
      }
    }
    dk3stream_c8_fputs(os, itadmin_netdocu_c8_kw[24]);
    /* Speed */			

#line 1119 "itanetd.ctr"
    if(co->sp) {
      if((co->sp)->s) {
        dk3uc2lat_c8_utf8_stputs(job->uc2l, os, (co->sp)->s);
      }
    }
    dk3stream_c8_fputs(os, itadmin_netdocu_c8_kw[24]);
    /* Hub port */		

#line 1126 "itanetd.ctr"
    if(co->hp) {
      dk3uc2lat_c8_utf8_stputs(job->uc2l, os, co->hp);
    }
    dk3stream_c8_fputs(os, itadmin_netdocu_c8_kw[25]);
    dk3stream_c8_fputs(os, itadmin_netdocu_c8_kw[0]);
  }				

#line 1132 "itanetd.ctr"
  if(!(is_first)) {
    dk3stream_c8_fputs(os, itadmin_netdocu_c8_kw[32]);
    dk3stream_c8_fputs(os, itadmin_netdocu_c8_kw[0]);
  } 

#line 1136 "itanetd.ctr"
}



/**	Write contents of network documentation.
	@param	job	Job structure.
	@param	os	Output stream.
*/
static
void
itadmin_netdocu_write_contents(itadmin_job *job, dk3_stream_t *os)
{
  itadmin_netdocu_write_hosts(job, os);
  itadmin_netdocu_write_netgroups(job, os);
  itadmin_netdocu_write_dhcp_pools(job, os);
  itadmin_netdocu_write_dhcp_classes(job, os);
  itadmin_netdocu_write_patches(job, os);
}



/**	Write entire output file.
  @param	job	Job structure.
  @param	os	Output stream.
 */
static
void
itadmin_netdocu_write_file(itadmin_job *job, dk3_stream_t *os)
{
  int	ie;
  ie = dk3app_get_encoding(job->app);
  if(job->ukoma) {
    itadmin_tool_write_section(job, os, itadmin_netdocu_file_start1a);
  } else {
    itadmin_tool_write_section(job, os, itadmin_netdocu_file_start1b);
  }
  dk3stream_c8_fputs(os, itadmin_netdocu_c8_kw[0]);
  dk3stream_strputs(os, (job->msg)[2], ie);
  dk3stream_c8_fputs(os, itadmin_netdocu_c8_kw[0]);
  itadmin_tool_write_section(job, os, itadmin_netdocu_file_start4);
  dk3stream_c8_fputs(os, itadmin_netdocu_c8_kw[4]);
  dk3stream_strputs(os, (job->msg)[0], ie);
  dk3stream_c8_fputs(os, itadmin_netdocu_c8_kw[5]);
  dk3stream_c8_fputs(os, itadmin_netdocu_c8_kw[0]);
  dk3stream_c8_fputs(os, itadmin_netdocu_c8_kw[6]);
  dk3stream_strputs(os, (job->msg)[1], ie);
  dk3stream_c8_fputs(os, itadmin_netdocu_c8_kw[5]);
  dk3stream_c8_fputs(os, itadmin_netdocu_c8_kw[0]);
  if(job->admn) {
    dk3stream_c8_fputs(os, itadmin_netdocu_c8_kw[7]);
    dk3stream_strputs(os, job->admn, ie);
    dk3stream_c8_fputs(os, itadmin_netdocu_c8_kw[5]);
    dk3stream_c8_fputs(os, itadmin_netdocu_c8_kw[0]);
  }
  dk3stream_c8_fputs(os, itadmin_netdocu_c8_kw[8]);
  dk3stream_c8_fputs(os, itadmin_netdocu_c8_kw[0]);
  itadmin_tool_write_section(job, os, itadmin_netdocu_file_start2);

  dk3stream_c8_fputs(os, itadmin_netdocu_c8_kw[10]);
  dk3stream_strputs(os, (job->msg)[0], ie);
  dk3stream_c8_fputs(os, itadmin_netdocu_c8_kw[11]);
  dk3stream_c8_fputs(os, itadmin_netdocu_c8_kw[0]);
  if(job->admn) {
    dk3stream_c8_fputs(os, itadmin_netdocu_c8_kw[9]);
    dk3stream_strputs(os, job->admn, ie);
    dk3stream_c8_fputs(os, itadmin_netdocu_c8_kw[11]);
    dk3stream_c8_fputs(os, itadmin_netdocu_c8_kw[0]);
  }
  if(job->ukoma) {
    itadmin_tool_write_section(job, os, itadmin_netdocu_file_start3a);
  }
  itadmin_tool_write_section(job, os, itadmin_netdocu_file_start3);
  itadmin_netdocu_write_contents(job, os);
  itadmin_tool_write_section(job, os, itadmin_netdocu_file_end);
}



int
itadmin_netdocu(itadmin_job *job)
{
  FILE			*fipo;
  dk3_stream_t		*os;
  int			 back = 0;
  

#line 1221 "itanetd.ctr"
    fipo = dk3sf_c8_fopen_app(
	itadmin_netdocu_c8_kw[3], itadmin_netdocu_c8_kw[2], job->app
	);
  if(fipo) {					

#line 1225 "itanetd.ctr"
    os = dk3stream_open_file_app(fipo, DK3_STREAM_FLAG_WRITE, job->app);
    if(os) {					

#line 1227 "itanetd.ctr"
      itadmin_netdocu_write_file(job, os);
      dk3stream_close(os);
      back = 1;
    } else {					

#line 1231 "itanetd.ctr"
    }
#if DK3_CHAR_SIZE == 1
    if(!dk3sf_fclose_fn_app(fipo, itadmin_netdocu_c8_kw[3], job->app)) {
      back = 0;
    }
#else
    if(!dk3sf_fclose_fn_app(fipo, NULL, job->app)) {
      back = 0;
    }
#endif
  } else {					

#line 1242 "itanetd.ctr"
  }
  

#line 1244 "itanetd.ctr"
  return back;
}


