/*
	WARNING: This file was generated by dkct.
	Changes you make here will be lost if dkct is run again!
	You should modify the original source and run dkct on it.
	Original source: itamysql.ctr
*/

/*
Copyright (C) 2012-2014, Dirk Krause

Redistribution and use in source and binary forms, with or without
modification, are permitted provided that the following conditions are met:

* Redistributions of source code must retain the above copyright notice,
  this list of conditions and the following disclaimer.
* Redistributions in binary form must reproduce the above opyright notice,
  this list of conditions and the following disclaimer in the documentation
  and/or other materials provided with the distribution.
* Neither the name of the author nor the names of contributors may be used
  to endorse or promote products derived from this software without specific
  prior written permission.

THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS ``AS IS''
AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
ARE DISCLAIMED.
IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE LIABLE FOR ANY
DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
(INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
(INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
*/

/**	@file itamysql.c The itamysql module.
*/


#line 10 "itamysql.ctr"

#include "dk3all.h"
#include "itadmin.h"

#if DK3_HAVE_MYSQL_MYSQL_H
#include <mysql/mysql.h>
#endif





#line 21 "itamysql.ctr"



#if DK3_HAVE_MYSQL_MYSQL_H


/**	Keywords used by this module.
*/
static char const *itadmin_mysql_c8_kw[] = {
/* 0 */
"select * from users",

/* 1 */
"select * from buildings",

/* 2 */
"select * from vlans",

/* 3 */
"select * from patches",

/* 4 */
"select * from ddspeed",

/* 5 */
"select * from networks",

/* 6 */
"select * from netgroups",

/* 7 */
"select * from ngdeps",

/* 8 */
"select * from dhcpclasses",

/* 9 */
"select * from dhcpgroups",

/* 10 */
"select * from dhcppools",

/* 11 */
"select * from computers",

/* 12 */
"select * from aliases",

/* 13 */
"select * from dhcpoptions",

/* 14 */
"select * from swmanufacturers",

/* 15 */
"select * from swproducts",

/* 16 */
"select * from licensetypes",

/* 17 */
"select * from licenses",

NULL


#line 104 "itamysql.ctr"
};



/**	Configuration section name "itadmin".
*/
static char itadmin_mysql_arg_0[] = {
  'i', 't', 'a', 'd', 'm', 'i', 'n', '\0'
};


/**	Configuration section name "client".
*/
static char itadmin_mysql_gr_client[] = {
  'c', 'l', 'i', 'e', 'n', 't', '\0'
};


/**	Argv array to initialize the library.
*/
static char *itadmin_mysql_argv[] = {
  itadmin_mysql_arg_0,
  NULL
};


/**	Groups (configuration file section) names.
*/
static char *itadmin_mysql_groups[] = {
  itadmin_mysql_gr_client,
  itadmin_mysql_arg_0,
  NULL
};


/**	Elements from users table.
*/
static char const * const	itadmin_mysql_cn_users[] = {
/* 0 */
"us_s",

/* 1 */
"us_t",

/* 2 */
"us_sn",

/* 3 */
"us_fn",

/* 4 */
"us_em",

/* 5 */
"us_ko",

/* 6 */
"us_se",

NULL


#line 151 "itamysql.ctr"
};

/**	Number of elements in itadmin_mysql_cn_users.
*/
static size_t const	itadmin_mysql_sz_cn_users =
sizeof(itadmin_mysql_cn_users)/sizeof(DK3_PCCHAR) - 1;


/**	Elements from buildings table.
*/
static char const * const       itadmin_mysql_cn_buildings[] = {
/* 0 */
"gb_s",

/* 1 */
"gb_l",

/* 2 */
"gb_a1",

/* 3 */
"gb_a2",

/* 4 */
"gb_a3",

/* 5 */
"gb_a4",

/* 6 */
"gb_plz",

/* 7 */
"gb_ort",

NULL


#line 172 "itamysql.ctr"
};

/**	Number of elements in itadmin_mysql_cn_buildings.
*/
static size_t const	itadmin_mysql_sz_cn_buildings =
sizeof(itadmin_mysql_cn_buildings)/sizeof(DK3_PCCHAR) - 1;


/**	Elements from speed table.
*/
static char const * const       itadmin_mysql_cn_speed[] = {
/* 0 */
"sp_s",

/* 1 */
"sp_l",

NULL


#line 187 "itamysql.ctr"
};

/**	Number of elements in itadmin_mysql_cn_speed.
*/
static size_t const	itadmin_mysql_sz_cn_speed =
sizeof(itadmin_mysql_cn_speed)/sizeof(DK3_PCCHAR) - 1;


/**	Elements from vlan table.
*/
static char const * const       itadmin_mysql_cn_vlan[] = {
/* 0 */
"vl_s",

/* 1 */
"vl_l",

NULL


#line 202 "itamysql.ctr"
};

/**	Number of elements in itadmin_mysql_cn_vlan.
*/
static size_t const	itadmin_mysql_sz_cn_vlan =
sizeof(itadmin_mysql_cn_vlan)/sizeof(DK3_PCCHAR) - 1;


/**	Elements from patch table.
*/
static char const * const       itadmin_mysql_cn_patch[] = {
/* 0 */
"dd_n",

/* 1 */
"sp_s",

/* 2 */
"vl_s",

/* 3 */
"dd_p",

/* 4 */
"gb_s",

/* 5 */
"dd_r",

NULL


#line 221 "itamysql.ctr"
};

/**	Number of elements in itadmin_mysql_cn_patch.
*/
static size_t const	itadmin_mysql_sz_cn_patch =
sizeof(itadmin_mysql_cn_patch)/sizeof(DK3_PCCHAR) - 1;


/**	Elements from netgroup table.
*/
static char const * const       itadmin_mysql_cn_netgroup[] = {
/* 0 */
"ng_s",

/* 1 */
"ng_l",

NULL


#line 236 "itamysql.ctr"
};

/**	Number of elements in itadmin_mysql_cn_netgroup.
*/
static size_t const	itadmin_mysql_sz_cn_netgroup =
sizeof(itadmin_mysql_cn_netgroup)/sizeof(DK3_PCCHAR) - 1;


/**	Elements from dhcp_option table.
*/
static char const * const       itadmin_mysql_cn_dhcp_option[] = {
/* 0 */
"do_pk",

/* 1 */
"do_sc",

/* 2 */
"do_sn",

/* 3 */
"do_n",

/* 4 */
"do_v",

NULL


#line 254 "itamysql.ctr"
};

/**	Number of elements in itadmin_mysql_cn_dhcp_option.
*/
static size_t const	itadmin_mysql_sz_cn_dhcp_option =
sizeof(itadmin_mysql_cn_dhcp_option)/sizeof(DK3_PCCHAR) - 1;


/**	Elements from swman table.
*/
static char const * const       itadmin_mysql_cn_swman[] = {
/* 0 */
"sm_s",

/* 1 */
"sm_l",

NULL


#line 269 "itamysql.ctr"
};

/**	Number of elements in itadmin_mysql_cn_swman.
*/
static size_t const	itadmin_mysql_sz_cn_swman =
sizeof(itadmin_mysql_cn_swman)/sizeof(DK3_PCCHAR) - 1;


/**	Elements from swprod table.
*/
static char const * const       itadmin_mysql_cn_swprod[] = {
/* 0 */
"sw_s",

/* 1 */
"sw_l",

/* 2 */
"sm_s",

NULL


#line 285 "itamysql.ctr"
};

/**	Number of elements in itadmin_mysql_cn_swprod.
*/
static size_t const	itadmin_mysql_sz_cn_swprod =
sizeof(itadmin_mysql_cn_swprod)/sizeof(DK3_PCCHAR) - 1;


/**	Elements from lictype table.
*/
static char const * const       itadmin_mysql_cn_lictype[] = {
/* 0 */
"lt_s",

/* 1 */
"lt_l",

/* 2 */
"lt_i",

NULL


#line 301 "itamysql.ctr"
};

/**	Number of elements in itadmin_mysql_cn_lictype.
*/
static size_t const	itadmin_mysql_sz_cn_lictype =
sizeof(itadmin_mysql_cn_lictype)/sizeof(DK3_PCCHAR) - 1;


/**	Elements from license table.
*/
static char const * const       itadmin_mysql_cn_license[] = {
/* 0 */
"li_pk",

/* 1 */
"li_on",

/* 2 */
"sw_s",

/* 3 */
"us_s",

/* 4 */
"co_s",

/* 5 */
"lt_s",

/* 6 */
"li_no",

/* 7 */
"sr_s",

/* 8 */
"li_dd",

/* 9 */
"li_nd",

/* 10 */
"li_di",

/* 11 */
"li_ni",

NULL


#line 339 "itamysql.ctr"
};

/**	Number of elements in itadmin_mysql_cn_license.
*/
static size_t const	itadmin_mysql_sz_cn_license =
sizeof(itadmin_mysql_cn_license)/sizeof(DK3_PCCHAR) - 1;


/**	Elements from ngdep table.
*/
static char const * const       itadmin_mysql_cn_ngdep[] = {
/* 0 */
"nd_p",

/* 1 */
"nd_c",

NULL


#line 354 "itamysql.ctr"
};

/**	Number of elements in itadmin_mysql_cn_ngdep.
*/
static size_t const	itadmin_mysql_sz_cn_ngdep =
sizeof(itadmin_mysql_cn_ngdep)/sizeof(DK3_PCCHAR) - 1;


/**	Elements from hosts table.
*/
static char const * const       itadmin_mysql_cn_hosts[] = {
/* 0 */
"co_s",

/* 1 */
"us_s",

/* 2 */
"co_ip",

/* 3 */
"co_mc",

/* 4 */
"ng_s",

/* 5 */
"co_co",

/* 6 */
"dc_s",

/* 7 */
"dg_s",

/* 8 */
"dd_n",

/* 9 */
"gb_s",

/* 10 */
"co_r",

/* 11 */
"co_in",

/* 12 */
"co_sn",

/* 13 */
"co_dd",

/* 14 */
"co_ff",

/* 15 */
"co_gu",

/* 16 */
"co_hi",

/* 17 */
"co_ex",

/* 18 */
"co_nn",

/* 19 */
"co_na",

NULL


#line 387 "itamysql.ctr"
};

/**	Number of elements in itadmin_mysql_cn_hosts.
*/
static size_t const	itadmin_mysql_sz_cn_hosts =
sizeof(itadmin_mysql_cn_hosts)/sizeof(DK3_PCCHAR) - 1;


/**	Elements from network table.
*/
static char const * const       itadmin_mysql_cn_network[] = {
/* 0 */
"nw_ip",

/* 1 */
"nw_ma",

/* 2 */
"nw_gw",

/* 3 */
"nw_bc",

/* 4 */
"vl_s",

NULL


#line 405 "itamysql.ctr"
};

/**	Number of elements in itadmin_mysql_cn_network.
*/
static size_t const	itadmin_mysql_sz_cn_network =
sizeof(itadmin_mysql_cn_network)/sizeof(DK3_PCCHAR) - 1;


/**	Elements from dhcp_class table.
*/
static char const * const       itadmin_mysql_cn_dhcp_class[] = {
/* 0 */
"dc_s",

/* 1 */
"dc_d",

NULL


#line 420 "itamysql.ctr"
};

/**	Number of elements in itadmin_mysql_cn_dhcp_class.
*/
static size_t const	itadmin_mysql_sz_cn_dhcp_class =
sizeof(itadmin_mysql_cn_dhcp_class)/sizeof(DK3_PCCHAR) - 1;


/**	Elements from dhcp_group table.
*/
static char const * const       itadmin_mysql_cn_dhcp_group[] = {
/* 0 */
"dg_s",

/* 1 */
"dg_l",

NULL


#line 435 "itamysql.ctr"
};

/**	Number of elements in itadmin_mysql_cn_dhcp_group.
*/
static size_t const	itadmin_mysql_sz_cn_dhcp_group =
sizeof(itadmin_mysql_cn_dhcp_group)/sizeof(DK3_PCCHAR) - 1;


/**	Elements from dhcp_pool table.
*/
static char const * const       itadmin_mysql_cn_dhcp_pool[] = {
/* 0 */
"dp_st",

/* 1 */
"dp_en",

/* 2 */
"nw_ip",

/* 3 */
"dp_al",

/* 4 */
"dp_dn",

/* 5 */
"dc_s",

NULL


#line 454 "itamysql.ctr"
};

/**	Number of elements in itadmin_mysql_cn_dhcp_pool.
*/
static size_t const	itadmin_mysql_sz_cn_dhcp_pool =
sizeof(itadmin_mysql_cn_dhcp_pool)/sizeof(DK3_PCCHAR) - 1;


/**	Elements from alias table.
*/
static char const * const       itadmin_mysql_cn_alias[] = {
/* 0 */
"al_s",

/* 1 */
"co_s",

NULL


#line 469 "itamysql.ctr"
};

/**	Number of elements in itadmin_mysql_cn_alias.
*/
static size_t const	itadmin_mysql_sz_cn_alias =
sizeof(itadmin_mysql_cn_alias)/sizeof(DK3_PCCHAR) - 1;


#if VERSION_BEFORE_20120208
/**	Obtain int value from string.
	@param	job	Job structure.
	@param	ptr	String to convert.
	@param	lgt	Length of string.
	@param	def	Default value to use if conversion fails.
	@return	The value or the default value.
*/
static
int
itadmin_mysql_read_int(itadmin_job *job, char const *ptr, size_t lgt, int def)
{
  int		back;
  int		i;
  

#line 492 "itamysql.ctr"
  back = def;
  if(ptr) {
    if(lgt) {
      if(sscanf(ptr, "%d", &i) == 1) {
        back = i;		

#line 497 "itamysql.ctr"
      }
    }
  } 

#line 500 "itamysql.ctr"
  return back;
}
#else
/**	Obtain int value from string.
	@param	job	Job structure.
	@param	ptr	String to convert.
	@param	lgts	Lengths of strings.
	@param	cnind	Column name indices.
	@param	ind	Current index to use.
	@param	def	Default value to use if conversion fails.
	@return	The value or the default value.
*/
static
int
itadmin_mysql_read_int(
  itadmin_job 		*job,
  char const 		*ptr,
  unsigned long		*lgts,
  size_t		*cnind,
  size_t		 ind,
  int			 def
)
{
  int		back;
  int		i;
  

#line 526 "itamysql.ctr"
  back = def;
  if(ptr) {
    if(cnind[ind] != 0xFFFFU) {
      if(lgts[cnind[ind]]) {
        if(sscanf(ptr, "%d", &i) == 1) {
	  back = i;
	}
      }
    }
  } 

#line 536 "itamysql.ctr"
  return back;
}
#endif


/**	Find column name indices.
	For column names not found the program sets the index
	to 0xFFFFU.
	@param	job		Job structure.
	@param	cnind		Destination array for indices.
	@param	sz_cnind	Size of @a cnind.
	@param	nf		Number of fields in query result.
	@param	mr		Query result.
	@param	colnames	Column names.
*/
static
void
itadmin_data_mysql_find_indices(
  itadmin_job		*job,
  size_t		*cnind,
  size_t		 sz_cnind,
  size_t		 nf,
  MYSQL_RES		*mr,
  char const * const	*colnames
)
{
  MYSQL_FIELD	*field;
  size_t	 i;
  int		 ai;
  for(i = 0; i < sz_cnind; i++) { cnind[i] = 0xFFFFU; }
  for(i = 0; i < nf; i++) {
    field = mysql_fetch_field_direct(mr, i);
    if(field) {
      if(field->name) {
        ai = dk3str_c8_array_index(colnames, field->name, 0);
	if(ai >= 0) {
	  if(((size_t)ai) < sz_cnind) {
	    cnind[(size_t)ai] = i;
	  }
	}
      }
    }
  }
}



/**	Set value pointers.
	@param	job		Job structure.
	@param	val		Value pointers array.
	@param	cnind		Index array.
	@param	sz_cnind	Size of @a val and @a cnind.
	@param	nf		Number of fields in @a mrow.
	@param	mrow		One result row.
	@param	lgts		Array of string lengths for row.
*/
static
void
itadmin_data_mysql_set_pointers(
  itadmin_job		*job,
  char const * 		*val,
  size_t		*cnind,
  size_t		 sz_cnind,
  size_t		 nf,
  MYSQL_ROW		 mrow,
  unsigned long		*lgts
)
{
  size_t		 i;
  size_t		 j;
  for(i = 0; i < sz_cnind; i++) {
    val[i] = NULL;
    if(cnind[i] != 0xFFFFU) {
      j = cnind[i];
      if(j < nf) {
        if(lgts[j]) {
          if(mrow[j]) {
            val[i] = mrow[j];
          }
	}
      }
    }
  }
}



/**	Read aliases table.
	@param	job	Job structure.
	@return	1 on success, 0 on error.
*/
static
int
itadmin_data_mysql_alias(itadmin_job *job)
{
  MYSQL_RES	*mr;		/* Results set. */
  MYSQL_ROW	 mrow;		/* One result row. */
  char const	*val[sizeof(itadmin_mysql_cn_alias)/sizeof(DK3_PCCHAR) - 1];
  size_t	 cnind[sizeof(itadmin_mysql_cn_alias)/sizeof(DK3_PCCHAR) - 1];
  unsigned long	*lgts;		/* Field lengths. */
  unsigned int	 nf;		/* Number of fields in result. */
  int		 res;		/* Query result. */
  int		 back	= 0;
  

#line 640 "itamysql.ctr"
  res = mysql_query((MYSQL *)(job->dbptr), itadmin_mysql_c8_kw[12]);
  if(0 == res) {
    mr = mysql_use_result((MYSQL *)(job->dbptr));
    if(mr) {
      nf = mysql_num_fields(mr);
      itadmin_data_mysql_find_indices(
        job, cnind, itadmin_mysql_sz_cn_alias, nf, mr,
	itadmin_mysql_cn_alias
      );
      back = 1;
      do {
        mrow = mysql_fetch_row(mr);
	if(mrow) {
	  lgts = mysql_fetch_lengths(mr);
	  if(lgts) {
	    itadmin_data_mysql_set_pointers(
	      job, val, cnind, itadmin_mysql_sz_cn_alias,
	      nf, mrow, lgts
	    );
	    res = itadmin_register_alias(
	      job,
	      val[0], val[1]
	    );
	    if(!(res)) { back = 0; }
	  } else {
	    back = 0;
	  }
	}
      } while(mrow);
      mysql_free_result(mr);
    } else {
      /* ERROR: Failed to obtain results list */
      dk3app_log_1(job->app, DK3_LL_ERROR, job->msg, 141);
    }
  } else {
    /* ERROR: Query failed! */
    dk3app_log_1(job->app, DK3_LL_ERROR, job->msg, 142);
  }
  

#line 679 "itamysql.ctr"
  return back;
}



/**	Read DHCP pool table.
	@param	job	Job structure.
	@return	1 on success, 0 on error.
*/
static
int
itadmin_data_mysql_dhcp_pool(itadmin_job *job)
{
  MYSQL_RES	*mr;		/* Results set. */
  MYSQL_ROW	 mrow;		/* One result row. */
  char const	*val[sizeof(itadmin_mysql_cn_dhcp_pool)/sizeof(DK3_PCCHAR) - 1];
  size_t	 cnind[sizeof(itadmin_mysql_cn_dhcp_pool)/sizeof(DK3_PCCHAR) - 1];
  unsigned long	*lgts;		/* Field lengths. */
  unsigned int	 nf;		/* Number of fields in result. */
  int		 res;		/* Query result. */
  int		 back	= 0;
  

#line 701 "itamysql.ctr"
  res = mysql_query((MYSQL *)(job->dbptr), itadmin_mysql_c8_kw[10]);
  if(0 == res) {
    mr = mysql_use_result((MYSQL *)(job->dbptr));
    if(mr) {
      nf = mysql_num_fields(mr);
      itadmin_data_mysql_find_indices(
        job, cnind, itadmin_mysql_sz_cn_dhcp_pool, nf, mr,
	itadmin_mysql_cn_dhcp_pool
      );
      back = 1;
      do {
        mrow = mysql_fetch_row(mr);
	if(mrow) {
	  lgts = mysql_fetch_lengths(mr);
	  if(lgts) {
	    itadmin_data_mysql_set_pointers(
	      job, val, cnind, itadmin_mysql_sz_cn_dhcp_pool,
	      nf, mrow, lgts
	    );
	    res = itadmin_register_dhcp_pool(
	      job,
	      val[0], val[1], val[2],
#if VERSION_BEFORE_20120208
	      itadmin_mysql_read_int(job, val[3], lgts[cnind[3]], 0),
	      itadmin_mysql_read_int(job, val[4], lgts[cnind[4]], 0),
#else
	      itadmin_mysql_read_int(job, val[3], lgts, cnind, 3, 0),
	      itadmin_mysql_read_int(job, val[4], lgts, cnind, 4, 0),
#endif
	      val[5]
	    );
	    if(!(res)) { back = 0; }
	  } else {
	    back = 0;
	  }
	}
      } while(mrow);

      mysql_free_result(mr);
    } else {
      dk3app_log_1(job->app, DK3_LL_ERROR, job->msg, 141);
    }
  } else {
    dk3app_log_1(job->app, DK3_LL_ERROR, job->msg, 142);
  }
  

#line 747 "itamysql.ctr"
  return back;
}


/**	Read DHCP group table.
	@param	job	Job structure.
	@return	1 on success, 0 on error.
*/
static
int
itadmin_data_mysql_dhcp_group(itadmin_job *job)
{
  MYSQL_RES	*mr;		/* Results set. */
  MYSQL_ROW	 mrow;		/* One result row. */
  char const	*val[sizeof(itadmin_mysql_cn_dhcp_group)/sizeof(DK3_PCCHAR) - 1];
  size_t	 cnind[sizeof(itadmin_mysql_cn_dhcp_group)/sizeof(DK3_PCCHAR) - 1];
  unsigned long	*lgts;		/* Field lengths. */
  unsigned int	 nf;		/* Number of fields in result. */
  int		 res;		/* Query result. */
  int		 back	= 0;
  

#line 768 "itamysql.ctr"
  res = mysql_query((MYSQL *)(job->dbptr), itadmin_mysql_c8_kw[9]);
  if(0 == res) {
    mr = mysql_use_result((MYSQL *)(job->dbptr));
    if(mr) {
      nf = mysql_num_fields(mr);
      itadmin_data_mysql_find_indices(
        job, cnind, itadmin_mysql_sz_cn_dhcp_group, nf, mr,
	itadmin_mysql_cn_dhcp_group
      );
      back = 1;
      do {
        mrow = mysql_fetch_row(mr);
	if(mrow) {
	  lgts = mysql_fetch_lengths(mr);
	  if(lgts) {
	    itadmin_data_mysql_set_pointers(
	      job, val, cnind, itadmin_mysql_sz_cn_dhcp_group,
	      nf, mrow, lgts
	    );
	    res = itadmin_register_dhcp_group(job, val[0], val[1]);
	    if(!(res)) { back = 0; }
	  } else {
	    back = 0;
	  }
	}
      } while(mrow);
      mysql_free_result(mr);
    } else {
      dk3app_log_1(job->app, DK3_LL_ERROR, job->msg, 141);
    }
  } else {
    dk3app_log_1(job->app, DK3_LL_ERROR, job->msg, 142);
  }
  

#line 802 "itamysql.ctr"
  return back;
}



/**	Read DHCP class table.
	@param	job	Job structure.
	@return	1 on success, 0 on error.
*/
static
int
itadmin_data_mysql_dhcp_class(itadmin_job *job)
{
  MYSQL_RES	*mr;		/* Results set. */
  MYSQL_ROW	 mrow;		/* One result row. */
  char const	*val[sizeof(itadmin_mysql_cn_dhcp_class)/sizeof(DK3_PCCHAR) - 1];
  size_t	 cnind[sizeof(itadmin_mysql_cn_dhcp_class)/sizeof(DK3_PCCHAR) - 1];
  unsigned long	*lgts;		/* Field lengths. */
  unsigned int	 nf;		/* Number of fields in result. */
  int		 res;		/* Query result. */
  int		 back	= 0;
  

#line 824 "itamysql.ctr"
  res = mysql_query((MYSQL *)(job->dbptr), itadmin_mysql_c8_kw[8]);
  if(0 == res) {
    mr = mysql_use_result((MYSQL *)(job->dbptr));
    if(mr) {
      nf = mysql_num_fields(mr);
      itadmin_data_mysql_find_indices(
        job, cnind, itadmin_mysql_sz_cn_dhcp_class, nf, mr,
	itadmin_mysql_cn_dhcp_class
      );
      back = 1;
      do {
        mrow = mysql_fetch_row(mr);
	if(mrow) {
	  lgts = mysql_fetch_lengths(mr);
	  if(lgts) {
	    itadmin_data_mysql_set_pointers(
	      job, val, cnind, itadmin_mysql_sz_cn_dhcp_class,
	      nf, mrow, lgts
	    );
	    res = itadmin_register_dhcp_class(job, val[0], val[1]);
	    if(!(res)) { back = 0; }
	  } else {
	    back = 0;
	  }
	}
      } while(mrow);
      mysql_free_result(mr);
    } else {
      dk3app_log_1(job->app, DK3_LL_ERROR, job->msg, 141);
    }
  } else {
    dk3app_log_1(job->app, DK3_LL_ERROR, job->msg, 142);
  }
  

#line 858 "itamysql.ctr"
  return back;
}



/**	Read networks table.
	@param	job	Job structure.
	@return	1 on success, 0 on error.
*/
static
int
itadmin_data_mysql_network(itadmin_job *job)
{
  MYSQL_RES	*mr;		/* Results set. */
  MYSQL_ROW	 mrow;		/* One result row. */
  char const	*val[sizeof(itadmin_mysql_cn_network)/sizeof(DK3_PCCHAR) - 1];
  size_t	 cnind[sizeof(itadmin_mysql_cn_network)/sizeof(DK3_PCCHAR) - 1];
  unsigned long	*lgts;		/* Field lengths. */
  unsigned int	 nf;		/* Number of fields in result. */
  int		 res;		/* Query result. */
  int		 back	= 0;
  

#line 880 "itamysql.ctr"
  res = mysql_query((MYSQL *)(job->dbptr), itadmin_mysql_c8_kw[5]);
  if(0 == res) {
    mr = mysql_use_result((MYSQL *)(job->dbptr));
    if(mr) {
      nf = mysql_num_fields(mr);
      itadmin_data_mysql_find_indices(
        job, cnind, itadmin_mysql_sz_cn_network, nf, mr,
	itadmin_mysql_cn_network
      );
      back = 1;
      do {
        mrow = mysql_fetch_row(mr);
	if(mrow) {
	  lgts = mysql_fetch_lengths(mr);
	  if(lgts) {
	    itadmin_data_mysql_set_pointers(
	      job, val, cnind, itadmin_mysql_sz_cn_network,
	      nf, mrow, lgts
	    );
	    res = itadmin_register_network(
	      job, val[0], val[1], val[2], val[3], val[4]
	    );
	    if(!(res)) { back = 0; }
	  } else {
	    back = 0;
	  }
	}
      } while(mrow);
      mysql_free_result(mr);
    } else {
      dk3app_log_1(job->app, DK3_LL_ERROR, job->msg, 141);
    }
  } else {
    dk3app_log_1(job->app, DK3_LL_ERROR, job->msg, 142);
  }
  

#line 916 "itamysql.ctr"
  return back;
}



/**	Read hosts table.
	@param	job	Job structure.
	@return	1 on success, 0 on error.
*/
static
int
itadmin_data_mysql_hosts(itadmin_job *job)
{
  itadmin_date	 expi;		/* Expiration date for host entry. */
  MYSQL_RES	*mr;		/* Results set. */
  MYSQL_ROW	 mrow;		/* One result row. */
  char const	*val[sizeof(itadmin_mysql_cn_hosts)/sizeof(DK3_PCCHAR) - 1];
  size_t	 cnind[sizeof(itadmin_mysql_cn_hosts)/sizeof(DK3_PCCHAR) - 1];
  unsigned long	*lgts;		/* Field lengths. */
  unsigned int	 nf;		/* Number of fields in result. */
  int		 res;		/* Query result. */
  int		 hexpi;		/* Flag: Have expiration date. */
  int		 flag_first;	/* Flag: Write FQDN to /etc/hosts first. */
  int		 flag_guest;	/* Flag: Guest computer. */
  int		 flag_no_net_docu;	/* Flag: Skip host in docu. */
  int		 flag_no_arpwatch;	/* Flag: Skip host for arpwatch. */
  int		 back	= 0;
  

#line 944 "itamysql.ctr"
  res = mysql_query((MYSQL *)(job->dbptr), itadmin_mysql_c8_kw[11]);
  if(0 == res) {
    mr = mysql_use_result((MYSQL *)(job->dbptr));
    if(mr) {
      nf = mysql_num_fields(mr);
      itadmin_data_mysql_find_indices(
        job, cnind, itadmin_mysql_sz_cn_hosts, nf, mr,
	itadmin_mysql_cn_hosts
      );
      back = 1;
      do {
        mrow = mysql_fetch_row(mr);
	if(mrow) {		

#line 957 "itamysql.ctr"
	  lgts = mysql_fetch_lengths(mr);
	  if(lgts) {		

#line 959 "itamysql.ctr"
	    itadmin_data_mysql_set_pointers(
	      job, val, cnind, itadmin_mysql_sz_cn_hosts,
	      nf, mrow, lgts
	    );
	    flag_first =
	    itadmin_mysql_read_int(job, val[14], lgts, cnind, 14, 0);
	    flag_guest =
	    itadmin_mysql_read_int(job, val[15], lgts, cnind, 15, 0);
	    flag_no_net_docu =
	    itadmin_mysql_read_int(job, val[18], lgts, cnind, 18, 0);
	    flag_no_arpwatch =
	    itadmin_mysql_read_int(job, val[19], lgts, cnind, 19, 0);
	    itadmin_mem_date_init(&expi);
	    hexpi = 0;
	    if(val[17]) {	

#line 974 "itamysql.ctr"
	      if(cnind[17] != 0xFFFFU) {	

#line 975 "itamysql.ctr"
	        if(lgts[cnind[17]]) {	

#line 976 "itamysql.ctr"
		  if(itadmin_tool_convert_date(job, &expi, val[17])) {
		    hexpi = 1;	

#line 978 "itamysql.ctr"
		  } else {	

#line 979 "itamysql.ctr"
		  }
		} else {	

#line 981 "itamysql.ctr"
		}
	      } else {		

#line 983 "itamysql.ctr"
	      }
	    } else {		

#line 985 "itamysql.ctr"
	    } 

#line 986 "itamysql.ctr"
	    res = itadmin_register_host(
	      job, val[0], val[1], val[2], val[3], val[4], val[5], val[6],
	      val[7], val[8], val[9], val[10], val[11], val[12], val[13],
	      flag_first, flag_guest, val[16], ((hexpi) ? &expi : NULL),
	      flag_no_net_docu, flag_no_arpwatch
	    );			

#line 992 "itamysql.ctr"
	    if(!(res)) { back = 0; }
	  } else {		

#line 994 "itamysql.ctr"
	    back = 0;
	  }			

#line 996 "itamysql.ctr"
	}
      } while(mrow);
      mysql_free_result(mr);
    } else {
      dk3app_log_1(job->app, DK3_LL_ERROR, job->msg, 141);
    }
  } else {
    dk3app_log_1(job->app, DK3_LL_ERROR, job->msg, 142);
  }
  

#line 1006 "itamysql.ctr"
  return back;
}



/**	Read ngdep table.
	@param	job	Job structure.
	@return	1 on success, 0 on error.
*/
static
int
itadmin_data_mysql_ngdep(itadmin_job *job)
{
  MYSQL_RES	*mr;		/* Results set. */
  MYSQL_ROW	 mrow;		/* One result row. */
  char const	*val[sizeof(itadmin_mysql_cn_ngdep)/sizeof(DK3_PCCHAR) - 1];
  size_t	 cnind[sizeof(itadmin_mysql_cn_ngdep)/sizeof(DK3_PCCHAR) - 1];
  unsigned long	*lgts;		/* Field lengths. */
  unsigned int	 nf;		/* Number of fields in result. */
  int		 res;		/* Query result. */
  int		 back	= 0;
  

#line 1028 "itamysql.ctr"
  res = mysql_query((MYSQL *)(job->dbptr), itadmin_mysql_c8_kw[7]);
  if(0 == res) {
    mr = mysql_use_result((MYSQL *)(job->dbptr));
    if(mr) {
      nf = mysql_num_fields(mr);
      itadmin_data_mysql_find_indices(
        job, cnind, itadmin_mysql_sz_cn_ngdep, nf, mr,
	itadmin_mysql_cn_ngdep
      );
      back = 1;
      do {
        mrow = mysql_fetch_row(mr);
	if(mrow) {
	  lgts = mysql_fetch_lengths(mr);
	  if(lgts) {
	    itadmin_data_mysql_set_pointers(
	      job, val, cnind, itadmin_mysql_sz_cn_ngdep,
	      nf, mrow, lgts
	    );
	    res = itadmin_register_ngdep(job, val[0], val[1]);
	    if(!(res)) { back = 0; }
	  } else {
	    back = 0;
	  }
	}
      } while(mrow);
      mysql_free_result(mr);
    } else {
      dk3app_log_1(job->app, DK3_LL_ERROR, job->msg, 141);
    }
  } else {
    dk3app_log_1(job->app, DK3_LL_ERROR, job->msg, 142);
  }
  

#line 1062 "itamysql.ctr"
  return back;
}



/**	Read license types table.
	@param	job	Job structure.
	@return	1 on success, 0 on error.
*/
static
int
itadmin_data_mysql_license(itadmin_job *job)
{
  char		 lnbuffer[128];	/* Line number buffer. */
  MYSQL_RES	*mr;		/* Results set. */
  MYSQL_ROW	 mrow;		/* One result row. */
  itadmin_date	 dd;		/* Delivery date. */
  itadmin_date	 di;		/* Invoice date. */
  char const	*val[sizeof(itadmin_mysql_cn_license)/sizeof(DK3_PCCHAR) - 1];
  size_t	 cnind[sizeof(itadmin_mysql_cn_license)/sizeof(DK3_PCCHAR) - 1];
  unsigned long	*lgts;		/* Field lengths. */
  unsigned long	 pk;		/* Primary key. */
  unsigned long	 lineno;	/* Record number. */
  unsigned int	 nf;		/* Number of fields in result. */
  int		 res;		/* Query result. */
  int		 hdd;		/* Flag: Have delivery date. */
  int		 hdi;		/* Flag: Have invoice date. */
  int		 back	= 0;
  

#line 1091 "itamysql.ctr"
  res = mysql_query((MYSQL *)(job->dbptr), itadmin_mysql_c8_kw[17]);
  if(0 == res) {
    mr = mysql_use_result((MYSQL *)(job->dbptr));
    if(mr) {
      nf = mysql_num_fields(mr);
      itadmin_data_mysql_find_indices(
        job, cnind, itadmin_mysql_sz_cn_license, nf, mr,
	itadmin_mysql_cn_license
      );
      back = 1;
      lineno = 0UL;
      do {
        mrow = mysql_fetch_row(mr);
	if(mrow) {
	  lgts = mysql_fetch_lengths(mr);
	  if(lgts) {
	    itadmin_data_mysql_set_pointers(
	      job, val, cnind, itadmin_mysql_sz_cn_license,
	      nf, mrow, lgts
	    );
	    /*
	    res = itadmin_register_license(
	      job, val[0], val[1], licno
	    );
	    if(!(res)) { back = 0; }
	    */
	    if(val[0]) {
	      if(sscanf(val[0], "%lu", &pk) == 1) {
	        hdd = hdi = 0;
		if(val[8]) {
		  if(cnind[8] != 0xFFFFU) {
		    if(lgts[cnind[8]]) {
		      if(itadmin_tool_convert_date(job, &dd, val[8])) {
		        hdd = 1;
		      }
		    }
		  }
		}
		if(val[10]) {
		  if(cnind[10] != 0xFFFFU) {
		    if(lgts[cnind[10]]) {
		      if(itadmin_tool_convert_date(job, &di, val[10])) {
		        hdi = 1;
		      }
		    }
		  }
		}
		res = itadmin_register_license(
		  job,
		  pk,
		  val[1],	/* li_on	*/
		  val[2],	/* sw_s		*/
		  val[3],	/* us_s		*/
		  val[4],	/* co_s		*/
		  val[5],	/* lt_s		*/
		  val[6],	/* li_no	*/
		  val[7],	/* sr_s		*/
		  ((hdd) ? &dd : NULL),
		  val[9],	/* li_nd	*/
		  ((hdi) ? &di : NULL),
		  val[11]	/* li_ni	*/
		);
		if(!(res)) { back = 0; }
	      } else {
	        /* ERROR: Primary key not numeric! */
		sprintf(lnbuffer, "%lu", lineno);
		itadmin_tool_log_utf8_3(job, DK3_LL_ERROR, 143, 144, lnbuffer);
	      }
	    } else {
	      /* ERROR: No primary key */
	      sprintf(lnbuffer, "%lu", lineno);
	      itadmin_tool_log_utf8_3(job, DK3_LL_ERROR, 143, 145, lnbuffer);
	    }
	  } else {
	    back = 0;
	  }
	}
	lineno++;
      } while(mrow);
      mysql_free_result(mr);
    } else {
      dk3app_log_1(job->app, DK3_LL_ERROR, job->msg, 141);
    }
  } else {
    dk3app_log_1(job->app, DK3_LL_ERROR, job->msg, 142);
  }
  

#line 1178 "itamysql.ctr"
  return back;
}



/**	Read license types table.
	@param	job	Job structure.
	@return	1 on success, 0 on error.
*/
static
int
itadmin_data_mysql_lictype(itadmin_job *job)
{
  MYSQL_RES	*mr;		/* Results set. */
  MYSQL_ROW	 mrow;		/* One result row. */
  char const	*val[sizeof(itadmin_mysql_cn_lictype)/sizeof(DK3_PCCHAR) - 1];
  size_t	 cnind[sizeof(itadmin_mysql_cn_lictype)/sizeof(DK3_PCCHAR) - 1];
  unsigned long	*lgts;		/* Field lengths. */
  unsigned int	 nf;		/* Number of fields in result. */
  int		 res;		/* Query result. */
  int		 licno;		/* Number of licenses. */
  int		 back	= 0;
  

#line 1201 "itamysql.ctr"
  res = mysql_query((MYSQL *)(job->dbptr), itadmin_mysql_c8_kw[16]);
  if(0 == res) {
    mr = mysql_use_result((MYSQL *)(job->dbptr));
    if(mr) {
      nf = mysql_num_fields(mr);
      itadmin_data_mysql_find_indices(
        job, cnind, itadmin_mysql_sz_cn_lictype, nf, mr,
	itadmin_mysql_cn_lictype
      );
      back = 1;
      do {
        mrow = mysql_fetch_row(mr);
	if(mrow) {
	  lgts = mysql_fetch_lengths(mr);
	  if(lgts) {
	    itadmin_data_mysql_set_pointers(
	      job, val, cnind, itadmin_mysql_sz_cn_lictype,
	      nf, mrow, lgts
	    );
	    licno = 1;
	    if(val[2]) {
	      char const	*s;
	      int		 i;
	      s = dk3str_c8_start(val[2], NULL);
	      if(s) {
	        if(sscanf(s, "%d", &i) == 1) {
		  licno = i;
		} else {
		  /* ERROR: Not a number! */
		  itadmin_tool_log_utf8_5(
		    job, DK3_LL_ERROR, 146, 147, 148, val[0], s
		  );
		}
	      }
	    }
	    res = itadmin_register_lictype(
	      job, val[0], val[1], licno
	    );
	    if(!(res)) { back = 0; }
	  } else {
	    back = 0;
	  }
	}
      } while(mrow);
      mysql_free_result(mr);
    } else {
      dk3app_log_1(job->app, DK3_LL_ERROR, job->msg, 141);
    }
  } else {
    dk3app_log_1(job->app, DK3_LL_ERROR, job->msg, 142);
  }
  

#line 1253 "itamysql.ctr"
  return back;
}



/**	Read software products table.
	@param	job	Job structure.
	@return	1 on success, 0 on error.
*/
static
int
itadmin_data_mysql_swprod(itadmin_job *job)
{
  MYSQL_RES	*mr;		/* Results set. */
  MYSQL_ROW	 mrow;		/* One result row. */
  char const	*val[sizeof(itadmin_mysql_cn_swprod)/sizeof(DK3_PCCHAR) - 1];
  size_t	 cnind[sizeof(itadmin_mysql_cn_swprod)/sizeof(DK3_PCCHAR) - 1];
  unsigned long	*lgts;		/* Field lengths. */
  unsigned int	 nf;		/* Number of fields in result. */
  int		 res;		/* Query result. */
  int		 back	= 0;
  

#line 1275 "itamysql.ctr"
  res = mysql_query((MYSQL *)(job->dbptr), itadmin_mysql_c8_kw[15]);
  if(0 == res) {
    mr = mysql_use_result((MYSQL *)(job->dbptr));
    if(mr) {
      nf = mysql_num_fields(mr);
      itadmin_data_mysql_find_indices(
        job, cnind, itadmin_mysql_sz_cn_swprod, nf, mr,
	itadmin_mysql_cn_swprod
      );
      back = 1;
      do {
        mrow = mysql_fetch_row(mr);
	if(mrow) {
	  lgts = mysql_fetch_lengths(mr);
	  if(lgts) {
	    itadmin_data_mysql_set_pointers(
	      job, val, cnind, itadmin_mysql_sz_cn_swprod,
	      nf, mrow, lgts
	    );
	    res = itadmin_register_swprod(
	      job, val[0], val[1], val[2]
	    );
	    if(!(res)) { back = 0; }
	  } else {
	    back = 0;
	  }
	}
      } while(mrow);
      mysql_free_result(mr);
    } else {
      dk3app_log_1(job->app, DK3_LL_ERROR, job->msg, 141);
    }
  } else {
    dk3app_log_1(job->app, DK3_LL_ERROR, job->msg, 142);
  }
  

#line 1311 "itamysql.ctr"
  return back;
}



/**	Read swman table.
	@param	job	Job structure.
	@return	1 on success, 0 on error.
*/
static
int
itadmin_data_mysql_swman(itadmin_job *job)
{
  char		 lnbuffer[128];	/* Buffer for record number. */
  unsigned long	 lineno;	/* Record number. */
  MYSQL_RES	*mr;		/* Results set. */
  MYSQL_ROW	 mrow;		/* One result row. */
  char const	*val[sizeof(itadmin_mysql_cn_swman)/sizeof(DK3_PCCHAR) - 1];
  size_t	 cnind[sizeof(itadmin_mysql_cn_swman)/sizeof(DK3_PCCHAR) - 1];
  unsigned long	*lgts;		/* Field lengths. */
#if 0
  long		 pk;
#endif
  unsigned int	 nf;		/* Number of fields in result. */
  int		 res;		/* Query result. */
  int		 back	= 0;
  

#line 1338 "itamysql.ctr"
  res = mysql_query((MYSQL *)(job->dbptr), itadmin_mysql_c8_kw[14]);
  if(0 == res) {
    mr = mysql_use_result((MYSQL *)(job->dbptr));
    if(mr) {
      nf = mysql_num_fields(mr);
      itadmin_data_mysql_find_indices(
        job, cnind, itadmin_mysql_sz_cn_swman, nf, mr,
	itadmin_mysql_cn_swman
      );
      back = 1;
      lineno = 0UL;
      do {
        mrow = mysql_fetch_row(mr);
	if(mrow) {
	  lgts = mysql_fetch_lengths(mr);
	  if(lgts) {
	    itadmin_data_mysql_set_pointers(
	      job, val, cnind, itadmin_mysql_sz_cn_swman,
	      nf, mrow, lgts
	    );
	    res = 0;
	    if(val[0]) {
	      res = itadmin_register_swman(
	        job, val[0], val[1]
	      );
	    } else {
	      /* ERROR: No pk pointer! */
	      sprintf(lnbuffer, "%lu", lineno);
	      itadmin_tool_log_utf8_3(job, DK3_LL_ERROR, 149, 150, lnbuffer);
	    }
	    if(!(res)) { back = 0; }
	  } else {
	    back = 0;
	  }
	}
	lineno++;
      } while(mrow);
      mysql_free_result(mr);
    } else {
      dk3app_log_1(job->app, DK3_LL_ERROR, job->msg, 141);
    }
  } else {
    dk3app_log_1(job->app, DK3_LL_ERROR, job->msg, 142);
  }
  

#line 1383 "itamysql.ctr"
  return back;
}



/**	Read dhcp_option table.
	@param	job	Job structure.
	@return	1 on success, 0 on error.
*/
static
int
itadmin_data_mysql_dhcp_option(itadmin_job *job)
{
  char		 lnbuffer[128];	/* Record number buffer. */
  unsigned long	 lineno;	/* Record number. */
  MYSQL_RES	*mr;		/* Results set. */
  MYSQL_ROW	 mrow;		/* One result row. */
  char const	*val[sizeof(itadmin_mysql_cn_dhcp_option)/sizeof(DK3_PCCHAR) - 1];
  size_t	 cnind[sizeof(itadmin_mysql_cn_dhcp_option)/sizeof(DK3_PCCHAR) - 1];
  unsigned long	*lgts;		/* Field lengths. */
  long		 pk;
  unsigned int	 nf;		/* Number of fields in result. */
  int		 res;		/* Query result. */
  int		 back	= 0;
  

#line 1408 "itamysql.ctr"
  res = mysql_query((MYSQL *)(job->dbptr), itadmin_mysql_c8_kw[13]);
  if(0 == res) {
    mr = mysql_use_result((MYSQL *)(job->dbptr));
    if(mr) {
      nf = mysql_num_fields(mr);
      itadmin_data_mysql_find_indices(
        job, cnind, itadmin_mysql_sz_cn_dhcp_option, nf, mr,
	itadmin_mysql_cn_dhcp_option
      );
      back = 1;
      lineno = 0UL;
      do {
        mrow = mysql_fetch_row(mr);
	if(mrow) {
	  lgts = mysql_fetch_lengths(mr);
	  if(lgts) {
	    itadmin_data_mysql_set_pointers(
	      job, val, cnind, itadmin_mysql_sz_cn_dhcp_option,
	      nf, mrow, lgts
	    );
	    res = 0;
	    if(val[0]) {
	      if(sscanf(val[0], "%ld", &pk) == 1) {
	        res = itadmin_register_dhcp_option(
	          job, val[1], val[2], val[3], val[4], pk
	        );
	      } else {
	        /* ERROR: pk not a number! */
		sprintf(lnbuffer, "%lu", lineno);
		itadmin_tool_log_utf8_3(job, DK3_LL_ERROR, 151, 152, lnbuffer);
	      }
	    } else {
	      /* ERROR: No pk pointer! */
	      sprintf(lnbuffer, "%lu", lineno);
	      itadmin_tool_log_utf8_3(job, DK3_LL_ERROR, 151, 153, lnbuffer);
	    }
	    if(!(res)) { back = 0; }
	  } else {
	    back = 0;
	  }
	}
	lineno++;
      } while(mrow);
      mysql_free_result(mr);
    } else {
      dk3app_log_1(job->app, DK3_LL_ERROR, job->msg, 141);
    }
  } else {
    dk3app_log_1(job->app, DK3_LL_ERROR, job->msg, 142);
  }
  

#line 1459 "itamysql.ctr"
  return back;
}



/**	Read netgroup table.
	@param	job	Job structure.
	@return	1 on success, 0 on error.
*/
static
int
itadmin_data_mysql_netgroup(itadmin_job *job)
{
  MYSQL_RES	*mr;		/* Results set. */
  MYSQL_ROW	 mrow;		/* One result row. */
  char const	*val[sizeof(itadmin_mysql_cn_netgroup)/sizeof(DK3_PCCHAR) - 1];
  size_t	 cnind[sizeof(itadmin_mysql_cn_netgroup)/sizeof(DK3_PCCHAR) - 1];
  unsigned long	*lgts;		/* Field lengths. */
  unsigned int	 nf;		/* Number of fields in result. */
  int		 res;		/* Query result. */
  int		 back	= 0;
  

#line 1481 "itamysql.ctr"
  res = mysql_query((MYSQL *)(job->dbptr), itadmin_mysql_c8_kw[6]);
  if(0 == res) {
    mr = mysql_use_result((MYSQL *)(job->dbptr));
    if(mr) {
      nf = mysql_num_fields(mr);
      itadmin_data_mysql_find_indices(
        job, cnind, itadmin_mysql_sz_cn_netgroup, nf, mr,
	itadmin_mysql_cn_netgroup
      );
      back = 1;
      do {
        mrow = mysql_fetch_row(mr);
	if(mrow) {
	  lgts = mysql_fetch_lengths(mr);
	  if(lgts) {
	    itadmin_data_mysql_set_pointers(
	      job, val, cnind, itadmin_mysql_sz_cn_netgroup,
	      nf, mrow, lgts
	    );
	    res = itadmin_register_netgroup(job, val[0], val[1]);
	    if(!(res)) { back = 0; }
	  } else {
	    back = 0;
	  }
	}
      } while(mrow);
      mysql_free_result(mr);
    } else {
      dk3app_log_1(job->app, DK3_LL_ERROR, job->msg, 141);
    }
  } else {
    dk3app_log_1(job->app, DK3_LL_ERROR, job->msg, 142);
  }
  

#line 1515 "itamysql.ctr"
  return back;
}



/**	Read patches table.
	@param	job	Job structure.
	@return	1 on success, 0 on error.
*/
static
int
itadmin_data_mysql_patch(itadmin_job *job)
{
  MYSQL_RES	*mr;		/* Results set. */
  MYSQL_ROW	 mrow;		/* One result row. */
  char const	*val[sizeof(itadmin_mysql_cn_patch)/sizeof(DK3_PCCHAR) - 1];
  size_t	 cnind[sizeof(itadmin_mysql_cn_patch)/sizeof(DK3_PCCHAR) - 1];
  unsigned long	*lgts;		/* Field lengths. */
  unsigned int	 nf;		/* Number of fields in result. */
  int		 res;		/* Query result. */
  int		 back	= 0;
  

#line 1537 "itamysql.ctr"
  res = mysql_query((MYSQL *)(job->dbptr), itadmin_mysql_c8_kw[3]);
  if(0 == res) {
    mr = mysql_use_result((MYSQL *)(job->dbptr));
    if(mr) {
      nf = mysql_num_fields(mr);
      itadmin_data_mysql_find_indices(
        job, cnind, itadmin_mysql_sz_cn_patch, nf, mr,
	itadmin_mysql_cn_patch
      );
      back = 1;
      do {
        mrow = mysql_fetch_row(mr);
	if(mrow) {
	  lgts = mysql_fetch_lengths(mr);
	  if(lgts) {
	    itadmin_data_mysql_set_pointers(
	      job, val, cnind, itadmin_mysql_sz_cn_patch,
	      nf, mrow, lgts
	    );
	    res = itadmin_register_patch(
	      job, val[0], val[1], val[2], val[3], val[4], val[5]
	    );
	    if(!(res)) { back = 0; }
	  } else {
	    back = 0;
	  }
	}
      } while(mrow);
      mysql_free_result(mr);
    } else {
      dk3app_log_1(job->app, DK3_LL_ERROR, job->msg, 141);
    }
  } else {
    dk3app_log_1(job->app, DK3_LL_ERROR, job->msg, 142);
  }
  

#line 1573 "itamysql.ctr"
  return back;
}



/**	Read VLAN table.
	@param	job	Job structure.
	@return	1 on success, 0 on error.
*/
static
int
itadmin_data_mysql_vlan(itadmin_job *job)
{
  MYSQL_RES	*mr;		/* Results set. */
  MYSQL_ROW	 mrow;		/* One result row. */
  char const	*val[sizeof(itadmin_mysql_cn_vlan)/sizeof(DK3_PCCHAR) - 1];
  size_t	 cnind[sizeof(itadmin_mysql_cn_vlan)/sizeof(DK3_PCCHAR) - 1];
  unsigned long	*lgts;		/* Field lengths. */
  unsigned int	 nf;		/* Number of fields in result. */
  int		 res;		/* Query result. */
  int		 back	= 0;
  

#line 1595 "itamysql.ctr"
  res = mysql_query((MYSQL *)(job->dbptr), itadmin_mysql_c8_kw[2]);
  if(0 == res) {
    mr = mysql_use_result((MYSQL *)(job->dbptr));
    if(mr) {
      nf = mysql_num_fields(mr);
      itadmin_data_mysql_find_indices(
        job, cnind, itadmin_mysql_sz_cn_vlan, nf, mr,
	itadmin_mysql_cn_vlan
      );
      back = 1;
      do {
        mrow = mysql_fetch_row(mr);
	if(mrow) {
	  lgts = mysql_fetch_lengths(mr);
	  if(lgts) {
	    itadmin_data_mysql_set_pointers(
	      job, val, cnind, itadmin_mysql_sz_cn_vlan,
	      nf, mrow, lgts
	    );
	    res = itadmin_register_vlan(job, val[0], val[1]);
	    if(!(res)) { back = 0; }
	  } else {
	    back = 0;
	  }
	}
      } while(mrow);
      mysql_free_result(mr);
    } else {
      dk3app_log_1(job->app, DK3_LL_ERROR, job->msg, 141);
    }
  } else {
    dk3app_log_1(job->app, DK3_LL_ERROR, job->msg, 142);
  }
  

#line 1629 "itamysql.ctr"
  return back;
}



/**	Read speed table.
	@param	job	Job structure.
	@return	1 on success, 0 on error.
*/
static
int
itadmin_data_mysql_speed(itadmin_job *job)
{
  MYSQL_RES	*mr;		/* Results set. */
  MYSQL_ROW	 mrow;		/* One result row. */
  char const	*val[sizeof(itadmin_mysql_cn_speed)/sizeof(DK3_PCCHAR) - 1];
  size_t	 cnind[sizeof(itadmin_mysql_cn_speed)/sizeof(DK3_PCCHAR) - 1];
  unsigned long	*lgts;		/* Field lengths. */
  unsigned int	 nf;		/* Number of fields in result. */
  int		 res;		/* Query result. */
  int		 back	= 0;
  

#line 1651 "itamysql.ctr"
  res = mysql_query((MYSQL *)(job->dbptr), itadmin_mysql_c8_kw[4]);
  if(0 == res) {
    mr = mysql_use_result((MYSQL *)(job->dbptr));
    if(mr) {
      nf = mysql_num_fields(mr);
      itadmin_data_mysql_find_indices(
        job, cnind, itadmin_mysql_sz_cn_speed, nf, mr,
	itadmin_mysql_cn_speed
      );
      back = 1;
      do {
        mrow = mysql_fetch_row(mr);
	if(mrow) {
	  lgts = mysql_fetch_lengths(mr);
	  if(lgts) {
	    itadmin_data_mysql_set_pointers(
	      job, val, cnind, itadmin_mysql_sz_cn_speed,
	      nf, mrow, lgts
	    );
	    res = itadmin_register_speed(job, val[0], val[1]);
	    if(!(res)) { back = 0; }
	  } else {
	    back = 0;
	  }
	}
      } while(mrow);
      mysql_free_result(mr);
    } else {
      dk3app_log_1(job->app, DK3_LL_ERROR, job->msg, 141);
    }
  } else {
    dk3app_log_1(job->app, DK3_LL_ERROR, job->msg, 142);
  }
  

#line 1685 "itamysql.ctr"
  return back;
}



/**	Read buildings table.
	@param	job	Job structure.
	@return	1 on success, 0 on error.
*/
static
int
itadmin_data_mysql_buildings(itadmin_job *job)
{
  MYSQL_RES	*mr;		/* Results set. */
  MYSQL_ROW	 mrow;		/* One result row. */
  char const	*val[sizeof(itadmin_mysql_cn_buildings)/sizeof(DK3_PCCHAR) - 1];
  size_t	 cnind[sizeof(itadmin_mysql_cn_buildings)/sizeof(DK3_PCCHAR) - 1];
  unsigned long	*lgts;		/* Field lengths. */
  unsigned int	 nf;		/* Number of fields in result. */
  int		 res;		/* Query result. */
  int		 back	= 0;
  

#line 1707 "itamysql.ctr"
  res = mysql_query((MYSQL *)(job->dbptr), itadmin_mysql_c8_kw[1]);
  if(0 == res) {
    mr = mysql_use_result((MYSQL *)(job->dbptr));
    if(mr) {
      nf = mysql_num_fields(mr);
      itadmin_data_mysql_find_indices(
        job, cnind, itadmin_mysql_sz_cn_buildings, nf, mr,
	itadmin_mysql_cn_buildings
      );
      back = 1;
      do {
        mrow = mysql_fetch_row(mr);
	if(mrow) {
	  lgts = mysql_fetch_lengths(mr);
	  if(lgts) {
	    itadmin_data_mysql_set_pointers(
	      job, val, cnind, itadmin_mysql_sz_cn_buildings,
	      nf, mrow, lgts
	    );	

#line 1726 "itamysql.ctr"
	    res = itadmin_register_building(
	      job,
	      val[0], val[1], val[2], val[3], val[4], val[5], val[6], val[7]
	    );
	    if(!(res)) { back = 0; }
	  } else {
	    back = 0;				

#line 1733 "itamysql.ctr"
	  }
	}
      } while(mrow);
      mysql_free_result(mr);
    } else {
      dk3app_log_1(job->app, DK3_LL_ERROR, job->msg, 141);
    }
  } else {
    dk3app_log_1(job->app, DK3_LL_ERROR, job->msg, 142);
  }
  

#line 1744 "itamysql.ctr"
  return back;
}



/**	Read users table.
	@param	job	Job structure.
	@return	1 on success, 0 on error.
*/
static
int
itadmin_data_mysql_users(itadmin_job *job)
{
  MYSQL_RES	*mr;		/* Results set. */
  MYSQL_ROW	 mrow;		/* One result row. */
  char const	*val[sizeof(itadmin_mysql_cn_users)/sizeof(DK3_PCCHAR) - 1];
  size_t	 cnind[sizeof(itadmin_mysql_cn_users)/sizeof(DK3_PCCHAR) - 1];
  unsigned long	*lgts;		/* Field lengths array. */
  unsigned int	 nf;		/* Number of fields in result. */
  int		 res;		/* Query result. */
  int		 back	= 0;
  

#line 1766 "itamysql.ctr"
  res = mysql_query((MYSQL *)(job->dbptr), itadmin_mysql_c8_kw[0]);	

#line 1767 "itamysql.ctr"
  if(0 == res) {				

#line 1768 "itamysql.ctr"
    mr = mysql_use_result((MYSQL *)(job->dbptr));
    if(mr) {					

#line 1770 "itamysql.ctr"
      nf = mysql_num_fields(mr);		

#line 1771 "itamysql.ctr"
      itadmin_data_mysql_find_indices(
        job, cnind, itadmin_mysql_sz_cn_users, nf, mr, itadmin_mysql_cn_users
      );
      back = 1;
      do {					

#line 1776 "itamysql.ctr"
        mrow = mysql_fetch_row(mr);
	if(mrow) {				

#line 1778 "itamysql.ctr"
	  lgts = mysql_fetch_lengths(mr);
	  if(lgts) {				

#line 1780 "itamysql.ctr"
	    itadmin_data_mysql_set_pointers(
	      job, val, cnind, itadmin_mysql_sz_cn_users,
	      nf, mrow, lgts
	    );
	    res = itadmin_register_user(
	      job, val[0], val[1], val[2], val[3], val[4], val[5], val[6]
	    );
	    if(!(res)) {
	      back = 0;
	    }
	  } else {				

#line 1791 "itamysql.ctr"
	    back = 0;
	  }
	}					

#line 1794 "itamysql.ctr"
      } while(mrow);				

#line 1795 "itamysql.ctr"
      mysql_free_result(mr);
    } else {					

#line 1797 "itamysql.ctr"
      dk3app_log_1(job->app, DK3_LL_ERROR, job->msg, 141);
    }
  } else {					

#line 1800 "itamysql.ctr"
    dk3app_log_1(job->app, DK3_LL_ERROR, job->msg, 142);
  } 

#line 1802 "itamysql.ctr"
  return back;
}




/**	Retrieve data from a MySQL database.
	@param	job	Job structure.
	@return	1 on success, 0 on error.
*/
static
int
itadmin_data_mysql_retrieve(itadmin_job *job)
{
  int			back	= 1;
  

#line 1818 "itamysql.ctr"
  /* PROGRESS: Reading users table. */
  itadmin_tool_log_1(job, DK3_LL_PROGRESS, 87);
  if(!itadmin_data_mysql_users(job)) { back = 0; }
  /* PROGRESS: Reading buildings table. */
  itadmin_tool_log_1(job, DK3_LL_PROGRESS, 88);
  if(!itadmin_data_mysql_buildings(job)) { back = 0; }
  if(itadmin_job_do_network(job)) {
    /* PROGRESS: Reading connection speed type table. */
    itadmin_tool_log_1(job, DK3_LL_PROGRESS, 89);
    if(!itadmin_data_mysql_speed(job)) { back = 0; }
    /* PROGRESS: Reading VLANS table. */
    itadmin_tool_log_1(job, DK3_LL_PROGRESS, 90);
    if(!itadmin_data_mysql_vlan(job)) { back = 0; }
    /* PROGRESS: Reading ethernet connections table. */
    itadmin_tool_log_1(job, DK3_LL_PROGRESS, 91);
    if(!itadmin_data_mysql_patch(job)) { back = 0; }
    /* PROGRESS: Reading netgroups table. */
    itadmin_tool_log_1(job, DK3_LL_PROGRESS, 92);
    if(!itadmin_data_mysql_netgroup(job)) { back = 0; }
    /* PROGRESS: Reading netgroup dependencies. */
    itadmin_tool_log_1(job, DK3_LL_PROGRESS, 93);
    if(!itadmin_data_mysql_ngdep(job)) { back = 0; }
  }
  if((itadmin_job_do_dhcp(job)) || (itadmin_job_do_licenses(job))) {
    /* PROGRESS: Reading networks. */
    itadmin_tool_log_1(job, DK3_LL_PROGRESS, 94);
    if(!itadmin_data_mysql_network(job)) { back = 0; }
  }
  if(itadmin_job_do_network(job)) {
    if(itadmin_job_do_dhcp(job)) {
      /* PROGRESS: Reading DHCP classes. */
      itadmin_tool_log_1(job, DK3_LL_PROGRESS, 95);
      if(!itadmin_data_mysql_dhcp_class(job)) { back = 0; }
      /* PROGRESS: Reading DHCP groups. */
      itadmin_tool_log_1(job, DK3_LL_PROGRESS, 96);
      if(!itadmin_data_mysql_dhcp_group(job)) { back = 0; }
    }
  }
  if((itadmin_job_do_dhcp(job)) || (itadmin_job_do_licenses(job))) {
    /* PROGRESS: Reading DHCP pools. */
    itadmin_tool_log_1(job, DK3_LL_PROGRESS, 97);
    if(!itadmin_data_mysql_dhcp_pool(job)) { back = 0; }
  }
  /* PROGRESS: Reading hosts. */
  itadmin_tool_log_1(job, DK3_LL_PROGRESS, 98);
  if(!itadmin_data_mysql_hosts(job)) { back = 0; }
  /* PROGRESS: Reading host name aliases. */
  itadmin_tool_log_1(job, DK3_LL_PROGRESS, 99);
  if(!itadmin_data_mysql_alias(job)) { back = 0; }
  if(itadmin_job_do_dhcp(job)) {
    /* PROGRESS: Reading DHCP options. */
    itadmin_tool_log_1(job, DK3_LL_PROGRESS, 100);
    if(!itadmin_data_mysql_dhcp_option(job)) { back = 0; }
  }
  if(itadmin_job_do_licenses(job)) {
    /* PROGRESS: Reading software manufacturers. */
    itadmin_tool_log_1(job, DK3_LL_PROGRESS, 101);
    if(!itadmin_data_mysql_swman(job)) { back = 0; }
    /* PROGRESS: Reading software products. */
    itadmin_tool_log_1(job, DK3_LL_PROGRESS, 102);
    if(!itadmin_data_mysql_swprod(job)) { back = 0; }
    /* PROGRESS: Reading license types. */
    itadmin_tool_log_1(job, DK3_LL_PROGRESS, 103);
    if(!itadmin_data_mysql_lictype(job)) { back = 0; }
    /* PROGRESS: Reading licenses. */
    itadmin_tool_log_1(job, DK3_LL_PROGRESS, 104);
    if(!itadmin_data_mysql_license(job)) { back = 0; }
  }
  /* PROGRESS: Finished reading input. */
  itadmin_tool_log_1(job, DK3_LL_PROGRESS, 105);
  

#line 1889 "itamysql.ctr"
  return back;
}


#endif

int
itadmin_data_mysql_read(itadmin_job *job)
{
#if DK3_HAVE_MYSQL_MYSQL_H
  char			 dbh[ITADMIN_CONFIG_LINE_SIZE];	/* Host name. */
  char			 dbu[ITADMIN_CONFIG_LINE_SIZE];	/* User name. */
  char			 dbp[ITADMIN_CONFIG_LINE_SIZE];	/* Password. */
  char			 dbn[ITADMIN_CONFIG_LINE_SIZE];	/* DB name. */
  MYSQL			*re1;
  MYSQL			*res;				/* Same connection. */
  int			 ie;				/* INput encoding. */
  int			 back	= 0;
  

#line 1908 "itamysql.ctr"
  ie = dk3app_get_encoding(job->app);
  if(0 == mysql_library_init(-1, itadmin_mysql_argv, itadmin_mysql_groups)) {
    re1 = mysql_init(NULL);
    if(re1) {
      if(dk3str_to_c8u_app(dbh,sizeof(dbh),job->dbhn,ie,job->app)) {
        if(dk3str_to_c8u_app(dbu,sizeof(dbu),job->dbus,ie,job->app)) {
	  if(dk3str_to_c8u_app(dbp,sizeof(dbp),job->dbpw,ie,job->app)) {
	    if(dk3str_to_c8u_app(dbn,sizeof(dbn),job->dbn,ie,job->app)) {
	      

#line 1917 "itamysql.ctr"
	      res = mysql_real_connect(re1, dbh, dbu, dbp, dbn, 0, NULL, 0);
	      if(res) {					

#line 1919 "itamysql.ctr"
	        job->dbptr = (void *)res;
	        if(mysql_set_character_set(res, "utf8")) {	

#line 1921 "itamysql.ctr"
		  /* WARNING: Failed to set encoding! */
		  dk3app_log_1(job->app, DK3_LL_WARNING, job->msg, 154);
		}
	        back = itadmin_data_mysql_retrieve(job);
	      } else {					

#line 1926 "itamysql.ctr"
	        /* ERROR: Failed to connect to database! */
		itadmin_tool_log_utf8_5(job,DK3_LL_ERROR,155,156,157,dbn,dbh);
	      }
	    } else {					

#line 1930 "itamysql.ctr"
	      /* ERROR: Failed to convert database name! */
	      dk3app_log_3(job->app,DK3_LL_ERROR,job->msg,158,159,job->dbn);
	    }
	  } else {					

#line 1934 "itamysql.ctr"
	    /* ERROR: Failed to convert database user password! */
	    dk3app_log_1(job->app, DK3_LL_ERROR, job->msg, 160);
	  }
	} else { 					

#line 1938 "itamysql.ctr"
	  /* ERROR: Failed to convert database user name! */
	  dk3app_log_3(job->app, DK3_LL_ERROR, job->msg, 161, 162, job->dbus);
	}
      } else {						

#line 1942 "itamysql.ctr"
        /* ERROR: Failed to convert database host name! */
	dk3app_log_3(job->app, DK3_LL_ERROR, job->msg, 163, 164, job->dbhn);
      }
      mysql_close(re1);
    } else {
      /* ERROR: Failed to initialize MySQL client object! */
      dk3app_log_1(job->app, DK3_LL_ERROR, job->msg, 165);
    }
    mysql_library_end();
  } else {
    /* ERROR: Failed to initialize MySQL library! */
    dk3app_log_1(job->app, DK3_LL_ERROR, job->msg, 166);
  }
  

#line 1956 "itamysql.ctr"
#else
  int			back	= 0;
  /* ERROR: No MySQL support available! */
  dk3app_log_1(job->app, DK3_LL_ERROR, job->msg, 167);
#endif
  return back;
}



