/*
	WARNING: This file was generated by dkct.
	Changes you make here will be lost if dkct is run again!
	You should modify the original source and run dkct on it.
	Original source: itamem.ctr
*/

/*
Copyright (C) 2012-2014, Dirk Krause

Redistribution and use in source and binary forms, with or without
modification, are permitted provided that the following conditions are met:

* Redistributions of source code must retain the above copyright notice,
  this list of conditions and the following disclaimer.
* Redistributions in binary form must reproduce the above opyright notice,
  this list of conditions and the following disclaimer in the documentation
  and/or other materials provided with the distribution.
* Neither the name of the author nor the names of contributors may be used
  to endorse or promote products derived from this software without specific
  prior written permission.

THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS ``AS IS''
AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
ARE DISCLAIMED.
IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE LIABLE FOR ANY
DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
(INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
(INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
*/

/**	@file itamem.c The itamem module.
*/


#line 10 "itamem.ctr"

#include "dk3all.h"
#include "itadmin.h"





#line 17 "itamem.ctr"





#line 21 "itamem.ctr"


#line 22 "itamem.ctr"


#line 23 "itamem.ctr"


#line 24 "itamem.ctr"



void
itadmin_mem_date_init(itadmin_date *dp)
{
  dp->y = 0;
  dp->m = 0;
  dp->d = 0;
}



void
itadmin_mem_date_copy(itadmin_date *dp, itadmin_date *sp)
{
  dp->y = sp->y;
  dp->m = sp->m;
  dp->d = sp->d;
}



void
itadmin_mem_user_del(void *v)
{
  itadmin_user	*u;
  

#line 52 "itamem.ctr"
  if(v) {
    u = (itadmin_user *)v;	

#line 54 "itamem.ctr"
    dk3_release(u->us);
    dk3_release(u->tt);
    dk3_release(u->sn);
    dk3_release(u->na);
    dk3_release(u->em);
    dk3_release(u->cc);
    dk3_release(u->si);
    if(u->s_ho) {
      if(u->i_ho) {
        dk3sto_it_close(u->i_ho);
      }
      dk3sto_close(u->s_ho);
    }
    u->s_ho = NULL; u->i_ho = NULL;
    if(u->s_li) {
      if(u->i_li) {
        dk3sto_it_close(u->i_li);
      }
      dk3sto_close(u->s_li);
    }
    u->s_li = NULL; u->i_li = NULL;
    dk3_delete(v);
  } 

#line 77 "itamem.ctr"
}



void
itadmin_mem_building_del(void *v)
{
  itadmin_building	*b;
  

#line 86 "itamem.ctr"
  if(v) {
    b = (itadmin_building *)v;	

#line 88 "itamem.ctr"
    dk3_release(b->s);
    dk3_release(b->l);
    dk3_release(b->a1);
    dk3_release(b->a2);
    dk3_release(b->a3);
    dk3_release(b->a4);
    dk3_release(b->zc);
    dk3_release(b->city);
    dk3_delete(v);
  } 

#line 98 "itamem.ctr"
}



void
itadmin_mem_speed_del(void *v)
{
  itadmin_speed	*s;
  

#line 107 "itamem.ctr"
  if(v) {
    s = (itadmin_speed *)v;	

#line 109 "itamem.ctr"
    dk3_release(s->s);
    dk3_release(s->l);
    dk3_delete(v);
  } 

#line 113 "itamem.ctr"
}



void
itadmin_mem_vlan_del(void *v)
{
  itadmin_vlan		*l;
  itadmin_dhcp_option	*d;
  

#line 123 "itamem.ctr"
  if(v) {
    l = (itadmin_vlan *)v;	

#line 125 "itamem.ctr"
    dk3_release(l->s);
    dk3_release(l->l);
    if(l->s_nw) {
      if(l->i_nw) {
        dk3sto_it_close(l->i_nw);
      }
      dk3sto_close(l->s_nw);
    }
    l->s_nw = NULL; l->i_nw = NULL;
    if(l->s_do) {
      if(l->i_do) {
        dk3sto_it_reset(l->i_do);
	while(NULL != (d = (itadmin_dhcp_option *)dk3sto_it_next(l->i_do))) {
	  itadmin_mem_dhcp_option_del((void *)d);
	}
	dk3sto_it_close(l->i_do);
      }
      dk3sto_close(l->s_do);
    }
    l->s_do = NULL; l->i_do = NULL;
    dk3_delete(v);
  } 

#line 147 "itamem.ctr"
}



void
itadmin_mem_connect_del(void *v)
{
  itadmin_connect *c;
  

#line 156 "itamem.ctr"
  if(v) {
    c = (itadmin_connect *)v;	

#line 158 "itamem.ctr"
    dk3_release(c->s);
    dk3_release(c->hp);
    dk3_release(c->room);
    c->sp = NULL; c->vl = NULL; c->bu = NULL;
    dk3_delete(v);
  } 

#line 164 "itamem.ctr"
}



void
itadmin_mem_dhcp_ginw_del(itadmin_dhcp_ginw *g)
{
  if(g) {
    g->gr = NULL;
    if(g->s_h) {
      if(g->i_h) {
        dk3sto_it_close(g->i_h);
      }
      dk3sto_close(g->s_h);
    }
    g->s_h = NULL; g->i_h = NULL;
    dk3_delete(g);
  }
}



void
itadmin_mem_network_del(void *v)
{
  itadmin_network 	*n;
  itadmin_dhcp_ginw	*ginw;
  void			*vp;
  

#line 193 "itamem.ctr"
  if(v) {
    n = (itadmin_network *)v;	

#line 195 "itamem.ctr"
    n->ip4 = 0UL;		

#line 196 "itamem.ctr"
    n->ma4 = 0UL;		

#line 197 "itamem.ctr"
    n->gw4 = 0UL;		

#line 198 "itamem.ctr"
    n->bc4 = 0UL;
    n->vl  = NULL;
    if(n->s_dg) {
      if(n->i_dg) {
        dk3sto_it_reset(n->i_dg);
	while(NULL != (ginw = (itadmin_dhcp_ginw *)dk3sto_it_next(n->i_dg))) {
	  itadmin_mem_dhcp_ginw_del(ginw);
	}
	dk3sto_it_close(n->i_dg);
      }
      dk3sto_close(n->s_dg);
    }
    n->s_dg = NULL; n->i_dg = NULL;
    if(n->s_p) {
      if(n->i_p) {
        dk3sto_it_close(n->i_p);
      }
      dk3sto_close(n->s_p);
    }
    n->s_p = NULL; n->i_p = NULL;
    if(n->s_do) {
      if(n->i_do) {
        dk3sto_it_reset(n->i_do);
	while(NULL != (vp = dk3sto_it_next(n->i_do))) {
	  itadmin_mem_dhcp_option_del(vp);
	}
	dk3sto_it_close(n->i_do);
      }
      dk3sto_close(n->s_do);
    }
    n->s_do = NULL; n->i_do = NULL;
    if(n->s_hoi) {
      if(n->i_hoi) {
        dk3sto_it_close(n->i_hoi);
      }
      dk3sto_close(n->s_hoi);
    }
    n->s_hoi = NULL; n->i_hoi = NULL;
    if(n->s_dc) {
      if(n->i_dc) {
        dk3sto_it_close(n->i_dc);
      }
      dk3sto_close(n->s_dc);
    }
    n->s_dc = NULL; n->i_dc = NULL;
    dk3_delete(v);
  } 

#line 245 "itamem.ctr"
}



void
itadmin_mem_netgroup_del(void *v)
{
  itadmin_netgroup *g;
  

#line 254 "itamem.ctr"
  if(v) {
    g = (itadmin_netgroup *)v;	

#line 256 "itamem.ctr"
    dk3_release(g->sn);
    dk3_release(g->ln);
    dk3_delete(v);
  } 

#line 260 "itamem.ctr"
}



void
itadmin_mem_ngdep_del(void *v)
{
  itadmin_ngdep	*d;
  if(v) {	

#line 269 "itamem.ctr"
    d = (itadmin_ngdep *)v;
    d->pa = NULL;
    d->ch = NULL;
    dk3_delete(v);
  }
}



void
itadmin_mem_dhcp_class_del(void *v)
{
  itadmin_dhcp_class	*c;
  

#line 283 "itamem.ctr"
  if(v) {
    c = (itadmin_dhcp_class *)v; 

#line 285 "itamem.ctr"
    dk3_release(c->sn);
    dk3_release(c->ln);
    if(c->s_ho) {
      if(c->i_ho) {
        dk3sto_it_close(c->i_ho);
      }
      dk3sto_close(c->s_ho);
    }
    c->s_ho = NULL; c->i_ho = NULL;
    c->dhcpn = NULL;
    dk3_delete(v);
  } 

#line 297 "itamem.ctr"
}



void
itadmin_mem_dhcp_pool_del(void *v)
{
  itadmin_dhcp_pool	*p;
  itadmin_dhcp_option	*pdo;
  

#line 307 "itamem.ctr"
  if(v) {
    p = (itadmin_dhcp_pool *)v;
    p->nw = NULL;
    p->acl = NULL;	

#line 311 "itamem.ctr"
    p->ip4s = 0UL;	

#line 312 "itamem.ctr"
    p->ip4e = 0UL;
    if(p->s_do) {
      if(p->i_do) {
        dk3sto_it_reset(p->i_do);
	while(NULL != (pdo = (itadmin_dhcp_option *)dk3sto_it_next(p->i_do))) {
	  itadmin_mem_dhcp_option_del((void *)pdo);
	}
	dk3sto_it_close(p->i_do);
      }
      dk3sto_close(p->s_do);
    }
    p->s_do = NULL; p->i_do = NULL;
    if(p->s_hoi) {
      if(p->i_hoi) {
        dk3sto_it_close(p->i_hoi);
      }
      dk3sto_close(p->s_hoi);
    }
    p->s_hoi = NULL; p->i_hoi = NULL;
    p->duc = 0x00; p->auc = 0x00;
    dk3_delete(v);
  } 

#line 334 "itamem.ctr"
}



void
itadmin_mem_dhcp_group_del(void *v)
{
  itadmin_dhcp_group	*g;
  void			*vp;
  

#line 344 "itamem.ctr"
  if(v) {
    g = (itadmin_dhcp_group *)v;	

#line 346 "itamem.ctr"
    dk3_release(g->sn);
    dk3_release(g->ln);
    if(g->s_do) {
      if(g->i_do) {
        dk3sto_it_reset(g->i_do);
	while(NULL != (vp = dk3sto_it_next(g->i_do))) {
	  itadmin_mem_dhcp_option_del(vp);
	}
	dk3sto_it_close(g->i_do);
      }
      dk3sto_close(g->s_do);
    }
    g->s_do = NULL; g->i_do = NULL;
    dk3_delete(v);
  } 

#line 361 "itamem.ctr"
}



void
itadmin_mem_host_del(void *v)
{
  itadmin_host	*h;
  char const	*c;
  void		*vp;
  

#line 372 "itamem.ctr"
  if(v) {
    h = (itadmin_host *)v;	

#line 374 "itamem.ctr"
    dk3_release(h->sn);
    dk3_release(h->co);
    dk3_release(h->maca);
    dk3_release(h->room);
    dk3_release(h->inv);
    dk3_release(h->serno);
    dk3_release(h->hid);
    dk3_release(h->dnsd);
    h->un = NULL;
    h->ng = NULL;
    h->dc = NULL;
    h->dg = NULL;
    h->nc = NULL;
    h->bu = NULL;
    itadmin_mem_date_init(&(h->expi));
    if(h->s_al) {
      if(h->i_al) {
        dk3sto_it_reset(h->i_al);
	while((c = (char const *)dk3sto_it_next(h->i_al)) != NULL) {
	  dk3_delete(c);
	}
	dk3sto_it_close(h->i_al);
      }
      dk3sto_close(h->s_al);
    }
    h->s_al = NULL; h->i_al = NULL;
    if(h->s_do) {
      if(h->i_do) {
        dk3sto_it_reset(h->i_do);
	while(NULL != (vp = dk3sto_it_next(h->i_do))) {
	  itadmin_mem_dhcp_option_del(vp);
	}
	dk3sto_it_close(h->i_do);
      }
      dk3sto_close(h->s_do);
    }
    h->s_do = NULL; h->i_do = NULL;
    if(h->s_li) {
      if(h->i_li) {
        dk3sto_it_close(h->i_li);
      }
      dk3sto_close(h->s_li);
    }
    h->s_li = NULL; h->i_li = NULL;
    h->ipv4 = 0UL;
    h->fnf = h->fgu = h->snd = h->saw = 0x00;
    dk3_delete(v);
  } 

#line 422 "itamem.ctr"
}



void
itadmin_mem_sw_man_del(void *v)
{
  itadmin_swman	*m;
  

#line 431 "itamem.ctr"
  if(v) {
    m = (itadmin_swman *)v;	

#line 433 "itamem.ctr"
    dk3_release(m->sn);
    dk3_release(m->ln);
    dk3_delete(v);
  } 

#line 437 "itamem.ctr"
}



void
itadmin_mem_software_del(void *v)
{
  itadmin_swprod	*p;
  

#line 446 "itamem.ctr"
  if(v) {
    p = (itadmin_swprod *)v;	

#line 448 "itamem.ctr"
    dk3_release(p->sn);
    dk3_release(p->ln);
    p->mn = NULL;
    dk3_delete(v);
  } 

#line 453 "itamem.ctr"
}



void
itadmin_mem_lic_type_del(void *v)
{
  itadmin_lictype	*t;
  

#line 462 "itamem.ctr"
  if(v) {
    t = (itadmin_lictype *)v;	

#line 464 "itamem.ctr"
    dk3_release(t->sn);
    dk3_release(t->ln);
    t->num = 0;
    dk3_delete(v);
  } 

#line 469 "itamem.ctr"
}



void
itadmin_mem_license_del(void *v)
{
  itadmin_license	*l;
  

#line 478 "itamem.ctr"
  if(v) {
    l = (itadmin_license *)v;	

#line 480 "itamem.ctr"
    dk3_release(l->order);
    dk3_release(l->notes);
    dk3_release(l->i_del);
    dk3_release(l->i_inv);
    itadmin_mem_date_init(&(l->d_del));
    itadmin_mem_date_init(&(l->d_inv));
    l->prod = NULL;
    l->ltype = NULL;
    l->owner = NULL;
    l->host = NULL;
    l->pk = 0UL;
    dk3_delete(v);
  } 

#line 493 "itamem.ctr"
}



/**	Set a string pointer.
	@param	job	Job structure.
	@param	dptr	Address of destination pointer.
	@param	sstr	Source pointer.
	@return	1 on success, 0 on error.
*/
static
int
itadmin_mem_set_string(
  itadmin_job	 *job,
  char const	**dptr,
  char const	 *sstr
)
{
  char		 bu[ITADMIN_CONFIG_LINE_SIZE];
  char		*p1;
  char const	*np;
  int		 back	= 0;
  if(sstr) {
    dk3_release(*dptr);
    if(dk3str_c8_len(sstr) < sizeof(bu)) {
      dk3str_c8_cpy_not_overlapped(bu, sstr);
      p1 = dk3str_c8_start(bu, NULL);
      if(p1) {
        dk3str_c8_normalize(p1,NULL,' ');
	np = dk3str_c8_dup_app(p1, job->app);
	if(np) {
	  *dptr = np;
	  back = 1;
	} else {
	  /* ERROR: Memory */
	  job->ec = DK3_ERROR_MEMORY;
	}
      } else {
        back = 1;	/* Empty text */
      }
    } else {
      np = dk3str_c8_dup_app(sstr, job->app);
      if(np) {
	*dptr = np;
	back = 1;
      } else {
        /* ERROR: Memory */
	job->ec = DK3_ERROR_MEMORY;
      }
    }
  }
  return back;
}



/**	Create new user.
	@param	job	Job structure.
	@param	un	Name.
	@param	tt	Academic degree or title (may be NULL).
	@param	sn	Surname (may be NULL).
	@param	na	Name.
	@param	em	E-Mail (may be NULL).
	@param	cc	Cost control ID (may be NULL).
	@param	si	Staff ID number (may be NULL).
	@return	Pointer to new object on success, NULL on error.
*/
itadmin_user *
itadmin_mem_user_new(
  itadmin_job	*job,
  char const	*un,
  char const	*tt,
  char const	*sn,
  char const	*na,
  char const	*em,
  char const	*cc,
  char const	*si
)
{
  itadmin_user		*back	= NULL;
  int			 ok	= 1;
  if(un) {
    back = dk3_new_app(itadmin_user,1,job->app);
    if(back) {
      back->us = NULL;
      back->tt = NULL;
      back->sn = NULL;
      back->na = NULL;
      back->em = NULL;
      back->cc = NULL;
      back->si = NULL;
      back->s_ho = NULL;
      back->i_ho = NULL;
      back->s_li = NULL;
      back->i_li = NULL;
      if(un) { if(!itadmin_mem_set_string(job, &(back->us), un)) { ok = 0; } }
      if(tt) { if(!itadmin_mem_set_string(job, &(back->tt), tt)) { ok = 0; } }
      if(sn) { if(!itadmin_mem_set_string(job, &(back->sn), sn)) { ok = 0; } }
      if(na) { if(!itadmin_mem_set_string(job, &(back->na), na)) { ok = 0; } }
      if(em) { if(!itadmin_mem_set_string(job, &(back->em), em)) { ok = 0; } }
      if(cc) { if(!itadmin_mem_set_string(job, &(back->cc), cc)) { ok = 0; } }
      if(si) { if(!itadmin_mem_set_string(job, &(back->si), si)) { ok = 0; } }
      if(!(ok)) {
        itadmin_mem_user_del((void *)back);
        back = NULL;
      }
    } else {
      job->ec = DK3_ERROR_MEMORY;
    }
  }
  return back;
}



/**	Create new building.
	@param	job	Job structure.
	@param	s	Name.
	@param	l	Long name (may be NULL).
	@param	a1	Address line 1 (typically street and number,
			may be NULL).
	@param	a2	Address line 2 (may be NULL).
	@param	a3	Address line 3 (may be NULL).
	@param	a4	Address line 4 (may be NULL).
	@param	zc	Zip code (may be NULL).
	@param	city	Town or city name (may be NULL).
	@return	Pointer to new object on success, NULL on error.
*/
itadmin_building *
itadmin_mem_building_new(
  itadmin_job	*job,
  char const	*s,
  char const	*l,
  char const	*a1,
  char const	*a2,
  char const	*a3,
  char const	*a4,
  char const	*zc,
  char const	*city
)
{
  itadmin_building	*back	= NULL;
  int			 ok	= 1;
  

#line 637 "itamem.ctr"
  if(s) {
    back = dk3_new_app(itadmin_building,1,job->app);
    if(back) {						

#line 640 "itamem.ctr"
      back->s = NULL;
      back->l = NULL;
      back->a1 = NULL;
      back->a2 = NULL;
      back->a3 = NULL;
      back->a4 = NULL;
      back->zc = NULL;
      back->city = NULL;
      if(s) { if(!itadmin_mem_set_string(job, &(back->s), s)) { ok = 0; } }
      if(l) { if(!itadmin_mem_set_string(job, &(back->l), l)) { ok = 0; } }
      if(a1) { if(!itadmin_mem_set_string(job, &(back->a1), a1)) { ok = 0; } }
      if(a2) { if(!itadmin_mem_set_string(job, &(back->a2), a2)) { ok = 0; } }
      if(a3) { if(!itadmin_mem_set_string(job, &(back->a3), a3)) { ok = 0; } }
      if(a4) { if(!itadmin_mem_set_string(job, &(back->a4), a4)) { ok = 0; } }
      if(zc) { if(!itadmin_mem_set_string(job, &(back->zc), zc)) { ok = 0; } }
      if(city) { if(!itadmin_mem_set_string(job, &(back->city), city)) { ok = 0; } }
      if(!(ok)) {					

#line 657 "itamem.ctr"
        itadmin_mem_building_del((void *)back);
	back = NULL;
      }
    }
  } 

#line 662 "itamem.ctr"
  return back;
}



/**	Create new speed setting.
	@param	job	Job structure.
	@param	s	Name.
	@param	n	Description (may be NULL).
	@return	Pointer to new object on success, NULL on error.
*/
itadmin_speed *
itadmin_mem_speed_new(
  itadmin_job	*job,
  char const	*s,
  char const	*n
)
{
  itadmin_speed		*back	= NULL;
  int			 ok	= 1;
  if(s) {
    back = dk3_new_app(itadmin_speed,1,job->app);
    if(back) {
      back->s = NULL;
      back->l = NULL;
      if(s) { if(!itadmin_mem_set_string(job, &(back->s), s)) { ok = 0; } }
      if(n) { if(!itadmin_mem_set_string(job, &(back->l), n)) { ok = 0; } }
      if(!(ok)) {
        itadmin_mem_speed_del((void *)back);
	back = NULL;
      }
    }
  }
  return back;
}



/**	Create new VLAN.
	@param	job	Job structure.
	@param	s	Name.
	@param	l	Long name (may be NULL).
	@return	Pointer to new object on success, NULL on error.
*/
itadmin_vlan *
itadmin_mem_vlan_new(
  itadmin_job	*job,
  char const	*s,
  char const	*l
)
{
  itadmin_vlan		*back	= NULL;
  int			 ok	= 1;
  if(s) {
    back = dk3_new_app(itadmin_vlan,1,job->app);
    if(back) {
      back->s = NULL;
      back->l = NULL;
      back->s_nw = NULL;
      back->i_nw = NULL;
      back->s_do = NULL;
      back->i_do = NULL;
      if(s) { if(!itadmin_mem_set_string(job, &(back->s), s)) { ok = 0; } }
      if(l) { if(!itadmin_mem_set_string(job, &(back->l), l)) { ok = 0; } }
      if(itadmin_job_do_dhcp(job)) {
        back->s_nw = dk3sto_open_app(job->app);
        if(back->s_nw) {
	  dk3sto_set_comp(back->s_nw, itadmin_comp_network, 0);
          back->i_nw = dk3sto_it_open(back->s_nw);
	  if(back->i_nw) {
	  } else {
	    ok = 0;
	    /* ERROR: Memory */
	  }
        } else {
          ok = 0;
	  /* ERROR: Memory */
        }
      }
      if(!(ok)) {
        itadmin_mem_vlan_del((void *)back);
	back = NULL;
      }
    }
  }
  return back;
}



/**	Create new network connector.
	@param	job	Job structure.
	@param	s	Name.
	@param	hp	Hub port name/number.
	@param	room	Room.
	@param	sp	Speed setting.
	@param	vl	VLAN.
	@param	bu	Building.
	@return	Pointer to new object on success, NULL on error.
*/
itadmin_connect *
itadmin_mem_connect_new(
  itadmin_job		*job,
  char const		*s,
  char const		*hp,
  char const		*room,
  itadmin_speed		*sp,
  itadmin_vlan		*vl,
  itadmin_building	*bu
)
{
  itadmin_connect	*back	= NULL;
  int			 ok	= 1;
  if(s) {
    back = dk3_new_app(itadmin_connect,1,job->app);
    if(back) {
      back->s = NULL;
      back->hp = NULL;
      back->room = NULL;
      back->sp = sp;
      back->vl = vl;
      back->bu = bu;
      if(!itadmin_mem_set_string(job, &(back->s), s)) { ok = 0; }
      if(hp) { if(!itadmin_mem_set_string(job, &(back->hp), hp)) { ok = 0; } }
      if(room) {
        if(!itadmin_mem_set_string(job, &(back->room), room)) { ok = 0; }
      }
      if(!(ok)) {
        itadmin_mem_connect_del((void *)back);
	back = NULL;
      }
    }
  }
  return back;
}



itadmin_dhcp_ginw *
itadmin_mem_dhcp_ginw_new(itadmin_job *job, itadmin_dhcp_group *gr)
{
  itadmin_dhcp_ginw		*back	= NULL;
  if((job) && (gr)) {
    back = dk3_new_app(itadmin_dhcp_ginw,1,job->app);
    if(back) {
      back->gr = gr;
      back->s_h = NULL;
      back->i_h = NULL;
      back->s_h = dk3sto_open_app(job->app);
      if(back->s_h) {
        dk3sto_set_comp(back->s_h, itadmin_comp_host, 2);
        back->i_h = dk3sto_it_open(back->s_h);
      }
      if(!((back->s_h) && (back->i_h))) {
        itadmin_mem_dhcp_ginw_del(back);
      }
    }
  }
  return back;
}



/**	Create new network.
	@param	job	Job structure.
	@param	ip4	Network address.
	@param	ma4	Network mask.
	@param	gw4	Gateway.
	@param	bc4	Broadcast address.
	@param	vl	VLAN.
	@return	Pointer to new object on success, NULL on error.
*/
itadmin_network *
itadmin_mem_network_new(
  itadmin_job	*job,
  unsigned long	 ip4,
  unsigned long	 ma4,
  unsigned long	 gw4,
  unsigned long	 bc4,
  itadmin_vlan	*vl
)
{
  itadmin_network	*back	= NULL;
#if 0
  unsigned long		 ulip4;
  unsigned long		 ulma4;
  unsigned long		 ulgw4;
  unsigned long		 ulbc4;
  int			 ok	= 1;
  if((ip4) && (ma4) && (gw4)) {
    back = dk3_new_app(itadmin_network,1,job->app);
    if(back) {
      back->ip4 = back->ma4 = back->gw4 = back->bc4 = 0UL;
      back->vl = vl;
      back->s_p = NULL;
      back->i_p = NULL;
      back->s_dg = NULL;
      back->i_dg = NULL;
      back->s_hoi = NULL;
      back->i_hoi = NULL;
      back->s_dc = NULL;
      back->i_dc = NULL;
      if(!dk3enc_c8_ipaddr_to_ul_app(ip4, &ulip4, job->app)) { ok = 0; }
      if(!dk3enc_c8_ipaddr_to_ul_app(ma4, &ulma4, job->app)) { ok = 0; }
      if(!dk3enc_c8_ipaddr_to_ul_app(gw4, &ulgw4, job->app)) { ok = 0; }
      if(bc4) {
        if(!dk3enc_c8_ipaddr_to_ul_app(bc4, &ulbc4, job->app)) { ok = 0; }
      } else {
        ulbc4 = ((~(ulip4 & ulma4)) | ulip4);
      }
      back->ip4 = ulip4;
      back->ma4 = ulma4;
      back->gw4 = ulgw4;
      back->bc4 = ulbc4;
      if(job->f_dh) {
        back->s_p = dk3sto_open_app(job->app);
	if(back->s_p) {
	  dk3sto_set_comp(back->s_p, itadmin_comp_dhcp_pool, 0);
	  back->i_p = dk3sto_it_open(back->s_p);
	  if(back->i_p) {
	    back->s_dg = dk3sto_open_app(job->app);
	    if(back->s_dg) {
	      dk3sto_set_comp(back->s_dg, itadmin_comp_dhcp_ginw, 0);
	      back->i_dg = dk3sto_it_open(back->s_dg);
	      if(back->i_dg) {
	        /* Success. */
	      } else {
	        ok = 0;
	      }
	    } else {
	      ok = 0;
	    }
	  } else {
	    ok = 0;
	  }
	} else { ok = 0; }
      }
      if(!(ok)) {
        itadmin_mem_network_del((void *)back);
	back = NULL;
      }
    }
  }
#else
  if((ip4) && (ma4)) {
    int ok;
    back = dk3_new_app(itadmin_network,1,job->app);
    if(back) {
      ok = 1;
      back->ip4 = ip4;
      back->ma4 = ma4;
      back->gw4 = gw4;
      back->bc4 = bc4;
      back->vl  = vl;
      back->s_p = NULL;
      back->i_p = NULL;
      back->s_do = NULL;
      back->i_do = NULL;
      if(itadmin_job_do_dhcp(job)) {
        ok = 0;
        back->s_p = dk3sto_open_app(job->app);
	if(back->s_p) {
	  dk3sto_set_comp(back->s_p, itadmin_comp_dhcp_pool, 0);
	  back->i_p = dk3sto_it_open(back->s_p);
	  if(back->i_p) {
	    ok = 1;
	  }
	}
      }
      if(!(ok)) {
        itadmin_mem_network_del((void *)back);
	back = NULL;
      }
    }
  }
#endif
  return back;
}



/**	Create new netgroup
	@param	job	Job structure.
	@param	sn	Short name.
	@param	ln	Long name (may be NULL).
	@return	Pointer to new object on success, NULL on error.
*/
itadmin_netgroup *
itadmin_mem_netgroup_new(
  itadmin_job	*job,
  char const	*sn,
  char const	*ln
)
{
  itadmin_netgroup		*back	= NULL;
  int				 ok	= 1;
  if(sn) {
    back = dk3_new_app(itadmin_netgroup,1,job->app);
    if(back) {
      back->no = 0;
      back->ln = NULL;
      if(sn) { if(!itadmin_mem_set_string(job, &(back->sn), sn)) { ok = 0; } }
      if(ln) { if(!itadmin_mem_set_string(job, &(back->ln), ln)) { ok = 0; } }
      if(!(ok)) {
        itadmin_mem_netgroup_del((void *)back);
	back = NULL;
      }
    }
  }
  return back;
}



/**	Create new netgroup dependency.
	@param	job	Job structure.
	@param	pa	Parent group.
	@param	ch	Child group.
	@return	Pointer to new object on success, NULL on error.
*/
itadmin_ngdep *
itadmin_mem_ngdep_new(
  itadmin_job		*job,
  itadmin_netgroup	*pa,
  itadmin_netgroup	*ch
)
{
  itadmin_ngdep		*back	= NULL;
  if((pa) && (ch)) {
    back = dk3_new_app(itadmin_ngdep,1,job->app);
    if(back) {
      back->pa = pa;
      back->ch = ch;
    }
  }
  return back;
}



/**	Create new DHCP class.
	@param	job	Job structure.
	@param	sn	Short name.
	@param	ln	Long name (may be NULL).
	@return	Pointer to new object on success, NULL on error.
*/
itadmin_dhcp_class *
itadmin_mem_dhcp_class_new(
  itadmin_job	*job,
  char const	*sn,
  char const	*ln
)
{
  itadmin_dhcp_class	*back	= NULL;
  int			 ok	= 1;
  if(sn) {
    back = dk3_new_app(itadmin_dhcp_class,1,job->app);
    if(back) {
      back->s_ho = NULL;
      back->i_ho = NULL;
      back->dhcpn = NULL;
      if(!itadmin_mem_set_string(job, &(back->sn), sn)) { ok = 0; }
      if(ln) { if(!itadmin_mem_set_string(job, &(back->ln), ln)) { ok = 0; } }
      if(!(ok)) {
        itadmin_mem_dhcp_class_del((void *)back);
	back = NULL;
      }
    }
  }
  return back;
}



/**	Create new DHCP pool.
	@param	job	Job structure.
	@param	nw	Network.
	@param	cn	Allowed class (if unknown clients are denied,
			may be NULL).
	@param	ip4s	IPv4 start address.
	@param	ip4e	IPv4 end address.
	@param	duc	Flag: Deny unknown clients (needs cn).
	@param	auc	Flag: Allow unknown clients.
	@return	Pointer to new object on success, NULL on error.
*/
itadmin_dhcp_pool *
itadmin_mem_dhcp_pool_new(
  itadmin_job		*job,
  itadmin_network	*nw,
  itadmin_dhcp_class	*cn,
  unsigned long		 ip4s,
  unsigned long		 ip4e,
  int			 duc,
  int			 auc
)
{
  char			 buffer[128];
  itadmin_dhcp_pool	*back	= NULL;
  int			 ok	= 1;
  

#line 1062 "itamem.ctr"
  if((nw) && (ip4s) && (ip4e)) {
    back = dk3_new_app(itadmin_dhcp_pool,1,job->app);
    if(back) {
      back->nw = nw;
      back->acl = cn;
      back->s_do = NULL;
      back->i_do = NULL;
      back->s_hoi = NULL;
      back->i_hoi = NULL;
      back->ip4s = ip4s;
      back->ip4e = ip4e;
      back->duc = ((duc) ? 0x01 : 0x00);
      back->auc = ((auc) ? 0x01 : 0x00);
      if((duc) && (auc)) {
        ok = 0;
	/* ERROR: can not allow and deny at same time! */
	sprintf(
	  buffer,
	  "%lu.%lu.%lu.%lu",
	  ((ip4s >> 24) & 0x000000FFUL),
	  ((ip4s >> 16) & 0x000000FFUL),
	  ((ip4s >>  8) & 0x000000FFUL),
	  (ip4s & 0x000000FFUL)
	);
	itadmin_tool_log_utf8_3(job, DK3_LL_ERROR, 134, 135, buffer);
      }
      if(!(ok)) {
        itadmin_mem_dhcp_pool_del((void *)back);
	back = NULL;
      }
    }
  } 

#line 1094 "itamem.ctr"
  return back;
}



/**	Create new DHCP group.
	@param	job	Job structure.
	@param	sn	Short name.
	@param	ln	Long name (may be NULL).
	@return	Pointer to new object on success, NULL on error.
*/
itadmin_dhcp_group *
itadmin_mem_dhcp_group_new(
  itadmin_job	*job,
  char const	*sn,
  char const	*ln
)
{
  itadmin_dhcp_group	*back	= NULL;
  int			 ok	= 1;
  if(sn) {
    back = dk3_new_app(itadmin_dhcp_group,1,job->app);
    if(back) {
      back->sn = NULL;
      back->ln = NULL;
      back->s_do = NULL;
      back->i_do = NULL;
      if(!itadmin_mem_set_string(job, &(back->sn), sn)) { ok = 0; }
      if(ln) { if(!itadmin_mem_set_string(job, &(back->ln), ln)) { ok = 0; } }
      if(!(ok)) {
        itadmin_mem_dhcp_group_del((void *)back);
	back = NULL;
      }
    }
  }
  return back;
}



/**	Create new host
	@param	job	Job structure.
	@param	sn	Short name.
	@param	co	Comment/description (may be NULL).
	@param	maca	MAC address (may be NULL).
	@param	room	Room (may be NULL).
	@param	inv	Inventory number (may be NULL).
	@param	serno	Serial number (may be NULL).
	@param	hid	Host ID (may be NULL).
	@param	expi	Expiration date (may be NULL).
	@param	dnsd	DNS domain (may be NULL).
	@param	un	System owner.
	@param	ng	Netgroup (may be NULL).
	@param	dc	DHCP class (may be NULL).
	@param	dg	DHCP group (may be NULL).
	@param	nc	Network connection socket (may be NULL).
	@param	bu	Building (may be NULL).
	@param	ipv4	IPv4 address (may be NULL).
	@param	fnf	Flag: FQDN first in hosts file.
	@param	fgu	Flag: Guest computer (bring your own device).
	@param	snd	Flag: Skip in network documentation.
	@param	saw	Flag: Skip in arpwatch configuration.
	@return	Pointer to new object on success, NULL on error.
*/
itadmin_host *
itadmin_mem_host_new(
  itadmin_job		*job,
  itadmin_date		*expi,
  char const		*sn,
  char const		*co,
  char const		*maca,
  char const		*room,
  char const		*inv,
  char const		*serno,
  char const		*hid,
  char const		*dnsd,
  itadmin_user		*un,
  itadmin_netgroup	*ng,
  itadmin_dhcp_class	*dc,
  itadmin_dhcp_group	*dg,
  itadmin_connect	*nc,
  itadmin_building	*bu,
  unsigned long		 ipv4,
  int			 fnf,
  int			 fgu,
  int			 snd,
  int			 saw
)
{
  itadmin_host		*back	= NULL;
  int			 ok	= 1;
  

#line 1186 "itamem.ctr"
  

#line 1187 "itamem.ctr"
  

#line 1188 "itamem.ctr"
  

#line 1189 "itamem.ctr"
  

#line 1190 "itamem.ctr"
  

#line 1191 "itamem.ctr"
  

#line 1192 "itamem.ctr"
  

#line 1193 "itamem.ctr"
  

#line 1194 "itamem.ctr"
  

#line 1195 "itamem.ctr"
  

#line 1196 "itamem.ctr"
  

#line 1197 "itamem.ctr"
  

#line 1198 "itamem.ctr"
  

#line 1199 "itamem.ctr"
  if(sn) {					

#line 1200 "itamem.ctr"
    back = dk3_new_app(itadmin_host,1,job->app);
    if(back) {					

#line 1202 "itamem.ctr"
      back->sn = back->co = back->maca = back->room = back->inv = back->serno
      = back->hid = back->dnsd = NULL;
      itadmin_mem_date_init(&(back->expi));
      back->un = un;
      back->ng = ng;
      back->dc = dc;
      back->dg = dg;
      back->nc = nc;
      back->bu = bu;
      back->s_al = NULL;
      back->i_al = NULL;
      back->s_do = NULL;
      back->i_do = NULL;
      back->s_li = NULL;
      back->i_li = NULL;
      back->ipv4 = ipv4;
      back->fnf = ((fnf) ? 0x01 : 0x00);
      back->fgu = (char)fgu;
      back->snd = ((snd) ? 0x01 : 0x00);
      back->saw = ((saw) ? 0x01 : 0x00);
      back->dp = NULL;
      if(!itadmin_mem_set_string(job, &(back->sn), sn)) {
        ok = 0;					

#line 1225 "itamem.ctr"
      }
      if(co) {
        if(!itadmin_mem_set_string(job, &(back->co), co)) {
	  ok = 0;				

#line 1229 "itamem.ctr"
	}
      }
      if(maca) {
        if(!itadmin_mem_set_string(job, &(back->maca), maca)) {
	  ok = 0;				

#line 1234 "itamem.ctr"
	}
      }
      if(room) {
        if(!itadmin_mem_set_string(job, &(back->room), room)) {
	  ok = 0;				

#line 1239 "itamem.ctr"
	}
      }
      if(inv) {
        if(!itadmin_mem_set_string(job, &(back->inv), inv)) {
	  ok = 0;				

#line 1244 "itamem.ctr"
	}
      }
      if(serno) {
        if(!itadmin_mem_set_string(job, &(back->serno), serno)) {
	  ok = 0;				

#line 1249 "itamem.ctr"
	}
      }
      if(hid) {
        if(!itadmin_mem_set_string(job, &(back->hid), hid)) {
	  ok = 0;				

#line 1254 "itamem.ctr"
	}
      }
      if(expi) {
	itadmin_mem_date_copy(&(back->expi), expi);
      }
      if(dnsd) {
        if(!itadmin_mem_set_string(job, &(back->dnsd), dnsd)) {
	  ok = 0;				

#line 1262 "itamem.ctr"
	}
      }
      back->s_al = dk3sto_open_app(job->app);
      if(back->s_al) {
        /* SET COMPARISON FUNCTION */
	dk3sto_set_comp(back->s_al, itadmin_comp_string, 0);
	back->i_al = dk3sto_it_open(back->s_al);
	if(!(back->i_al)) { ok = 0; }
      } else { ok = 0; }
      if(!(ok)) {				

#line 1272 "itamem.ctr"
        itadmin_mem_host_del((void *)back);
	back = NULL;
      }
    } else {					

#line 1276 "itamem.ctr"
    }
  } else {					

#line 1278 "itamem.ctr"
  } 

#line 1279 "itamem.ctr"
  return back;
}



/**	Create new software manufacturer.
	@param	job	Job structure.
	@param	sn	Short name.
	@param	ln	Long name (description).
	@return	Pointer to new object on success, NULL on error.
*/
itadmin_swman *
itadmin_mem_swman_new(
  itadmin_job	*job,
  char const	*sn,
  char const	*ln
)
{
  itadmin_swman		*back	= NULL;
  int			 ok	= 1;
  if(sn) {
    back = dk3_new_app(itadmin_swman,1,job->app);
    if(back) {
      back->sn = NULL;
      back->ln = NULL;
      if(!itadmin_mem_set_string(job, &(back->sn), sn)) { ok = 0; }
      if(ln) { if(!itadmin_mem_set_string(job, &(back->ln), ln)) { ok = 0; } }
      if(!(ok)) {
        itadmin_mem_sw_man_del((void *)back);
	back = NULL;
      }
    }
  }
  return back;
}



/**	Create new software product.
	@param	job	Job structure.
	@param	sn	Short name.
	@param	ln	Long name.
	@param	mn	Software manufacturer (may be NULL).
	@return	Pointer to new object on success, NULL on error.
*/
itadmin_swprod *
itadmin_mem_swprod_new(
  itadmin_job	*job,
  char const	*sn,
  char const	*ln,
  itadmin_swman	*mn
)
{
  itadmin_swprod	*back	= NULL;
  int			 ok	= 1;
  if(sn) {
    back = dk3_new_app(itadmin_swprod,1,job->app);
    if(back) {
      back->sn = NULL;
      back->ln = NULL;
      back->mn = mn;
      if(!itadmin_mem_set_string(job, &(back->sn), sn)) { ok = 0; }
      if(ln) { if(!itadmin_mem_set_string(job, &(back->ln), ln)) { ok = 0; } }
      if(!(ok)) {
        itadmin_mem_software_del((void *)back);
	back = NULL;
      }
    }
  }
  return back;
}



/**	Create new license type.
	@param	job	Job structure.
	@param	sn	Short license type name.
	@param	ln	Long name (description).
	@param	num	Number of client licenses for floating license servers.
	@return	Pointer to new object on success, NULL on error.
*/
itadmin_lictype *
itadmin_mem_lictype_new(
  itadmin_job	*job,
  char const	*sn,
  char const	*ln,
  int		 num
)
{
  itadmin_lictype	*back	=	NULL;
  int			 ok	=	1;
  if(sn) {
    back = dk3_new_app(itadmin_lictype,1,job->app);
    if(back) {
      back->sn = NULL; back->ln = NULL; back->num = num;
      if(!itadmin_mem_set_string(job, &(back->sn), sn)) { ok = 0; }
      if(ln) { if(!itadmin_mem_set_string(job, &(back->ln), ln)) { ok = 0; } }
      if(!(ok)) {
        itadmin_mem_lic_type_del((void *)back);
	back = NULL;
      }
    }
  }
  return back;
}



itadmin_license *
itadmin_mem_license_new(
  itadmin_job		*job,
  unsigned long		 pk,
  char const		*order,
  char const		*notes,
  itadmin_date		*d_del,
  char const		*i_del,
  itadmin_date		*d_inv,
  char const		*i_inv,
  itadmin_swprod	*prod,
  itadmin_lictype	*ltype,
  itadmin_user		*owner,
  itadmin_host		*host
)
{
  itadmin_license	*back	=	NULL;
  int			 ok	=	1;
  if(prod) {
    back = dk3_new_app(itadmin_license,1,job->app);
    if(back) {
      back->order = NULL;
      back->notes = NULL;
      itadmin_mem_date_init(&(back->d_del));
      back->i_del = NULL;
      itadmin_mem_date_init(&(back->d_inv));
      back->i_inv = NULL;
      back->pk = pk;
      back->prod = prod;
      back->ltype = ltype;
      back->owner = owner;
      back->host = host;
      if(order) {
        if(!itadmin_mem_set_string(job, &(back->order), order)) { ok = 0; }
      }
      if(notes) {
        if(!itadmin_mem_set_string(job, &(back->notes), notes)) { ok = 0; }
      }
      if(i_del) {
        if(!itadmin_mem_set_string(job, &(back->i_del), i_del)) { ok = 0; }
      }
      if(i_inv) {
        if(!itadmin_mem_set_string(job, &(back->i_inv), i_inv)) { ok = 0; }
      }
      if(!(ok)) {
        itadmin_mem_license_del((void *)back);
	back = NULL;
      }
    }
  }
  return back;
}



void
itadmin_mem_dhcp_option_del(void *v)
{
  itadmin_dhcp_option *o;
  

#line 1447 "itamem.ctr"
  if(v) {
    o = (itadmin_dhcp_option *)v; 

#line 1449 "itamem.ctr"
    dk3_release(o->k);
    dk3_release(o->v);
    dk3_release(o);
  } 

#line 1453 "itamem.ctr"
}



itadmin_dhcp_option *
itadmin_mem_dhcp_option_new(
  itadmin_job	*job,
  char const	*k,
  char const	*v,
  long		 pk
)
{
  itadmin_dhcp_option	*back	= NULL;
  int			 ok	= 1;
  if((job) && (k)) {
    back = dk3_new_app(itadmin_dhcp_option,1,job->app);
    if(back) {
      back->k  = NULL;
      back->v  = NULL;
      back->pk = pk;
      if(!itadmin_mem_set_string(job, &(back->k), k)) { ok = 0; }
      if(v) { if(!itadmin_mem_set_string(job, &(back->v), v)) { ok = 0; } }
      if(!(ok)) {
        itadmin_mem_dhcp_option_del((void *)back);
	back = NULL;
      }
    }
  }
  return back;
}



itadmin_swman *
itadmin_mem_sw_man_new(itadmin_job *job, char const *sn, char const *ln)
{
  itadmin_swman		*back	= NULL;
  int			 ok	= 1;
  if((job) && (sn)) {
    back = dk3_new_app(itadmin_swman,1,job->app);
    if(back) {
      back->sn = NULL;
      back->ln = NULL;
      if(sn) { if(!itadmin_mem_set_string(job, &(back->sn), sn)) { ok = 0; } }
      if(ln) { if(!itadmin_mem_set_string(job, &(back->ln), ln)) { ok = 0; } }
      if(!(ok)) {
        itadmin_mem_sw_man_del(back);
	back = NULL;
      }
    }
  }
  return back;
}

