/*
	WARNING: This file was generated by dkct.
	Changes you make here will be lost if dkct is run again!
	You should modify the original source and run dkct on it.
	Original source: italic.ctr
*/

/*
Copyright (C) 2012-2014, Dirk Krause

Redistribution and use in source and binary forms, with or without
modification, are permitted provided that the following conditions are met:

* Redistributions of source code must retain the above copyright notice,
  this list of conditions and the following disclaimer.
* Redistributions in binary form must reproduce the above opyright notice,
  this list of conditions and the following disclaimer in the documentation
  and/or other materials provided with the distribution.
* Neither the name of the author nor the names of contributors may be used
  to endorse or promote products derived from this software without specific
  prior written permission.

THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS ``AS IS''
AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
ARE DISCLAIMED.
IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE LIABLE FOR ANY
DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
(INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
(INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
*/

/**	@file italic.c The italic module.
*/


#line 9 "italic.ctr"

#include "dk3all.h"
#include "itadmin.h"





#line 16 "italic.ctr"



/**	Keywords used by the module.
*/
static char const * const itadmin_license_c8_kw[] = {
/* 0 */
"\n",

/* 1 */
" ",

/* 2 */
"licenses.tex",

/* 3 */
"w",

/* 4 */
"\\chapter{",

/* 5 */
"}",

/* 6 */
"\\clearpage",

/* 7 */
"\\\\\n\\end{longtable}",

/* 8 */
"\\section{",

/* 9 */
"\\subsection{",

/* 10 */
"\\subsubsection{",

/* 11 */
"pdftitle={",

/* 12 */
"pdfsubject={",

/* 13 */
"pdfauthor={",

/* 14 */
"pdfcreator={itadmin - http://dktools.sourceforge.net/}",

/* 15 */
"\\author{",

/* 16 */
"\\title{",

/* 17 */
",",

/* 18 */
"\\begin{longtable}{lll}",

/* 19 */
"\\endfirsthead",

/* 20 */
"\\endhead",

/* 21 */
"\\endfoot",

/* 22 */
"\\endlastfoot",

/* 23 */
"\\\\[0.5em]",

/* 24 */
"&",

/* 25 */
"\\multicolumn{2}{l}{",

/* 26 */
"\\\\*",

/* 27 */
"\\textit{",

/* 28 */
"\\chapter[",

/* 29 */
"]{",

/* 30 */
"\\section[",

/* 31 */
"\\emph{",

/* 32 */
"\\/} ",

NULL


#line 156 "italic.ctr"
};



/**	Start of LaTeX source.
*/
static char const * const	itadmin_license_file_start1a[] = {
"\\documentclass[titlepage,origlongtable]{scrbook}",
"\\KOMAoptions{paper=a4}",
"\\KOMAoptions{fontsize=12pt}",
NULL


#line 168 "italic.ctr"
};



/**	Start of LaTeX source.
*/
static char const * const	itadmin_license_file_start1b[] = {
"\\documentclass[12pt]{book}",
NULL


#line 178 "italic.ctr"
};


/**	LaTeX packages after ngerman.
*/
static char const * const       itadmin_license_file_start4[] = {
"\\usepackage{ifpdf}",
"\\usepackage[utf8]{inputenc}",
"\\usepackage{mathptmx}",
"\\usepackage[scaled=.92]{helvet}",
"\\usepackage{courier}",
"\\usepackage[T1]{fontenc}",
"\\usepackage{textcomp}",
"\\usepackage{latexsym}",
"\\usepackage{varioref}",
"\\usepackage{color}",
"\\usepackage{makeidx}",
"\\usepackage{longtable}",
"\\makeindex",
"\\ifpdf",
"\\usepackage[activate=normal]{pdfcprot}",
"\\pdfcompresslevel=9",
"\\usepackage[",
"pdftex,",
"colorlinks=true,",
"pdfpagemode=UseNone,",
"pdfstartview={XYZ 0 835 1.25},",
"bookmarksnumbered,",
NULL


#line 208 "italic.ctr"
};



/**	LaTeX package after hyperref options for title, subject, author.
*/
static char const * const	itadmin_license_file_start2[] = {
"]{hyperref}",
"\\else",
"\\usepackage[dvips,colorlinks=true,linkcolor=black]{hyperref}",
"\\fi",
"\\parindent0cm",
NULL


#line 222 "italic.ctr"
};



/**	Renewcommand used only for koma-script.
*/
static char const * const	itadmin_license_file_start3a[] = {
"\\renewcommand*{\\sectfont}{\\bfseries}",
NULL


#line 232 "italic.ctr"
};



/**	Final commands after title and author.
*/
static char const * const	itadmin_license_file_start3[] = {
"\\setcounter{secnumdepth}{1}",
"\\begin{document}",
NULL


#line 243 "italic.ctr"
};



/**	LaTeX file end.
*/
static char const * const	itadmin_license_file_end[] = {
"\\end{document}",
NULL


#line 253 "italic.ctr"
};



/**	Write data for one license.
	@param	job	Job structure.
	@param	os	Output stream.
	@param	lic	License to write.
*/
static
void
itadmin_license_write_license_type(
  itadmin_job		*job,
  dk3_stream_t		*os,
  itadmin_license	*lic
)
{
  char const		*ltn;
  int			 ie;
  ltn = NULL;
  if(lic->ltype) {
    ltn = (lic->ltype)->sn;
    if((lic->ltype)->ln) {
      ltn = (lic->ltype)->ln;
    }
  }
  dk3stream_c8_fputs(os, itadmin_license_c8_kw[25]);
  if(ltn) {
    dk3uc2lat_c8_utf8_stputs(job->uc2l, os, ltn);
  } else {
    ie = dk3app_get_encoding(job->app);
    dk3uc2lat_stputs(job->uc2l, os, (job->msg)[53], ie);
  }
  dk3stream_c8_fputs(os, itadmin_license_c8_kw[5]);
}



/**	Check whether we must write the license owner because the host owner
	differs from the license owner.
	@param	user	License owner.
	@param	host	Host on which the license is used.
	@return	1 if host and license owner differ, 0 if they match.
*/
static
int
itadmin_license_must_write_license_owner(itadmin_user *user, itadmin_host *host)
{
  int		back	= 0;
  if(user) {
    if(user->us) {
      if(host) {
        if(host->un) {
	  if((host->un)->us) {
	    if(dk3str_c8_cmp(user->us, (host->un)->us)) {
	      back = 1;
	    }
	  }
	} else {
	}
      } else {
      }
    }
  }
  return back;
}



/**	Check whether we must write the host owner because the host owner
	differs from the license owner.
	@param	user	License owner.
	@param	host	Host on which the license is used.
	@return	1 if host and license owner differ, 0 if they match.
*/
static
int
itadmin_license_must_write_host_owner(itadmin_user *user, itadmin_host *host)
{
  int		 back = 0;
  if(host) {
    if(host->un) {
      if(user) {
        if((host->un)->us) {
	  if(user->us) {
	    if(dk3str_c8_cmp((host->un)->us, user->us)) {
	      back = 1;
	    }
	  } else {
	    back = 1;
	  }
	}
      } else {
        back = 1;
      }
    }
  }
  return back;
}



/**	Write data for one license.
	@param	job	Job structure.
	@param	os	Output stream.
	@param	lic	License to write.
	@param	pman	Software manufacturuer name.
	@param	pprod	Software product name.
	@param	mn	Flag: Write software manufacturer name.
	@param	pn	Flag: Write software product name.
	@param	un	Flag: Write user name who owns the license.
	@param	hn	Flag: Write host name where license is used.
	@param	ond	On difference between license owner and host owner:
	0=do nothing, 1=write host owner, 2=write license owner
*/
static
void
itadmin_license_write_license(
  itadmin_job		*job,
  dk3_stream_t		*os,
  itadmin_license	*lic,
  char const		*pman,
  char const		*pprod,
  int			 mn,
  int			 pn,
  int			 un,
  int			 hn,
  int			 ond
)
{
  char		bu[128];
  int		ie;
  ie = dk3app_get_encoding(job->app);
  sprintf(bu, "%lu", lic->pk);
  dk3stream_c8_fputs(os, bu);
  dk3stream_c8_fputs(os, itadmin_license_c8_kw[24]);
  if((mn) && (pman)) {
    dk3stream_c8_fputs(os, itadmin_license_c8_kw[25]);
    dk3uc2lat_c8_utf8_stputs(job->uc2l, os, pman);
    dk3stream_c8_fputs(os, itadmin_license_c8_kw[5]);
    if((pn) && (pprod)) {
      dk3stream_c8_fputs(os, itadmin_license_c8_kw[26]);
      dk3stream_c8_fputs(os, itadmin_license_c8_kw[0]);
      dk3stream_c8_fputs(os, itadmin_license_c8_kw[24]);
      dk3stream_c8_fputs(os, itadmin_license_c8_kw[25]);
      dk3uc2lat_c8_utf8_stputs(job->uc2l, os, pprod);
      dk3stream_c8_fputs(os, itadmin_license_c8_kw[5]);
    }
    dk3stream_c8_fputs(os, itadmin_license_c8_kw[26]);
    dk3stream_c8_fputs(os, itadmin_license_c8_kw[0]);
    dk3stream_c8_fputs(os, itadmin_license_c8_kw[24]);
    itadmin_license_write_license_type(job, os, lic);
  } else {
    if((pn) && (pprod)) {
      dk3stream_c8_fputs(os, itadmin_license_c8_kw[25]);
      dk3uc2lat_c8_utf8_stputs(job->uc2l, os, pprod);
      dk3stream_c8_fputs(os, itadmin_license_c8_kw[5]);
      dk3stream_c8_fputs(os, itadmin_license_c8_kw[26]);
      dk3stream_c8_fputs(os, itadmin_license_c8_kw[0]);
      dk3stream_c8_fputs(os, itadmin_license_c8_kw[24]);
      itadmin_license_write_license_type(job, os, lic);
    } else {
      itadmin_license_write_license_type(job, os, lic);
    }
  }
  if(lic->notes) {
    dk3stream_c8_fputs(os, itadmin_license_c8_kw[26]);
    dk3stream_c8_fputs(os, itadmin_license_c8_kw[0]);
    dk3stream_c8_fputs(os, itadmin_license_c8_kw[24]);
    dk3stream_c8_fputs(os, itadmin_license_c8_kw[25]);
    dk3uc2lat_c8_utf8_stputs(job->uc2l, os, lic->notes);
    dk3stream_c8_fputs(os, itadmin_license_c8_kw[5]);
  }
  if(un) {
    if(lic->owner) {
      dk3stream_c8_fputs(os, itadmin_license_c8_kw[26]);
      dk3stream_c8_fputs(os, itadmin_license_c8_kw[0]);
      dk3stream_c8_fputs(os, itadmin_license_c8_kw[24]);
      dk3stream_c8_fputs(os, itadmin_license_c8_kw[25]);
      itadmin_tool_write_user_latex_long(job, os, lic->owner);
      dk3stream_c8_fputs(os, itadmin_license_c8_kw[5]);
    }
  }
  if(hn) {
    if(lic->host) {
      dk3stream_c8_fputs(os, itadmin_license_c8_kw[26]);
      dk3stream_c8_fputs(os, itadmin_license_c8_kw[0]);
      dk3stream_c8_fputs(os, itadmin_license_c8_kw[24]);
      if((lic->host)->sn) {
        dk3uc2lat_c8_utf8_stputs(job->uc2l, os, (lic->host)->sn);
      }
      dk3stream_c8_fputs(os, itadmin_license_c8_kw[24]);
      if((lic->host)->co) {
        dk3uc2lat_c8_utf8_stputs(job->uc2l, os, (lic->host)->co);
      }
      switch(ond) {
        case 1: {	/* On difference write host owner. */
	  if(itadmin_license_must_write_host_owner(lic->owner, lic->host)) {
	    dk3stream_c8_fputs(os, itadmin_license_c8_kw[26]);
	    dk3stream_c8_fputs(os, itadmin_license_c8_kw[0]);
	    dk3stream_c8_fputs(os, itadmin_license_c8_kw[24]);
            dk3stream_c8_fputs(os, itadmin_license_c8_kw[25]);
	    if(mn) { dk3stream_c8_fputs(os, itadmin_license_c8_kw[27]); }
            itadmin_tool_write_user_latex_long(job, os, (lic->host)->un);
	    if(mn) { dk3stream_c8_fputs(os, itadmin_license_c8_kw[5]); }
            dk3stream_c8_fputs(os, itadmin_license_c8_kw[5]);
	  }
	} break;
	case 2: {	/* On difference write license owner. */
	  if(itadmin_license_must_write_license_owner(lic->owner, lic->host)) {
	    dk3stream_c8_fputs(os, itadmin_license_c8_kw[26]);
	    dk3stream_c8_fputs(os, itadmin_license_c8_kw[0]);
	    dk3stream_c8_fputs(os, itadmin_license_c8_kw[24]);
            dk3stream_c8_fputs(os, itadmin_license_c8_kw[25]);
	    dk3stream_c8_fputs(os, itadmin_license_c8_kw[27]);
            itadmin_tool_write_user_latex_long(job, os, lic->owner);
	    dk3stream_c8_fputs(os, itadmin_license_c8_kw[5]);
            dk3stream_c8_fputs(os, itadmin_license_c8_kw[5]);
	  }
	} break;
      }
    }
  } else {
    if((lic->host) && (lic->owner)) {
      switch(ond) {
        case 1: {
	  if(itadmin_license_must_write_host_owner(lic->owner, lic->host)) {
	    dk3stream_c8_fputs(os, itadmin_license_c8_kw[26]);
	    dk3stream_c8_fputs(os, itadmin_license_c8_kw[0]);
	    dk3stream_c8_fputs(os, itadmin_license_c8_kw[24]);
            dk3stream_c8_fputs(os, itadmin_license_c8_kw[25]);
	    dk3stream_c8_fputs(os, itadmin_license_c8_kw[27]);
            itadmin_tool_write_user_latex_long(job, os, (lic->host)->un);
	    dk3stream_c8_fputs(os, itadmin_license_c8_kw[5]);
            dk3stream_c8_fputs(os, itadmin_license_c8_kw[5]);
	  }
        } break;
        case 2: {
	  if(itadmin_license_must_write_license_owner(lic->owner, lic->host)) {
	    dk3stream_c8_fputs(os, itadmin_license_c8_kw[26]);
	    dk3stream_c8_fputs(os, itadmin_license_c8_kw[0]);
	    dk3stream_c8_fputs(os, itadmin_license_c8_kw[24]);
            dk3stream_c8_fputs(os, itadmin_license_c8_kw[25]);
	    dk3stream_c8_fputs(os, itadmin_license_c8_kw[27]);
            itadmin_tool_write_user_latex_long(job, os, lic->owner);
	    dk3stream_c8_fputs(os, itadmin_license_c8_kw[5]);
            dk3stream_c8_fputs(os, itadmin_license_c8_kw[5]);
	  }
        } break;
      }
    }
  }
  if(lic->order) {
    dk3stream_c8_fputs(os, itadmin_license_c8_kw[26]);
    dk3stream_c8_fputs(os, itadmin_license_c8_kw[0]);
    dk3stream_c8_fputs(os, itadmin_license_c8_kw[24]);
    dk3uc2lat_stputs(job->uc2l, os, (job->msg)[54], ie);
    dk3stream_c8_fputs(os, itadmin_license_c8_kw[24]);
    dk3uc2lat_c8_utf8_stputs(job->uc2l, os, lic->order);
  }
  if(((lic->d_del).d) && ((lic->d_del).m) && ((lic->d_del).y)) {
    if(job->gdate) {
      sprintf(
        bu, "%02d.%02d.%04d", (lic->d_del).d, (lic->d_del).m, (lic->d_del).y
      );
    } else {
      sprintf(
        bu, "%04d-%02d-%02d", (lic->d_del).y, (lic->d_del).m, (lic->d_del).d
      );
    }
    dk3stream_c8_fputs(os, itadmin_license_c8_kw[26]);
    dk3stream_c8_fputs(os, itadmin_license_c8_kw[0]);
    dk3stream_c8_fputs(os, itadmin_license_c8_kw[24]);
    dk3uc2lat_stputs(job->uc2l, os, (job->msg)[55], ie);
    dk3stream_c8_fputs(os, itadmin_license_c8_kw[24]);
    dk3stream_c8_fputs(os, bu);
  }
  if(lic->i_del) {
    dk3stream_c8_fputs(os, itadmin_license_c8_kw[26]);
    dk3stream_c8_fputs(os, itadmin_license_c8_kw[0]);
    dk3stream_c8_fputs(os, itadmin_license_c8_kw[24]);
    dk3uc2lat_stputs(job->uc2l, os, (job->msg)[56], ie);
    dk3stream_c8_fputs(os, itadmin_license_c8_kw[24]);
    dk3uc2lat_c8_utf8_stputs(job->uc2l, os, lic->i_del);
  }
  if(((lic->d_inv).d) && ((lic->d_inv).m) && ((lic->d_inv).y)) {
    if(job->gdate) {
      sprintf(
        bu, "%02d.%02d.%04d", (lic->d_inv).d, (lic->d_inv).m, (lic->d_inv).y
      );
    } else {
      sprintf(
        bu, "%04d-%02d-%02d", (lic->d_inv).y, (lic->d_inv).m, (lic->d_inv).d
      );
    }
    dk3stream_c8_fputs(os, itadmin_license_c8_kw[26]);
    dk3stream_c8_fputs(os, itadmin_license_c8_kw[0]);
    dk3stream_c8_fputs(os, itadmin_license_c8_kw[24]);
    dk3uc2lat_stputs(job->uc2l, os, (job->msg)[57], ie);
    dk3stream_c8_fputs(os, itadmin_license_c8_kw[24]);
    dk3stream_c8_fputs(os, bu);
  }
  if(lic->i_inv) {
    dk3stream_c8_fputs(os, itadmin_license_c8_kw[26]);
    dk3stream_c8_fputs(os, itadmin_license_c8_kw[0]);
    dk3stream_c8_fputs(os, itadmin_license_c8_kw[24]);
    dk3uc2lat_stputs(job->uc2l, os, (job->msg)[58], ie);
    dk3stream_c8_fputs(os, itadmin_license_c8_kw[24]);
    dk3uc2lat_c8_utf8_stputs(job->uc2l, os, lic->i_inv);
  }
}



/**	Get software manufacturer name.
	@param	li	License
	@return	Software manufacturer name on success, NULL on error.
*/
static
char const *
itadmin_license_get_manufacturer(itadmin_license *li)
{
  char const		*back = NULL;
  if(li->prod) {
    if((li->prod)->mn) {
      back = ((li->prod)->mn)->sn;
      if(((li->prod)->mn)->ln) {
        back = ((li->prod)->mn)->ln;
      }
    }
  }
  return back;
}



/**	Get software product name.
	@param	li	License.
	@return	Product name on success, NULL on error.
*/
static
char const *
itadmin_license_get_product(itadmin_license *li)
{
  char const		*back = NULL;
  if(li->prod) {
    back = (li->prod)->sn;
    if((li->prod)->ln) {
      back = (li->prod)->ln;
    }
  }
  return back;
}



/**	Check whether manufacturer and/or product have changed.
	@param	pman
	@param	prev_man
	@param	pprod
	@param	prev_prod
	@return	0=no change, 1=product change, 2=manufacturer change.
*/
static
int
itadmin_license_change_level(
  char const	*pman,
  char const	*prev_man,
  char const	*pprod,
  char const	*prev_prod
)
{
  int		 back = 0;
  

#line 627 "italic.ctr"
  if(pprod) {
    if(prev_prod) {
      if(dk3str_c8_cmp(pprod, prev_prod)) {
        back = 1;
      }
    } else { back = 1; }
  } else {
    if(prev_prod) { back = 1; }
  }
  if(pman) {
    if(prev_man) {
      if(dk3str_c8_cmp(pman, prev_man)) {
        back = 2;
      }
    } else { back = 2; }
  } else {
    if(prev_man) { back = 2; }
  } 

#line 645 "italic.ctr"
  return back;
}



/**	Start a longtable for the licenses.
	@param	job	Job structure.
	@param	os	Output stream.
*/
static
void
itadmin_license_start_longtable_for_licenses(
  itadmin_job	*job,
  dk3_stream_t	*os
)
{
  dk3stream_c8_fputs(os, itadmin_license_c8_kw[18]);
  dk3stream_c8_fputs(os, itadmin_license_c8_kw[0]);
  dk3stream_c8_fputs(os, itadmin_license_c8_kw[19]);
  dk3stream_c8_fputs(os, itadmin_license_c8_kw[0]);
  dk3stream_c8_fputs(os, itadmin_license_c8_kw[20]);
  dk3stream_c8_fputs(os, itadmin_license_c8_kw[0]);
  dk3stream_c8_fputs(os, itadmin_license_c8_kw[21]);
  dk3stream_c8_fputs(os, itadmin_license_c8_kw[0]);
  dk3stream_c8_fputs(os, itadmin_license_c8_kw[22]);
  dk3stream_c8_fputs(os, itadmin_license_c8_kw[0]);
}



/**	End a longtable for the licenses.
	@param	job	Job structure.
	@param	os	Output stream.
*/
static
void
itadmin_license_end_longtable_for_licenses(
  itadmin_job	*job,
  dk3_stream_t	*os
)
{
  dk3stream_c8_fputs(os, itadmin_license_c8_kw[7]);
  dk3stream_c8_fputs(os, itadmin_license_c8_kw[0]);
}



/**	Write available licenses.
	@param	job	Job structure.
	@param	os	Output stream.
*/
static
void
itadmin_license_write_available(itadmin_job *job, dk3_stream_t *os)
{
  itadmin_license	*li;		/* Current license to print. */
  char const		*prev_man;	/* Previous software manufacturer. */
  char const		*prev_prod;	/* Previous software product. */
  char const		*pman;		/* Current software manufacturer. */
  char const		*pprod;		/* Current software product. */
  int			 have_chap;	/* Flag: Chapter was started. */
  int			 have_tab;	/* Flag: Table was started. */
  int			 ie;		/* Input encoding. */
  

#line 709 "italic.ctr"
  ie = dk3app_get_encoding(job->app);
  have_chap = have_tab = 0;
  prev_man = NULL; prev_prod = NULL;
  dk3sto_it_reset(job->i_lf);
  while(NULL != (li = (itadmin_license *)dk3sto_it_next(job->i_lf))) {
    if(!(have_chap)) {
      dk3stream_c8_fputs(os, itadmin_license_c8_kw[4]);
      dk3uc2lat_stputs(job->uc2l, os, (job->msg)[48], ie);
      dk3stream_c8_fputs(os, itadmin_license_c8_kw[5]);
      dk3stream_c8_fputs(os, itadmin_license_c8_kw[0]);
      dk3uc2lat_stputs(job->uc2l, os, (job->msg)[49], ie);
      dk3stream_c8_fputs(os, itadmin_license_c8_kw[0]);
      dk3uc2lat_stputs(job->uc2l, os, (job->msg)[50], ie);
      dk3stream_c8_fputs(os, itadmin_license_c8_kw[0]);
    } have_chap = 1;
    pman = itadmin_license_get_manufacturer(li);	

#line 725 "italic.ctr"
    pprod = itadmin_license_get_product(li);		

#line 726 "italic.ctr"
    switch(itadmin_license_change_level(pman, prev_man, pprod, prev_prod)) {
      case 2: {		/* Manufacturer changed. */
        if(have_tab) {
	  itadmin_license_end_longtable_for_licenses(job, os);
          dk3stream_c8_fputs(os, itadmin_license_c8_kw[6]);
          dk3stream_c8_fputs(os, itadmin_license_c8_kw[0]);
        }
	dk3stream_c8_fputs(os, itadmin_license_c8_kw[8]);
	dk3uc2lat_c8_utf8_stputs(job->uc2l, os, pman);
	dk3stream_c8_fputs(os, itadmin_license_c8_kw[5]);
	dk3stream_c8_fputs(os, itadmin_license_c8_kw[0]);
	dk3stream_c8_fputs(os, itadmin_license_c8_kw[9]);
	dk3uc2lat_c8_utf8_stputs(job->uc2l, os, pprod);
	dk3stream_c8_fputs(os, itadmin_license_c8_kw[5]);
	dk3stream_c8_fputs(os, itadmin_license_c8_kw[0]);
	have_tab = 0;
      } break;
      case 1: {		/* Product changed. */
        if(have_tab) {
	  itadmin_license_end_longtable_for_licenses(job, os);
          dk3stream_c8_fputs(os, itadmin_license_c8_kw[6]);
          dk3stream_c8_fputs(os, itadmin_license_c8_kw[0]);
	}
	dk3stream_c8_fputs(os, itadmin_license_c8_kw[9]);
	dk3uc2lat_c8_utf8_stputs(job->uc2l, os, pprod);
	dk3stream_c8_fputs(os, itadmin_license_c8_kw[5]);
	dk3stream_c8_fputs(os, itadmin_license_c8_kw[0]);
	have_tab = 0;
      } break;
      default: {	/* No change. */
        if(have_tab) {
	  dk3stream_c8_fputs(os, itadmin_license_c8_kw[23]);
	  dk3stream_c8_fputs(os, itadmin_license_c8_kw[0]);
	}
      } break;
    }
    if(!(have_tab)) {
      itadmin_license_start_longtable_for_licenses(job, os);
      have_tab = 1;
    }
    itadmin_license_write_license(job, os, li, pman, pprod, 0, 0, 0, 0, 0);
    prev_man = pman; prev_prod = pprod;
  }
  if(have_chap) {
    if(have_tab) {
      /* end{longtable} */
      itadmin_license_end_longtable_for_licenses(job, os);
    }
    /* clearpage */
    dk3stream_c8_fputs(os, itadmin_license_c8_kw[6]);
    dk3stream_c8_fputs(os, itadmin_license_c8_kw[0]);
  } 

#line 778 "italic.ctr"
}



/**	Write license report per user/host.
	@param	job	Job structure.
	@param	os	Output stream.
*/
static
void
itadmin_license_write_user(itadmin_job *job, dk3_stream_t *os)
{
  itadmin_user		*us;
  itadmin_host		*ho;
  itadmin_license	*li;
  char const		*pman;
  char const		*pprod;
  char const		*prev_man;
  char const		*prev_prod;
  int			 have_chap;
  int			 have_sec;
  int			 have_subsec;
  int			 have_tab;
  int			 ie;
  

#line 803 "italic.ctr"
  ie = dk3app_get_encoding(job->app);
  dk3sto_it_reset(job->i_us);
  while(NULL != (us = (itadmin_user *)dk3sto_it_next(job->i_us))) {
    have_chap = 0; have_sec = 0; have_subsec = 0; have_tab = 0;
    /*
    	Licenses on hosts
    */
    if(us->i_ho) {
      dk3sto_it_reset(us->i_ho);
      while(NULL != (ho = (itadmin_host *)dk3sto_it_next(us->i_ho))) {
        have_sec = 0; have_subsec = 0;
        if(ho->i_li) {
	  prev_man = NULL;
	  prev_prod = NULL;
	  have_tab = 0;
	  dk3sto_it_reset(ho->i_li);
	  while(NULL != (li = (itadmin_license *)dk3sto_it_next(ho->i_li))) {
	    pman = itadmin_license_get_manufacturer(li);
	    pprod = itadmin_license_get_product(li);
	    switch(itadmin_license_change_level(pman,prev_man,pprod,prev_prod))
	    {
	      case 2: {		/* Manufacturer changed. */
	        if(have_tab) {
		  itadmin_license_end_longtable_for_licenses(job, os);
		} have_tab = 0;
		if(!(have_chap)) {
		  dk3stream_c8_fputs(os, itadmin_license_c8_kw[28]);
		  itadmin_tool_write_user_latex_short(job, os, us);
		  dk3stream_c8_fputs(os, itadmin_license_c8_kw[29]);
		  itadmin_tool_write_user_latex_long(job, os, us);
		  dk3stream_c8_fputs(os, itadmin_license_c8_kw[5]);
		  dk3stream_c8_fputs(os, itadmin_license_c8_kw[0]);
		} have_chap = 1;
		if(!(have_sec)) {
		  dk3stream_c8_fputs(os, itadmin_license_c8_kw[8]);
		  dk3uc2lat_c8_utf8_stputs(job->uc2l, os, ho->sn);
		  dk3stream_c8_fputs(os, itadmin_license_c8_kw[5]);
		  dk3stream_c8_fputs(os, itadmin_license_c8_kw[0]);
		} have_sec = 1;
		dk3stream_c8_fputs(os, itadmin_license_c8_kw[9]);
		dk3uc2lat_c8_utf8_stputs(job->uc2l, os, pman);
		dk3stream_c8_fputs(os, itadmin_license_c8_kw[5]);
		dk3stream_c8_fputs(os, itadmin_license_c8_kw[0]);
	      } break;
	      default: {	/* Manufacturer unchanged. */
	        if(have_tab) {
		  dk3stream_c8_fputs(os, itadmin_license_c8_kw[23]);
                  dk3stream_c8_fputs(os, itadmin_license_c8_kw[0]);
		}
	      } break;
	    }
	    if(!(have_tab)) {
	      itadmin_license_start_longtable_for_licenses(job, os);
	      have_tab = 1;
	    }
	    itadmin_license_write_license(job, os, li, pman, pprod, 0, 1, 0, 0, 2);
	    prev_man = pman; prev_prod = pprod;
	  }
	  if(have_tab) {
	    itadmin_license_end_longtable_for_licenses(job, os);
	  }
	  if(have_sec) {
	    /* clearpage */
	    dk3stream_c8_fputs(os, itadmin_license_c8_kw[6]);
            dk3stream_c8_fputs(os, itadmin_license_c8_kw[0]);
	  }
	}
      }
    }
    if(us->i_li) {
      /*
    	  Licenses not assigned to hosts
      */
      have_sec = 0; have_tab = 0;
      dk3sto_it_reset(us->i_li);
      prev_man = NULL; prev_prod = NULL;
      while(NULL != (li = (itadmin_license *)dk3sto_it_next(us->i_li))) {
        if(!(li->host)) {
	  pman = itadmin_license_get_manufacturer(li);
	  pprod = itadmin_license_get_product(li);
	  switch(itadmin_license_change_level(pman,prev_man,pprod,prev_prod))
	  {
	    case 2: {	/* Manufacturer changed */
	      if(have_tab) {
	        itadmin_license_end_longtable_for_licenses(job, os);
	      } have_tab = 0;
	      if(!(have_chap)) {
		dk3stream_c8_fputs(os, itadmin_license_c8_kw[28]);
		itadmin_tool_write_user_latex_short(job, os, us);
		dk3stream_c8_fputs(os, itadmin_license_c8_kw[29]);
		itadmin_tool_write_user_latex_long(job, os, us);
		dk3stream_c8_fputs(os, itadmin_license_c8_kw[5]);
		dk3stream_c8_fputs(os, itadmin_license_c8_kw[0]);
	      } have_chap = 1;
	      if(!(have_sec)) {
		dk3stream_c8_fputs(os, itadmin_license_c8_kw[30]);
      		dk3uc2lat_stputs(job->uc2l, os, (job->msg)[60], ie);
		dk3stream_c8_fputs(os, itadmin_license_c8_kw[29]);
      		dk3uc2lat_stputs(job->uc2l, os, (job->msg)[61], ie);
		dk3stream_c8_fputs(os, itadmin_license_c8_kw[5]);
		dk3stream_c8_fputs(os, itadmin_license_c8_kw[0]);
      		dk3uc2lat_stputs(job->uc2l, os, (job->msg)[64], ie);
		dk3stream_c8_fputs(os, itadmin_license_c8_kw[0]);
      		dk3uc2lat_stputs(job->uc2l, os, (job->msg)[65], ie);
		dk3stream_c8_fputs(os, itadmin_license_c8_kw[0]);
      		dk3uc2lat_stputs(job->uc2l, os, (job->msg)[66], ie);
		dk3stream_c8_fputs(os, itadmin_license_c8_kw[0]);
	      } have_sec = 1;
	      dk3stream_c8_fputs(os, itadmin_license_c8_kw[9]);
	      dk3uc2lat_c8_utf8_stputs(job->uc2l, os, pman);
	      dk3stream_c8_fputs(os, itadmin_license_c8_kw[5]);
	      dk3stream_c8_fputs(os, itadmin_license_c8_kw[0]);
	      dk3stream_c8_fputs(os, itadmin_license_c8_kw[10]);
	      dk3uc2lat_c8_utf8_stputs(job->uc2l, os, pprod);
	      dk3stream_c8_fputs(os, itadmin_license_c8_kw[5]);
	      dk3stream_c8_fputs(os, itadmin_license_c8_kw[0]);
	    } break;
	    case 1: {	/* Product changed */
	      if(have_tab) {
	        itadmin_license_end_longtable_for_licenses(job, os);
	      } have_tab = 0;
	      if(!(have_chap)) {
		dk3stream_c8_fputs(os, itadmin_license_c8_kw[28]);
		itadmin_tool_write_user_latex_short(job, os, us);
		dk3stream_c8_fputs(os, itadmin_license_c8_kw[29]);
		itadmin_tool_write_user_latex_long(job, os, us);
		dk3stream_c8_fputs(os, itadmin_license_c8_kw[5]);
		dk3stream_c8_fputs(os, itadmin_license_c8_kw[0]);
	      } have_chap = 1;
	      if(!(have_sec)) {
		dk3stream_c8_fputs(os, itadmin_license_c8_kw[30]);
      		dk3uc2lat_stputs(job->uc2l, os, (job->msg)[60], ie);
		dk3stream_c8_fputs(os, itadmin_license_c8_kw[29]);
      		dk3uc2lat_stputs(job->uc2l, os, (job->msg)[61], ie);
		dk3stream_c8_fputs(os, itadmin_license_c8_kw[5]);
		dk3stream_c8_fputs(os, itadmin_license_c8_kw[0]);
      		dk3uc2lat_stputs(job->uc2l, os, (job->msg)[64], ie);
		dk3stream_c8_fputs(os, itadmin_license_c8_kw[0]);
      		dk3uc2lat_stputs(job->uc2l, os, (job->msg)[65], ie);
		dk3stream_c8_fputs(os, itadmin_license_c8_kw[0]);
      		dk3uc2lat_stputs(job->uc2l, os, (job->msg)[66], ie);
		dk3stream_c8_fputs(os, itadmin_license_c8_kw[0]);
	      } have_sec = 1;
	      dk3stream_c8_fputs(os, itadmin_license_c8_kw[10]);
	      dk3uc2lat_c8_utf8_stputs(job->uc2l, os, pprod);
	      dk3stream_c8_fputs(os, itadmin_license_c8_kw[5]);
	      dk3stream_c8_fputs(os, itadmin_license_c8_kw[0]);
	    } break;
	    default: {
              if(have_tab) {
	        dk3stream_c8_fputs(os, itadmin_license_c8_kw[23]);
                dk3stream_c8_fputs(os, itadmin_license_c8_kw[0]);
	      }
	    } break;
	  }
	  if(!(have_tab)) {
	    itadmin_license_start_longtable_for_licenses(job, os);
	    have_tab = 1;
	  }
	  itadmin_license_write_license(job, os, li, pman, pprod, 0, 0, 0, 0, 0);
	  prev_man = pman; prev_prod = pprod;
	}
      }
      if(have_tab) {
        itadmin_license_end_longtable_for_licenses(job, os);
      }
      if(have_sec) {
        dk3stream_c8_fputs(os, itadmin_license_c8_kw[6]);
	dk3stream_c8_fputs(os, itadmin_license_c8_kw[0]);
      }
      /*
    	  Licenses used on other users computers
      */
      have_sec = 0; have_tab = 0;
      dk3sto_it_reset(us->i_li);
      prev_man = NULL; prev_prod = NULL;
      while(NULL != (li = (itadmin_license *)dk3sto_it_next(us->i_li))) {
        if(li->host) {
	  pman = itadmin_license_get_manufacturer(li);
	  pprod = itadmin_license_get_product(li);
	  switch(itadmin_license_change_level(pman,prev_man,pprod,prev_prod))
	  {
	    case 2: {	/* Manufacturer changed */
	      if(have_tab) {
	        itadmin_license_end_longtable_for_licenses(job, os);
	      } have_tab = 0;
	      if(!(have_chap)) {
		dk3stream_c8_fputs(os, itadmin_license_c8_kw[28]);
		itadmin_tool_write_user_latex_short(job, os, us);
		dk3stream_c8_fputs(os, itadmin_license_c8_kw[29]);
		itadmin_tool_write_user_latex_long(job, os, us);
		dk3stream_c8_fputs(os, itadmin_license_c8_kw[5]);
		dk3stream_c8_fputs(os, itadmin_license_c8_kw[0]);
	      } have_chap = 1;
	      if(!(have_sec)) {
		dk3stream_c8_fputs(os, itadmin_license_c8_kw[30]);
      		dk3uc2lat_stputs(job->uc2l, os, (job->msg)[62], ie);
		dk3stream_c8_fputs(os, itadmin_license_c8_kw[29]);
      		dk3uc2lat_stputs(job->uc2l, os, (job->msg)[63], ie);
		dk3stream_c8_fputs(os, itadmin_license_c8_kw[5]);
		dk3stream_c8_fputs(os, itadmin_license_c8_kw[0]);
      		dk3uc2lat_stputs(job->uc2l, os, (job->msg)[67], ie);
		dk3stream_c8_fputs(os, itadmin_license_c8_kw[0]);
      		dk3uc2lat_stputs(job->uc2l, os, (job->msg)[68], ie);
		dk3stream_c8_fputs(os, itadmin_license_c8_kw[0]);
      		dk3uc2lat_stputs(job->uc2l, os, (job->msg)[69], ie);
		dk3stream_c8_fputs(os, itadmin_license_c8_kw[26]);
		dk3stream_c8_fputs(os, itadmin_license_c8_kw[0]);
		dk3stream_c8_fputs(os, itadmin_license_c8_kw[31]);
      		dk3uc2lat_stputs(job->uc2l, os, (job->msg)[70], ie);
		dk3stream_c8_fputs(os, itadmin_license_c8_kw[32]);
      		dk3uc2lat_stputs(job->uc2l, os, (job->msg)[71], ie);
		dk3stream_c8_fputs(os, itadmin_license_c8_kw[0]);
      		dk3uc2lat_stputs(job->uc2l, os, (job->msg)[72], ie);
		dk3stream_c8_fputs(os, itadmin_license_c8_kw[0]);
      		dk3uc2lat_stputs(job->uc2l, os, (job->msg)[73], ie);
		dk3stream_c8_fputs(os, itadmin_license_c8_kw[0]);
      		dk3uc2lat_stputs(job->uc2l, os, (job->msg)[74], ie);
		dk3stream_c8_fputs(os, itadmin_license_c8_kw[0]);
      		dk3uc2lat_stputs(job->uc2l, os, (job->msg)[75], ie);
		dk3stream_c8_fputs(os, itadmin_license_c8_kw[0]);
	      } have_sec = 1;
	      dk3stream_c8_fputs(os, itadmin_license_c8_kw[9]);
	      dk3uc2lat_c8_utf8_stputs(job->uc2l, os, pman);
	      dk3stream_c8_fputs(os, itadmin_license_c8_kw[5]);
	      dk3stream_c8_fputs(os, itadmin_license_c8_kw[0]);
	      dk3stream_c8_fputs(os, itadmin_license_c8_kw[10]);
	      dk3uc2lat_c8_utf8_stputs(job->uc2l, os, pprod);
	      dk3stream_c8_fputs(os, itadmin_license_c8_kw[5]);
	      dk3stream_c8_fputs(os, itadmin_license_c8_kw[0]);
	    } break;
	    case 1: {	/* Product changed */
	      if(have_tab) {
	        itadmin_license_end_longtable_for_licenses(job, os);
	      } have_tab = 0;
	      if(!(have_chap)) {
		dk3stream_c8_fputs(os, itadmin_license_c8_kw[28]);
		itadmin_tool_write_user_latex_short(job, os, us);
		dk3stream_c8_fputs(os, itadmin_license_c8_kw[29]);
		itadmin_tool_write_user_latex_long(job, os, us);
		dk3stream_c8_fputs(os, itadmin_license_c8_kw[5]);
		dk3stream_c8_fputs(os, itadmin_license_c8_kw[0]);
	      } have_chap = 1;
	      if(!(have_sec)) {
		dk3stream_c8_fputs(os, itadmin_license_c8_kw[30]);
      		dk3uc2lat_stputs(job->uc2l, os, (job->msg)[62], ie);
		dk3stream_c8_fputs(os, itadmin_license_c8_kw[29]);
      		dk3uc2lat_stputs(job->uc2l, os, (job->msg)[63], ie);
		dk3stream_c8_fputs(os, itadmin_license_c8_kw[5]);
		dk3stream_c8_fputs(os, itadmin_license_c8_kw[0]);
      		dk3uc2lat_stputs(job->uc2l, os, (job->msg)[67], ie);
		dk3stream_c8_fputs(os, itadmin_license_c8_kw[0]);
      		dk3uc2lat_stputs(job->uc2l, os, (job->msg)[68], ie);
		dk3stream_c8_fputs(os, itadmin_license_c8_kw[0]);
      		dk3uc2lat_stputs(job->uc2l, os, (job->msg)[69], ie);
		dk3stream_c8_fputs(os, itadmin_license_c8_kw[26]);
		dk3stream_c8_fputs(os, itadmin_license_c8_kw[0]);
		dk3stream_c8_fputs(os, itadmin_license_c8_kw[31]);
      		dk3uc2lat_stputs(job->uc2l, os, (job->msg)[70], ie);
		dk3stream_c8_fputs(os, itadmin_license_c8_kw[32]);
      		dk3uc2lat_stputs(job->uc2l, os, (job->msg)[71], ie);
		dk3stream_c8_fputs(os, itadmin_license_c8_kw[0]);
      		dk3uc2lat_stputs(job->uc2l, os, (job->msg)[72], ie);
		dk3stream_c8_fputs(os, itadmin_license_c8_kw[0]);
      		dk3uc2lat_stputs(job->uc2l, os, (job->msg)[73], ie);
		dk3stream_c8_fputs(os, itadmin_license_c8_kw[0]);
      		dk3uc2lat_stputs(job->uc2l, os, (job->msg)[74], ie);
		dk3stream_c8_fputs(os, itadmin_license_c8_kw[0]);
      		dk3uc2lat_stputs(job->uc2l, os, (job->msg)[75], ie);
		dk3stream_c8_fputs(os, itadmin_license_c8_kw[0]);
	      } have_sec = 1;
	      dk3stream_c8_fputs(os, itadmin_license_c8_kw[10]);
	      dk3uc2lat_c8_utf8_stputs(job->uc2l, os, pprod);
	      dk3stream_c8_fputs(os, itadmin_license_c8_kw[5]);
	      dk3stream_c8_fputs(os, itadmin_license_c8_kw[0]);
	    } break;
	    default: {
              if(have_tab) {
	        dk3stream_c8_fputs(os, itadmin_license_c8_kw[23]);
                dk3stream_c8_fputs(os, itadmin_license_c8_kw[0]);
	      }
	    } break;
	  }
	  if(!(have_tab)) {
	    itadmin_license_start_longtable_for_licenses(job, os);
	    have_tab = 1;
	  }
	  itadmin_license_write_license(job, os, li, pman, pprod, 0, 0, 0, 1, 1);
	  prev_man = pman; prev_prod = pprod;
	}
      }
      if(have_tab) {
        itadmin_license_end_longtable_for_licenses(job, os);
      }
      if(have_sec) {
        dk3stream_c8_fputs(os, itadmin_license_c8_kw[6]);
	dk3stream_c8_fputs(os, itadmin_license_c8_kw[0]);
      }
    }
  } 

#line 1103 "italic.ctr"
}



/**	Write complete list of licenses.
	@param	job	Job structure.
	@param	os	Output stream.
*/
static
void
itadmin_license_write_complete_list(itadmin_job *job, dk3_stream_t *os)
{
  itadmin_license	*li;
  char const		*pman;
  char const		*pprod;
  int			 have_tab = 0;
  int			 ie;
  ie = dk3app_get_encoding(job->app);
  dk3sto_it_reset(job->i_lc);
  while(NULL != (li = (itadmin_license *)dk3sto_it_next(job->i_lc))) {
    if(!(have_tab)) {
      dk3stream_c8_fputs(os, itadmin_license_c8_kw[4]);
      dk3uc2lat_stputs(job->uc2l, os, (job->msg)[59], ie);
      dk3stream_c8_fputs(os, itadmin_license_c8_kw[5]);
      dk3stream_c8_fputs(os, itadmin_license_c8_kw[0]);
      itadmin_license_start_longtable_for_licenses(job, os);
    } else {
      dk3stream_c8_fputs(os, itadmin_license_c8_kw[23]);
      dk3stream_c8_fputs(os, itadmin_license_c8_kw[0]);
    }
    have_tab = 1;
    pman = itadmin_license_get_manufacturer(li);
    pprod = itadmin_license_get_product(li);
    itadmin_license_write_license(job, os, li, pman, pprod, 1, 1, 1, 1, 1);
  }
  if(have_tab) {
    itadmin_license_end_longtable_for_licenses(job, os);
  }
}



/**	Write license report to file.
	@param	job	Job structure.
	@param	os	Output stream.
*/
static
void
itadmin_license_write_file(itadmin_job *job, dk3_stream_t *os)
{
  int			 ie;
  ie = dk3app_get_encoding(job->app);
  if(job->ukoma) {
    itadmin_tool_write_section(job, os, itadmin_license_file_start1a);
  } else {
    itadmin_tool_write_section(job, os, itadmin_license_file_start1b);
  }
  dk3stream_c8_fputs(os, itadmin_license_c8_kw[0]);
  dk3stream_strputs(os, (job->msg)[2], ie);
  dk3stream_c8_fputs(os, itadmin_license_c8_kw[0]);
  itadmin_tool_write_section(job, os, itadmin_license_file_start4);
  /* pdftitle */
  dk3stream_c8_fputs(os, itadmin_license_c8_kw[11]);
  dk3uc2lat_stputs(job->uc2l, os, (job->msg)[51], ie);
  dk3stream_c8_fputs(os, itadmin_license_c8_kw[5]);
  dk3stream_c8_fputs(os, itadmin_license_c8_kw[17]);
  dk3stream_c8_fputs(os, itadmin_license_c8_kw[0]);
  /* pdfsubject */
  dk3stream_c8_fputs(os, itadmin_license_c8_kw[12]);
  dk3uc2lat_stputs(job->uc2l, os, (job->msg)[52], ie);
  dk3stream_c8_fputs(os, itadmin_license_c8_kw[5]);
  dk3stream_c8_fputs(os, itadmin_license_c8_kw[17]);
  dk3stream_c8_fputs(os, itadmin_license_c8_kw[0]);
  /* pdfauthor */
  if(job->admn) {
    dk3stream_c8_fputs(os, itadmin_license_c8_kw[13]);
    dk3uc2lat_stputs(job->uc2l, os, job->admn, ie);
    dk3stream_c8_fputs(os, itadmin_license_c8_kw[5]);
    dk3stream_c8_fputs(os, itadmin_license_c8_kw[17]);
    dk3stream_c8_fputs(os, itadmin_license_c8_kw[0]);
  }
  /* pdfcreator */
  dk3stream_c8_fputs(os, itadmin_license_c8_kw[14]);
  dk3stream_c8_fputs(os, itadmin_license_c8_kw[0]);
  itadmin_tool_write_section(job, os, itadmin_license_file_start2);
  /* author */
  if(job->admn) {
    dk3stream_c8_fputs(os, itadmin_license_c8_kw[15]);
    dk3uc2lat_stputs(job->uc2l, os, job->admn, ie);
    dk3stream_c8_fputs(os, itadmin_license_c8_kw[5]);
    dk3stream_c8_fputs(os, itadmin_license_c8_kw[0]);
  }
  /* title */
  dk3stream_c8_fputs(os, itadmin_license_c8_kw[16]);
  dk3uc2lat_stputs(job->uc2l, os, (job->msg)[51], ie);
  dk3stream_c8_fputs(os, itadmin_license_c8_kw[5]);
  dk3stream_c8_fputs(os, itadmin_license_c8_kw[0]);
  if(job->ukoma) {
    itadmin_tool_write_section(job, os, itadmin_license_file_start3a);
  }
  itadmin_tool_write_section(job, os, itadmin_license_file_start3);
  itadmin_license_write_available(job, os);
  itadmin_license_write_user(job, os);
  itadmin_license_write_complete_list(job, os);
  itadmin_tool_write_section(job, os, itadmin_license_file_end);
}



int
itadmin_license_report(itadmin_job *job)
{
  FILE		*fipo;
  dk3_stream_t	*os;
  int		 back = 0;
  

#line 1219 "italic.ctr"
  fipo = dk3sf_c8_fopen_app(
    itadmin_license_c8_kw[2],
    itadmin_license_c8_kw[3],
    job->app
  );
  if(fipo) {
    os = dk3stream_open_file_app(fipo, DK3_STREAM_FLAG_WRITE, job->app);
    if(os) {
      back = 1;
      itadmin_license_write_file(job, os);
      dk3stream_close(os);
    }
#if DK3_CHAR_SIZE == 1
    if(!dk3sf_fclose_fn_app(fipo, itadmin_license_c8_kw[2], job->app)) {
      back = 0;
    }
#else
    if(!dk3sf_fclose_fn_app(fipo, NULL, job->app)) {
      back = 0;
    }
#endif
  }
  

#line 1242 "italic.ctr"
  return back;
}


