/*
	WARNING: This file was generated by dkct.
	Changes you make here will be lost if dkct is run again!
	You should modify the original source and run dkct on it.
	Original source: itadmin.ctr
*/

/*
Copyright (C) 2012-2014, Dirk Krause

Redistribution and use in source and binary forms, with or without
modification, are permitted provided that the following conditions are met:

* Redistributions of source code must retain the above copyright notice,
  this list of conditions and the following disclaimer.
* Redistributions in binary form must reproduce the above opyright notice,
  this list of conditions and the following disclaimer in the documentation
  and/or other materials provided with the distribution.
* Neither the name of the author nor the names of contributors may be used
  to endorse or promote products derived from this software without specific
  prior written permission.

THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS ``AS IS''
AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
ARE DISCLAIMED.
IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE LIABLE FOR ANY
DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
(INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
(INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
*/

/**	@file itadmin.h Header file for the itadmin module.
*/

#ifndef ITADMIN_H_INCLUDED
/** Avoid multiple inclusions. */
#define ITADMIN_H_INCLUDED 1


#line 10 "itadmin.ctr"

#include "dk3all.h"



/**	Computer owner/user.
*/
typedef struct {
  char const		*us;	/**< Short name, login name (primary key). */
  char const		*tt;	/**< Title, academic degree. */
  char const		*sn;	/**< Surname. */
  char const		*na;	/**< Family name. */
  char const		*em;	/**< E-mail address. */
  char const		*cc;	/**< ID in cost controlling. */
  char const		*si;	/**< Staff ID number. */
  dk3_sto_t		*s_ho;	/**< Hosts for user. */
  dk3_sto_it_t		*i_ho;	/**< Iterator for hosts storage. */
  dk3_sto_t		*s_li;	/**< Licenses assigned to user. */
  dk3_sto_it_t		*i_li;	/**< Iterator for licenses storage. */
} itadmin_user;



/**	Building.
*/
typedef struct {
  char const		*s;	/**< Short name (primary key). */
  char const		*l;	/**< Full building name. */
  char const		*a1;	/**< Address line 1. */
  char const		*a2;	/**< Address line 2. */
  char const		*a3;	/**< Address line 3. */
  char const		*a4;	/**< Address line 4. */
  char const		*zc;	/**< Zip code (german: Postleitzahl). */
  char const		*city;	/**< City/Town name. */
} itadmin_building;



/**	Speed for network connection.
*/
typedef struct {
  char const		*s;	/**< Short speed name (primary key). */
  char const		*l;	/**< Long speed name (description). */
} itadmin_speed;



/**	VLAN.
*/
typedef struct {
  char const		*s;	/**< Short VLAN name (primary key). */
  char const		*l;	/**< Long VLAN name (description). */
  dk3_sto_t		*s_nw;	/**< Storage for networks. */
  dk3_sto_it_t		*i_nw;	/**< Iterator through networks storage. */
  dk3_sto_t		*s_do;	/**< DHCP options for VLAN. */
  dk3_sto_it_t		*i_do;	/**< Iterator through DHCP options. */
} itadmin_vlan;



/**	Network connection socket.
*/
typedef struct {
  char const		*s;	/**< Short name (label on socket, pk). */
  char const		*hp;	/**< Hub port used for socket. */
  char const		*room;	/**< Room name or number in building. */
  itadmin_speed		*sp;	/**< Speed setting for socket. */
  itadmin_vlan		*vl;	/**< VLAN for socket. */
  itadmin_building	*bu;	/**< Building. */
} itadmin_connect;



/**	Network.
*/
typedef struct {
  itadmin_vlan		*vl;	/**< Parent VLAN. */
  dk3_sto_t		*s_p;	/**< Storage for DHCP pools. */
  dk3_sto_it_t		*i_p;	/**< Iterator through pools storage. */
  dk3_sto_t		*s_dg;	/**< Storage for DHCP groups in network. */
  dk3_sto_it_t		*i_dg;	/**< Iterator through groups in nw storage. */
  dk3_sto_t		*s_do;	/**< DHCP options. */
  dk3_sto_it_t		*i_do;	/**< Iterator for DHCP options. */
  dk3_sto_t		*s_hoi;	/**< Storage for hosts. */
  dk3_sto_it_t		*i_hoi;	/**< Iterator for hosts storage. */
  dk3_sto_t		*s_dc;	/**< DHCP classes for this network. */
  dk3_sto_it_t		*i_dc;	/**< Iterator through DHCP classes storage. */
  unsigned long	 	 ip4;	/**< IPv4 start address (primary key). */
  unsigned long	 	 ma4;	/**< IPv4 network mask. */
  unsigned long	 	 gw4;	/**< IPv4 gateway. */
  unsigned long	 	 bc4;	/**< IPv4 broadcast address. */
} itadmin_network;



/**	Netgroup.
*/
typedef struct {
  char const		*sn;	/**< Short name (primary key). */
  char const		*ln;	/**< Long name (description). */
  size_t		 no;	/**< Netgroup number. */
} itadmin_netgroup;



/**	Netgroup dependency.
*/
typedef struct {
  itadmin_netgroup	*pa;	/**< Parent group. */
  itadmin_netgroup	*ch;	/**< Child group. */
} itadmin_ngdep;



/**	DHCP class.
*/
typedef struct {
  char const		*sn;	/**< Short name (primary key). */
  char const		*ln;	/**< Long name (description). */
  dk3_sto_t		*s_ho;	/**< Hosts in this class. */
  dk3_sto_it_t		*i_ho;	/**< Iterator through hosts storage. */
  itadmin_network	*dhcpn;	/**< Network for DHCP hosts. */
} itadmin_dhcp_class;



/**	DHCP address pool.
*/
typedef struct {
  itadmin_network	*nw;	/**< Network. */
  itadmin_dhcp_class	*acl;	/**< Allowed DHCP class. */
  dk3_sto_t		*s_do;	/**< DHCP options for pool. */
  dk3_sto_it_t		*i_do;	/**< Iterator for DHCP options. */
  dk3_sto_t		*s_hoi;	/**< Hosts storage. */
  dk3_sto_it_t		*i_hoi;	/**< Hosts storage iterator. */
  unsigned long		 ip4s;	/**< IPv4 start address. */
  unsigned long		 ip4e;	/**< IPv4 end address. */
  char			 duc;	/**< Flag: Deny unknown clients. */
  char			 auc;	/**< Flag: Allow unknown clients. */
} itadmin_dhcp_pool;



/**	DHCP group.
*/
typedef struct {
  char const		*sn;	/**< Short group name (primary key). */
  char const		*ln;	/**< Long name (description). */
  dk3_sto_t		*s_do;	/**< DHCP options storage. */
  dk3_sto_it_t		*i_do;	/**< DHCP options iterator. */
} itadmin_dhcp_group;



/**	DHCP group within a network.
*/
typedef struct {
  itadmin_dhcp_group	*gr;	/**< Group. */
  dk3_sto_t		*s_h;	/**< Storage for hosts in this group. */
  dk3_sto_it_t		*i_h;	/**< Iterator for storage. */
} itadmin_dhcp_ginw;



/**	Date (used for host expiration).
*/
typedef struct {
  int	y;			/**< Year. */
  int	m;			/**< Month. */
  int	d;			/**< Day in month. */
} itadmin_date;



/**	Host.
*/
typedef struct {
  itadmin_date		 expi;	/**< Expiration date. */
  char const		*sn;	/**< Short host name (primary key). */
  char const		*co;	/**< Comment, description. */
  char const		*maca;	/**< MAC address. */
  char const		*room;	/**< Room within the building. */
  char const		*inv;	/**< Inventory ID. */
  char const		*serno;	/**< Serial number. */
  char const		*hid;	/**< Host ID. */
  char const		*dnsd;	/**< DNS domain. */
  itadmin_user		*un;	/**< System owner. */
  itadmin_netgroup	*ng;	/**< Netgroup. */
  itadmin_dhcp_class	*dc;	/**< DHCP class. */
  itadmin_dhcp_group	*dg;	/**< DHCP group. */
  itadmin_dhcp_pool	*dp;	/**< DHCP pool. */
  itadmin_connect	*nc;	/**< Network connection socket. */
  itadmin_building	*bu;	/**< Building. */
  dk3_sto_t		*s_al;	/**< Storage for aliases. */
  dk3_sto_it_t		*i_al;	/**< Iterator through aliases storage. */
  dk3_sto_t		*s_do;	/**< DHCP options for host. */
  dk3_sto_it_t		*i_do;	/**< DHCP options iterator. */
  dk3_sto_t		*s_li;	/**< Licenses assigned to host. */
  dk3_sto_it_t		*i_li;	/**< Iterator through licenses storage. */
  unsigned long		 ipv4;	/**< IPv4 address. */
  char			 fnf;	/**< Flag: Full name first in hosts. */
  char			 fgu;	/**< Flag: Guest computer. */
  char			 snd;	/**< Flag: Skip in network documentation. */
  char			 saw;	/**< Flag: Skip in arpwatch configuration. */
} itadmin_host;



/**	Software manufacturer.
*/
typedef struct {
  char const		*sn;	/**< Short name (primary key). */
  char const		*ln;	/**< Full name. */
} itadmin_swman;



/**	Software product.
*/
typedef struct {
  char const		*sn;	/**< Short name (primary key). */
  char const		*ln;	/**< Full name. */
  itadmin_swman		*mn;	/**< Software manufacturer. */
} itadmin_swprod;



/**	License type.
*/
typedef struct {
  char const		*sn;	/**< Short name (primary key). */
  char const		*ln;	/**< Full name. */
  int			 num;	/**< Number of client licenses. */
} itadmin_lictype;



/**	Software license.
*/
typedef struct {
  itadmin_date		 d_del;	/**< Delivery date. */
  itadmin_date		 d_inv; /**< Invoice date. */
  char const		*order;	/**< Internal order ID. */
  char const		*notes;	/**< Additional notes about the license. */
  char const		*i_del;	/**< Delivery note ID. */
  char const		*i_inv;	/**< Invoice ID. */
  itadmin_swprod	*prod;	/**< Software product. */
  itadmin_lictype	*ltype;	/**< License type. */
  itadmin_user		*owner;	/**< License owner. */
  itadmin_host		*host;	/**< Host where license is used. */
  unsigned long		 pk;	/**< Primary key from database. */
} itadmin_license;



/**	DHCP option.
*/
typedef struct {
  char const		*k;	/**< Key (option name). */
  char const		*v;	/**< Option value. */
  long			 pk;	/**< Primary key from database. */
} itadmin_dhcp_option;



/**	Job structure for the itadmin program.
*/
typedef struct {
  itadmin_date		 today;	/**< Current date. */
  dk3_app_t		*app;	/**< Application structure. */
  dk3_option_set_t	*opt;	/**< Option set. */
  dk3_sto_t		*s_us;	/**< User storage. */
  dk3_sto_it_t		*i_us;	/**< User storage iterator. */
  dk3_sto_t		*s_usn;	/**< User sorted by name. */
  dk3_sto_it_t		*i_usn;	/**< Storage iterator for users by name. */
  dk3_sto_t		*s_bu;	/**< Building storage. */
  dk3_sto_it_t		*i_bu;	/**< Building storage iterator. */
  dk3_sto_t		*s_sp;	/**< Patch speed storage. */
  dk3_sto_it_t		*i_sp;	/**< Patch speed storage iterator. */
  dk3_sto_t		*s_vl;	/**< VLAN storage. */
  dk3_sto_it_t		*i_vl;	/**< VLAN storage iterator. */
  dk3_sto_t		*s_pa;	/**< Network patch storage. */
  dk3_sto_it_t		*i_pa;	/**< Network patch storage iterator. */
  dk3_sto_t		*s_nw;	/**< Network storage. */
  dk3_sto_it_t		*i_nw;	/**< Network storage iterator. */
  dk3_sto_t		*s_ng;	/**< Netgroup storage. */
  dk3_sto_it_t		*i_ng;	/**< Netgroup storage iterator. */
  dk3_sto_t		*s_nd;	/**< Netgroup dependency storage. */
  dk3_sto_it_t		*i_nd;	/**< Netgroup dependency storage iterator. */
  dk3_sto_t		*s_dc;	/**< DHCP class storage. */
  dk3_sto_it_t		*i_dc;	/**< DHCP class storage iterator. */
  dk3_sto_t		*s_dp;	/**< DHCP pool storage. */
  dk3_sto_it_t		*i_dp;	/**< DHCP pool storage iterator. */
  dk3_sto_t		*s_dg;	/**< DHCP group storage. */
  dk3_sto_it_t		*i_dg;	/**< DHCP group storage iterator. */
  dk3_sto_t		*s_ho;	/**< Host storage, sorted by name. */
  dk3_sto_it_t		*i_ho;	/**< Host storage iterator for s_ho. */
  dk3_sto_t		*s_hoi;	/**< Host storage, sorted by IP address. */
  dk3_sto_it_t		*i_hoi;	/**< Host storage iterator for s_hoi. */
  dk3_sto_t		*s_sm;	/**< Software manufacturer storage. */
  dk3_sto_it_t		*i_sm;	/**< Software manufacturer storage iterator. */
  dk3_sto_t		*s_sw;	/**< Software storage. */
  dk3_sto_it_t		*i_sw;	/**< Software storage iterator. */
  dk3_sto_t		*s_lt;	/**< License type storage. */
  dk3_sto_it_t		*i_lt;	/**< License type storage iterator. */
  dk3_sto_t		*s_lc;	/**< Licenses storage. */
  dk3_sto_it_t		*i_lc;	/**< Licenses storage iterator. */
  dk3_sto_t		*s_lf;	/**< Free licenses. */
  dk3_sto_it_t		*i_lf;	/**< Free licenses iterator. */
  dk3_sto_t		*s_do;	/**< DHCP options for entire server. */
  dk3_sto_it_t		*i_do;	/**< Iterator for DHCP options. */
  void			*dbptr;	/**< Database object pointer. */
  dk3_bm_t		*ngdep;	/**< Direct/indirect netgroup dependencies. */
  dk3_uc2lat_t		*uc2l;	/**< Unicode to LaTeX converter. */
  dkChar const * const	*msg;	/**< Localized message texts. */
  dkChar const * const	*noloc;	/**< Texts, not localized. */
  dkChar const		*dbhn;	/**< Database host name. */
  dkChar const		*dbn;	/**< Database name. */
  dkChar const		*dbcf;	/**< Database credentials files. */
  dkChar const		*dbus;	/**< Database user name. */
  dkChar const		*dbpw;	/**< Database password. */
  dkChar const		*vlan;	/**< VLAN name. */
  dkChar const		*org;	/**< Organization name. */
  dkChar const		*ou;	/**< Organizational unit name. */
  dkChar const		*admn;	/**< Administrator name. */
  dkChar const		*ldapb;	/**< LDAP base. */
  size_t		 nng;	/**< Number of netgroups. */
  int			 exval;	/**< Exit status code. */
  int			 ec;	/**< Error code, see @ref errorcodes. */
  int			 cmd;	/**< Command to execute. */
  int			 f_dh;	/**< Flag: Write dhcpd.conf file. */
  int			 dbt;	/**< Database type. */
  int			 gdate;	/**< Flag: German date notation. */
  int			 hlh;	/**< Flag: Have localhost entry. */
  int			 ukoma;	/**< Flag: Use koma-script. */
} itadmin_job;



/**	Reader structure for credentials file.
*/
typedef struct {
  itadmin_job		*job;		/**< Job structure. */
  int			 f_clnt;	/**< Flag: In client section. */
} itadmin_cred_reader;


/**	@defgroup	itadmincommand	Command IDs for itadmin. */
/**@{*/
/**	itadmin command: Rebuild configuration and network documentation.
*/
#define	ITADMIN_CMD_CONFIG		1

/**	itadmin command: Rebuild license report.
*/
#define	ITADMIN_CMD_LICENSES		2

/**	itadmin command: show help text.
*/
#define	ITADMIN_CMD_HELP		4

/**	itadmin command: show version information.
*/
#define	ITADMIN_CMD_VERSION		8

/**	itadmin command: show license terms.
*/
#define	ITADMIN_CMD_LICENSE_TERMS	16
/**@}*/



/**	Maximum size for configuration file lines.
*/
#define	ITADMIN_CONFIG_LINE_SIZE	256

/**	Function to remove one object.
*/
typedef void itadmin_obj_del(void *);

#ifdef __cplusplus
extern "C" {
#endif

/**	Read configuration file(s).
	@param	job	Job structure.
	@return	1 on success, 0 on error.
*/
int
itadmin_config_read(itadmin_job *job);

/**	Delete one user.
	@param	v	Object to delete.
*/
void
itadmin_mem_user_del(void *v);

/**	Delete one building.
	@param	v	Object to delete.
*/
void
itadmin_mem_building_del(void *v);

/**	Delete one speed setting.
	@param	v	Object to delete.
*/
void
itadmin_mem_speed_del(void *v);

/**	Delete one VLAN.
	@param	v	Object to delete.
*/
void
itadmin_mem_vlan_del(void *v);

/**	Delete one network connection patch.
	@param	v	Object to delete.
*/
void
itadmin_mem_connect_del(void *v);

/**	Delete one network.
	@param	v	Object to delete.
*/
void
itadmin_mem_network_del(void *v);

/**	Delete one netgroup.
	@param	v	Object to delete.
*/
void
itadmin_mem_netgroup_del(void *v);

/**	Delete one netgroup dependency.
	@param	v	Object to delete.
*/
void
itadmin_mem_ngdep_del(void *v);

/**	Delete one DHCP class.
	@param	v	Object to delete.
*/
void
itadmin_mem_dhcp_class_del(void *v);

/**	Delete one DHCP pool.
	@param	v	Object to delete.
*/
void
itadmin_mem_dhcp_pool_del(void *v);

/**	Delete one DHCP group.
	@param	v	Object to delete.
*/
void
itadmin_mem_dhcp_group_del(void *v);

/**	Delete one host.
	@param	v	Object to delete.
*/
void
itadmin_mem_host_del(void *v);

/**	Delete one software manufacturer.
	@param	v	Object to delete.
*/
void
itadmin_mem_sw_man_del(void *v);

/**	Delete one software product.
	@param	v	Object to delete.
*/
void
itadmin_mem_software_del(void *v);

/**	Delete one license type.
	@param	v	Object to delete.
*/
void
itadmin_mem_lic_type_del(void *v);

/**	Delete one license.
	@param	v	Object to delete.
*/
void
itadmin_mem_license_del(void *v);

/**	Create new user.
	@param	job	Job structure.
	@param	un	Name.
	@param	tt	Academic degree or title (may be NULL).
	@param	sn	Surname (may be NULL).
	@param	na	Name.
	@param	em	E-Mail (may be NULL).
	@param	cc	Cost control ID (may be NULL).
	@param	si	Staff ID number (may be NULL).
	@return	Pointer to new object on success, NULL on error.
*/
itadmin_user *
itadmin_mem_user_new(
  itadmin_job	*job,
  char const	*un,
  char const	*tt,
  char const	*sn,
  char const	*na,
  char const	*em,
  char const	*cc,
  char const	*si
);

/**	Create new building.
	@param	job	Job structure.
	@param	s	Name.
	@param	l	Long name (may be NULL).
	@param	a1	Address line 1 (typically street and number,
			may be NULL).
	@param	a2	Address line 2 (may be NULL).
	@param	a3	Address line 3 (may be NULL).
	@param	a4	Address line 4 (may be NULL).
	@param	zc	Zip code (may be NULL).
	@param	city	Town or city name (may be NULL).
	@return	Pointer to new object on success, NULL on error.
*/
itadmin_building *
itadmin_mem_building_new(
  itadmin_job	*job,
  char const	*s,
  char const	*l,
  char const	*a1,
  char const	*a2,
  char const	*a3,
  char const	*a4,
  char const	*zc,
  char const	*city
);

/**	Create new speed setting.
	@param	job	Job structure.
	@param	s	Name.
	@param	n	Description (may be NULL).
	@return	Pointer to new object on success, NULL on error.
*/
itadmin_speed *
itadmin_mem_speed_new(
  itadmin_job	*job,
  char const	*s,
  char const	*n
);

/**	Create new VLAN.
	@param	job	Job structure.
	@param	s	Name.
	@param	l	Long name (may be NULL).
	@return	Pointer to new object on success, NULL on error.
*/
itadmin_vlan *
itadmin_mem_vlan_new(
  itadmin_job	*job,
  char const	*s,
  char const	*l
);

/**	Create new network connector.
	@param	job	Job structure.
	@param	s	Name.
	@param	hp	Building.
	@param	room	Room.
	@param	sp	Speed setting.
	@param	vl	VLAN.
	@param	bu	Building.
	@return	Pointer to new object on success, NULL on error.
*/
itadmin_connect *
itadmin_mem_connect_new(
  itadmin_job		*job,
  char const		*s,
  char const		*hp,
  char const		*room,
  itadmin_speed		*sp,
  itadmin_vlan		*vl,
  itadmin_building	*bu
);

/**	Create new network.
	@param	job	Job structure.
	@param	ip4	Network address.
	@param	ma4	Network mask.
	@param	gw4	Gateway.
	@param	bc4	Broadcast address.
	@param	vl	VLAN.
	@return	Pointer to new object on success, NULL on error.
*/
itadmin_network *
itadmin_mem_network_new(
  itadmin_job	*job,
  unsigned long	 ip4,
  unsigned long	 ma4,
  unsigned long	 gw4,
  unsigned long	 bc4,
  itadmin_vlan	*vl
);

/**	Create new netgroup.
	@param	job	Job structure.
	@param	sn	Short name.
	@param	ln	Long name (may be NULL).
	@return	Pointer to new object on success, NULL on error.
*/
itadmin_netgroup *
itadmin_mem_netgroup_new(
  itadmin_job	*job,
  char const	*sn,
  char const	*ln
);

/**	Create new netgroup dependency.
	@param	job	Job structure.
	@param	pa	Parent group.
	@param	ch	Child group.
	@return	Pointer to new object on success, NULL on error.
*/
itadmin_ngdep *
itadmin_mem_ngdep_new(
  itadmin_job		*job,
  itadmin_netgroup	*pa,
  itadmin_netgroup	*ch
);

/**	Create new DHCP class.
	@param	job	Job structure.
	@param	sn	Short name.
	@param	ln	Long name (may be NULL).
	@return	Pointer to new object on success, NULL on error.
*/
itadmin_dhcp_class *
itadmin_mem_dhcp_class_new(
  itadmin_job	*job,
  char const	*sn,
  char const	*ln
);

/**	Create new DHCP pool.
	@param	job	Job structure.
	@param	nw	Network.
	@param	cn	Allowed class (if unknown clients are denied,
			may be NULL).
	@param	ip4s	IPv4 start address.
	@param	ip4e	IPv4 end address.
	@param	duc	Flag: Deny unknown clients (needs cn).
	@param	auc	Flag: Allow unknown clients.
	@return	Pointer to new object on success, NULL on error.
*/
itadmin_dhcp_pool *
itadmin_mem_dhcp_pool_new(
  itadmin_job		*job,
  itadmin_network	*nw,
  itadmin_dhcp_class	*cn,
  unsigned long		 ip4s,
  unsigned long		 ip4e,
  int			 duc,
  int			 auc
);

/**	Create new DHCP group.
	@param	job	Job structure.
	@param	sn	Short name.
	@param	ln	Long name (may be NULL).
	@return	Pointer to new object on success, NULL on error.
*/
itadmin_dhcp_group *
itadmin_mem_dhcp_group_new(
  itadmin_job	*job,
  char const	*sn,
  char const	*ln
);

/**	Create new host
	@param	job	Job structure.
	@param	sn	Short name.
	@param	co	Comment/description (may be NULL).
	@param	maca	MAC address (may be NULL).
	@param	room	Room (may be NULL).
	@param	inv	Inventory number (may be NULL).
	@param	serno	Serial number (may be NULL).
	@param	hid	Host ID (may be NULL).
	@param	expi	Expiration date (may be NULL).
	@param	dnsd	DNS domain (may be NULL).
	@param	un	System owner.
	@param	ng	Netgroup (may be NULL).
	@param	dc	DHCP class (may be NULL).
	@param	dg	DHCP group (may be NULL).
	@param	nc	Network connection socket (may be NULL).
	@param	bu	Building (may be NULL).
	@param	ipv4	IPv4 address (may be NULL).
	@param	fnf	Flag: FQDN first in hosts file.
	@param	fgu	Flag: Guest computer (bring your own device).
	@param	snd	Flag: Skip in network documentation.
	@param	saw	Flag: Skip in arpwatch configuration.
	@return	Pointer to new object on success, NULL on error.
*/
itadmin_host *
itadmin_mem_host_new(
  itadmin_job		*job,
  itadmin_date		*expi,
  char const		*sn,
  char const		*co,
  char const		*maca,
  char const		*room,
  char const		*inv,
  char const		*serno,
  char const		*hid,
  char const		*dnsd,
  itadmin_user		*un,
  itadmin_netgroup	*ng,
  itadmin_dhcp_class	*dc,
  itadmin_dhcp_group	*dg,
  itadmin_connect	*nc,
  itadmin_building	*bu,
  unsigned long		 ipv4,
  int			 fnf,
  int			 fgu,
  int			 snd,
  int			 saw
);

/**	Create new software manufacturer.
	@param	job	Job structure.
	@param	sn	Short name.
	@param	ln	Long name (description).
	@return	Pointer to new object on success, NULL on error.
*/
itadmin_swman *
itadmin_mem_sw_man_new(
  itadmin_job	*job,
  char const	*sn,
  char const	*ln
);

/**	Create new software product.
	@param	job	Job structure.
	@param	sn	Short name.
	@param	ln	Long name.
	@param	mn	Software manufacturer name (may be NULL).
	@return	Pointer to new object on success, NULL on error.
*/
itadmin_swprod *
itadmin_mem_swprod_new(
  itadmin_job	*job,
  char const	*sn,
  char const	*ln,
  itadmin_swman	*mn
);

/**	Create new license type.
	@param	job	Job structure.
	@param	sn	Short license type name.
	@param	ln	Long name (description).
	@param	num	Number of client licenses for floating license servers.
	@return	Pointer to new object on success, NULL on error.
*/
itadmin_lictype *
itadmin_mem_lictype_new(
  itadmin_job	*job,
  char const	*sn,
  char const	*ln,
  int		 num
);

/**	Create new license.
	@param	job	Job structure.
	@param	pk	Primary key from licenses table (unused).
	@param	order	Order ID or tracking information (may be NULL).
	@param	notes	Additional notes (may be NULL).
	@param	d_del	Delivery date (may be NULL).
	@param	i_del	Delivery note ID (may be NULL).
	@param	d_inv	Invoice date (may be NULL).
	@param	i_inv	Invoice ID (may be NULL).
	@param	prod	Software product.
	@param	ltype	License type.
	@param	owner	License owner (may be NULL).
	@param	host	Computer (may be NULL).
	@return	Pointer to new object on success, NULL on error.
*/
itadmin_license *
itadmin_mem_license_new(
  itadmin_job		*job,
  unsigned long		 pk,
  char const		*order,
  char const		*notes,
  itadmin_date		*d_del,
  char const		*i_del,
  itadmin_date		*d_inv,
  char const		*i_inv,
  itadmin_swprod	*prod,
  itadmin_lictype	*ltype,
  itadmin_user		*owner,
  itadmin_host		*host
);

/**	Create new DHCP group in network.
	@param	job	Job structure.
	@param	gr	DHCP group structure.
	@return	Pointer to new object on success, NULL on error.
*/
itadmin_dhcp_ginw *
itadmin_mem_dhcp_ginw_new(itadmin_job *job, itadmin_dhcp_group *gr);

/**	Destroy DHCP group in network structure, release memory.
	@param	g	Group structure to destroy.
*/
void
itadmin_mem_dhcp_ginw_del(itadmin_dhcp_ginw *g);

/**	Initialize date structure.
	@param	dp	Date pointer.
*/
void
itadmin_mem_date_init(itadmin_date *dp);

/**	Copy date structure.
	@param	dp	Destination pointer.
	@param	sp	Source pointer.
*/
void
itadmin_mem_date_copy(itadmin_date *dp, itadmin_date *sp);

/**	Create a DHCP option structure.
	@param	job	Job structure.
	@param	k	Key (option name).
	@param	v	Option value.
	@param	pk	Primary key number from table (unused).
	@return	Valid pointer to new object on success, NULL on error.
*/
itadmin_dhcp_option *
itadmin_mem_dhcp_option_new(
  itadmin_job	*job,
  char const	*k,
  char const	*v,
  long		 pk
);

/**	Destroy DHCP option structure, release memory.
	@param	v	Option to destroy.
*/
void
itadmin_mem_dhcp_option_del(void *v);

/**	Read data from database.
	@param	job	Job structure.
	@return	1 on success, 0 on error.
*/
int
itadmin_data_read(itadmin_job *job);

/**	Read data from MySQL database.
	@param	job	Job structure.
	@return	1 on success, 0 on error.
*/
int
itadmin_data_mysql_read(itadmin_job *job);

/**	Register a user record.
	@param	job	Job structure.
	@param	us_s	User short name (login name).
	@param	us_t	User title or academic degree.
	@param	us_sn	Surname.
	@param	us_fn	Family name.
	@param	us_em	E-Mail.
	@param	us_ko	Cost control ID.
	@param	us_se	Organizational unit.
	@return	1 on success, 0 on error.
*/
int
itadmin_register_user(
  itadmin_job	*job,
  char const	*us_s,
  char const	*us_t,
  char const	*us_sn,
  char const	*us_fn,
  char const	*us_em,
  char const	*us_ko,
  char const	*us_se
);

/**	Register building.
	@param	job	Job structure.
	@param	gb_s	Short building name.
	@param	gb_l	Long building name.
	@param	gb_a1	Address line 1.
	@param	gb_a2	Address line 2.
	@param	gb_a3	Address line 3.
	@param	gb_a4	Address line 4.
	@param	gb_plz	Zip code.
	@param	gb_ort	City name.
	@return	1 on success, 0 on error.
*/
int
itadmin_register_building(
  itadmin_job		*job,
  char const		*gb_s,
  char const		*gb_l,
  char const		*gb_a1,
  char const		*gb_a2,
  char const		*gb_a3,
  char const		*gb_a4,
  char const		*gb_plz,
  char const		*gb_ort
);

/**	Register a speed setting.
	@param	job	Job structure.
	@param	sn	Short name for setting.
	@param	ln	Description.
	@return	1 on success, 0 on error.
*/
int
itadmin_register_speed(
  itadmin_job		*job,
  char const		*sn,
  char const		*ln
);

/**	Register a VLAN.
	@param	job	Job structure.
	@param	vl_s	Short name for VLAN.
	@param	vl_l	Description.
	@return	1 on success, 0 on error.
*/
int
itadmin_register_vlan(itadmin_job *job, char const *vl_s, char const *vl_l);

/**	Register patch (ethernet socket).
	@param	job	Job structure.
	@param	dd_n	Patch name.
	@param	sp_s	Speed setting name.
	@param	vl_s	VLAN short name.
	@param	dd_p	Hub port name.
	@param	gb_s	Building.
	@param	dd_r	Room number/name of patch.
	@return	1 on success, 0 on error.
*/
int
itadmin_register_patch(
  itadmin_job		*job,
  char const		*dd_n,
  char const		*sp_s,
  char const		*vl_s,
  char const		*dd_p,
  char const		*gb_s,
  char const		*dd_r
);

/**	Register network.
	@param	job	Job structure.
	@param	nw_ip	IP address.
	@param	nw_ma	Network mask.
	@param	nw_gw	Gateway.
	@param	nw_bc	Broadcast address.
	@param	vl_s	VLAN for network.
	@return	1 on success, 0 on error.
*/
int
itadmin_register_network(
  itadmin_job		*job,
  char const		*nw_ip,
  char const		*nw_ma,
  char const		*nw_gw,
  char const		*nw_bc,
  char const		*vl_s
);

/**	Register DHCP pool.
	@param	job	Job structure.
	@param	ips	IP start address of pool.
	@param	ipe	IP end address of pool.
	@param	nw	Network address (may be NULL or empty).
	@param	alu	Flag: Allow unknown clients.
	@param	dnu	Flag: Deny unknown clients.
	@param	dcn	Allowed class name if unknown clients denied.
	@return	1 on success, 0 on error.
*/
int
itadmin_register_dhcp_pool(
  itadmin_job		*job,
  char const		*ips,
  char const		*ipe,
  char const		*nw,
  int			 alu,
  int			 dnu,
  char const		*dcn
);

/**	Register DHCP class.
	@param	job	Job structure.
	@param	dcs	Short class name.
	@param	dcl	Long class name (description).
	@return	1 on success, 0 on error.
*/
int
itadmin_register_dhcp_class(itadmin_job *job,char const *dcs,char const *dcl);

/**	Register DHCP group.
	@param	job	Job structure.
	@param	sn	Short name.
	@param	ln	Long name (description).
	@return	1 on success, 0 on error.
*/
int
itadmin_register_dhcp_group(itadmin_job *job, char const *sn, char const *ln);

/**	Register netgroup.
	@param	job	Job structure.
	@param	ng_s	Short netgroup name.
	@param	ng_l	Long name (description).
	@return	1 on success, 0 on error.
*/
int
itadmin_register_netgroup(itadmin_job *job,char const *ng_s,char const *ng_l);

/**	Register netgroup dependency.
	@param	job	Job structure.
	@param	pgn	Name of the parent group.
	@param	cgn	Name of the child group.
	@return	1 on success, 0 on error.
*/
int
itadmin_register_ngdep(itadmin_job *job, char const *pgn, char const *cgn);

/**	Register one host.
	@param	job		Job structure.
	@param	co_s		Short name for computer.
	@param	us_s		Owner / user in charge.
	@param	co_ip		IPv4 address.
	@param	co_mc		MAC address.
	@param	ng_s		Netgroup.
	@param	co_co		Comment for PC.
	@param	dc_s		DHCP class.
	@param	dg_s		DHCP group.
	@param	dd_n		Patch/connector number.
	@param	gb_s		Building.
	@param	co_r		Room number.
	@param	co_in		Inventory ID.
	@param	co_sn		Serial number.
	@param	co_dd		DNS domain name.
	@param	co_ff		Flag: Write FQDN first in /etc/hosts.
	@param	co_gu		Flag: BYOD (bring your own device).
	@param	co_hi		Host ID.
	@param	co_ex		Expiration date.
	@param	co_nn		Flag: Skip host in network documentation.
	@param	co_na		Flag: Skip host for arpwatch.
*/

int
itadmin_register_host(
  itadmin_job		*job,
  char const		*co_s,
  char const		*us_s,
  char const		*co_ip,
  char const		*co_mc,
  char const		*ng_s,
  char const		*co_co,
  char const		*dc_s,
  char const		*dg_s,
  char const		*dd_n,
  char const		*gb_s,
  char const		*co_r,
  char const		*co_in,
  char const		*co_sn,
  char const		*co_dd,
  int			 co_ff,
  int			 co_gu,
  char const		*co_hi,
  itadmin_date		*co_ex,
  int			 co_nn,
  int			 co_na
);

/**	Register host name alias.
	@param	job	Job structure.
	@param	al	Alias name.
	@param	rn	Real host name.
	@return	1 on success, 0 on error.
*/
int
itadmin_register_alias(itadmin_job *job, char const *al, char const *rn);

/**	Register a DHCP option.
	@param	job	Job structure.
	@param	sct	Scope type name.
	@param	scn	Scope name.
	@param	k	Key (option name).
	@param	v	Option value.
	@param	pk	Primary key from database.
	@return	1 on success, 0 on error.
*/
int
itadmin_register_dhcp_option(
  itadmin_job	*job,
  char const	*sct,
  char const	*scn,
  char const	*k,
  char const	*v,
  long		 pk
);

/**	Check name for empty string or minus.
	We have to save the entry if the string pointer is not
	NULL and the string is not empty and not a minus.
	@param	sn	String to check.
	@return	1 if string must be saved, 0 for ignore.
*/
int
itadmin_register_check_user_name(char const *sn);

/**	Check whether we can attempt to convert a string to an IP address.
	@param	ip	String to test.
	@return	1 for string with text, 0 for empty string.
*/
int
itadmin_register_check_ip(char const *ip);

/**	Register a software manufacturer.
	@param	job	Job structure.
	@param	sm_s	Short name.
	@param	sm_l	Long name.
	@return	1 on success, 0 on error.
*/
int
itadmin_register_swman( itadmin_job *job, char const *sm_s, char const *sm_l);

/**	Register a software product.
	@param	job	Job structure.
	@param	sw_s	Short software name.
	@param	sw_l	Long software name.
	@param	sm_s	Software manufacturer.
	@return	1 on success, 0 on error.
*/
int
itadmin_register_swprod(
  itadmin_job	*job,
  char const	*sw_s,
  char const	*sw_l,
  char const	*sm_s
);
/**	Register a license type.
	@param	job	Job structure.
	@param	lt_s	Short license type name.
	@param	lt_l	Long name/description of license type.
	@param	nl	Number of licenses (for floating licenses).
*/
int
itadmin_register_lictype(
  itadmin_job	*job,
  char const	*lt_s,
  char const	*lt_l,
  int		 nl
);

/**	Register license.
	@param	job	Job structure.
	@param	pk	Primary key.
	@param	li_on	Order number (purchase process ID).
	@param	sw_s	Software short name.
	@param	us_s	User to which the license is assigned.
	@param	co_s	Computer on which the license is used.
	@param	lt_s	License type.
	@param	li_no	Optional note for the license.
	@param	sr_s	Software reseller.
	@param	li_dd	Delivery date.
	@param	li_nd	Delivery note number.
	@param	li_di	Invoide date.
	@param	li_ni	Invoice number.
	@return	1 on success, 0 on error.
*/
int
itadmin_register_license(
  itadmin_job	*job,
  unsigned long	 pk,
  char const	*li_on,
  char const	*sw_s,
  char const	*us_s,
  char const	*co_s,
  char const	*lt_s,
  char const	*li_no,
  char const	*sr_s,
  itadmin_date	*li_dd,
  char const	*li_nd,
  itadmin_date	*li_di,
  char const	*li_ni
);

/**	Compare structures for user.
	@param	l	Left structure.
	@param	r	Right structure, object, or name.
	@param	cr	Comparison criteria
	(0=user/user by us, 1=user/name by us, 2=user/user by na+sn+tt+us).
	@return	Comparison result.
*/
int
itadmin_comp_user(void const *l, void const *r, int cr);

/**	Compare structures for buildings.
	@param	l	Left structure.
	@param	r	Right structure, object, or name.
	@param	cr	Comparison criteria
	(0=building/building by s, 1=building/name by s).
	@return	Comparison result.
*/
int
itadmin_comp_building(void const *l, void const *r, int cr);

/**	Compare structures for network speed.
	@param	l	Left structure.
	@param	r	Right structure, object, or name.
	@param	cr	Comparison criteria
	(0=speed/speed by s, 1=speed/name).
	@return	Comparison result.
*/
int
itadmin_comp_speed(void const *l, void const *r, int cr);

/**	Compare structures for VLAN.
	@param	l	Left structure.
	@param	r	Right structure, object, or name.
	@param	cr	Comparison criteria
	(0=vlan/vlan by s, 1=vlan/name by s).
	@return	Comparison result.
*/
int
itadmin_comp_vlan(void const *l, void const *r, int cr);

/**	Compare structures for ethernet socket.
	@param	l	Left structure.
	@param	r	Right structure, object, or name.
	@param	cr	Comparison criteria
	(0=socket/socket by s, 1=socket/name).
	@return	Comparison result.
*/
int
itadmin_comp_connect(void const *l, void const *r, int cr);

/**	Compare structures for network.
	@param	l	Left structure.
	@param	r	Right structure, object, or name.
	@param	cr	Comparison criteria
	(0=network/network by ip4, 1=network/ipaddress).
	@return	Comparison result.
*/
int
itadmin_comp_network(void const *l, void const *r, int cr);

/**	Compare structures for netgroup.
	@param	l	Left structure.
	@param	r	Right structure, object, or name.
	@param	cr	Comparison criteria
	(0=netgroup/netgroup by sn, 1=netgroup/name by sn).
	@return	Comparison result.
*/
int
itadmin_comp_netgroup(void const *l, void const *r, int cr);

/**	Compare structures for DHCP class.
	@param	l	Left structure.
	@param	r	Right structure, object, or name.
	@param	cr	Comparison criteria
	(0=class/class by sn, 1=class/name by sn).
	@return	Comparison result.
*/
int
itadmin_comp_dhcp_class(void const *l, void const *r, int cr);

/**	Compare structures for DHCP pool.
	@param	l	Left structure.
	@param	r	Right structure, object, or name.
	@param	cr	Comparison criteria
	(0=pool/pool by ip4s, 1=pool/ipaddress).
	@return	Comparison result.
*/
int
itadmin_comp_dhcp_pool(void const *l, void const *r, int cr);

/**	Compare structures for DHCP group.
	@param	l	Left structure.
	@param	r	Right structure, object, or name.
	@param	cr	Comparison criteria
	(0=group/group by sn, 1=group/name).
	@return	Comparison result.
*/
int
itadmin_comp_dhcp_group(void const *l, void const *r, int cr);

/**	Compare structures for host
	@param	l	Left structure.
	@param	r	Right structure, object, or name.
	@param	cr	Comparison criteria
	(0=host/host by sn, 1=host/name, 2=host/host by ipv4, 3=host/ipaddr).
	@return	Comparison result.
*/
int
itadmin_comp_host(void const *l, void const *r, int cr);

/**	Compare structures for software manufacturer.
	@param	l	Left structure.
	@param	r	Right structure, object, or name.
	@param	cr	Comparison criteria
	(0=swman/swman by sn, 1=swman/name).
	@return	Comparison result.
*/
int
itadmin_comp_swman(void const *l, void const *r, int cr);

/**	Compare structures for software product.
	@param	l	Left structure.
	@param	r	Right structure, object, or name.
	@param	cr	Comparison criteria
	(0=product/product by sn, 1=product/name,
	2=product/product by mn->ln+ln).
	@return	Comparison result.
*/
int
itadmin_comp_swprod(void const *l, void const *r, int cr);

/**	Compare structures for license type.
	@param	l	Left structure.
	@param	r	Right structure, object, or name.
	@param	cr	Comparison criteria
	(0=type/type by sn, 1=type/name).
	@return	Comparison result.
*/
int
itadmin_comp_user(void const *l, void const *r, int cr);

/**	Compare structures for license type.
	@param	l	Left structure.
	@param	r	Right structure, object, or name.
	@param	cr	Comparison criteria
	(0=license/license by product).
	@return	Comparison result.
*/
int
itadmin_comp_lictype(void const *l, void const *r, int cr);

/**	Compare structures for license.
	@param	l	Left structure.
	@param	r	Right structure, object, or name.
	@param	cr	Comparison criteria
	(0=license/license by pk, 1=license/pk, 2=license/license by product).
	@return	Comparison result.
*/
int
itadmin_comp_license(void const *l, void const *r, int cr);

/**	Compare two licenses within a network.
	@param	l	Left object.
	@param	r	Right object or name.
	@param	cr	Comparison criteria (0=group/group,
	1=group/name).
	@return	Comparison result.
*/
int
itadmin_comp_dhcp_ginw(void const *l, void const *r, int cr);

/**	Compare two date structures.
	@param	l	Left object.
	@param	r	Right object.
	@return	1 if @arg l is later than @arg r, 0 for equal days,
	1 if @arg l is earlier than @arg r.
*/
int
itadmin_comp_date(itadmin_date const *l, itadmin_date const *r);

/**	Compare two DHCP options.
	@param	l	Left object.
	@param	r	Right object.
	@param	cr	Comparison criteria (ignored).
	@return	Comparison result.
*/
int
itadmin_comp_dhcp_option(void const *l, void const *r, int cr);

/**	Compare two strings.
	@param	l	Left string.
	@param	r	Right string.
	@param	cr	Comparison criteria (1=case-insensitive, 0=normal).
	@return	Comparison result.
*/
int
itadmin_comp_string(void const *l, void const *r, int cr);

/**	Check whether we have to write network configuration
	and documentation.
	@param	job	Job structure.
	@return	1 for yes, 0 for no.
*/
int
itadmin_job_do_network(itadmin_job *job);

/**	Check whether we have to write a dhcpd.conf file.
	@param	job	Job structure.
	@return	1 for yes, 0 for no.
*/
int
itadmin_job_do_dhcp(itadmin_job *job);

/**	Check whether we have to write a license report.
	@param	job	Job structure.
	@return	1 for yes, 0 for no.
*/
int
itadmin_job_do_licenses(itadmin_job *job);

/**	Convert string yyyy-mm-dd to date structure.
	@param	job	Job structure.
	@param	dp	Destination pointer.
	@param	str	Source text.
	@return	1 on success, 0 on error.
*/
int
itadmin_tool_convert_date(itadmin_job *job, itadmin_date *dp, char const *str);

/**	Write IPv4 address to file.
	@param	df	Destination file.
	@param	ipv4	Address to write.
*/
void
itadmin_tool_write_ip(FILE *df, unsigned long ipv4);

/**	Write IPv4 address to stream.
	@param	os	Output stream.
	@param	ipv4	Address to write.
*/
void
itadmin_tool_stream_ip(dk3_stream_t *os, unsigned long ipv4);

/**	Write user name short to LaTeX output.
	@param	job	Job structure.
	@param	os	Output stream.
	@param	user	User to write.
*/
void
itadmin_tool_write_user_latex_short(
  itadmin_job	*job,
  dk3_stream_t	*os,
  itadmin_user	*user
);

/**	Write user name long to LaTeX output.
	@param	job	Job structure.
	@param	os	Output stream.
	@param	user	User to write.
*/
void
itadmin_tool_write_user_latex_long(
  itadmin_job	*job,
  dk3_stream_t	*os,
  itadmin_user	*user
);

/**	Write the section header in the table.
	@param	job	Job structure.
	@param	os	Output stream.
	@param	kwi	Keyword index.
*/
void
itadmin_tool_table_section_header(
  itadmin_job	*job,
  dk3_stream_t	*os,
  size_t	 kwi
);

/**	Start a table line.
	@param	job	Job structure.
	@param	os	Output stream.
	@param	kwi	Keyword index in localized messages.
*/
void
itadmin_tool_table_line_start(
  itadmin_job	*job,
  dk3_stream_t	*os,
  size_t	 kwi
);

/**	Separate two items in a table.
	@param	job	Job structure.
	@param	os	Output stream.
*/
void
itadmin_tool_table_line_sep_rows(
  itadmin_job	*job,
  dk3_stream_t	*os
);

/**	Finish a table line.
	@param	job	Job structure.
	@param	os	Output stream.
	@param	pb	Flag: Allow page break here.
*/
void
itadmin_tool_table_line_finish(
  itadmin_job	*job,
  dk3_stream_t	*os,
  int		 pb
);

/**	Create empty table field.
	@param	job	Job structure.
	@param	os	Output stream.
	@param	nu	Flag: Write notification for missing value.
*/
void
itadmin_tool_table_line_no_data(
  itadmin_job	*job,
  dk3_stream_t	*os,
  int		 nu
);

/**	Write one detail table line.
	@param	job	Job structure.
	@param	os	Output stream.
	@param	kwi	Keyword index for option name.
	@param	det	Details to write.
	@param	nu	Flag: Write a note about unknown values.
	@param	pb	Flag: Allow page break after line.
*/
void
itadmin_tool_table_line(
  itadmin_job	*job,
  dk3_stream_t	*os,
  size_t	 kwi,
  char const	*det,
  int		 nu,
  int		 pb
);

/**	Write a table line consisting of two values.
	@param	job	Job structure.
	@param	os	Output stream.
	@param	key	Key.
	@param	val	Value.
	@param	fb	Flag: Key in bold.
	@param	pb	Flag: Allow page break.
*/
void
itadmin_tool_table_values(
  itadmin_job	*job,
  dk3_stream_t	*os,
  char const	*key,
  char const	*val,
  int		 fb,
  int		 pb
);

/**	Check whether a host is owned by a user.
	@param	us	User.
	@param	co	Host.
	@return	1 if the host is owned by the user, 0 otherwise.
*/
int
itadmin_tool_check_same_user(itadmin_user *us, itadmin_host *co);

/**	Write a section of text to output stream.
	@param	job	Job structure.
	@param	os	Output stream.
	@param	sect	Text section to write.
*/
void
itadmin_tool_write_section(
  itadmin_job		*job,
  dk3_stream_t		*os,
  char const * const	*sect
);

/**	Write log message of one part.
	@param	job	Job structure.
	@param	ll	Log level.
	@param	i	Index of message text in localized messages array.
*/
void
itadmin_tool_log_1(
  itadmin_job		*job,
  int			 ll,
  size_t		 i
);

/**	Write log message of three parts.
	@param	job	Job structure.
	@param	ll	Log level.
	@param	i1	Index of first message text in localized messages array.
	@param	i2	Index of third text part in localized messages array.
	@param	msg	Variable message text, second text part.
*/
void
itadmin_tool_log_utf8_3(
  itadmin_job		*job,
  int			 ll,
  size_t		 i1,
  size_t		 i2,
  char const		*msg
);

/**	Write log message of five parts.
	@param	job	Job structure.
	@param	ll	Log level.
	@param	i1	Index of first message text in localized messages array.
	@param	i2	Index of third text part in localized messages array.
	@param	i3	Index of fifth text part in localized messages array.
	@param	msg1	First variable message text, second text part.
	@param	msg2	Second variable messagetext, fourth text part.
*/
void
itadmin_tool_log_utf8_5(
  itadmin_job		*job,
  int			 ll,
  size_t		 i1,
  size_t		 i2,
  size_t		 i3,
  char const		*msg1,
  char const		*msg2
);

/**	Write log message of three parts.
	@param	job	Job structure.
	@param	ll	Log level.
	@param	i1	Index of first constant message part.
	@param	i2	Index of third message part.
	@param	pk	Primary key as numeric value.
*/
void
itadmin_tool_log_pk_3(
  itadmin_job		*job,
  int			 ll,
  size_t		 i1,
  size_t		 i2,
  unsigned long		 pk
);

/**	Write log message of five parts.
	@param	job	Job structure.
	@param	ll	Log level.
	@param	i1	Index of first constant message part.
	@param	i2	Index of third message part.
	@param	i3	Index of fifth message part.
	@param	pk	Primary key as numeric value.
	@param	msg	Variable message part.
*/
void
itadmin_tool_log_pk_5(
  itadmin_job		*job,
  int			 ll,
  size_t		 i1,
  size_t		 i2,
  size_t		 i3,
  unsigned long		 pk,
  char const		*msg
);

/**	Write IPv4 address to buffer.
	@param	bu	Destination buffer, at least 16 bytes long.
	@param	ip	IP address.
*/
void
itadmin_tool_ip_to_buffer(char *bu, unsigned long ip);

/**	Write hosts file.
	@param	job	Job structure.
	@return	1 on success, 0 on error.
*/
int
itadmin_hosts_output(itadmin_job *job);

/**	Write hosts.ldif file.
	@param	job	Job structure.
	@return	1 on success, 0 on error.
*/
int
itadmin_hosts_ldif_output(itadmin_job *job);

/**	Write ethers-by-ip and ethers-by-mac files.
	@param	job	Job structure.
	@return	1 on success, 0 on error.
*/
int
itadmin_ethers_output(itadmin_job *job);

/**	Write ethers.ldif file.
	@param	job	Job structure.
	@return	1 on success, 0 on error.
*/
int
itadmin_ethers_ldif_output(itadmin_job *job);

/**	Expand netgroup dependencies.
	@param	job	Job structure.
	@return	1 on success, 0 on error.
*/
int
itadmin_netgroup_expand(itadmin_job *job);

/**	Check whether a host is a member of a netgroup.
	@param	job		Job structure.
	@param	netgroup	Netgroup.
	@param	host		Host.
	@return	0 for no member, 1 for indirect member, 2 for direct member.
*/
int
itadmin_netgroup_host_member(
  itadmin_job		*job,
  itadmin_netgroup	*netgroup,
  itadmin_host		*host
);

/**	Write netgroup.ldif file.
	@param	job	Job structure.
	@return	1 on success, 0 on error.
*/
int
itadmin_netgroup_ldif_output(itadmin_job *job);

/**	Write dhcpd.conf file.
	@param	job	Job structure.
	@return	1 on success, 0 on error.
*/
int
itadmin_dhcpd_conf_output(itadmin_job *job);

/**	Write network documentation file.
	@param	job	Job structure.
	@return	1 on success, 0 on error.
*/
int
itadmin_netdocu(itadmin_job *job);

/**	Write license report.
	@param	job	Job structure.
	@return	1 on success, 0 on error.
*/
int
itadmin_license_report(itadmin_job *job);

#ifdef __cplusplus
}
#endif


#endif
