/*
	WARNING: This file was generated by dkct.
	Changes you make here will be lost if dkct is run again!
	You should modify the original source and run dkct on it.
	Original source: itadhcp.ctr
*/

/*
Copyright (C) 2012-2014, Dirk Krause

Redistribution and use in source and binary forms, with or without
modification, are permitted provided that the following conditions are met:

* Redistributions of source code must retain the above copyright notice,
  this list of conditions and the following disclaimer.
* Redistributions in binary form must reproduce the above opyright notice,
  this list of conditions and the following disclaimer in the documentation
  and/or other materials provided with the distribution.
* Neither the name of the author nor the names of contributors may be used
  to endorse or promote products derived from this software without specific
  prior written permission.

THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS ``AS IS''
AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
ARE DISCLAIMED.
IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE LIABLE FOR ANY
DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
(INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
(INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
*/

/**	@file itadhcp.c The itadhcp module.
*/


#line 10 "itadhcp.ctr"

#include "dk3all.h"
#include "itadmin.h"




#line 16 "itadhcp.ctr"



/**	Keywords used by the module.
*/
static char const * const itadmin_dhcp_c8_kw[] = {
/* 0 */
"dhcpd.conf",

/* 1 */
" ",

/* 2 */
"option:",

/* 3 */
"option ",

/* 4 */
"not ",

/* 5 */
"w",

/* 6 */
"class \"",

/* 7 */
"\" { match hardware; }",

/* 8 */
"subclass \"",

/* 9 */
"\" 1:",

/* 10 */
";",

/* 11 */
"# ",

/* 12 */
"shared-network dhcpnet",

/* 13 */
"{",

/* 14 */
"}",

/* 15 */
"subnet ",

/* 16 */
" netmask ",

/* 17 */
"option routers\t\t",

/* 18 */
"option subnet-mask\t\t",

/* 19 */
"option broadcast-address\t",

/* 20 */
"pool",

/* 21 */
"range ",

/* 22 */
"allow unknown clients;",

/* 23 */
"deny unknown clients;",

/* 24 */
"allow members of \"",

/* 25 */
"deny members of \"",

/* 26 */
"\";",

/* 27 */
"group",

/* 28 */
"host ",

/* 29 */
"option host-name\t\"",

/* 30 */
"hardware ethernet\t",

/* 31 */
"fixed-address\t",

NULL


#line 152 "itadhcp.ctr"
};




/**	Option names requiring special treatment.
*/
static char const * const itadmin_dhcp_option_names[] = {
/* 0 */
"authorative",

NULL


#line 163 "itadhcp.ctr"
};





/**	Indent line.
	@param	fipo	Output file.
	@param	ind	Indent level.
*/
static
void
itadmin_dhcp_indent(FILE *fipo, int ind)
{
  int i;
  for(i = 0; i < ind; i++) {
    fputs(itadmin_dhcp_c8_kw[1], fipo);
  }
}



/**	Write DHCP options.
	@param	job	Job structure.
	@param	fipo	Output file.
	@param	i_o	Options storage iterator.
	@param	objtype	Object type (ignored).
	@param	indent	Indent level.

*/
static
void
itadmin_dhcp_write_options(
  itadmin_job		*job,
  FILE			*fipo,
  dk3_sto_it_t		*i_o,
  int			 objtype,
  int			 indent
)
{
  itadmin_dhcp_option	*opt;
  char const		*p1;
  size_t		 sl;
  int			 is_option;
  

#line 208 "itadhcp.ctr"
  dk3sto_it_reset(i_o);
  while(NULL != (opt = (itadmin_dhcp_option *)dk3sto_it_next(i_o))) { 

#line 210 "itadhcp.ctr"
    is_option = 0;
    if(opt->k) {				

#line 212 "itadhcp.ctr"
      p1 = dk3str_c8_start(opt->k, NULL);
      if(p1) {					

#line 214 "itadhcp.ctr"
        sl = strlen(itadmin_dhcp_c8_kw[2]);
        if(dk3str_c8_len(p1) >= sl) {
	  if(dk3str_c8_ncmp(p1, itadmin_dhcp_c8_kw[2], sl) == 0) {
	    is_option = 1;
	    p1 = dk3str_c8_start(&(p1[7]), NULL);
	  }
	}
      } else {					

#line 222 "itadhcp.ctr"
      }
      if(p1) {					

#line 224 "itadhcp.ctr"
        if(is_option) {				

#line 225 "itadhcp.ctr"
	  itadmin_dhcp_indent(fipo, indent);
	  fputs(itadmin_dhcp_c8_kw[3], fipo);
	  fputs(p1, fipo);
	  if(opt->v) {
	    fputc('\t', fipo);
	    fputs(opt->v, fipo);
	  }
	  fputc(';', fipo);
	  fputc('\n', fipo);
	} else {				

#line 235 "itadhcp.ctr"
	  switch(dk3str_c8_array_index(itadmin_dhcp_option_names, p1, 0)) {
	    case 0: {				

#line 237 "itadhcp.ctr"
	      is_option = 1;
	      if(opt->v) {
	        if(dk3str_c8_is_bool(opt->v)) {
		  is_option = ((dk3str_c8_is_on(opt->v)) ? 1 : 0);
		}
	      }
	      itadmin_dhcp_indent(fipo, indent);
	      if(!is_option) {
	        fputs(itadmin_dhcp_c8_kw[4], fipo);
	      }
	      fputs(p1, fipo);
	      fputc(';', fipo);
	      fputc('\n', fipo);
	    } break;
	    default: {				

#line 252 "itadhcp.ctr"
	      itadmin_dhcp_indent(fipo, indent);
	      fputs(p1, fipo);
	      if(opt->v) {
	        fputc('\t', fipo);
		fputs(opt->v, fipo);
		fputc(';', fipo);
		fputc('\n', fipo);
	      }
	    } break;
	  }
	}
      } else {					

#line 264 "itadhcp.ctr"
      }
    } else {					

#line 266 "itadhcp.ctr"
    }
  } 

#line 268 "itadhcp.ctr"
}



/**	Check DHCP pool for correct settings.
	@param	job	Job structure.
	@param	dp	Pool to check.
	@return	1 on success, 0 on error.
*/
static
int
itadmin_dhcp_check_pool(
  itadmin_job		*job,
  itadmin_dhcp_pool	*dp
)
{
  int		 back = 0;
  char		 buffer[128];
  

#line 287 "itadhcp.ctr"
  if(dp->auc) {
    if(!(dp->duc)) {
      back = 1;
    }
  } else {
    if(dp->duc) {
      if(dp->acl) {
        back = 1;
      }
    }
  }
  if(!(back)) {
    /* ERROR: Inconsistent DHCP pool setup! */
    sprintf(
      buffer,
      "%lu.%lu.%lu.%lu",
      (((dp->ip4s) >> 24) & 0x000000FFUL),
      (((dp->ip4s) >> 16) & 0x000000FFUL),
      (((dp->ip4s) >>  8) & 0x000000FFUL),
      ((dp->ip4s) & 0x000000FFUL)
    );
    itadmin_tool_log_utf8_3(job, DK3_LL_ERROR, 134, 135, buffer);
  } 

#line 310 "itadhcp.ctr"
  return back;
}



/**	Register DHCP group for all hosts in a class with a network.
	@param	job	Job structure.
	@param	nw	Network.
	@param	dc	DHCP class.
	@return	1 on success, 0 on error.
*/
static
int
itadmin_dhcp_register_class_groups(
  itadmin_job		*job,
  itadmin_network	*nw,
  itadmin_dhcp_class	*dc
)
{
  itadmin_host		*ho;
  itadmin_dhcp_ginw	*ginw;
  int			 back = 1;
  

#line 333 "itadhcp.ctr"
  if(dc->i_ho) {
    dk3sto_it_reset(dc->i_ho);
    while(NULL != (ho = (itadmin_host *)dk3sto_it_next(dc->i_ho))) {
      if(ho->dg) {
	if(!(nw->s_dg)) {
	  nw->s_dg = dk3sto_open_app(job->app);
	  if(nw->s_dg) {
	    dk3sto_set_comp(nw->s_dg, itadmin_comp_dhcp_ginw, 0);
	  }
	}
	if(!(nw->i_dg)) {
	  if(nw->s_dg) {
	    nw->i_dg = dk3sto_it_open(nw->s_dg);
	  }
	}
	if((nw->s_dg) && (nw->i_dg)) {
	  ginw = (itadmin_dhcp_ginw *)dk3sto_it_find_like(
	    nw->i_dg, (void *)((ho->dg)->sn), 1
	  );
	  if(!(ginw)) {
	    ginw = itadmin_mem_dhcp_ginw_new(job, ho->dg);
	    if(ginw) {
	      if(!dk3sto_add(nw->s_dg, (void *)ginw)) {
	        /* ERROR: Failed to add! */
	        back = 0;
		itadmin_mem_dhcp_ginw_del(ginw);
	      }
	    } else {
	      back = 0;
	      /* ERROR: Memory! */
	    }
	  }
	} else {
	  back = 0;
	}
      }
    }
  } 

#line 371 "itadhcp.ctr"
  return back;
}



/**	Link DHCP classes to networks.
	@param	job	Job structure.
	@param	i_nw	Storage iterator for the networks.
*/
int
itadmin_dhcp_link_classes(
  itadmin_job	*job,
  dk3_sto_it_t	*i_nw
)
{
  char			 buffer[128];
  itadmin_network	*nw;
  itadmin_dhcp_pool	*dp;
  itadmin_dhcp_class	*dc;
  int			 back = 1;
  

#line 392 "itadhcp.ctr"
  dk3sto_it_reset(i_nw);
  while(NULL != (nw = (itadmin_network *)dk3sto_it_next(i_nw))) {	

#line 394 "itadhcp.ctr"
    if(nw->i_p) {			

#line 395 "itadhcp.ctr"
      dk3sto_it_reset(nw->i_p);
      while(NULL != (dp = (itadmin_dhcp_pool *)dk3sto_it_next(nw->i_p))) {
        if(!itadmin_dhcp_check_pool(job, dp)) { back = 0; }
        if(!(dp->auc)) {		

#line 399 "itadhcp.ctr"
	  if(dp->duc) {			

#line 400 "itadhcp.ctr"
	    if(dp->acl) {		

#line 401 "itadhcp.ctr"
	      dc = dp->acl;		

#line 402 "itadhcp.ctr"
	      if(!(dc->dhcpn)) {	

#line 403 "itadhcp.ctr"
	        dc->dhcpn = nw;
	        if(!(nw->s_dc)) {	

#line 405 "itadhcp.ctr"
	          nw->s_dc = dk3sto_open_app(job->app);
		  if(nw->s_dc) {	

#line 407 "itadhcp.ctr"
		    dk3sto_set_comp(nw->s_dc, itadmin_comp_dhcp_class, 0);
		  } else {
		    back = 0;		

#line 410 "itadhcp.ctr"
		  }
	        }
	        if(!(nw->i_dc)) {	

#line 413 "itadhcp.ctr"
	          if(nw->s_dc) {	

#line 414 "itadhcp.ctr"
		    nw->i_dc = dk3sto_it_open(nw->s_dc);
		  } else {		

#line 416 "itadhcp.ctr"
		    back = 0;
		  }
	        }
	        if((nw->s_dc) && (nw->i_dc)) {	

#line 420 "itadhcp.ctr"
		  if(!(dk3sto_it_find_like(nw->i_dc, (void *)dc, 0))) {
		    

#line 422 "itadhcp.ctr"
		    if(!(dk3sto_add(nw->s_dc, (void *)dc))) {
		      back = 0;		

#line 424 "itadhcp.ctr"
		    }
		  }
	        } else {		

#line 427 "itadhcp.ctr"
	          back = 0;
		  /* ERROR: Memory */
	        }
	      } else {			

#line 431 "itadhcp.ctr"
	        if(((dc->dhcpn)->ip4) != (nw->ip4)) {
		  back = 0;		

#line 433 "itadhcp.ctr"
		  /* ERROR: Class assigned to pools in different nets! */
		  itadmin_tool_log_utf8_3(job, DK3_LL_ERROR, 136, 137, dc->sn);
		}
	      }
	      if(!itadmin_dhcp_register_class_groups(job, nw, dc)) {
	        back = 0;
	      }
	    } else {			

#line 441 "itadhcp.ctr"
	      /* ERROR: No allowed class specified! */
	      sprintf(
	        buffer,
		"%lu.%lu.%lu.%lu",
		(((dp->ip4s) >> 24) & 0x000000FFUL),
		(((dp->ip4s) >> 16) & 0x000000FFUL),
		(((dp->ip4s) >>  8) & 0x000000FFUL),
		((dp->ip4s) & 0x000000FFUL)
	      );
	      itadmin_tool_log_utf8_3(job, DK3_LL_ERROR, 134, 138, buffer);
	    }
	  } else {			

#line 453 "itadhcp.ctr"
	  }
	} else {			

#line 455 "itadhcp.ctr"
	}
      }
    } else {				

#line 458 "itadhcp.ctr"
    }
  } 

#line 460 "itadhcp.ctr"
  return back;
}



/**	Write DHCP classes to output file.
	@param	job	Job structure.
	@param	fipo	output file.
*/
static
void
itadmin_dhcp_write_classes(itadmin_job *job, FILE *fipo)
{
  itadmin_dhcp_class	*dc;
  itadmin_host		*ho;
  int			 is_first;
  

#line 477 "itadhcp.ctr"
  dk3sto_it_reset(job->i_dc);
  while(NULL != (dc = (itadmin_dhcp_class *)dk3sto_it_next(job->i_dc))) {
    

#line 480 "itadhcp.ctr"
    if((dc->sn) && (dc->dhcpn)) {			

#line 481 "itadhcp.ctr"
      is_first = 1;
      if(dc->i_ho) {					

#line 483 "itadhcp.ctr"
        dk3sto_it_reset(dc->i_ho);
	while(NULL != (ho = (itadmin_host *)dk3sto_it_next(dc->i_ho))) {
	  if((ho->sn) && (ho->maca) && (!(ho->ipv4))) {
	    if(is_first) {
	      fputc('\n', fipo);
	      fputs(itadmin_dhcp_c8_kw[6], fipo);
	      fputs(dc->sn, fipo);
	      fputs(itadmin_dhcp_c8_kw[7], fipo);
	      fputc('\n', fipo);
	    }
	    is_first = 0;
	    fputs(itadmin_dhcp_c8_kw[11],  fipo);
	    fputs(ho->sn, fipo);
	    fputc('\n', fipo);
	    fputs(itadmin_dhcp_c8_kw[8],  fipo);
	    fputs(dc->sn, fipo);
	    fputs(itadmin_dhcp_c8_kw[9],  fipo);
	    fputs(ho->maca, fipo);
	    fputs(itadmin_dhcp_c8_kw[10], fipo);
	    fputc('\n', fipo);
	  }
	}						

#line 505 "itadhcp.ctr"
      } else {						

#line 506 "itadhcp.ctr"
      }
    }
  } 

#line 509 "itadhcp.ctr"
}



/**	Write one DHCP pool to output.
	@param	job	Job structure.
	@param	fipo	Output file.
	@param	dp	Pool to write.
	@param	indent	Line indent level.
*/
static
void
itadmin_dhcp_write_pool(
  itadmin_job		*job,
  FILE			*fipo,
  itadmin_dhcp_pool	*dp,
  int			 indent
)
{
  itadmin_dhcp_class	*dc;
  

#line 530 "itadhcp.ctr"
  itadmin_dhcp_indent(fipo, indent);
  fputs(itadmin_dhcp_c8_kw[20], fipo);
  fputc('\n', fipo);
  itadmin_dhcp_indent(fipo, indent);
  fputs(itadmin_dhcp_c8_kw[13], fipo);
  fputc('\n', fipo);
  itadmin_dhcp_indent(fipo, (indent + 1));
  fputs(itadmin_dhcp_c8_kw[21], fipo);
  itadmin_tool_write_ip(fipo, dp->ip4s);
  fputc('\t', fipo);
  itadmin_tool_write_ip(fipo, dp->ip4e);
  fputc(';', fipo);
  fputc('\n', fipo);
  if(dp->auc) {
    itadmin_dhcp_indent(fipo, (indent + 1));
    fputs(itadmin_dhcp_c8_kw[22], fipo);
    fputc('\n', fipo);
    /* Fuer alle Klassen verbieten */
    if(job->i_dc) {
      dk3sto_it_reset(job->i_dc);
      while(NULL != (dc = (itadmin_dhcp_class *)dk3sto_it_next(job->i_dc))) {
        itadmin_dhcp_indent(fipo, (indent + 1));
        fputs(itadmin_dhcp_c8_kw[25], fipo);
        fputs(dc->sn, fipo);
        fputs(itadmin_dhcp_c8_kw[26], fipo);
        fputc('\n', fipo);
      }
    }
  } else {
    itadmin_dhcp_indent(fipo, (indent + 1));
    fputs(itadmin_dhcp_c8_kw[23], fipo);
    fputc('\n', fipo);
    if(dp->acl) {
      itadmin_dhcp_indent(fipo, (indent + 1));
      fputs(itadmin_dhcp_c8_kw[24], fipo);
      fputs((dp->acl)->sn, fipo);
      fputs(itadmin_dhcp_c8_kw[26], fipo);
      fputc('\n', fipo);
    }
  }
  /* POOL OPTIONS */
  if(dp->i_do) {
    itadmin_dhcp_write_options(job, fipo, dp->i_do, 4, (indent+1));
  }
  itadmin_dhcp_indent(fipo, indent);
  fputs(itadmin_dhcp_c8_kw[14], fipo);
  fputc('\n', fipo);	

#line 577 "itadhcp.ctr"
}



/**	Write one host in group.
	@param	job	Job structure.
	@param	fipo	Output file.
	@param	ho	Host to write.
	@param	ind	Indent level at beginning of line.
*/
static
void
itadmin_dhcp_write_one_host(
  itadmin_job		*job,
  FILE			*fipo,
  itadmin_host		*ho,
  int			 ind
)
{
  

#line 597 "itadhcp.ctr"
  if((ho->sn) && (ho->maca)) {
    itadmin_dhcp_indent(fipo, ind);
    fputs(itadmin_dhcp_c8_kw[28], fipo);
    fputs(ho->sn, fipo);
    fputc('\n', fipo);
    itadmin_dhcp_indent(fipo, ind);
    fputs(itadmin_dhcp_c8_kw[13], fipo);
    fputc('\n', fipo);
  
    itadmin_dhcp_indent(fipo, (ind + 1));
    fputs(itadmin_dhcp_c8_kw[29], fipo);
    fputs(ho->sn, fipo);
    fputs(itadmin_dhcp_c8_kw[26], fipo);
    fputc('\n', fipo);
  
    itadmin_dhcp_indent(fipo, (ind + 1));
    fputs(itadmin_dhcp_c8_kw[30], fipo);
    fputs(ho->maca, fipo);
    fputs(itadmin_dhcp_c8_kw[10], fipo);
    fputc('\n', fipo);
  
    if(ho->ipv4) {
      itadmin_dhcp_indent(fipo, (ind + 1));
      fputs(itadmin_dhcp_c8_kw[31], fipo);
      itadmin_tool_write_ip(fipo, ho->ipv4);
      fputs(itadmin_dhcp_c8_kw[10], fipo);
      fputc('\n', fipo);
    }

    /* Added 2013-09-14: Must write host options too. */
    if((ho->s_do) && (ho->i_do)) {
      itadmin_dhcp_write_options(job, fipo, ho->i_do, 3, (ind+1));
    }
  
    itadmin_dhcp_indent(fipo, ind);
    fputs(itadmin_dhcp_c8_kw[14], fipo);
    fputc('\n', fipo);
  } 

#line 635 "itadhcp.ctr"
}



/**	Write hosts of one group for a network.
	
*/
static
void
itadmin_dhcp_write_group(
  itadmin_job		*job,
  FILE			*fipo,
  itadmin_network	*nw,
  dk3_sto_it_t		*i_ho,
  itadmin_dhcp_group	*gr,
  int			 ind

)
{
  itadmin_host		*ho;
  itadmin_dhcp_class	*dc;
  int			 is_first;
  int			 is_in_group;
  

#line 659 "itadhcp.ctr"
  if(gr) {	

#line 660 "itadhcp.ctr"
  } else {	

#line 661 "itadhcp.ctr"
  }
  is_first = 1;
  if(i_ho) {
    dk3sto_it_reset(i_ho);
    while(NULL != (ho = (itadmin_host *)dk3sto_it_next(i_ho))) {
      if((ho->sn) && (ho->maca)) {
        if(is_first) {
	  itadmin_dhcp_indent(fipo, ind);
	  fputs(itadmin_dhcp_c8_kw[27], fipo);
	  fputc('\n', fipo);
	  itadmin_dhcp_indent(fipo, ind);
	  fputs(itadmin_dhcp_c8_kw[13], fipo);
	  fputc('\n', fipo);
	  if(gr) {
	    if(gr->i_do) {
              itadmin_dhcp_write_options(job, fipo, gr->i_do, 3, (ind+1));
              fputc('\n', fipo);
	    }
	  }
        } is_first = 0;
	itadmin_dhcp_write_one_host(job, fipo, ho, (ind + 1));
      }
    }
  }
  if(nw) {
    if(nw->i_dc) {
      dk3sto_it_reset(nw->i_dc);
      while(NULL != (dc = (itadmin_dhcp_class *)dk3sto_it_next(nw->i_dc))) {
        if(dc->i_ho) {
	  dk3sto_it_reset(dc->i_ho);
	  while(NULL != (ho = (itadmin_host *)dk3sto_it_next(dc->i_ho))) {
	    is_in_group = 0;
	    if(ho->dg) {
	      if(gr) {
	        if(itadmin_comp_dhcp_group((void *)(ho->dg),(void *)gr,0) == 0)
		{
		  is_in_group = 1;
		}
	      }
	    } else {
	      if(!(gr)) {
	        is_in_group = 1;
	      }
	    }
	    if(is_in_group) {
              if(is_first) {
	        itadmin_dhcp_indent(fipo, ind);
	        fputs(itadmin_dhcp_c8_kw[27], fipo);
	        fputc('\n', fipo);
	        itadmin_dhcp_indent(fipo, ind);
	        fputs(itadmin_dhcp_c8_kw[13], fipo);
	        fputc('\n', fipo);
	        if(gr) {
	          if(gr->i_do) {
                    itadmin_dhcp_write_options(job,fipo,gr->i_do,3,(ind + 1));
                    fputc('\n', fipo);
	          }
	        }
              } is_first = 0;
	      itadmin_dhcp_write_one_host(job, fipo, ho, (ind + 1));
	    }
	  }
	}
      }
    }
  }
  if(!(is_first)) {
    itadmin_dhcp_indent(fipo, ind);
    fputs(itadmin_dhcp_c8_kw[14], fipo);
    fputc('\n', fipo);
  }
  

#line 733 "itadhcp.ctr"
}



/**	Write one network to output file.
	@param	job	Job structure.
	@param	fipo	Output file.
	@param	nw	Network to write.
	@param	indent	Indent at start of file.
*/
static
void
itadmin_dhcp_write_one_network(
  itadmin_job		*job,
  FILE			*fipo,
  itadmin_network	*nw,
  int			 indent
)
{
  itadmin_dhcp_pool	*dp;
  itadmin_dhcp_ginw	*ginw;
  

#line 755 "itadhcp.ctr"
  itadmin_dhcp_indent(fipo, indent);
  fputs(itadmin_dhcp_c8_kw[15], fipo);
  itadmin_tool_write_ip(fipo, nw->ip4);
  fputs(itadmin_dhcp_c8_kw[16], fipo);
  itadmin_tool_write_ip(fipo, nw->ma4);
  fputc('\n', fipo);
  itadmin_dhcp_indent(fipo, indent);
  fputs(itadmin_dhcp_c8_kw[13], fipo);
  fputc('\n', fipo);
  itadmin_dhcp_indent(fipo, (indent + 1));
  fputs(itadmin_dhcp_c8_kw[17], fipo);
  itadmin_tool_write_ip(fipo, nw->gw4);
  fputc(';', fipo);
  fputc('\n', fipo);
  itadmin_dhcp_indent(fipo, (indent + 1));
  fputs(itadmin_dhcp_c8_kw[18], fipo);
  itadmin_tool_write_ip(fipo, nw->ma4);
  fputc(';', fipo);
  fputc('\n', fipo);
  itadmin_dhcp_indent(fipo, (indent + 1));
  fputs(itadmin_dhcp_c8_kw[19], fipo);
  itadmin_tool_write_ip(fipo, nw->bc4);
  fputc(';', fipo);
  fputc('\n', fipo);
  /* DHCP options */
  if(nw->i_do) {
    itadmin_dhcp_write_options(job, fipo, nw->i_do, 2, (indent+1));
    fputc('\n', fipo);
  }
  /* Pools */
  if(nw->i_p) {
    dk3sto_it_reset(nw->i_p);
    while(NULL != (dp = (itadmin_dhcp_pool *)dk3sto_it_next(nw->i_p))) {
      itadmin_dhcp_write_pool(job, fipo, dp, (indent + 1));
    }
  }
  /* Groups, direct for network and in DHCP classes */
  if(nw->i_dg) {
    dk3sto_it_reset(nw->i_dg);
    while(NULL != (ginw = (itadmin_dhcp_ginw *)dk3sto_it_next(nw->i_dg))) {
      itadmin_dhcp_write_group(job,fipo,nw,ginw->i_h,ginw->gr,(indent + 1));
    }
  }
  /* Hosts without groups, direct for network and in DHCP classes */
  itadmin_dhcp_write_group(job, fipo, nw, nw->i_hoi, NULL, (indent + 1));
  itadmin_dhcp_indent(fipo, indent);
  fputs(itadmin_dhcp_c8_kw[14], fipo);
  fputc('\n', fipo); 

#line 803 "itadhcp.ctr"
}



/**	Write DHCP networks.
	@param	job	Job structure.
	@param	fipo	Output file.
	@param	i_nw	Iterator for networks storage.
*/
static
void
itadmin_dhcp_write_networks(
  itadmin_job	*job,
  FILE		*fipo,
  dk3_sto_it_t	*i_nw
)
{
  itadmin_network	*nw;
  

#line 822 "itadhcp.ctr"
  dk3sto_it_reset(i_nw);
  while(NULL != (nw = (itadmin_network *)dk3sto_it_next(i_nw))) {
    itadmin_dhcp_write_one_network(job, fipo, nw, 1);
  } 

#line 826 "itadhcp.ctr"
}



/**	Write data for one VLAN to output.
	@param	job	Job structure.
	@param	fipo	Output file.
	@param	i_nw	Networks iterator.
	@param	i_do	DHCP options storage iterator.
*/
static
void
itadmin_dhcp_write_vlan(
  itadmin_job	*job,
  FILE		*fipo,
  dk3_sto_it_t	*i_nw,
  dk3_sto_it_t	*i_do
)
{
  itadmin_network	*nw;
  int		 	 num_networks;
  

#line 848 "itadhcp.ctr"
  num_networks = 0;
  if(i_nw) {
    dk3sto_it_reset(i_nw);
    while(NULL != dk3sto_it_next(i_nw)) { num_networks++; }
    if(num_networks > 0) {
      dk3sto_it_reset(i_nw);
      if((num_networks > 1) || (i_do)) {
        fputs(itadmin_dhcp_c8_kw[12], fipo);
	fputc('\n', fipo);
	fputs(itadmin_dhcp_c8_kw[13], fipo);
	fputc('\n', fipo);
	if(i_do) {
	  itadmin_dhcp_write_options(job, fipo, i_do, 1, 1);
	}
	itadmin_dhcp_write_networks(job, fipo, i_nw);
	fputs(itadmin_dhcp_c8_kw[14], fipo);
	fputc('\n', fipo);
      } else {
        nw = (itadmin_network *)dk3sto_it_next(i_nw);
	if(nw) {
	  itadmin_dhcp_write_one_network(job, fipo, nw, 0);
	}
      }
    }
  } 

#line 873 "itadhcp.ctr"
}



/**	Write output file for a VLAN or all networks.
	@param	job		Job structure.
	@param	vlanname	Name of VLAN (NULL if not specified).
	@param	i_nw		Iterator for all networks.
	@param	i_do		Iterator for VLAN DHCP options (may be NULL).
	@return	1 on success, 0 on error.
*/
static
int
itadmin_dhcpd_output(
  itadmin_job		*job,
  dkChar const		*vlanname,
  dk3_sto_it_t		*i_nw,
  dk3_sto_it_t		*i_do
)
{
  FILE			*fipo;
  int			 back = 0;
  

#line 896 "itadhcp.ctr"
  if(itadmin_dhcp_link_classes(job, i_nw)) {	

#line 897 "itadhcp.ctr"
    fipo = dk3sf_c8_fopen_app(
      itadmin_dhcp_c8_kw[0], itadmin_dhcp_c8_kw[5], job->app
    );
    if(fipo) {					

#line 901 "itadhcp.ctr"
      itadmin_dhcp_write_options(job, fipo, job->i_do, 0, 0);
      fputc('\n', fipo);
      itadmin_dhcp_write_classes(job, fipo);
      fputc('\n', fipo);
      itadmin_dhcp_write_vlan(job, fipo, i_nw, i_do);
      back = 1;
#if DK3_CHAR_SIZE == 1
      if(!dk3sf_fclose_fn_app(fipo, itadmin_dhcp_c8_kw[0], job->app)) {
        back = 0;
      }
#else
      if(!dk3sf_fclose_fn_app(fipo, NULL, job->app)) {
        back = 0;
      }
#endif
    } else {					

#line 917 "itadhcp.ctr"
      /* ERROR: Failed to open file. */
    }
  } else {				

#line 920 "itadhcp.ctr"
  } 

#line 921 "itadhcp.ctr"
  return back;
}



int
itadmin_dhcpd_conf_output(itadmin_job *job)
{
  char			 vlname[ITADMIN_CONFIG_LINE_SIZE];
  itadmin_vlan		*dhcpvl;
  int			 back = 0;
  int			 res;
  

#line 934 "itadhcp.ctr"
  if(job->vlan) {
    res = dk3str_str_to_c8u_app(
      vlname, sizeof(vlname), job->vlan,
      dk3app_get_encoding(job->app), job->app
    );
    if(res) {
      dhcpvl =
      (itadmin_vlan *)dk3sto_it_find_like(job->i_vl, (void *)vlname, 1);
      if(dhcpvl) {
        back = itadmin_dhcpd_output(job, dhcpvl->s, dhcpvl->i_nw, dhcpvl->i_do);
      } else {
        dk3app_log_3(job->app, DK3_LL_ERROR, job->msg, 139, 140, job->vlan);
      }
    } else {
      /* ERROR: Failed to convert VLAN name! */
    }
  } else {
    back = itadmin_dhcpd_output(job, NULL, job->i_nw, NULL);
  } 

#line 953 "itadhcp.ctr"
  return back;
}

