/*
	WARNING: This file was generated by dkct.
	Changes you make here will be lost if dkct is run again!
	You should modify the original source and run dkct on it.
	Original source: itacomp.ctr
*/

/*
Copyright (C) 2012-2014, Dirk Krause

Redistribution and use in source and binary forms, with or without
modification, are permitted provided that the following conditions are met:

* Redistributions of source code must retain the above copyright notice,
  this list of conditions and the following disclaimer.
* Redistributions in binary form must reproduce the above opyright notice,
  this list of conditions and the following disclaimer in the documentation
  and/or other materials provided with the distribution.
* Neither the name of the author nor the names of contributors may be used
  to endorse or promote products derived from this software without specific
  prior written permission.

THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS ``AS IS''
AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
ARE DISCLAIMED.
IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE LIABLE FOR ANY
DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
(INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
(INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
*/

/**	@file itacomp.c The itacomp module.
*/


#line 10 "itacomp.ctr"

#include "dk3all.h"
#include "itadmin.h"





#line 17 "itacomp.ctr"



/**	@file	itacomp.c	Comparison functions.
This module provides comparison functions for the sorted
containers.
*/



/**	Correct comparison result.
	@param	v	Direct result from string comparison.
	@return	-1, 0, or 1.
*/
static
int
itadmin_comp_correct(int v)
{
  int	back;
  back = v;
  if(v < -1) back = -1;
  if(v >  1) back =  1;
  return back;
}



int
itadmin_comp_user(void const *l, void const *r, int cr)
{
  itadmin_user const	*pl;
  itadmin_user const	*pr;
  char const	*sn;
  int		back	= 0;
  if(l) {
    if(r) {
      pl = (itadmin_user const *)l;
      switch(cr) {
        case 1: {
	  sn = (char const *)r;
	  if(pl->us) {
	    back = itadmin_comp_correct(dk3str_c8_cmp(pl->us, sn));
	  } else {
	    back = -1;
	  }
	} break;
	case 2: {
	  pr = (itadmin_user const *)r;
	  if(pl->na) {
	    if(pr->na) {
	      back = itadmin_comp_correct(dk3str_c8_cmp(pl->na, pr->na));
	    } else { back = 1; }
	  } else {
	    if(pr->na) { back = -1; }
	  }
	  if(back == 0) {
	    if(pl->sn) {
	      if(pr->sn) {
	        back = itadmin_comp_correct(dk3str_c8_cmp(pl->sn, pr->sn));
	      } else { back = 1; }
	    } else {
	      if(pr->sn) { back = -1; }
	    }
	  }
	  if(back == 0) {
	    if(pl->tt) {
	      if(pr->tt) {
	        back = itadmin_comp_correct(dk3str_c8_cmp(pl->tt, pr->tt));
	      } else { back = 1; }
	    } else {
	      if(pr->tt) { back = -1; }
	    }
	  }
	  if(back == 0) {
	    if(pl->us) {
	      if(pr->us) {
	        back = itadmin_comp_correct(dk3str_c8_cmp(pl->us, pr->us));
	      } else { back = 1; }
	    } else {
	      if(pr->us) { back = -1; }
	    }
	  }
	} break;
	default: {
	  pr = (itadmin_user *)r;
	  if(pl->us) {
	    if(pr->us) {
	      back = itadmin_comp_correct(dk3str_c8_cmp(pl->us, pr->us));
	    } else { back = 1; }
	  } else {
	    if(pr->us) { back = -1; }
	  }
	} break;
      }
    } else { back = 1; }
  } else {
    if(r) { back = -1; }
  }
  return back;
}



int
itadmin_comp_building(void const *l, void const *r, int cr)
{
  itadmin_building const	*pl;
  itadmin_building const	*pr;
  int				 back	= 0;
  if(l) {
    if(r) {
      pl = (itadmin_building const *)l;
      switch(cr) {
        case 1: {
	  if(pl->s) {
	    back = itadmin_comp_correct(dk3str_c8_cmp(pl->s, (char const *)r));
	  } else { back = -1; }
	} break;
	default: {
	  pr = (itadmin_building const *)r;
	  if(pl->s) {
	    if(pr->s) {
	      back = itadmin_comp_correct(dk3str_c8_cmp(pl->s, pr->s));
	    } else { back = 1; }
	  } else {
	    if(pr->s) { back = -1; }
	  }
	} break;
      }
    } else { back = 1; }
  } else {
    if(r) { back = -1; }
  }
  return back;
}



int
itadmin_comp_speed(void const *l, void const *r, int cr)
{
  itadmin_speed const	*pl;
  itadmin_speed	const	*pr;
  int			 back	= 0;
  if(l) {
    if(r) {
      pl = (itadmin_speed const *)l;
      switch(cr) {
        case 1: {
	  if(pl->s) {
	    back = itadmin_comp_correct(dk3str_c8_cmp(pl->s, (char const *)r));
	  } else { back = -1; }
	} break;
	default: {
	  pr = (itadmin_speed const *)r;
	  if(pl->s) {
	    if(pr->s) {
	      back = itadmin_comp_correct(dk3str_c8_cmp(pl->s, pr->s));
	    } else { back = 1; }
	  } else {
	    if(pr->s) { back = -1; }
	  }
	} break;
      }
    } else { back = 1; }
  } else {
    if(r) { back = -1; }
  }
  return back;
}



int
itadmin_comp_vlan(void const *l, void const *r, int cr)
{
  itadmin_vlan const		*pl;
  itadmin_vlan const		*pr;
  int				 back	= 0;
  if(l) {
    if(r) {
      pl = (itadmin_vlan const *)l;
      switch(cr) {
        case 1: {
	  if(pl->s) {
	    back = itadmin_comp_correct(dk3str_c8_cmp(pl->s, (char const *)r));
	  } else { back = -1; }
	} break;
	default: {
	  pr = (itadmin_vlan const *)r;
	  if(pl->s) {
	    if(pr->s) {
	      back = itadmin_comp_correct(dk3str_c8_cmp(pl->s, pr->s));
	    } else { back = 1; }
	  } else {
	    if(pr->s) { back = -1; }
	  }
	} break;
      }
    } else { back = 1; }
  } else {
    if(r) { back = -1; }
  }
  return back;
}



int
itadmin_comp_connect(void const *l, void const *r, int cr)
{
  itadmin_connect const	*pl;
  itadmin_connect const	*pr;
  int			 back	= 0;
  if(l) {
    if(r) {
      pl = (itadmin_connect const *)l;
      switch(cr) {
        case 1: {
	  if(pl->s) {
	    back = itadmin_comp_correct(dk3str_c8_cmp(pl->s, (char const *)r));
	  } else { back = -1; }
	} break;
	default: {
	  pr = (itadmin_connect const *)r;
	  if(pl->s) {
	    if(pr->s) {
	      back = itadmin_comp_correct(dk3str_c8_cmp(pl->s, pr->s));
	    } else { back = 1; }
	  } else {
	    if(pr->s) { back = -1; }
	  }
	} break;
      }
    } else { back = 1; }
  } else {
    if(r) { back = -1; }
  }
  return back;
}



int
itadmin_comp_network(void const *l, void const *r, int cr)
{
  itadmin_network const	*pl;
  itadmin_network const	*pr;
  unsigned long	const	*ul;
  int			 back	= 0;
  if(l) {
    if(r) {
      pl = (itadmin_network const *)l;
      switch(cr) {
        case 1: {
	  ul = (unsigned long const *)r;
	  if(((pl->ip4) & (pl->ma4)) > ((*ul) & (pl->ma4))) {
	    back = 1;
	  } else {
	    if(((pl->ip4) & (pl->ma4)) < ((*ul) & (pl->ma4))) {
	      back = -1;
	    }
	  }
	} break;
	default: {
	  pr = (itadmin_network const *)r;
	  if(pl->ip4 > pr->ip4) {
	    back = 1;
	  } else {
	    if(pl->ip4 < pr->ip4) {
	      back = -1;
	    }
	  }
	} break;
      }
    } else { back = 1; }
  } else {
    if(r) { back = -1; }
  }
  return back;
}



int
itadmin_comp_netgroup(void const *l, void const *r, int cr)
{
  itadmin_netgroup const	*pl;
  itadmin_netgroup const	*pr;
  int				 back	= 0;
  if(l) {
    if(r) {
      pl = (itadmin_netgroup const *)l;
      switch(cr) {
        case 1: {
	  if(pl->sn) {
	    back = itadmin_comp_correct(dk3str_c8_cmp(pl->sn, (char const *)r));
	  } else { back = -1; }
	} break;
	default: {
	  pr = (itadmin_netgroup const *)r;
	  if(pl->sn) {
	    if(pr->sn) {
	      back = itadmin_comp_correct(dk3str_c8_cmp(pl->sn, pr->sn));
	    } else { back = 1; }
	  } else {
	    if(pr->sn) { back = -1; }
	  }
	} break;
      }
    } else { back = 1; }
  } else {
    if(r) { back = -1; }
  }
  return back;
}



int
itadmin_comp_dhcp_class(void const *l, void const *r, int cr)
{
  itadmin_dhcp_class const	*pl;
  itadmin_dhcp_class const	*pr;
  int				 back	= 0;
  if(l) {
    if(r) {
      pl = (itadmin_dhcp_class const *)l;
      switch(cr) {
        case 1: {
	  if(pl->sn) {
	    back = itadmin_comp_correct(dk3str_c8_cmp(pl->sn, (char const *)r));
	  } else { back = -1; }
	} break;
	default: {
	  pr = (itadmin_dhcp_class const *)r;
	  if(pl->sn) {
	    if(pr->sn) {
	      back = itadmin_comp_correct(dk3str_c8_cmp(pl->sn, pr->sn));
	    } else { back = 1; }
	  } else {
	    if(pr->sn) { back = -1; }
	  }
	} break;
      }
    } else { back = 1; }
  } else {
    if(r) { back = -1; }
  }
  return back;
}



int
itadmin_comp_dhcp_pool(void const *l, void const *r, int cr)
{
  itadmin_dhcp_pool const	*pl;
  itadmin_dhcp_pool const	*pr;
  unsigned long	const		*ul;
  int				 back	= 0;
  if(l) {
    if(r) {
      pl = (itadmin_dhcp_pool const *)l;
      switch(cr) {
        case 1: {
	  ul = (unsigned long const *)r;
	  if(pl->ip4s > *ul) {
	    back = 1;
	  } else {
	    if(pl->ip4e < *ul) {
	      back = -1;
	    }
	  }
	} break;
	default: {
	  pr = (itadmin_dhcp_pool const *)r;
	  if(pl->ip4s > pr->ip4s) {
	    back = 1;
	  } else {
	    if(pl->ip4s < pr->ip4s) {
	      back = -1;
	    }
	  }
	} break;
      }
    } else { back = 1; }
  } else {
    if(r) { back = -1; }
  }
  return back;
}



int
itadmin_comp_dhcp_group(void const *l, void const *r, int cr)
{
  itadmin_dhcp_group const	*pl;
  itadmin_dhcp_group const	*pr;
  int				 back	= 0;
  if(l) {
    if(r) {
      pl = (itadmin_dhcp_group const *)l;
      switch(cr) {
        case 1: {
	  if(pl->sn) {
	    back = itadmin_comp_correct(dk3str_c8_cmp(pl->sn, (char const *)r));
	  } else { back = -1; }
	} break;
	default: {
	  pr = (itadmin_dhcp_group const *)r;
	  if(pl->sn) {
	    if(pr->sn) {
	      back = itadmin_comp_correct(dk3str_c8_cmp(pl->sn, pr->sn));
	    } else { back = 1; }
	  } else {
	    if(pr->sn) { back = -1; }
	  }
	} break;
      }
    } else { back = 1; }
  } else {
    if(r) { back = -1; }
  }
  return back;
}



int
itadmin_comp_host(void const *l, void const *r, int cr)
{
  itadmin_host const		*pl;
  itadmin_host const		*pr;
  unsigned long	const		*ul;
  int				 back	= 0;
  if(l) {
    if(r) {
      pl = (itadmin_host const *)l;
      switch(cr) {
        case 3: {
	  ul = (unsigned long const *)r;
	  if(pl->ipv4 > *ul) {
	    back = 1;
	  } else {
	    if(pl->ipv4 < *ul) {
	       back = -1;
	    }
	  }
	} break;
	case 2: {
	  pr = (itadmin_host const *)r;
	  if(pl->ipv4 > pr->ipv4) {
	    back = 1;
	  } else {
	    if(pl->ipv4 < pr->ipv4) {
	      back = -1;
	    }
	  }
	} break;
	case 1: {
	  if(pl->sn) {
	    back = itadmin_comp_correct(dk3str_c8_cmp(pl->sn, (char const *)r));
	  } else { back = -1; }
	} break;
	default: {
	  pr = (itadmin_host const *)r;
	  if(pl->sn) {
	    if(pr->sn) {
	      back = itadmin_comp_correct(dk3str_c8_cmp(pl->sn, pr->sn));
	    } else { back = 1; }
	  } else {
	    if(pr->sn) { back = -1; }
	  }
	} break;
      }
    } else { back = 1; }
  } else {
    if(r) { back = -1; }
  }
  return back;
}



int
itadmin_comp_swman(void const *l, void const *r, int cr)
{
  itadmin_swman const		*pl;
  itadmin_swman	const		*pr;
  int				 back	= 0;
  if(l) {
    if(r) {
      pl = (itadmin_swman const *)l;
      switch(cr) {
        case 2: {
	  pr = (itadmin_swman const *)r;
	  if(pl->ln) {
	    if(pr->ln) {
	      back = itadmin_comp_correct(dk3str_c8_cmp(pl->ln, pr->ln));
	    } else { back = 1; }
	  } else {
	    if(pr->ln) { back = -1; }
	  }
	  if(back == 0) {
	    if(pl->sn) {
	      if(pr->sn) {
	        back = itadmin_comp_correct(dk3str_c8_cmp(pl->sn, pr->sn));
	      } else { back = 1; }
	    } else {
	      if(pr->sn) { back = -1; }
	    }
	  }
	} break;
        case 1: {
	  if(pl->sn) {
	    back = itadmin_comp_correct(dk3str_c8_cmp(pl->sn, (char const *)r));
	  } else { back = -1; }
	} break;
	default: {
	  pr = (itadmin_swman const *)r;
	  if(pl->sn) {
	    if(pr->sn) {
	      back = itadmin_comp_correct(dk3str_c8_cmp(pl->sn, pr->sn));
	    } else { back = 1; }
	  } else {
	    if(pr->sn) { back = -1; }
	  }
	} break;
      }
    } else { back = 1; }
  } else {
    if(r) { back = -1; }
  }
  return back;
}



int
itadmin_comp_swprod(void const *l, void const *r, int cr)
{
  itadmin_swprod const	*pl;
  itadmin_swprod const	*pr;
  int			 back	= 0;
  if(l) {
    if(r) {
      pl = (itadmin_swprod const *)l;
      switch(cr) {
        case 2: {
	  pr = (itadmin_swprod const *)r;
	  back = itadmin_comp_swman((void *)(pl->mn), (void *)(pr->mn), 2);
	  if(back == 0) {
	    if(pl->ln) {
	      if(pr->ln) {
	        back = itadmin_comp_correct(dk3str_c8_cmp(pl->ln, pr->ln));
	      } else { back = 1; }
	    } else {
	      if(pr->ln) { back = -1; }
	    }
	  }
	  if(back == 0) {
            if(pl->sn) {
	      if(pr->sn) {
	        back = itadmin_comp_correct(dk3str_c8_cmp(pl->sn, pr->sn));
	      } else { back = 1; }
	    } else {
	      if(pr->sn) { back = -1; }
	    }
	  }
	} break;
	case 1: {
	  if(pl->sn) {
	    back = itadmin_comp_correct(dk3str_c8_cmp(pl->sn, (char const *)r));
	  } else { back = -1; }
	} break;
	default: {
	  pr = (itadmin_swprod const *)r;
	  if(pl->sn) {
	    if(pr->sn) {
	      back = itadmin_comp_correct(dk3str_c8_cmp(pl->sn, pr->sn));
	    } else { back = 1; }
	  } else {
	    if(pr->sn) { back = -1; }
	  }
	} break;
      }
    } else { back = 1; }
  } else {
    if(r) { back = -1; }
  }
  return back;
}



int
itadmin_comp_lictype(void const *l, void const *r, int cr)
{
  itadmin_lictype const	*pl;
  itadmin_lictype const	*pr;
  int			 back	= 0;
  if(l) {
    if(r) {
      pl = (itadmin_lictype const *)l;
      switch(cr) {
        case 2: {
	  pr = (itadmin_lictype const *)r;
	  if(pl->ln) {
	    if(pr->ln) {
	      back = itadmin_comp_correct(dk3str_c8_cmp(pl->ln, pr->ln));
	    } else { back = 1; }
	  } else {
	    if(pr->ln) { back = -1; }
	  }
	  if(back == 0) {
	    if(pl->num > pr->num) {
	      back = 1;
	    } else {
	      if(pl->num < pr->num) {
	        back = -1;
	      }
	    }
	  }
	} break;
        case 1: {
	  if(pl->sn) {
	    back = itadmin_comp_correct(dk3str_c8_cmp(pl->sn, (char const *)r));
	  } else { back = -1; }
	} break;
	default: {
	  pr = (itadmin_lictype const *)r;
	  if(pl->sn) {
	    if(pr->sn) {
	      back = itadmin_comp_correct(dk3str_c8_cmp(pl->sn, pr->sn));
	    } else { back = 1; }
	  } else {
	    if(pr->sn) { back = -1; }
	  }
	} break;
      }
    } else { back = 1; }
  } else {
    if(r) { back = -1; }
  }
  return back;
}



int
itadmin_comp_license(void const *l, void const *r, int cr)
{
  itadmin_license const	*pl;
  itadmin_license const	*pr;
  unsigned long	const	*ulp;
  int			 back	= 0;
  if(l) {
    if(r) {
      pl = (itadmin_license const *)l;
      pr = (itadmin_license const *)r;
      ulp = (unsigned long const *)r;
      switch(cr) {
        case 2: {
	  back = itadmin_comp_swprod((void *)(pl->prod),(void *)(pr->prod),2);
	  if(back == 0) {
	    back = itadmin_comp_lictype((void const *)(pl->ltype), (void const *)(pr->ltype), 2);
	  }
	  if(back == 0) {
	    back = itadmin_comp_user((void const *)(pl->owner), (void const *)(pr->owner), 2);
	  }
	  if(back == 0) {
	    back = itadmin_comp_host((void const *)(pl->host), (void const *)(pr->host), 0);
	  }
	  if(back == 0) {
	    back = itadmin_comp_license(l, r, 0);
	  }
	} break;
	case 1: {
	  if(pl->pk > (*ulp)) {
	    back = 1;
	  } else {
	    if(pl->pk < (*ulp)) {
	      back = -1;
	    }
	  }
	} break;
	default: {
	  if(pl->pk > pr->pk) {
	    back = 1;
	  } else {
	    if(pl->pk < pr->pk) {
	      back = -1;
	    }
	  }
	} break;
      }
    } else { back = 1; }
  } else {
    if(r) { back = -1; }
  }
  return back;
}



int
itadmin_comp_dhcp_ginw(void const *l, void const *r, int cr)
{
  itadmin_dhcp_ginw const	*pl;
  itadmin_dhcp_ginw const	*pr;
  int				 back = 0;
  if(l) {
    if(r) {
      pl = (itadmin_dhcp_ginw const *)l;
      switch(cr) {
        case 1: {
	  if(pl->gr) {
	    if((pl->gr)->sn) {
	      back = dk3str_c8_cmp((pl->gr)->sn, (char const *)r);
	      back = itadmin_comp_correct(back);
	    } else back = -1;
	  } else back = -1;
	} break;
	default: {
	  pr = (itadmin_dhcp_ginw const *)r;
	  if(pl->gr) {
	    if(pr->gr) {
	      if((pl->gr)->sn) {
	        if((pr->gr)->sn) {
		  back = dk3str_c8_cmp((pl->gr)->sn, (pr->gr)->sn);
		  back = itadmin_comp_correct(back);
		} else back = 1;
	      } else {
	        if((pr->gr)->sn) back = -1;
	      }
	    } else back = 1;
	  } else {
	    if(pr->gr) back = -1;
	  }
	} break;
      }
    } else back = 1;
  } else {
    if(r) back = -1;
  }
  return back;
}



int
itadmin_comp_date(itadmin_date const *l, itadmin_date const *r)
{
  int		back = 0;
  if(l) {
    if(r) {
      if(l->y > r->y) back = 1;
      else {
        if(l->y < r->y) back = -1;
      }
      if(back == 0) {
        if(l->m > r->m) back = 1;
	else {
	  if(l->m < r->m) back = -1;
	}
      }
      if(back == 0) {
        if(l->d > r->d) back = 1;
	else {
	  if(l->d < r->d) back = -1;
	}
      }
    } else back = 1;
  } else {
    if(r) back = -1;
  }
  return back;
}



int
itadmin_comp_dhcp_option(void const *l, void const *r, int cr)
{
  itadmin_dhcp_option const	*pl;
  itadmin_dhcp_option const	*pr;
  int				 back = 0;
  if(l) {
    if(r) {
      pl = (itadmin_dhcp_option const *)l;
      pr = (itadmin_dhcp_option const *)r;
      if(pl->pk > pr->pk) {
        back = 1;
      } else {
        if(pl->pk < pr->pk) {
	  back = -1;
	}
      }
      if(back == 0) {
        if(pl->k) {
	  if(pr->k) {
	    back = dk3str_c8_cmp(pl->k, pr->k);
	    back = itadmin_comp_correct(back);
	  } else back = 1;
	} else {
	  if(pr->k) back = -1;
	}
      }
    } else back = 1;
  } else {
    if(r) back = -1;
  }
  return back;
}



int
itadmin_comp_string(void const *l, void const *r, int cr)
{
  int		back = 0;
  if(l) {
    if(r) {
      switch(cr) {
        case 1: {
	  back = itadmin_comp_correct(
	    dk3str_c8_casecmp((char const *)l, (char const *)r)
	  );
	} break;
	default: {
	  back = itadmin_comp_correct(
	    dk3str_c8_cmp((char const *)l, (char const *)r)
	  );
	} break;
      }
    } else back = 1;
  } else {
    if(r) back = -1;
  }
  return  back;
}

