/*
	WARNING: This file was generated by dkct.
	Changes you make here will be lost if dkct is run again!
	You should modify the original source and run dkct on it.
	Original source: htmlbook.ctr
*/

/*
Copyright (C) 2013-2014, Dirk Krause

Redistribution and use in source and binary forms, with or without
modification, are permitted provided that the following conditions are met:

* Redistributions of source code must retain the above copyright notice,
  this list of conditions and the following disclaimer.
* Redistributions in binary form must reproduce the above opyright notice,
  this list of conditions and the following disclaimer in the documentation
  and/or other materials provided with the distribution.
* Neither the name of the author nor the names of contributors may be used
  to endorse or promote products derived from this software without specific
  prior written permission.

THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS ``AS IS''
AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
ARE DISCLAIMED.
IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE LIABLE FOR ANY
DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
(INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
(INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
*/

/**	@file htmlbook.h Header file for the htmlbook module.
*/

#ifndef HTMLBOOK_H_INCLUDED
/** Avoid multiple inclusions. */
#define HTMLBOOK_H_INCLUDED 1


#line 10 "htmlbook.ctr"

#include "dk3conf.h"
#include "dk3types.h"
#include "dk3numco.h"



/**	Image dimension cache entry.
*/
typedef struct {
  dkChar		*fn;	/**< Image name. */
  unsigned long		 w;	/**< Image width. */
  unsigned long		 h;	/**< Image height. */
} hb_img_dim_t;



/**	External link.
*/
typedef struct {
  dkChar		*url;	/**< Link URL. */
  unsigned long		 lno;	/**< Link number within current page. */
} hb_link_t;



/**	One contents line.
*/
typedef struct {
  dkChar	*text;		/**< Allocated line text. */
  dkChar	*aname;		/**< The a name text (if any). */
  dkChar	*realtext;	/**< Real start of text for header. */
  unsigned long	 lineno;	/**< Line number. */
  unsigned long	 header;	/**< Running number of header. */
  unsigned	 headlevel;	/**< Header level (1 to 6). */
  int		 lt;		/**< Line type (0=normal, 1=header). */
} hb_line_t;



/**	One node in the document tree.
*/
struct hb__node_t {
  struct hb__node_t	*parent;	/**< Parent node. */
  struct hb__node_t	*curchild;	/**< Current child to edit. */
  struct hb__node_t	*jumpnode;	/**< Link target node. */
  dk3_sto_t		*s_subnodes;	/**< Subnodes collection. */
  dk3_sto_it_t		*i_subnodes;	/**< Subnodes iterator. */
  dk3_sto_t		*s_variables;	/**< Variables storage. */
  dk3_sto_it_t		*i_variables;	/**< Variables iterator. */
  dk3_sto_t		*s_lines;	/**< Contents lines storage. */
  dk3_sto_it_t		*i_lines;	/**< Contents lines iterator. */
  dk3_sto_t		*s_lbyurl;	/**< Storage for links by URL. */
  dk3_sto_it_t		*i_lbyurl;	/**< Iterator for links by URL. */
  dk3_sto_t		*s_lbylno;	/**< Storage for links by number. */
  dk3_sto_it_t		*i_lbylno;	/**< Iterator for links by number. */
  dk3_sto_t		*s_jsfiles;	/**< Storage for JS files. */
  dk3_sto_it_t		*i_jsfiles;	/**< Iterator for JS files. */
  dkChar		*title;		/**< Node title. */
  dkChar		*shorttitle;	/**< Short title (optional). */
  dkChar		*filename;	/**< Text file name (optional). */
  dkChar		*suffix;	/**< Output file name suffix (opt). */
  dkChar		*template;	/**< Template file name (optional). */
  dkChar		*stylefile;	/**< Style file. */
  dkChar		*author;	/**< Name of author. */
  dkChar		*location;	/**< Location (city) of author. */
  dkChar		*icontoc;	/**< File name TOC icon. */
  dkChar		*iconprev;	/**< File name previous section icon. */
  dkChar		*iconnext;	/**< File name next section icon. */
  dkChar		*iconindex;	/**< File name index icon. */
  dkChar		*favicon;	/**< favicon. */
  dkChar const		*outFileName;	/**< Output file name. */
  unsigned long		 lineno;	/**< Line number in project file. */
  unsigned long		 objno;		/**< Object index. */
  unsigned long		 pobjno;	/**< Printable object number. */
  unsigned long		 nextlink;	/**< Next link number. */
  unsigned long		 nextindex;	/**< Next index entry number. */
  unsigned long		 headno;	/**< Head number. */
  unsigned long		 nextsubheadno;	/**< Next head number for sub node. */
  unsigned long		 nextjs;	/**< Number of next js file. */
  long			 contnum;	/**< Context number. */
  unsigned		 options;	/**< Options for node. */
  int			 indent;	/**< Line indent (number of spaces). */
  int			 depth;		/**< Depth. */
  int			 tocstate;	/**< State when creating TOC. */
  int			 inenc;		/**< Text file input encoding. */
};

/**	One node in the document tree.
*/
typedef struct hb__node_t hb_node_t;



/**	Entry in keyword index.
*/
typedef struct {
  dkChar		*tx;	/**< Keyword index text. */
  dkChar		*fn;	/**< File name. */
  dkChar		*an;	/**< Anchor name (optional). */
  unsigned long		 ul;	/**< Anchor number (if no name available). */
  hb_node_t		*no;	/**< Node for file name (needed for title). */
} hb_index_entry_t;



/**	Job type for the htmlbook program.
	The s_nodes storage contains a plain list of all nodes,
	this storage is used to release all nodes at the end of the program.
	The s_pnodes storage contains a plain list of all nodes to
	write output for.
	The tree structure is below the rootnode element.
*/
typedef struct {
  dk3_tm_t		 starttime;	/**< Start time. */
  dk3_app_t		*app;		/**< Application structure. */
  dkChar const * const	*msg;		/**< Localized messages. */
  dkChar const * const	*kwnl;		/**< Keywords, not localized. */
  dk3_option_set_t	*opt;		/**< Command line options. */
  dk3_sto_t		*s_nodes;	/**< All nodes storage. */
  dk3_sto_it_t		*i_nodes;	/**< All nodes storage iterator. */
  dk3_sto_t		*s_pnodes;	/**< Leaf nodes storage. */
  dk3_sto_it_t		*i_pnodes;	/**< Leaf nodes storage iterator. */
  dk3_sto_t		*s_files;	/**< Additional files storage. */
  dk3_sto_it_t		*i_files;	/**< Additional files iterator. */
  dk3_sto_t		*s_index;	/**< Index entries storage. */
  dk3_sto_it_t		*i_index;	/**< Index entries storage iterator. */
  dk3_sto_t		*s_optsect;	/**< Optional sections storage. */
  dk3_sto_it_t		*i_optsect;	/**< Optional sections iterator. */
  dk3_sto_t		*s_imgdim;	/**< Image dimension cache storage. */
  dk3_sto_it_t		*i_imgdim;	/**< Image dimension cache iterator. */
  hb_node_t		*rootnode;	/**< Root node. */
  hb_node_t		*currentnode;	/**< Current node to modify. */
  hb_node_t		*impressumnode;	/**< Impressum node. */
  hb_node_t		*firstnode;	/**< First pnode. */
  hb_node_t		*lastnode;	/**< Last pnode. */
  dkChar const		*infilename;	/**< Input file name (project). */
  dkChar const		*outputdir;	/**< Output directory (allocated). */
  dkChar const		*outputscript;	/**< Name of script to produce. */
  dkChar const		*url;		/**< URL to publish the results. */
  dkChar const		*indexfile;	/**< Typically index html. */
  dkChar const		*impressumlink;	/**< Link to impressum. */
  dkChar const		*chmlang;	/**< Language setting for CHM. */
  dkChar		*shipbuffer;	/**< Shipout buffer. */
  dkChar		*iltemplate;	/**< Input line from template. */
  dkChar		*ilfile;	/**< Input line from file. */
  dkChar		*special;	/**< Buffer for current special. */
  dk3_c32_t		*buffer32;	/**< Buffer for 32-bit characters. */
  FILE			*of;		/**< Output file. */
  unsigned long		 lineno;	/**< Line number. */
  unsigned long		 nextobj;	/**< Next object number. */
  unsigned long		 npobjs;	/**< Number of printable objects. */
  size_t		 bs;		/**< Buffer size. */
  size_t		 spused;	/**< Number elements used in special. */
  size_t		 shipused;	/**< Shipout buffer used. */
  unsigned		 options;	/**< Job options. */
  int			 iecmd;		/**< Input encoding from cmd args. */
  int			 actsect;	/**< Flag: Active section. */
  int			 cmd;		/**< Option processing result. */
  int			 exv;		/**< Exit status code. */
  int			 cs;		/**< Character set for HTML output. */
  int			 secttype;	/**< Section type. */
  int			 non_url;	/**< Flag: Non-URL characters found. */
  int			 maxdepth;	/**< Maximum depth of a node. */
  int			 headlevels;	/**< Maximum depth to print header. */
  int			 coli;		/**< Current code line number. */
  int			 cols;		/**< Code line state. */
} hb_job_t;



/**	File processing help structure.
*/
typedef struct {
  hb_job_t		*job;		/**< Job structure. */
  hb_node_t		*p;		/**< Previous node. */
  hb_node_t		*n;		/**< Next node. */
  int			 in_template;	/**< Flag: Processing template. */
  int			 stm;		/**< State machine. */
} hb_file_processor_t;



/**	@defgroup	hboptions	Node options from project file. */
/**@{*/

/**	Write page TOC.
*/
#define	HB_NODE_OPT_PAGE_TOC			0x0001U

/**	Replace ampersand.
*/
#define	HB_NODE_OPT_REPLACE_AMPERSAND		0x0002U

/**	Use tidy while copying.
*/
#define	HB_NODE_OPT_USE_TIDY			0x0004U

/**	Write header chain.
*/
#define	HB_NODE_OPT_HEADER_CHAIN		0x0008U

/**	Indicate the impressum node.
*/
#define	HB_NODE_OPT_IMPRESSUM			0x0010U

/**	Stop inheritance of JS files at this node.
*/
#define	HB_NODE_OPT_STOP_JS_INHERITANCE		0x0020U

/**@}*/



/**	@defgroup	hbjoboptions	Job options. */
/**@{*/

/**	Create index file.
*/
#define	HB_JOB_OPT_CREATE_INDEX			0x0001U

/**	Create table of contents.
*/
#define	HB_JOB_OPT_CREATE_TOC			0x0002U

/**	Currently processing code.
*/
#define	HB_JOB_OPT_CODE				0x0004U

/**	Produce output for building a chm file.
*/
#define	HB_JOB_OPT_CHM				0x0008U

/**	Use ln instead of cp for resource files.
*/
#define	HB_JOB_OPT_LN				0x0010U

/**	Write section number in positions table.
*/
#define	HB_JOB_OPT_NUM_IN_POS			0x0020U

/**	Write section number in keyword index.
*/
#define	HB_JOB_OPT_NUM_IN_IDX			0x0040U

/**	Write section number in page header.
*/
#define	HB_JOB_OPT_NUM_IN_PAGE_HEADER		0x0080U

/**	Enable full text search in chm output.
*/
#define	HB_JOB_OPT_CHM_FULL_TEXT_SEARCH		0x0100U

/**	Print line numbers for code.
*/
#define	HB_JOB_OPT_CODE_LINE_NUMBERS		0x0200U

/**@}*/



/**	@defgroup	hbcharsets	Character sets used by htmlbook. */
/**@{*/

/**	Character set us-ascii.
*/
#define	HB_CS_ASCII				0

/**	Character set UTF-8.
*/
#define	HB_CS_UTF_8				1

/**@}*/



/**	@defgroup	hbsections	Section types. */
/**@{*/

/**	Section type not yet known.
*/
#define	HB_SECTION_UNKNOWN			0

/**	Options section.
*/
#define	HB_SECTION_OPTIONS			1

/**	Files section.
*/
#define	HB_SECTION_FILES			2

/**	Contents section.
*/
#define	HB_SECTION_CONTENTS			3

/**@}*/



/**	@defgroup	hbtocstate	Node state when creating TOC. */
/**@{*/

/**	Work on this node is not yet in progress.
*/
#define	HB_TOC_STATE_INIT			0
	
/**	Work on this node is in progress.
*/
#define	HB_TOC_STATE_IN_PROGRESS		1

/**	Work on this node is finished.
*/
#define	HB_TOC_STATE_FINISHED			2

/**@}*/



/**	@defgroup	hbcolist	Code line states. */
/**@{*/

/**	Directly after code special command.
*/
#define	HB_COLIST_NONE		0

/**	In a new line, no contents yet thus no opened code tag.
*/
#define	HB_COLIST_NOT_OPENED	1

/**	Code tag was opened and must be closed.
*/
#define	HB_COLIST_OPENED	2

/**@}*/



/**	Maximum line length.
*/
#define	HB_LINE_LENGTH		16383


#include "hbnode.h"
#include "hbconf.h"
#include "hbhtml.h"
#include "hbtool.h"
#include "hbcont.h"
#include "hbindex.h"
#include "hbimgdim.h"
#include "hbchm.h"
#include "dk3strkv.h"
#include "dk3kv.h"
#include "dk3se.h"




#endif
