/*
	WARNING: This file was generated by dkct.
	Changes you make here will be lost if dkct is run again!
	You should modify the original source and run dkct on it.
	Original source: htmlbook.ctr
*/

/*
Copyright (C) 2013-2014, Dirk Krause

Redistribution and use in source and binary forms, with or without
modification, are permitted provided that the following conditions are met:

* Redistributions of source code must retain the above copyright notice,
  this list of conditions and the following disclaimer.
* Redistributions in binary form must reproduce the above opyright notice,
  this list of conditions and the following disclaimer in the documentation
  and/or other materials provided with the distribution.
* Neither the name of the author nor the names of contributors may be used
  to endorse or promote products derived from this software without specific
  prior written permission.

THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS ``AS IS''
AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
ARE DISCLAIMED.
IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE LIABLE FOR ANY
DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
(INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
(INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
*/

/**	@file htmlbook.c The htmlbook module.
*/


#line 367 "htmlbook.ctr"

#include "dk3all.h"
#include "dkt-version.h"
#include "htmlbook.h"


/*	Synopsis:
	htmlbook -h | --help
	htmlbook -v | --version
	htmlbook -L | --license
	htmlbook [<options>] <project>

	Options:
*/




#line 384 "htmlbook.ctr"



/**	@defgroup	hbcmd	Commands for htmlbook. */
/**@{*/
/**	Print help.
*/
#define	HB_CMD_HELP		1
/**	Print version number.
*/
#define	HB_CMD_VERSION		2
/**	Print license terms.
*/
#define	HB_CMD_LICENSE		4
/**@}*/



/**	Version information.
*/
static dkChar const *hb_version[] = {
  dkT("htmlbook "),
  DKT_VERSION
};



/**	License conditions.
*/
static dkChar const * const hb_license[] = {
dkT(""),
dkT("Copyright (c) 2013, Dirk Krause"),
dkT("All rights reserved."),
dkT(""),
dkT("Redistribution and use in source and binary forms,"),
dkT("with or without modification, are permitted provided"),
dkT("that the following conditions are met:"),
dkT(""),
dkT("* Redistributions of source code must retain the above"),
dkT("  copyright notice, this list of conditions and the"),
dkT("  following disclaimer."),
dkT("* Redistributions in binary form must reproduce the above "),
dkT("  copyright notice, this list of conditions and the following"),
dkT("  disclaimer in the documentation and/or other materials"),
dkT("  provided with the distribution."),
dkT("* Neither the name of the copyright holder(s) nor the names of"),
dkT("  contributors may be used to endorse or promote"),
dkT("  products derived from this software without specific"),
dkT("  prior written permission."),
dkT(""),
dkT("THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS \"AS IS\""),
dkT("AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE"),
dkT("IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE"),
dkT("ARE DISCLAIMED."),
dkT("IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE LIABLE FOR ANY"),
dkT("DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES"),
dkT("(INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR"),
dkT("SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER"),
dkT("CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT,"),
dkT("STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN"),
dkT("ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE"),
dkT("POSSIBILITY OF SUCH DAMAGE."),
dkT(""),
NULL


#line 449 "htmlbook.ctr"
};



/**	Help text shown if help file is not found.
*/
static dkChar const * const	hb_help_text[] = {
dkT(""),
dkT("NAME"),
dkT(""),
dkT("htmlbook - Create HTML book structure"),
dkT(""),
dkT("SYNOPSIS"),
dkT(""),
dkT("  htmlbook [<option>] <file>"),
dkT("  htmlbook -h"),
dkT("  htmlbook -v"),
dkT("  htmlbook -L"),
dkT(""),
dkT("DESCRIPTION"),
dkT(""),
dkT("The program creates a HTML book structure in a specified output directory."),
dkT("Configuration is read from a project file read on th command line."),
dkT(""),
dkT("OPTIONS"),
dkT(""),
dkT("-i <encoding> | --input-encoding=<encoding>"),
dkT("\t\tspecify input encoding for project file to process."),
dkT(""),
dkT("-o name[,name...]"),
dkT("\t\tactivates optional project file sections."),
dkT(""),
dkT("-s name=value | --set=name=value"),
dkT("\t\tset variables (overwrite variables from options section)."),
dkT(""),
dkT("-h | --help"),
dkT("\t\tprint help text."),
dkT(""),
dkT("-v | --version"),
dkT("\t\tprint version information."),
dkT(""),
dkT("-L | --license"),
dkT("\t\tprint license terms."),
dkT(""),
dkT("RETURN VALUE"),
dkT(""),
dkT("The program returns exit status code 0 on success, any other value"),
dkT("indicates an error."),
dkT(""),
dkT("FILES"),
dkT(""),
dkT("The project file contains project settings and information about the"),
dkT("document structure (text files and used template files)."),
dkT(""),
dkT("Project file"),
dkT("------------"),
dkT("A project file consists of three sections: ``[options]'', ``[files]'', and"),
dkT("``[contents]''. A project file can contain optional sections"),
dkT("``[options:<name>]'', ``[files:<name>]'', and ``[contents:<name>]''. Optional"),
dkT("sections are only processed when activated by the -o command line option."),
dkT("On Windows systems optional sections named ``windows'' are activated"),
dkT("automatically, on non-Windows systems sections named ``non-windows'' are"),
dkT("activated automatically."),
dkT(""),
dkT("The options section contains ``key=value'' lines for the following keys:"),
dkT(""),
dkT("  output directory\t\tName of output directory. This directory is"),
dkT("  \t\t\t\tremoved completely and created again each"),
dkT("\t\t\t\ttime the output script is run."),
dkT(""),
dkT("  output script\t\t\tScript to re-create the output directory and"),
dkT("  \t\t\t\tcopy files into it."),
dkT(""),
dkT("  title\t\t\t\tDocument or collection title."),
dkT(""),
dkT("  url\t\t\t\tURL to access the document collection via web."),
dkT(""),
dkT("  index file\t\t\tName of file containing text for start page."),
dkT(""),
dkT("  html charset\t\t\tCharacter set for output HTML files"),
dkT("\t\t\t\t(``us-ascii'', ``ascii'', or ``utf-8'')."),
dkT(""),
dkT("  template\t\t\tName of default template file (``web.hbt'')."),
dkT(""),
dkT("  style\t\t\t\tName of default style file (``style.css'')."),
dkT(""),
dkT("  page toc\t\t\tFlag: Create an intra-page table of contents."),
dkT(""),
dkT("  create toc\t\t\tFlag: Create table of contents."),
dkT(""),
dkT("  create index\t\t\tFlag: Create keyword index."),
dkT(""),
dkT("  section numbers in index\tFlag: Write section numbers in index."),
dkT(""),
dkT("  replace ampersand\t\tFlag: Replace ampersand in texts (no)."),
dkT(""),
dkT("  tidy\t\t\t\tFlag: Use tidy for inspection and correction"),
dkT("\t\t\t\tof HTML output files."),
dkT(""),
dkT("  ln\t\t\t\tFlag: Use ln command instead of cp to save"),
dkT("\t\t\t\tdisk space."),
dkT(""),
dkT("  author\t\t\tAuthor name."),
dkT(""),
dkT("  location\t\t\tLocation of author."),
dkT(""),
dkT("  write position\t\tFlag: Write position within the collection at"),
dkT("  \t\t\t\tstart of page."),
dkT(""),
dkT("  section numbers in position\tFlag: Write section number in position."),
dkT(""),
dkT("  shortcut icon\t\t\tURL to shortcut icon."),
dkT(""),
dkT("  icon toc\t\t\tFile names for icons in navigation bar."),
dkT("  icon previous"),
dkT("  icon next"),
dkT("  icon index"),
dkT(""),
dkT("  impressum link\t\tURL to impressum."),
dkT(""),
dkT("  impressum page\t\tName of text file for impressum (you can use"),
dkT("\t\t\t\teither impressum link or impressum page)."),
dkT(""),
dkT("  chm\t\t\t\tFlag: Create HTML to produce a CHM file later."),
dkT(""),
dkT("  chm language\t\t\tLanguage setting for CHM project"),
dkT("  \t\t\t\t(``0x409 English (USA)'')."),
dkT(""),
dkT("  js file\t\t\tFile name of JavaScript file."),
dkT(""),
dkT("  inherit js\t\t\tFlag: Inherit JavaScript files from parents."),
dkT(""),
dkT("  var\t\t\t\tSet variable (the first text word on the"),
dkT("\t\t\t\tright side is the variable name, the"),
dkT("\t\t\t\tremainder of the line is the variable value)."),
dkT(""),
dkT("The ``[files]'' section lists the name of additional files to copy,"),
dkT("one per line."),
dkT(""),
dkT("The ``[contents]'' section contains the tree structure for navigation."),
dkT("Each subsection for a node is started by a title line."),
dkT("The indent level corresponds to the tree structure."),
dkT("Title lines with same indent level are neighbours (sub-nodes of the same"),
dkT("parent node). A nodes parent node is the next node above the node with"),
dkT("smaller indent."),
dkT("After the node title there are lines started by @ to configure the node:"),
dkT(""),
dkT("  file = <File>\t\t\tText file for the nodes contents."),
dkT("  input encoding = <Encoding>\tDefault encoding to use if no BOM is found."),
dkT("  suffix = <String>\t\tFile name suffix for output file."),
dkT("  short = <Short title>\t\tShort title for use in the navigation menu."),
dkT(""),
dkT("Additionally you can use the ``html charset'', ``template'', ``style'',"),
dkT("``page toc'', ``write position'', ``replace ampersand'', ``tidy'', ``ln'',"),
dkT("``author'', ``location'', ``js file'', ``inherit js'', ``var'',"),
dkT("``icon toc'', ``icon previous'', ``icon next'', ``icon index'', and"),
dkT("``shortcut icon'' settings as shown for the options section."),
dkT(""),
dkT("Leafs (nodes without further subnodes) must have a text file configured,"),
dkT("for other nodes it's optional."),
dkT(""),
dkT("Template file"),
dkT("-------------"),
dkT("The template file specifies the text between <BODY> and </BODY>."),
dkT("Special commands %%command%% can be used to insert the text, the navigation"),
dkT("menu, navigation blocks with clickable icons."),
dkT("The following special commands are available:"),
dkT(""),
dkT("  %%contents%%\t\t\tinserts the text file contents."),
dkT(""),
dkT("  %%title%%\t\t\tinserts the node title."),
dkT(""),
dkT("  %%img <options>%%\t\tinserts an image. The following options"),
dkT("  \t\t\t\tare available:"),
dkT("    div[=Bool]\t\t\tCreate <div> around <img>"),
dkT("    centered[=Bool]\t\tShow image centered, not left-aligned."),
dkT("    src=file\t\t\tFile name for image."),
dkT("    alt=``text''\t\tAlternative text for image."),
dkT("    title[=``text'']\t\tTitle text (alt= is used as default)."),
dkT("    caption[=``text'']\t\tImage caption."),
dkT("    longdesc=URL\t\tFile containing long description of image."),
dkT("    border=width\t\tBorder width."),
dkT("    height=height\t\tImage height."),
dkT("    width=width\t\t\tImage width."),
dkT("    svg=file\t\t\tSVG version of image."),
dkT("    svgwh[=Bool]\t\tApply PNG/JPEG dimensions to SVG object."),
dkT("    object[=Bool]\t\tCreate object for SVG."),
dkT("    pdf=file\t\t\tPDF version of image."),
dkT("    larger=file\t\t\tLarger version of image."),
dkT("    ismap[=bool]\t\tSet ismap attribute."),
dkT("    usemap=file\t\t\tImage map file."),
dkT("    name=name\t\t\tItem name."),
dkT("    id=name\t\t\tID for CSS styling."),
dkT("    class=name\t\t\tClass name for CSS styling."),
dkT("    align=name\t\t\tAlignment."),
dkT("    vspace=distance\t\tVertical space."),
dkT("    hspace=distance\t\tHorizontal space."),
dkT("    downloads[=Bool]\t\tProvide links to download vector graphics"),
dkT("    cache\t\t\tCache image dimensions for images used multiple"),
dkT("    \t\t\t\ttimes. Image dimensions for images used in"),
dkT("\t\t\t\ta template are cached automatically."),
dkT(""),
dkT("  %%menu <options>%%\t\tinserts the navigation menu."),
dkT("  \t\t\t\tThe following options are available:"),
dkT("    style=...\t\t\tOne from ``reverse'' (full menu in reverse"),
dkT("\t\t\t\torder), ``full'' (full menu), ``top'' (show"),
dkT("\t\t\t\tonly first hierarchy level) or ``current''"),
dkT("\t\t\t\t(show only current hierarchy level)."),
dkT("    sub[=bool]\t\t\tFlag: Show subnodes of current node."),
dkT(""),
dkT("  %%navigation <options>%%\tinserts a navigation block."),
dkT("  \t\t\t\tThe following options are available:"),
dkT("    itop=file\t\t\tIcon for table of contents (``toc.png'')."),
dkT("    iprev=file\t\t\tIcon for previous section (``prev.png'')."),
dkT("    inext=file\t\t\tIcon for next section (``next.png'')."),
dkT("    ikind=file\t\t\tIcon for keyword index (``index.png'')."),
dkT(""),
dkT("  %%author%%\t\t\tinserts the author name."),
dkT(""),
dkT("  %%location%%\t\t\tinserts the authors location."),
dkT(""),
dkT("  %%date <options>%%\t\tinserts the current node."),
dkT("  \t\t\t\tThe following options are available:"),
dkT("    style=name\t\t\tDate style, currently only ``german'' is"),
dkT("\t\t\t\tallowed to switch from the default"),
dkT("\t\t\t\t``yyyy-mm-dd'' to ``dd.mm.yyyy''."),
dkT(""),
dkT("  %%var <name> <options>%%\tinserts a variable value."),
dkT("  \t\t\t\tThe following options are available:"),
dkT("    url[=bool]\t\t\tFlag: Encode as URL, not as text."),
dkT(""),
dkT("  %%code <options>%%\t\tcontrols output encoding. By default the"),
dkT("  \t\t\t\t``<'', ``>'' are not replaced by ``&lt;'', and"),
dkT("\t\t\t\t``&gt;'' as we expect to get correct HTML "),
dkT("\t\t\t\tfrom the text files. Replacement of ``&''"),
dkT("\t\t\t\tby ``&amp;'' is controlled by the"),
dkT("\t\t\t\t``replace ampersand'' setting in the options"),
dkT("\t\t\t\tsection."),
dkT("\t\t\t\tIn code mode our text comes from a source"),
dkT("\t\t\t\tcode file, so we have to encode these"),
dkT("\t\t\t\tcharacters for HTML output."),
dkT("\t\t\t\tThe following options are available:"),
dkT("    enable[=bool]\t\tturns code mode on."),
dkT("    on[=bool]\t\t\tturns code mode on."),
dkT("    disable[=bool]\t\tturns code mode off."),
dkT("    off[=bool]\t\t\tturns code mode off."),
dkT("    toggle\t\t\ttoggles code mode."),
dkT(""),
dkT("  %%a <options>%%\t\tinserts a named anchor or a hyperlink."),
dkT("  \t\t\t\tThe following options are available:"),
dkT("    name=name\t\t\tAnchor name."),
dkT("    href=URL\t\t\tLink destination."),
dkT("    title=``text''\t\tText to show when mouse is over link."),
dkT("    text=``text''\t\tText for hyperlink."),
dkT("    target=destination\t\tDestination windows or frame, i.e. ``_blank''."),
dkT("    type=text\t\t\tMIME type."),
dkT("    external[=bool]\t\tOverride result of internal/external test."),
dkT("    id=text\t\t\tID for CSS styling."),
dkT("    class=text\t\t\tClass name for CSS styling."),
dkT("    style=text\t\t\tDirect style information."),
dkT("    hreflang=text\t\tLanguage for href text."),
dkT("    charset=text\t\tCharacter set."),
dkT("    onblur=text\t\t\tScript to execute when link looses focus."),
dkT("    onfocus=text\t\tScript to execute when link gets focus."),
dkT("    accesskey=text\t\tHotkey for link."),
dkT("    tabindex=number\t\tTabulator index."),
dkT("    shape=text\t\t\tLink shape form."),
dkT("    coords=text\t\t\tCoordinates."),
dkT("    rel=text\t\t\tInformation for link to next element."),
dkT("    rev=text\t\t\tInformation for link to previous element."),
dkT(""),
dkT("  %%menuentry <options>%%\tinserts code to visualize a menu entry."),
dkT("  \t\t\t\tThe following options are available:"),
dkT("    item=``text''\t\tText of the menu entry, can be used"),
dkT("    \t\t\t\tmultiple times for hierarchical menus."),
dkT(""),
dkT("  %%sourcefile <options>%%\tshows a file contents in a <PRE></PRE>"),
dkT("  \t\t\t\tenvironment and provides a download"),
dkT("\t\t\t\thyperlink. The following options are available:"),
dkT("    file=file\t\t\tFile name."),
dkT("    type=text\t\t\tMIME type."),
dkT("    title=``text''\t\tText shown when mouse is over hyperlink."),
dkT(""),
dkT("Text file"),
dkT("---------"),
dkT("Text files contain the page contents."),
dkT("You can use headings like"),
dkT("  .1\t@name@\tHeading text"),
dkT("for a structural document. Depths 1, 2, 3, 4, or 5 are converted to"),
dkT("<h2>...<h6> headers. A <h1> header is used for the page title."),
dkT("The @name@ specification is optional, it results in a named anchor"),
dkT("  <a name=\"name\"></a>"),
dkT("before the heading. If the name specification is omitted, an anchor name"),
dkT("is generated automatically."),
dkT(""),
dkT("Text files can use the special commands listed in ``Template file'', execpt"),
dkT("%%contents%%. Additionally the following special command can be used"),
dkT("in text files:"),
dkT(""),
dkT("  %%index <options>%%\t\tadds an entry to the keyword index."),
dkT("  \t\t\t\tThe following options can be used:"),
dkT("    text=``text''\t\tKeyword."),
dkT("    name=``text''\t\tName of a named anchor."),
dkT("    reference[=bool]\t\tFlag: Use existing named anchor, do not"),
dkT("    \t\t\t\tcreate an anchor."),
dkT("NOTES"),
dkT(""),
dkT("All text files, style files and images must be local files"),
dkT("in the current working directory."),
dkT(""),
dkT("AUTHOR"),
dkT(""),
dkT("Dipl.-Ing. Dirk krause"),
dkT(""),
dkT("HISTORY"),
dkT(""),
dkT("2013-11-30 work on program was started."),
dkT(""),
dkT("COPYRIGHT AND LICENSE"),
dkT(""),
dkT("Run"),
dkT("  htmlbook --license"),
dkT("to see the license conditions."),
dkT(""),
dkT("SEE ALSO"),
dkT(""),
dkT("tidy"),
dkT(""),
NULL


#line 779 "htmlbook.ctr"
};



/**	8-bit character keywords.
*/
static char const * const	hb_c8_kw[] = {
/* 0 */
"\n",

/* 1 */
" ",

/* 2 */
"RD /S /Q \"",

/* 3 */
"\"\n",

/* 4 */
"rm -fr '",

/* 5 */
"'\n",

/* 6 */
"MKDIR \"",

/* 7 */
"mkdir -p '",

/* 8 */
"IF NOT EXIST \"",

/* 9 */
"\" ECHO ERROR File does not exist: ",

/* 10 */
"IF EXIST \"",

/* 11 */
"\" XCOPY \"",

/* 12 */
"\" \"",

/* 13 */
"\\\" /Y /Q\n",

/* 14 */
"if [ -f '",

/* 15 */
"' ]\n",

/* 16 */
"then\n",

/* 17 */
"else\n",

/* 18 */
"fi\n",

/* 19 */
"ln '",

/* 20 */
"cp '",

/* 21 */
"' '",

/* 22 */
"echo 'ERROR: File ",

/* 23 */
" does not exist'\n",

/* 24 */
"tidy -q -utf8 < \"",

/* 25 */
"tidy -q -ascii < \"",

/* 26 */
"\" > \"",

/* 27 */
"tidy -q -utf8 < '",

/* 28 */
"tidy -q -ascii < '",

/* 29 */
"' > '",

/* 30 */
"/",

/* 31 */
"@ECHO OFF\n",

/* 32 */
"#! /bin/sh\n",

/* 33 */
"EXITCODE=0\n",

/* 34 */
"exit $EXITCODE\n",

/* 35 */
"EXITCODE=1\n",

/* 36 */
"ECHO TIDY ",

/* 37 */
"echo TIDY ",

/* 38 */
"\" DEL /Q \"",

/* 39 */
"\"\n",

/* 40 */
"find '",

/* 41 */
"' -type d -exec chmod ugo+rx {} \\;\n",

/* 42 */
"' -type f -exec chmod ugo+r  {} \\;\n",

NULL


#line 882 "htmlbook.ctr"
};



/**	Fixed keywords (not localized).
*/
static dkChar const * const	hb_kwnl[] = {
/* 0 */
dkT("dkt-3"),

/* 1 */
dkT("htmlbook.str"),

/* 2 */
dkT("htmlbook.txt"),

/* 3 */
dkT("htmlbook.conf"),

/* 4 */
dkT("toc.png"),

/* 5 */
dkT("prev.png"),

/* 6 */
dkT("next.png"),

/* 7 */
dkT("index.png"),

/* 8 */
dkT("index.html"),

/* 9 */
dkT("."),

/* 10 */
dkT("html"),

/* 11 */
dkT("german"),

/* 12 */
dkT("url"),

/* 13 */
dkT("#hb_index"),

/* 14 */
dkT("toc.png"),

/* 15 */
dkT("prev.png"),

/* 16 */
dkT("next.png"),

/* 17 */
dkT("index.png"),

/* 18 */
dkT("windows"),

/* 19 */
dkT("non-windows"),

/* 20 */
dkT("http://"),

/* 21 */
dkT("ftp://"),

/* 22 */
dkT("w"),

/* 23 */
dkT("html"),

/* 24 */
dkT("htm"),

/* 25 */
dkT("none"),

/* 26 */
dkT("project.hhp"),

/* 27 */
dkT("index.chm"),

/* 28 */
dkT("contents.hhc"),

/* 29 */
dkT("index.hhk"),

/* 30 */
dkT("wb"),

/* 31 */
dkT("#hb_toc"),

/* 32 */
dkT("set"),

/* 33 */
dkT("SVG"),

/* 34 */
dkT("PDF"),

/* 35 */
dkT(" "),

/* 36 */
dkT("project.xml"),

NULL


#line 1021 "htmlbook.ctr"
};



/**	Default message texts.
*/
static dkChar const * const	hb_kw[] = {
/* 0 */
dkT("Impressum"),

/* 1 */
dkT("Go to start page: "),

/* 2 */
dkT("At start page."),

/* 3 */
dkT("Go to previous page: "),

/* 4 */
dkT("At first page."),

/* 5 */
dkT("Go to next page: "),

/* 6 */
dkT("At last page."),

/* 7 */
dkT("Go to keyword index."),

/* 8 */
dkT("Syntax error, missing \"=\"!"),

/* 9 */
dkT("Syntax error, empty value!"),

/* 10 */
dkT("Syntax error, setting only allowed in options section!"),

/* 11 */
dkT("Syntax error, illegal character set!\nOnly \"ascii\" or \"utf-8\" allowed."),

/* 12 */
dkT("Syntax error, no path specification in file name allowed!"),

/* 13 */
dkT("Missing project file name!"),

/* 14 */
dkT("Too many project file specified, just one allowed!"),

/* 15 */
dkT("No parent candidate found (probably a bug)!"),

/* 16 */
dkT("Syntax error, missing section name!"),

/* 17 */
dkT("Syntax error, missing closing square bracket!"),

/* 18 */
dkT("Syntax error, illegal section name!"),

/* 19 */
dkT("No template for node!"),

/* 20 */
dkT("Failed to obtain file name (probably a bug)!"),

/* 21 */
dkT("String \""),

/* 22 */
dkT("\" contains characters not usable in an URL!"),

/* 23 */
dkT("External links"),

/* 24 */
dkT("No source file specified!"),

/* 25 */
dkT("Syntax error, illegal menu style: \""),

/* 26 */
dkT("\"!"),

/* 27 */
dkT("Syntax error, illegal key (attribute name): \""),

/* 28 */
dkT("Syntax error, \"%%contents%%\" is only allowed in templates!"),

/* 29 */
dkT("Syntax error, illegal special command: \""),

/* 30 */
dkT("Syntax error, parsing special command failed near:\n\""),

/* 31 */
dkT("Line too long:\n\""),

/* 32 */
dkT("Syntax error, missing header text!"),

/* 33 */
dkT("Syntax error, missing closing ``@''!"),

/* 34 */
dkT("Syntax error, missing text after ``@''!"),

/* 35 */
dkT("Syntax error, missing header level!"),

/* 36 */
dkT("Syntax error, no text after leading ``.'' in line!"),

/* 37 */
dkT("Header level corrected to allowed maximum 6!"),

/* 38 */
dkT("Syntax error, ''url'' can be set in options section only!"),

/* 39 */
dkT("Failed to process a special command!"),

/* 40 */
dkT("Syntax error, parsing special command arguments failed!"),

/* 41 */
dkT("Syntax error, too many items for menu entry!"),

/* 42 */
dkT("Syntax error, no items for menu entry!"),

/* 43 */
dkT("Syntax error, illegal configuration key: \""),

/* 44 */
dkT("\"!"),

/* 45 */
dkT("Table of contents"),

/* 46 */
dkT("Keyword index"),

/* 47 */
dkT("No default topic found!"),

/* 48 */
dkT("Missing ``text'' attribute!"),

/* 49 */
dkT("Missing ``file'' attribute!"),

/* 50 */
dkT("The ``index'' special command can not be used in template!"),

/* 51 */
dkT("No destination file for link found!"),

/* 52 */
dkT("No text node for title:\n\""),

/* 53 */
dkT("\"!"),

/* 54 */
dkT("Current position"),

/* 55 */
dkT("Page table of contents"),

/* 56 */
dkT("External links"),

/* 57 */
dkT("Table of contents"),

/* 58 */
dkT("Large"),

/* 59 */
dkT("Image"),

/* 60 */
dkT("Menu entry"),

/* 61 */
dkT("Impressum"),

/* 62 */
dkT("Unfinished ``%%'' command!"),

/* 63 */
dkT("Not a backslash escape sequence: ``"),

/* 64 */
dkT("''!"),

/* 65 */
dkT("Image"),

/* 66 */
dkT("Overwriting ``div'' option by ``table''!"),

/* 67 */
dkT("No output directory configured!"),

/* 68 */
dkT("No output script configured"),

/* 69 */
dkT("Overwriting previous setting for ``author''!"),

/* 70 */
dkT("Overwriting previous setting for ``title''!"),

/* 71 */
dkT("Overwriting previous setting for ``output directory''!"),

/* 72 */
dkT("Overwriting previous setting for ``output script''!"),

/* 73 */
dkT("Overwriting previous setting for ``template''!"),

/* 74 */
dkT("Overwriting previous setting for ``style''!"),

/* 75 */
dkT("Overwriting previous setting for ``short''!"),

/* 76 */
dkT("Overwriting previous setting for ``file''!"),

/* 77 */
dkT("Overwriting previous setting for ``suffix''!"),

/* 78 */
dkT("Overwriting previous setting for ``icon toc''!"),

/* 79 */
dkT("Overwriting previous setting for ``icon previous''!"),

/* 80 */
dkT("Overwriting previous setting for ``icon next''!"),

/* 81 */
dkT("Overwriting previous setting for ``icon index''!"),

/* 82 */
dkT("Overwriting previous setting for ``shortcut icon''!"),

/* 83 */
dkT("Overwriting previous setting for ``var''!"),

/* 84 */
dkT("File not found: \""),

/* 85 */
dkT("\"!"),

/* 86 */
dkT("Overwriting previous setting for ``file''!"),

/* 87 */
dkT("Start page"),

/* 88 */
dkT("Too many text lines, max. 999 allowed!"),

NULL


#line 1311 "htmlbook.ctr"
};



/**	Section names in project files.
*/
static dkChar const * const	hb_section_names[] = {
/* 0 */
dkT("options"),

/* 1 */
dkT("files"),

/* 2 */
dkT("contents"),

NULL


#line 1323 "htmlbook.ctr"
};



/**	Accepted program options.
*/
static dk3_option_t const hb_options[] = {
  { dkT('h'), dkT("help"), 0 },
  { dkT('v'), dkT("version"), 0 },
  { dkT('L'), dkT("license"), 0 },
  { dkT('o'), dkT("optional-sections"), 1 },
  { dkT('i'), dkT("input-encoding"), 1 }
};

/**	Number of elements in the hb_options array.
*/
static size_t const hb_sz_options = sizeof(hb_options)/sizeof(dk3_option_t);



/**	Initialize job structure.
	@param	job	Job structure to initialize.
	@param	app	Application structure.
	@param	msg	Localized keywords.
	@param	kwnl	Keywords not localized.
*/
static
void
hb_job_init(
  hb_job_t		*job,
  dk3_app_t		*app,
  dkChar const * const	*msg,
  dkChar const * const	*kwnl
)
{
  

#line 1359 "htmlbook.ctr"
  job->app = app;
  job->msg = msg;
  job->kwnl = kwnl;
  job->opt = NULL;
  job->s_nodes = NULL;
  job->i_nodes = NULL;
  job->s_pnodes = NULL;
  job->i_pnodes = NULL;
  job->s_files = NULL;
  job->i_files = NULL;
  job->s_index = NULL;
  job->i_index = NULL;
  job->s_optsect = NULL;
  job->i_optsect = NULL;
  job->s_imgdim = NULL;
  job->i_imgdim = NULL;
  job->rootnode = NULL;
  job->currentnode = NULL;
  job->impressumnode = NULL;
  job->firstnode = NULL;
  job->lastnode = NULL;
  job->infilename = NULL;
  job->outputdir = NULL;
  job->outputscript = NULL;
  job->url = NULL;
  job->indexfile = NULL;
  job->impressumlink = NULL;
  job->chmlang = NULL;
  job->shipbuffer = NULL;
  job->iltemplate = NULL;
  job->ilfile = NULL;
  job->special = NULL;
  job->buffer32 = NULL;
  job->of = NULL;
  job->lineno = 0UL;
  job->nextobj = 0UL;
  job->npobjs = 0UL;
  job->spused = 0;
  job->shipused = 0;
  job->options =  HB_JOB_OPT_CREATE_TOC;
  job->options |= HB_JOB_OPT_NUM_IN_POS;
  job->options |= HB_JOB_OPT_NUM_IN_IDX;
  job->options |= HB_JOB_OPT_NUM_IN_PAGE_HEADER;
  job->options |= HB_JOB_OPT_CODE_LINE_NUMBERS;
  job->actsect = 1;
  job->iecmd = -1;	/* No input encoding specified */
  job->bs = 0;
  job->cmd = 0;
  job->exv = 1;			

#line 1408 "htmlbook.ctr"
  job->cs = HB_CS_ASCII;
  job->secttype = HB_SECTION_UNKNOWN;
  job->non_url = 0;
  job->maxdepth = 0;
  job->coli = 0;
  job->cols = HB_COLIST_NONE;
#if DK3_SIZEOF_INT > 2
#if Dk3_SIZEOF_INT > 4
  job->headlevels = 9223372036854775807;
#else
  job->headlevels = 2147483647;
#endif
#else
  job->headlevels = 32767;
#endif
  

#line 1424 "htmlbook.ctr"
}



/**	Clean up job structure at end of program.
	@param	job	Job structure to clean up.
*/
static
void
hb_job_end(hb_job_t *job)
{
  hb_img_dim_t		*idptr;	/* Current image dimension cache entry */
  hb_index_entry_t	*ie;	/* Current index entry */
  hb_node_t		*cn;	/* Current node */
  dkChar		*cfn;	/* Current file name */
  

#line 1440 "htmlbook.ctr"
  /*	Release options.
  */
  if(job->opt) {
    dk3opt_close(job->opt); job->opt = NULL;
  }

  /*	The s_nodes component contains a list of all nodes.
  	We traverse this container to release all nodes.
  */
  if(job->s_nodes) {
    if(job->i_nodes) {
      dk3sto_it_reset(job->i_nodes);
      while(NULL != (cn = (hb_node_t *)dk3sto_it_next(job->i_nodes))) {
	hb_node_delete(cn);
      }
      dk3sto_it_close(job->i_nodes); job->i_nodes = NULL;
    }
    dk3sto_close(job->s_nodes); job->s_nodes = NULL;
  }

  if(job->s_imgdim) {
    if(job->i_imgdim) {
      dk3sto_it_reset(job->i_imgdim);
      while(NULL != (idptr = (hb_img_dim_t *)dk3sto_it_next(job->i_imgdim))) {
        hbimgdim_delete(idptr);
      }
      dk3sto_it_close(job->i_imgdim);
    }
    dk3sto_close(job->s_imgdim);
  } job->s_imgdim = NULL; job->i_imgdim = NULL;

  if(job->s_optsect) {
    if(job->i_optsect) {
      dk3sto_it_reset(job->i_optsect);
      while(NULL != (cfn = (dkChar *)dk3sto_it_next(job->i_optsect))) {
        

#line 1476 "htmlbook.ctr"
        dk3_release(cfn);
      }
      dk3sto_it_close(job->i_optsect);
    }
    dk3sto_close(job->s_optsect);
  }
  job->s_optsect = NULL; job->i_optsect = NULL;

  if(job->s_index) {
    if(job->i_index) {
      dk3sto_it_reset(job->i_index);
      while(NULL != (ie = (hb_index_entry_t *)dk3sto_it_next(job->i_index))) {
        hbindex_delete(ie);
      }
      dk3sto_it_close(job->i_index);
    }
    dk3sto_close(job->s_index);
  }
  job->s_index = NULL; job->i_index = NULL;

  /*	We must free the list of additional files.
  */
  if(job->s_files) {
    if(job->i_files) {
      dk3sto_it_reset(job->i_files);
      while(NULL != (cfn = (dkChar *)dk3sto_it_next(job->i_files))) {
        

#line 1503 "htmlbook.ctr"
        dk3_release(cfn);
      }
      dk3sto_it_close(job->i_files); job->i_files = NULL;
    }
    dk3sto_close(job->s_files); job->s_files = NULL;
  }

  /*	The s_pnodes component contains a list of the leaf nodes
  	only (nodes to produce output for).
	We already traversed s_nodes to release all the nodes, so
	we can simply close s_pnodes and i_pnodes here.
  */
  if(job->s_pnodes) {
    if(job->i_pnodes) {
      dk3sto_it_close(job->i_pnodes);
    }
    dk3sto_close(job->s_pnodes); job->s_pnodes = NULL;
  }

  /*	Release components allocated dynamically.
  */
  dk3_release(job->outputdir);
  dk3_release(job->outputscript);
  dk3_release(job->url);
  dk3_release(job->impressumlink);
  dk3_release(job->chmlang);
  dk3_release(job->indexfile);
  dk3_release(job->shipbuffer);
  dk3_release(job->iltemplate);
  dk3_release(job->ilfile);
  dk3_release(job->special);
  dk3_release(job->buffer32);

  job->impressumnode = NULL;
  

#line 1538 "htmlbook.ctr"
}



/**	Save names of optional sections to process.
	@param	job		Job structure.
	@param	sections	Section names.
	@return	1 on success, 0 on errors.
*/
static
int
hb_save_optional_sections(hb_job_t *job, dkChar const *sections)
{
  dkChar	 bu[1024];	/* Private copy of sections */
  dkChar	*p1;		/* Current section name */
  dkChar	*p2;		/* Next section name */
  dkChar	*p3;		/* Copy of current section for storage */
  int		 back = 0;	/* Result */
  

#line 1557 "htmlbook.ctr"
  if((job) && (sections)) {
    if(dk3str_len(sections) < DK3_SIZEOF(bu,dkChar)) {
      dk3str_cpy(bu, sections);
      back = 1;		

#line 1561 "htmlbook.ctr"
      p1 = dk3str_start(bu, NULL);
      while(p1) {
        p2 = dk3str_chr(p1, dkT(','));
        if(p2) {
          *(p2++) = dkT('\0');
	  p2 = dk3str_start(p2, NULL);
        }
        dk3str_chomp(p1, NULL);
        

#line 1570 "htmlbook.ctr"
        p3 = dk3str_dup_app(p1, job->app);
        if(p3) {
          if(!dk3sto_add(job->s_optsect, p3)) {
	    dk3_release(p3);
	    back = 0;	/* REPORTED */	

#line 1575 "htmlbook.ctr"
	  }
        } else {
          back = 0;	/* REPORTED */	

#line 1578 "htmlbook.ctr"
        }
        p1 = p2;
      }
    } else {
      dk3app_log_i3(job->app, DK3_LL_ERROR, 135, 136, sections);
    }
  } 

#line 1585 "htmlbook.ctr"
  return back;
}



/**	Process command line options.
	@param	job	Job structure.
	@return	1 on success, 0 on error.
*/
static
int
hb_process_options(hb_job_t *job)
{
  dkChar const	*optarg;	/* Option argument */
  int		 back = 0;
  job->opt = dk3opt_open_from_app(
    hb_options, hb_sz_options, dkT('s'), hb_kwnl[32], job->app
  );
  if(job->opt) {
    if(0 == dk3opt_get_error_code(job->opt)) {
      back = 1;
      if(dk3opt_is_set(job->opt, dkT('h'))) {
        job->cmd |= HB_CMD_HELP;
      }
      if(dk3opt_is_set(job->opt, dkT('v'))) {
        job->cmd |= HB_CMD_VERSION;
      }
      if(dk3opt_is_set(job->opt, dkT('L'))) {
        job->cmd |= HB_CMD_LICENSE;
      }
      if(0 == (job->cmd)) {
        if(dk3opt_is_set(job->opt, dkT('i'))) {
	  optarg = dk3opt_get_short_arg(job->opt, dkT('i'));
	  if(optarg) {
	    job->iecmd = dk3enc_get_text_encoding_app(optarg, job->app);
	    if(0 > job->iecmd) { job->iecmd = -1; }
	  }
	}
        if(1 > dk3opt_get_num_args(job->opt)) {	

#line 1624 "htmlbook.ctr"
	  /* ERROR: No project file specified! */
	  dk3app_log_1(job->app, DK3_LL_ERROR, job->msg, 13);
	  back = 0;
	} else {
	  if(1 < dk3opt_get_num_args(job->opt)) {	

#line 1629 "htmlbook.ctr"
	    /* WARNING: Too many project files, using just one! */
	    dk3app_log_1(job->app, DK3_LL_WARNING, job->msg, 14);
	  }
	}
      }
    }
  }
  return back;
}



/**	Print help text, version information or license terms.
	@param	job	Job structure.
*/
static
void
hb_help_version_license(hb_job_t *job)
{
  dkChar const * const	*ptr;	/* Current line to print */
  

#line 1650 "htmlbook.ctr"
  /* Show version
  */
  dk3sf_initialize_stdout();
  dk3sf_fputs(hb_version[0], stdout);
  dk3sf_fputs(hb_version[1], stdout);
  dk3sf_fputc(dkT('\n'), stdout);

  if(HB_CMD_LICENSE & (job->cmd)) {
    /* Show license
    */
    ptr = hb_license;
    while(*ptr) {
      dk3sf_fputs(*(ptr++), stdout); dk3sf_fputc(dkT('\n'), stdout);
    }
  }
  if(HB_CMD_HELP & (job->cmd)) {
    /* Show help
    */
    dk3app_help(job->app, hb_kwnl[2], hb_help_text);
  }
  job->exv = 0;			

#line 1671 "htmlbook.ctr"
  

#line 1672 "htmlbook.ctr"
}



/**	Compare two file names.
	@param	l	Left pointer.
	@param	r	Right pointer.
	@param	cr	Comparison criteria (ignored).
	@return	Comparison result.
*/
static
int
hb_file_name_compare(void const *l, void const *r, int cr)
{
  int			 back	= 0;
  

#line 1688 "htmlbook.ctr"
  if(l) {
    if(r) {
      back = dk3str_fncmp((dkChar const *)l, (dkChar const *)r);
      if(-1 > back) { back = -1; }
      if( 1 < back) { back =  1; }
    } else {
      back = 1;
    }
  } else {
    if(r) {
      back = -1;
    }
  } 

#line 1701 "htmlbook.ctr"
  return back;
}


 
/**	Compare two strings.
	@param	l	Left string.
	@param	r	Right string.
	@param	cr	Comparison criteria (ignored).
	@return	Comparison result.
*/
static
int
hb_compare_strings(void const *l, void const *r, int cr)
{
  int		 back = 0;
  

#line 1718 "htmlbook.ctr"
  if(l) {
    if(r) {
      back = dk3str_cmp((dkChar const *)l, (dkChar const *)r);
      if(-1 > back) { back = -1; }
      if( 1 < back) { back =  1; }
    } else back = 1;
  } else {
    if(r) back = -1;
  } 

#line 1727 "htmlbook.ctr"
  return back;
}



/**	Allocate memory for job structure.
	@param	job	Job structure to initialize.
	@return	1 on success, 0 on error.
*/
static
int
hb_job_allocate(hb_job_t *job)
{
  int			 back = 0;
  

#line 1742 "htmlbook.ctr"
  job->s_nodes = dk3sto_open_app(job->app);
  if(job->s_nodes) {
    dk3sto_set_comp(job->s_nodes, hb_node_compare, 0);
    job->i_nodes = dk3sto_it_open(job->s_nodes);
    if(job->i_nodes) {
      job->s_pnodes = dk3sto_open_app(job->app);
      if(job->s_pnodes) {
        dk3sto_set_comp(job->s_pnodes, hb_node_compare, 0);
	job->i_pnodes = dk3sto_it_open(job->s_pnodes);
	if(job->i_pnodes) {
	  job->rootnode = hb_node_new(job, NULL, 0UL, 0UL, -1);
	  job->nextobj += 1UL;
	  if(job->rootnode) {
	    (job->rootnode)->depth = 0;
	    if(dk3sto_add(job->s_nodes, job->rootnode)) {
	      job->currentnode = job->rootnode;
	      job->shipbuffer = dk3_new_app(dkChar,HB_LINE_LENGTH,job->app);
	      job->iltemplate = dk3_new_app(dkChar,HB_LINE_LENGTH,job->app);
	      job->ilfile = dk3_new_app(dkChar,HB_LINE_LENGTH,job->app);
	      job->special = dk3_new_app(dkChar,HB_LINE_LENGTH,job->app);
	      job->buffer32 = dk3_new_app(dk3_c32_t,HB_LINE_LENGTH,job->app);
	      job->bs = HB_LINE_LENGTH;
	      job->spused = 0;
	      if(job->iltemplate) {
	        if(job->ilfile) {
		  if(job->special) {
		    if(job->buffer32) {
		      if(job->shipbuffer) {
		        job->s_files = dk3sto_open_app(job->app);
		        if(job->s_files) {
		          dk3sto_set_comp(job->s_files,hb_file_name_compare,0);
		          job->i_files = dk3sto_it_open(job->s_files);
			  if(job->i_files) {
			    if(dk3sto_add(job->s_pnodes, job->rootnode)) {
			      back = 1;
			    }
		          }
		        }
		      }
		    }
		  }
		}
	      }
	    } else {
	      hb_node_delete(job->rootnode);
	      job->rootnode = NULL;
	    }
	  }
	}
      }
    }
  }
  if(back) {
    back = 0;
    job->s_index = dk3sto_open_app(job->app);
    if(job->s_index) {
      dk3sto_set_comp(job->s_index, hbindex_compare, 0);
      job->i_index = dk3sto_it_open(job->s_index);
      if(job->i_index) {
        job->s_optsect = dk3sto_open_app(job->app);
	if(job->s_optsect) {
	  dk3sto_set_comp(job->s_optsect, hb_compare_strings, 0);
	  job->i_optsect = dk3sto_it_open(job->s_optsect);
	  if(job->i_optsect) {
	    job->s_imgdim = dk3sto_open_app(job->app);
	    if(job->s_imgdim) {
	      dk3sto_set_comp(job->s_imgdim, hbimgdim_compare, 0);
	      job->i_imgdim = dk3sto_it_open(job->s_imgdim);
	      if(job->i_imgdim) {
	        back = 1;
	      }
	    }
	  }
	}
      }
    }
  } 

#line 1819 "htmlbook.ctr"
  return back;
}



#if 0
/**	Add one file to file list.
	@param	job	Job structure.
	@param	il	Input line to process, contains file name.
	@return	1 on success, -1 on error.
*/
static
int
hb_add_file_to_file_list(hb_job_t *job, dkChar *il)
{
#if VERSION_BEFORE_20131207
  dkChar	*p1;		/* Start of line */
  dkChar	*p2;		/* Allocated memory */
  int		 back = 1;
  p1 = dk3str_start(il, NULL);
  if(p1) {
    dk3str_chomp(p1, NULL);
    if(!(dk3sto_it_find_like(job->i_files, (void const *)il, 0))) {
      p2 = dk3str_dup_app(il,job->app);
      if(p2) {
        if(!(dk3sto_add(job->s_files, (void *)p2))) {
	  back = -1;
	  dk3_release(p2);
	}
      } else {
        back = -1;
      }
    }
  }
  return back;
#else
  return(hbtool_add_file(job,il));
#endif
}
#endif



/**	Find indent level.
	@param	il	Input line to process.
	@return	Number of leading spaces.
*/
static
int
hb_find_indent(dkChar *il)
{
  dkChar	*p1;		/* Traverse text line */
  int		 back = 0;
  

#line 1873 "htmlbook.ctr"
  p1 = il;
  while((dkT(' ') == *p1) || (dkT('\t') == *p1)) {
    back++;
    if(dkT('\t') == *p1) {
      while(back % 8) { back++; }
    }
    p1++;
  } 

#line 1881 "htmlbook.ctr"
  return back;
}



/**	Find parent candidate for new node.
	@param	current	Current node to edit.
	@param	indent	Indent of new node.
	@return	Pointer to node on success, NULL on error.
*/
static
hb_node_t *
hb_parent_candidate(hb_node_t *current, int indent)
{
  hb_node_t		*back	= NULL;
  hb_node_t		*ca;			/* Candidate node */
  int			 cc;			/* Flag: Can continue */
  

#line 1899 "htmlbook.ctr"
  ca = current;
  cc = 1;
  while(cc) {
    if(ca) {
      if((ca->indent) < indent) {
        back = ca;
	cc = 0;
      } else {
        ca = ca->parent;
      }
    } else {
      cc = 0;
    }
  } 

#line 1913 "htmlbook.ctr"
  return back;
}



/**	Process a line from the contents section.
	@param	job	Job structure.
	@param	il	Input line.
	@return	1 on success, -1 on error.
*/
static
int
hb_add_contents(hb_job_t *job, dkChar *il)
{
  hb_node_t	*pa;		/* Parent node for new node */
  hb_node_t	*nn;		/* New node */
  dkChar	*p1;		/* Start of text line */
  int		 indent;	/* Indent level */
  int		 back = 1;
  

#line 1933 "htmlbook.ctr"
  p1 = dk3str_start(il, NULL);
  if(p1) {
    if(dkT('@') == *p1) {
      p1++;
      back = hbconf_process_line(job, p1, HB_SECTION_CONTENTS);
    } else {
      /* Create new node. */
      indent = hb_find_indent(il);
      pa = hb_parent_candidate(job->currentnode, indent);
      if(pa) {
        nn = hb_node_new(job, pa, job->lineno, job->nextobj, indent);
	job->nextobj += 1UL;
	if(nn) {
	  if(nn->depth > job->maxdepth) { job->maxdepth = nn->depth; }
	  if(dk3sto_add(job->s_nodes, (void *)nn)) {
	    if(dk3sto_add(pa->s_subnodes, (void *)nn)) {
	      job->currentnode = nn;
	      nn->title = dk3str_dup_app(p1,job->app);
	      if(!(nn->title)) {
	        back = -1;	/* REPORTED */
	      }
	    } else {
	      back = -1;	/* REPORTED */
	    }
	  } else {
	    back = -1;		/* REPORTED */
	    hb_node_delete(nn);
	  }
	} else {
	  back = -1;		/* REPORTED */
	}
      } else {
        back = -1;
	/* ERROR: No parent candidate found! */
	dk3app_log_1(job->app, DK3_LL_WARNING, job->msg, 15);
      }
    }
  } 

#line 1971 "htmlbook.ctr"
  return back;
}



/**	Process one line from project file.
	@param	job	Job structure.
	@param	il	Input line to process.
	@return	1 on success, 0 on minor errors, -1 on fatal errors.
*/
static
int
hb_process_line(hb_job_t *job, dkChar *il)
{
  dkChar	*p1;				/* Start of line */
  dkChar	*p2;				/* Next pointer */
  int		 back	= 1;			/* Result */
  int		 newst	= HB_SECTION_UNKNOWN;	/* New section type */
  

#line 1990 "htmlbook.ctr"
  job->lineno += 1UL;
  p1 = dk3str_start(il, NULL);
  if(p1) {
    dk3str_chomp(p1,NULL);
    if(dkT('#') != *p1) {
      if(dkT('[') == *p1) {
        job->actsect = 1;
        job->secttype = HB_SECTION_UNKNOWN;
	p1++;
	p1 = dk3str_start(p1, NULL);
	if(p1) {
	  p2 = dk3str_chr(p1, dkT(']'));
	  if(p2) {
	    *p2 = dkT('\0');
	    dk3str_chomp(p1, NULL);
	    p2 = dk3str_chr(p1, dkT(':'));
	    if(p2) {
	      *(p2++) = dkT('\0');
	      p2 = dk3str_start(p2, NULL);
	      dk3str_chomp(p2, NULL);
	      dk3str_chomp(p1, NULL);
	    }
	    newst = dk3str_array_index(hb_section_names, p1, 0);
	    if(0 <= newst) {
	      job->secttype = 1 + newst;
	    } else {
	      /* ERROR: Syntax (unknown section name) */
	      dk3app_log_1(job->app, DK3_LL_WARNING, job->msg, 18);
	    }
	    if(p2) {
	      if(!dk3sto_it_find_like(job->i_optsect, p2, 0)) {
	        job->actsect = 0;
#if DK3_ON_WINDOWS
		if(0 == dk3str_cmp(p2, (job->kwnl)[18])) {
		  job->actsect = 1;
		}
#else
		if(0 == dk3str_cmp(p2, (job->kwnl)[19])) {
		  job->actsect = 1;
		}
#endif
	      }
	    }
	  } else {
	    /* ERROR: Syntax (missing closing bracket) */
	    dk3app_log_1(job->app, DK3_LL_WARNING, job->msg, 17);
	  }
	} else {
	  /* ERROR: Syntax (no text in bracket) */
	  back = -1;
	  dk3app_log_1(job->app, DK3_LL_WARNING, job->msg, 16);
	}
      } else {
        if(job->actsect) {
          switch(job->secttype) {
	    case HB_SECTION_OPTIONS: {
	      back = hbconf_process_line(job, il, HB_SECTION_OPTIONS);
	    } break;
	    case HB_SECTION_FILES: {
	      back = hbtool_add_file(job, il);
	    } break;
	    case HB_SECTION_CONTENTS: {
	      back = hb_add_contents(job, il);
	    } break;
	  }
	}
      }
    }
  } 

#line 2059 "htmlbook.ctr"
  return back;
}



/**	Line handler to process one line from project file.
	@param	obj	Object to save data.
	@param	il	Input line to process.
	@return	1 on success, 0 on minor errors, -1 on fatal errors.
*/
static
int
hb_line_reader_handler(void *obj, dkChar *il)
{
  int back;
  

#line 2075 "htmlbook.ctr"
  back = hb_process_line((hb_job_t *)obj, il);
  

#line 2077 "htmlbook.ctr"
  return back;
}



/**	Process command line variables, overwrite settings from
	options section in project file.
	@param	job	Job structure.
	@return	1 on success, 0 on error.
*/
static
int
hb_read_variables(hb_job_t *job)
{
  dkChar		 bu[1024];	/* Buffer for modification */
  dk3_key_value_t	*kvp;		/* New key value pair */
  dkChar const		*optstr;	/* Option string */
  dkChar		*p1;		/* Start of option string (key) */
  dkChar		*p2;		/* Start of value */
  dkChar		*p3;		/* Copy of value */
  int			 back = 1;
  int			 nfo;		/* Number of further arguments */
  int			 i;		/* Index of current argument */

  if(0 < (nfo = dk3opt_get_num_fo(job->opt))) {
    for(i = 0; i < nfo; i++) {
      optstr = dk3opt_get_fo(job->opt, i);
      if(optstr) {
        if(dk3str_len(optstr) < DK3_SIZEOF(bu,dkChar)) {
	  dk3str_cpy(bu, optstr);
	  p1 = dk3str_start(bu, NULL);
	  if(p1) {
	    p2 = dk3str_chr(p1, dkT('='));
	    if(p2) {
	      *(p2++) = dkT('\0');
	      p2 = dk3str_start(p2, NULL);
	    }
	    if(p2) {
	      dk3str_chomp(p1, NULL);
	      dk3str_chomp(p2, NULL);
	      kvp = dk3sto_it_find_like(
	        (job->rootnode)->i_variables, p1, 1
	      );
	      if(kvp) {
	        p3 = dk3str_dup_app(p2, job->app);
		if(p3) {
		  dk3_release(kvp->val);
		  kvp->val = p3;
		} else {
		  back = 0;
		}
	      } else {
	        kvp = dk3kv_new_app(p1, p2, job->app);
		if(kvp) {
		  if(!dk3sto_add((job->rootnode)->s_variables, kvp)) {
		    dk3kv_delete(kvp);
		    back = 0;
		  }
		} else {
		  back = 0;
		}
	      }
	    } else {
	      kvp = dk3sto_it_find_like(
	        (job->rootnode)->i_variables, p1, 1
	      );
	      if(kvp) {
	        dk3sto_remove((job->rootnode)->s_variables, kvp);
		dk3kv_delete(kvp);
	      }
	    }
	  } else {
	    /* Empty string is ok */
	  }
	} else {
	  /* ERROR: String too long! */
	  dk3app_log_i3(job->app, DK3_LL_ERROR, 135, 136, optstr);
	}
      }
    }
  }
  return back;
}



/**	Read the project file.
	@param	job	Job structure.
	@return	1 on success, 0 on error.
*/
static
int
hb_read_project(hb_job_t *job)
{
  int		 back = 0;
  int		 inenc;		/* Input encoding */
  

#line 2174 "htmlbook.ctr"
  inenc = dk3app_get_input_file_encoding(job->app);
  if(0 <= job->iecmd) { inenc = job->iecmd; }
  back = dk3stream_process_filename_lines_app(
    (void *)job, hb_line_reader_handler, job->infilename,
    job->ilfile, job->bs,
    dk3app_get_encoding(job->app),
    inenc,
    job->app
  );
  if(!hb_read_variables(job)) {
    back = 0;
  }
  if((job->options) & HB_JOB_OPT_CHM) {
    job->cs = HB_CS_ASCII;
  }
  if(1 != back) { back = 0; }
  

#line 2191 "htmlbook.ctr"
  return back;
}



/**	Write all HTML files for the project.
	@param	job	Job structure.
*/
static
void
hb_write_html_files(hb_job_t *job)
{
#if VERSION_BEFORE_20131206
  hb_node_t		*nptr;
  

#line 2206 "htmlbook.ctr"
  dk3sto_it_reset(job->i_pnodes);
  while(NULL != (nptr = (hb_node_t *)dk3sto_it_next(job->i_pnodes))) {
    

#line 2209 "htmlbook.ctr"
    if(0UL != nptr->objno) {	

#line 2210 "htmlbook.ctr"
      hbhtml_write_file(job, nptr);
    }
  } 

#line 2213 "htmlbook.ctr"
#else
  hb_node_t		*c;
  hb_node_t		*p;
  hb_node_t		*n;
  

#line 2218 "htmlbook.ctr"
  p = c = n = NULL;
  dk3sto_it_reset(job->i_pnodes);
  c = dk3sto_it_next(job->i_pnodes);
  while(c) {
    n = dk3sto_it_next(job->i_pnodes);
    if(0UL != c->objno) {
      hbhtml_write_file(job, c, p, n);
    }
    p = c;
    c = n;
  }
  

#line 2230 "htmlbook.ctr"
#endif
}



/**	Write index html file.
	@param	job	Job structure.
*/
static
void
hb_write_index(hb_job_t *job)
{
  hb_node_t	*n;		/* Current index item */
  

#line 2244 "htmlbook.ctr"
  dk3sto_it_reset(job->i_pnodes);
  if(dk3sto_it_next(job->i_pnodes)) {
    n = (hb_node_t *)dk3sto_it_next(job->i_pnodes);
    if(n) {
      hbhtml_write_file(job, job->rootnode, NULL, n);
    } else {
/*	2014/02/05	We now allow an empty contents section to
			produce just one file index.html.
*/
#if VERSION_BEFORE_20140205
      job->exv = 1;		

#line 2255 "htmlbook.ctr"
#else
      hbhtml_write_file(job, job->rootnode, NULL, n);
#endif
    }
  } else {
    job->exv = 1;		

#line 2261 "htmlbook.ctr"
  } 

#line 2262 "htmlbook.ctr"
}



#if TRACE_DEBUG && (DK3_CHAR_SIZE == 1)
/**	Show document tree structure at a node recursively.
	@param	job	Job structure.
	@param	nptr	Current node to show.
	@param	l	Indent level.
*/
static
void
hb_show_tree_node(hb_job_t *job, hb_node_t *nptr, int l)
{
  hb_node_t	*hbptr;
  int i;
  if(dktrace_file()) {
    fputs("> ", dktrace_file());
    for(i = 0; i < l; i++) {
      fputs("  ", dktrace_file());
    }
    fputs(nptr->title, dktrace_file());
    if(nptr->shorttitle) {
      fputs("   (", dktrace_file());
      fputs(nptr->shorttitle, dktrace_file());
      fputs(")", dktrace_file());
    }
    fprintf(dktrace_file(), "   depth=%d", nptr->depth);
    fputc('\n', dktrace_file());
    dk3sto_it_reset(nptr->i_subnodes);
    while(NULL != (hbptr = (hb_node_t *)dk3sto_it_next(nptr->i_subnodes))) {
      hb_show_tree_node(job, hbptr, (l+1));
    }
  }
}

/**	Show document tree structure.
	@param	job	Job structure.
*/
static
void
hb_show_structure(hb_job_t *job)
{
  hb_show_tree_node(job, job->rootnode, 0);
}
#endif



#if (DK3_ON_WINDOWS) || (DK3_CHAR_SIZE > 1)
/**	Write file name to output file, ANSI encoded.
	Set exit status code on error.
	@param	job	Job structure.
	@param	fn	File name.
*/
static
void
hb_write_ansi_filename(hb_job_t *job, dkChar const *fn)
{
  

#line 2322 "htmlbook.ctr"
  if(!dk3se_ansi_fputs(fn, dk3app_get_encoding(job->app), job->of, job->app)) {
    job->exv = 1;
  } 

#line 2325 "htmlbook.ctr"
}
#endif


#if !DK3_ON_WINDOWS
/**	Write a file name.
	@param	job	Job structure.
	@param	fn	File name to write.
*/
static
void
hb_write_filename(hb_job_t *job, dkChar const *fn)
{
#if DK3_CHAR_SIZE > 1
  hb_write_ansi_filename(job, fn);
#error	"Not implemented!"
#else
  if(EOF == fputs(fn, job->of)) {
    job->exv = 1;
    /* ERROR: Write attempt failed! */
    dk3app_log_i1(job->app, DK3_LL_ERROR, 120);
  }
#endif
}
#endif



/**	Check whether the output file for a node is a HTML file.
	@param	nptr	Node to check.
	@return	1 for HTML files, 0 otherwise.
*/
static
int
hb_htfile(hb_node_t *nptr)
{
  int		 back = 1;
  

#line 2363 "htmlbook.ctr"
  if(nptr->suffix) {
    back = 0;
    if(dk3str_fncmp(nptr->suffix, hb_kwnl[23]) == 0) { back = 1; }
    if(dk3str_fncmp(nptr->suffix, hb_kwnl[24]) == 0) { back = 1; }
  } 

#line 2368 "htmlbook.ctr"
  return back;
}



/**	Write instruction to copy one file to script.
	@param	job	Job structure.
	@param	fn	File name.
*/
static
void
hb_write_script_copy_file(hb_job_t *job, dkChar const *fn)
{
#if DK3_ON_WINDOWS
  fputs(hb_c8_kw[8], job->of);
  hb_write_ansi_filename(job, fn);
  fputs(hb_c8_kw[9], job->of);
  hb_write_ansi_filename(job, fn);
  fputs(hb_c8_kw[0], job->of);
  fputs(hb_c8_kw[10], job->of);
  hb_write_ansi_filename(job, fn);
  fputs(hb_c8_kw[11], job->of);
  hb_write_ansi_filename(job, fn);
  fputs(hb_c8_kw[12], job->of);
  hb_write_ansi_filename(job, job->outputdir);
  fputs(hb_c8_kw[13], job->of);
#else
  fputs(hb_c8_kw[14], job->of);	/* if */
  hb_write_filename(job, fn);
  fputs(hb_c8_kw[15], job->of);	/* then */
  fputs(hb_c8_kw[16], job->of);	/* else */
  if((job->options) & HB_JOB_OPT_LN) {
    fputs(hb_c8_kw[19], job->of);
  } else {
    fputs(hb_c8_kw[20], job->of);
  }
  hb_write_filename(job, fn);
  fputs(hb_c8_kw[21], job->of);
  hb_write_filename(job, job->outputdir);
  fputs(hb_c8_kw[5], job->of);
  fputs(hb_c8_kw[17], job->of);	/* fi */
  fputs(hb_c8_kw[22], job->of);
  hb_write_filename(job, fn);
  fputs(hb_c8_kw[23], job->of);
  fputs(hb_c8_kw[35], job->of);
  fputs(hb_c8_kw[18], job->of);
#endif
}



/**	Write the output script.
	Set exit status code on errors.
	@param	job	Job structure.
*/
static
void
hb_write_script(hb_job_t *job)
{
  dkChar	 of[DK3_MAX_PATH];	/* Output file name */
  hb_node_t	*nptr;			/* Current print node */
  dkChar const	*fn;			/* Current resource file name */
  

#line 2431 "htmlbook.ctr"
  if(job->outputscript) {
    if(job->outputdir) {
      job->of = dk3sf_fopen_app(job->outputscript, hb_kwnl[22], job->app);
      if(job->of) {
        /*	Start of file
	*/
#if DK3_ON_WINDOWS
	fputs(hb_c8_kw[31], job->of);
#else
	fputs(hb_c8_kw[32], job->of);
	fputs(hb_c8_kw[33], job->of);
#endif
        /*	Remove existing directory completely.
        */
#if DK3_ON_WINDOWS
	fputs(hb_c8_kw[2], job->of);
	hb_write_ansi_filename(job, job->outputdir);
	fputs(hb_c8_kw[3], job->of);
#else
	fputs(hb_c8_kw[4], job->of);
	hb_write_filename(job, job->outputdir);
	fputs(hb_c8_kw[5], job->of);
#endif
        /*	Create new directory.
        */
#if DK3_ON_WINDOWS
	fputs(hb_c8_kw[6], job->of);
	hb_write_ansi_filename(job, job->outputdir);
	fputs(hb_c8_kw[5], job->of);
#else
	fputs(hb_c8_kw[7], job->of);
	hb_write_filename(job, job->outputdir);
	fputs(hb_c8_kw[5], job->of);
#endif
        /*	Copy resource files.
        */
	dk3sto_it_reset(job->i_files);
	while(NULL != (fn = (dkChar const *)dk3sto_it_next(job->i_files))) {
	  /*	2014-04-17
	  	Writinig the file copy instruction is now in the
	  	hb_write_script_copy_file() function.
	  */
	  hb_write_script_copy_file(job, fn);
	}
	/*	For CHM projects copy index.hhp, index.hhc and index.hhk
	*/
	if ((job->options) & HB_JOB_OPT_CHM) {
	  hb_write_script_copy_file(job, hb_kwnl[36]);
	  hb_write_script_copy_file(job, hb_kwnl[26]);
	  hb_write_script_copy_file(job, hb_kwnl[28]);
	  if ((job->options) & HB_JOB_OPT_CREATE_INDEX) {
	    if (hbchm_have_index_entries(job)) {
	      hb_write_script_copy_file(job, hb_kwnl[29]);
	    }
	  }
	}
        /*	Copy HTML files, use tidy if available.
        */
	dk3sto_it_reset(job->i_pnodes);
	while(NULL != (nptr = (hb_node_t *)dk3sto_it_next(job->i_pnodes))) {
	  if(hbhtml_create_output_filename(of,DK3_SIZEOF(of,dkChar),job,nptr))
	  {
	    fn = of;
#if DK3_ON_WINDOWS
	    /*	Remove existing file.
	    */
	    fputs(hb_c8_kw[10], job->of);
	    hb_write_ansi_filename(job, job->outputdir);
	    fputc('\\', job->of);
	    hb_write_ansi_filename(job, fn);
	    fputs(hb_c8_kw[38], job->of);
	    hb_write_ansi_filename(job, job->outputdir);
	    fputc('\\', job->of);
	    hb_write_ansi_filename(job, fn);
	    fputs(hb_c8_kw[39], job->of);
	    /*	Use tidy or xcopy to bring new file in place.
	    */
	    fputs(hb_c8_kw[8], job->of);
	    hb_write_ansi_filename(job, fn);
	    fputs(hb_c8_kw[9], job->of);
	    hb_write_ansi_filename(job, fn);
	    fputs(hb_c8_kw[0], job->of);
	    if(((nptr->options) & HB_NODE_OPT_USE_TIDY) && (hb_htfile(nptr))) {
	      fputs(hb_c8_kw[36], job->of);
	      hb_write_ansi_filename(job, fn);
	      fputs(hb_c8_kw[0], job->of);
	      if(HB_CS_UTF_8 == job->cs) {
	        fputs(hb_c8_kw[24], job->of);
		hb_write_ansi_filename(job, fn);
		fputs(hb_c8_kw[26], job->of);
	        hb_write_ansi_filename(job, job->outputdir);
		fputc('\\', job->of);
		hb_write_ansi_filename(job, fn);
		fputs(hb_c8_kw[3], job->of);
	      } else {
	        fputs(hb_c8_kw[25], job->of);
		hb_write_ansi_filename(job, fn);
		fputs(hb_c8_kw[26], job->of);
	        hb_write_ansi_filename(job, job->outputdir);
		fputc('\\', job->of);
		hb_write_ansi_filename(job, fn);
		fputs(hb_c8_kw[3], job->of);
	      }
	    } else {
	      fputs(hb_c8_kw[10], job->of);
	      hb_write_ansi_filename(job, fn);
	      fputs(hb_c8_kw[11], job->of);
	      hb_write_ansi_filename(job, fn);
	      fputs(hb_c8_kw[12], job->of);
	      hb_write_ansi_filename(job, job->outputdir);
	      fputs(hb_c8_kw[13], job->of);
	    }
#else
	    /*	Remove existing file.
	    */
	    fputs(hb_c8_kw[14], job->of);	/* if */
	    hb_write_filename(job, job->outputdir);
	    fputs(hb_c8_kw[30], job->of);
	    hb_write_filename(job, fn);
	    fputs(hb_c8_kw[15], job->of);
	    fputs(hb_c8_kw[16], job->of);	/* then */
	    fputs(hb_c8_kw[4], job->of);
	    hb_write_filename(job, job->outputdir);
	    fputs(hb_c8_kw[30], job->of);
	    hb_write_filename(job, fn);
	    fputs(hb_c8_kw[5], job->of);
	    fputs(hb_c8_kw[18], job->of);	/* fi */
	    /*	Use tidy, cp or ln to bring new file in place.
	    */
	    fputs(hb_c8_kw[14], job->of);
	    hb_write_filename(job, fn);
	    fputs(hb_c8_kw[15], job->of);
	    fputs(hb_c8_kw[16], job->of);
	    if(((nptr->options) & HB_NODE_OPT_USE_TIDY) && (hb_htfile(nptr))) {
	      fputs(hb_c8_kw[37], job->of);
	      hb_write_filename(job, fn);
	      fputs(hb_c8_kw[0], job->of);
	      if(HB_CS_UTF_8 == job->cs) {
	        fputs(hb_c8_kw[27], job->of);
	      } else {
	        fputs(hb_c8_kw[28], job->of);
	      }
	      hb_write_filename(job, fn);
	      fputs(hb_c8_kw[29], job->of);
	      hb_write_filename(job, job->outputdir);
	      fputs(hb_c8_kw[30], job->of);
	      hb_write_filename(job, fn);
	      fputs(hb_c8_kw[5], job->of);
	    } else {
	      if((job->options) & HB_JOB_OPT_LN) {
	        fputs(hb_c8_kw[19], job->of);
	      } else {
	        fputs(hb_c8_kw[20], job->of);
	      }
	      hb_write_filename(job, fn);
	      fputs(hb_c8_kw[21], job->of);
	      hb_write_filename(job, job->outputdir);
	      fputs(hb_c8_kw[5], job->of);
	    }
	    fputs(hb_c8_kw[17], job->of);
	    fputs(hb_c8_kw[22], job->of);
	    hb_write_filename(job, fn);
	    fputs(hb_c8_kw[23], job->of);
	    fputs(hb_c8_kw[35], job->of);
	    fputs(hb_c8_kw[18], job->of);
#endif
	  }
	}
	/*	End of file.
	*/
#if !DK3_ON_WINDOWS
	/* find ... -type d -exec chmod ugo+rx {} \; */
	fputs(hb_c8_kw[40], job->of);
	hb_write_filename(job, job->outputdir);
	fputs(hb_c8_kw[41], job->of);
	/* find ... -type f -exec chmod ugo+r  {} \; */
	fputs(hb_c8_kw[40], job->of);
	hb_write_filename(job, job->outputdir);
	fputs(hb_c8_kw[42], job->of);
	/* exit EXITCODE */
	fputs(hb_c8_kw[34], job->of);
#endif
	/*	Close file.
	*/
        if(!dk3sf_fclose_fn_app(job->of, job->outputscript, job->app)) {
          job->exv = 1;
        }
      } else {
        job->exv = 1;
      }
    } else {
      job->exv = 1;
      /* ERROR: No output directory configured! */
      dk3app_log_1(job->app, DK3_LL_ERROR, job->msg, 67);
    }
  } else {
    job->exv = 1;
    /* ERROR: No output script configured! */
    dk3app_log_1(job->app, DK3_LL_ERROR, job->msg, 68);
  } 

#line 2631 "htmlbook.ctr"
}



/**	Write output files.
	Set exit status code on errors.
	@param	job	Job structure.
*/
static
void
hb_write_output(hb_job_t *job)
{
  

#line 2644 "htmlbook.ctr"
  

#line 2645 "htmlbook.ctr"
  hb_write_html_files(job);
  hb_write_index(job);
  hb_write_script(job);
  if((job->options) & HB_JOB_OPT_CHM) {
    if(!hbchm_write_project(job)) { job->exv = 1; }
  }
  

#line 2652 "htmlbook.ctr"
  

#line 2653 "htmlbook.ctr"
}



/**	Check consistency of input data.
	@param	job	Job structure.
	@return	1 on success, 0 on error.
*/
static
int
hb_check_data(hb_job_t *job)
{
  hb_node_t	*nptr;		/* Current node */
  int		 back = 1;
  

#line 2668 "htmlbook.ctr"
  /*	All printable nodes must have a template.
  */
  job->npobjs = 0UL;
  dk3sto_it_reset(job->i_pnodes);
  while(NULL != (nptr = (hb_node_t *)dk3sto_it_next(job->i_pnodes))) {
    if(!(job->firstnode)) { job->firstnode = nptr; }
    job->lastnode = nptr;
    nptr->pobjno = job->npobjs;
    job->npobjs += 1UL;
    if(!hbconf_node_template(job, nptr)) {
      back = 0;
      /* ERROR: No template for node! */
      dk3app_set_source_line(job->app, nptr->lineno);
      dk3app_log_1(job->app, DK3_LL_WARNING, job->msg, 19);
    }
  }
  if(back) {
    /* ##### Further tests. */
  } 

#line 2687 "htmlbook.ctr"
  return back;
}



/**	Do normal processing for one specified project file.
	@param	job	Job structure.
*/
static
void
hb_run_with_input_filename(hb_job_t *job)
{
  int		res = 1;
  

#line 2701 "htmlbook.ctr"
  dk3app_set_source_file(job->app, job->infilename);
  dk3app_set_source_line(job->app, 0UL);
  if(hb_job_allocate(job)) {		

#line 2704 "htmlbook.ctr"
    if(dk3opt_is_set(job->opt, dkT('o'))) {
      res = hb_save_optional_sections(
	job, dk3opt_get_short_arg(job->opt, dkT('o'))
      );
    }
    if(res) {
      if(hbconf_read_files(job)) {
        if(hb_read_project(job)) {
          if(hb_check_data(job)) {
	    hbtool_enumerate(job);
            job->exv = 0;		

#line 2715 "htmlbook.ctr"
	    hb_write_output(job);
	  }
        }
      }
    }
  } else {				

#line 2721 "htmlbook.ctr"
  }
  

#line 2723 "htmlbook.ctr"
}



/**	Run normally.
	@param	job	Job structure.
*/
static
void
hb_run(hb_job_t *job)
{
  dkChar const	*infilename;	/* Input file name */
  dk3_dir_t	*fne;		/* File name expander */
  dk3_um_t	 numfiles;	/* Number of files in expander */
  

#line 2738 "htmlbook.ctr"
  infilename = dk3opt_get_arg(job->opt, 0);
  if(infilename) {
    if(dk3sf_must_expand(infilename)) {
      fne = dk3dir_fne_open_app(infilename, job->app);
      if(fne) {
        numfiles = dk3dir_get_number_of_files(fne);
	if(DK3_UM_0 < numfiles) {
	  if(DK3_UM_1 < numfiles) {
	    /* ERROR: Too many file names match */
	    dk3app_log_i3(job->app, DK3_LL_ERROR, 168, 169, infilename);
	  } else {
	    if(dk3dir_get_next_file(fne)) {
	      job->infilename = dk3dir_get_fullname(fne);
	      if(job->infilename) {
	        hb_run_with_input_filename(job);
	      } else {
	        /* ERROR: Failed to obtain file name */
		dk3app_log_1(job->app, DK3_LL_ERROR, job->msg, 20);
	      }
	    } else {
	      /* ERROR: Failed to obtain file name */
	      dk3app_log_1(job->app, DK3_LL_ERROR, job->msg, 20);
	    }
	  }
	} else {
	  /* ERROR: No matching file name! */
	  dk3app_log_i3(job->app, DK3_LL_ERROR, 215, 216, infilename);
	}
        dk3dir_close(fne);
      }
    } else {
      job->infilename = infilename;
      hb_run_with_input_filename(job);
    }
  } else {
    /* ERROR: Missing project file name! */
    dk3app_log_1(job->app, DK3_LL_ERROR, job->msg, 13);
  }
  

#line 2777 "htmlbook.ctr"
}



/**	Main function of the htmlbook program.
	@param	argc	Number of command line arguments.
	@param	argv	Command line arguments array.
	@return	0 on success, any other value indicates an error.
*/
DK3_MAIN
{
  hb_job_t		 job;		/* Job structure */
  dk3_app_t		*app = NULL;	/* Application structure */
  dkChar const * const	*msg = NULL;	/* Localized message texts */
  dk3_time_t		 timer;		/* Current time */
  int			 exv = 1;	/* Exit status code */

  

#line 2795 "htmlbook.ctr"
  

#line 2796 "htmlbook.ctr"
#if DK3_HAVE_TZSET
  tzset();
#endif
  app = dk3app_open_command(
    argc, (dkChar const * const *)argv, hb_kwnl[0]
  );
  if(app) {
    msg = dk3app_messages(app, hb_kwnl[1], (dkChar const **)hb_kw);
    hb_job_init(&job, app, msg, hb_kwnl);
    dk3sf_time(&timer);
    dk3sf_localtime_app(&(job.starttime), &timer, app);
    if(hb_process_options(&job)) {
      if(job.cmd) {
        hb_help_version_license(&job);
      } else {
        hb_run(&job);
      }
    }
    exv = job.exv;
    hb_job_end(&job);
    dk3app_close(app); app = NULL;
  } else {
    fputs("htmlbook: ERROR: Not enough memory (RAM/swap)!\n", stderr);
    fflush(stderr);
  }
  

#line 2822 "htmlbook.ctr"
  

#line 2823 "htmlbook.ctr"
  fflush(stdout);
  exit(exv); return exv;
}


