/*
	WARNING: This file was generated by dkct.
	Changes you make here will be lost if dkct is run again!
	You should modify the original source and run dkct on it.
	Original source: hbtool.ctr
*/

/*
Copyright (C) 2013-2014, Dirk Krause

Redistribution and use in source and binary forms, with or without
modification, are permitted provided that the following conditions are met:

* Redistributions of source code must retain the above copyright notice,
  this list of conditions and the following disclaimer.
* Redistributions in binary form must reproduce the above opyright notice,
  this list of conditions and the following disclaimer in the documentation
  and/or other materials provided with the distribution.
* Neither the name of the author nor the names of contributors may be used
  to endorse or promote products derived from this software without specific
  prior written permission.

THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS ``AS IS''
AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
ARE DISCLAIMED.
IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE LIABLE FOR ANY
DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
(INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
(INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
*/

/**	@file hbtool.h Header file for the hbtool module.
*/

#ifndef HBTOOL_H_INCLUDED
/** Avoid multiple inclusions. */
#define HBTOOL_H_INCLUDED 1


#line 10 "hbtool.ctr"


#ifdef __cplusplus
extern "C" {
#endif

/**	Add one file name to the list of files to copy.
	@param	job	Job structure.
	@param	fn	File name.
	@return	1 on success, 0 on error.
*/
int
hbtool_add_file(hb_job_t *job, dkChar const *fn);

/**	Add one file (probably with CGI arguments) to list of files to copy.
	The URL is only added if it references a local file name
	in the current working directory without any protocol
	specification, (src="filename.png"). For all other URLs we skip
	adding and return 1.
	@param	job	Job structure.
	@param	url	URL as specified.
	@return	1 on success, 0 on error.
*/
int
hbtool_add_url(hb_job_t *job, dkChar const *url);

/**	Check file name. The file must be specified without a path.
	The file name must be encodable as URL
	so it must be in range 0x00000000 to 0x000000FF.
	For Windows systems the file name must be encodable as ANSI,
	so the following codes are excluded from the range above:
	0x80 to 0x8C, 0x8E, 0x91 to 0x9C, 0x9E to 0x9F.
	@param	job	Job structure.
	@param	fn	File name.
	@return	1 on success, 0 on error.
*/
int
hbtool_check_filename(hb_job_t *job, dkChar const *fn);

/**	Check file name encoding.
	The file name must be encodable as URL
	so it must be in range 0x00000000 to 0x000000FF.
	For Windows systems the file name must be encodable as ANSI,
	so the following codes are excluded from the range above:
	0x80 to 0x8C, 0x8E, 0x91 to 0x9C, 0x9E to 0x9F.
	@param	job	Job structure.
	@param	fn	File name.
	@return	1 on success, 0 on error.
*/
int
hbtool_check_filename_encoding(hb_job_t *job, dkChar const *fn);
	
/**	Retrieve start character from text.
	@param	text	Text to obtain character from.
	@param	enc	Text encoding.
	@return	Start character on success, 0UL on error.
*/
dk3_c32_t
hbtool_get_start_char(dkChar const *text, int enc);

/**	Enumerate section and subsections.
	@param	job	Job structure.
*/
void
hbtool_enumerate(hb_job_t *job);

/**	Write hiearchical header number.
	@param	job	Job structure.
	@param	nptr	Node to write header for.
	@return	1 if number was written, 0 otherwise.
*/
int
hbtool_write_header_number(hb_job_t *job, hb_node_t *nptr);

/**	Write all titles, separated by arrows.
	For the primary node we write the full header, for parent
	nodes the short header.
	@param	job	Job structure.
	@param	nptr	Current node to write title for.
	@param	isprim	Flag: Is primary node.
*/
int
hbtool_write_all_titles(hb_job_t *job, hb_node_t *nptr, int isprim);

/**	Correct backslashes to slash on Windows systems.
	@param	str	String to correct.
*/
void
hbtool_correct_backslash_to_slash(dkChar *str);

/**	Write text (file name) UTF-8 encoded to jobs output file.
	@param	job	Job structure.
	@param	src	String to write.
	@return	1 on success, 0 on error.
*/
int
hbtool_write_text_utf(hb_job_t *job, dkChar const *src);

#ifdef __cplusplus
}
#endif


#endif
